/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.FullFtpClient;
import com.sun.portal.netfile.servlet.NetFileLogManager;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;

class FtpFile {
    protected NetFileLogManager logMgr = null;
    private NetFileResource nfRes = null;
    protected Debug debug = null;
    protected String szEncoding;
    protected FullFtpClient ffc = null;
    protected int intDirsTraversed = 0;
    protected ArrayList alSearchResults = new ArrayList();

    FtpFile(NetFileLogManager log_Mgr, String szMachineEncoding) {
        this.logMgr = log_Mgr;
        this.szEncoding = szMachineEncoding;
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    String[] searchFTPDir(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfrUsrResBundle) throws NetFileException {
        this.nfRes = nfrUsrResBundle;
        this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
        this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir, nfrUsrResBundle);
        if (this.alSearchResults.size() == 0) {
            return new String[]{"        "};
        }
        String[] sa_results = new String[this.alSearchResults.size()];
        int j = 0;
        while (j < sa_results.length) {
            sa_results[j] = (String)this.alSearchResults.get(j);
            ++j;
        }
        return sa_results;
    }

    void search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfrUsrResBundle) throws NetFileException {
        block16: {
            try {
                ++this.intDirsTraversed;
                this.writeDebug("Directory number being searched = " + this.intDirsTraversed, null);
                if (this.intDirsTraversed > maxsrchdir) {
                    return;
                }
                String[] sa_file_listing = this.getFTPDir(usernam, passwrd, machnam, VMSnam, dir_nam, nfrUsrResBundle, false);
                if (sa_file_listing == null || sa_file_listing.length < 0) {
                    return;
                }
                if (sa_file_listing[0].startsWith("ERROR:")) {
                    this.writeDebug("Error in searching is :" + sa_file_listing[0], null);
                    throw new NetFileException(500, nfrUsrResBundle.getString("ff.1", new Object[]{VMSnam, dir_nam}));
                }
                int i = 0;
                while (i < sa_file_listing.length && this.intDirsTraversed <= maxsrchdir) {
                    block17: {
                        if (sa_file_listing[i] == null) break block16;
                        if (sa_file_listing[i].equalsIgnoreCase("d")) {
                            String s_error = "";
                            String s_directory = dir_nam + "/" + sa_file_listing[i + 1];
                            try {
                                this.writeDebug("Changing to directory " + s_directory + " to search", null);
                                this.search(usernam, passwrd, machnam, VMSnam, pattern, s_directory, maxsrchdir, nfrUsrResBundle);
                            }
                            catch (NetFileException nfe) {
                                if (this.intDirsTraversed >= maxsrchdir) {
                                    throw nfe;
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                this.writeErrorDebug("Exception in searching directory " + s_directory + " in " + VMSnam, e);
                                s_error = "(" + nfrUsrResBundle.getString("error13") + ")";
                            }
                            if (sa_file_listing[i + 1].indexOf(pattern) > -1) {
                                this.alSearchResults.add("/" + VMSnam + s_directory + "/" + s_error);
                            }
                        } else if (sa_file_listing[i + 1].indexOf(pattern) > -1) {
                            this.writeDebug("Adding " + sa_file_listing[i + 1] + " to search results", null);
                            this.alSearchResults.add("/" + VMSnam + dir_nam + "/" + sa_file_listing[i + 1]);
                        }
                    }
                    i += 4;
                }
            }
            catch (NetFileException nfe) {
                if (this.intDirsTraversed >= maxsrchdir) {
                    throw nfe;
                }
            }
            catch (Exception e) {
                this.writeErrorDebug("Exception in searching " + VMSnam + dir_nam + "/", e);
                throw new NetFileException(500, nfrUsrResBundle.getString("ff.1", new Object[]{VMSnam, dir_nam}));
            }
        }
    }

    InputStream getInputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam, NetFileResource nfrUsrResBundle) throws NetFileException {
        Exception e = null;
        TelnetInputStream ftpin = null;
        this.nfRes = nfrUsrResBundle;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpin = this.ffc.get(mainfilenam);
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, "Exceptione obtaining the FTP file", this.ffc);
        }
        return ftpin;
    }

    OutputStream getOutputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String remotefil_arg, String dir_nam, NetFileResource nfrUsrResBundle) throws NetFileException {
        Exception e = null;
        TelnetOutputStream ftpout = null;
        this.nfRes = nfrUsrResBundle;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpout = this.ffc.put(remotefil_arg);
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, "Could upload file", this.ffc);
        }
        return ftpout;
    }

    void closeFtpFile() {
        try {
            if (this.ffc != null) {
                this.ffc.quit();
            }
            this.ffc = null;
        }
        catch (IOException ioe) {
            this.ffc = null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getFTPFile(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam, String tmpdir, NetFileResource nfrUsrResBundle, String usersession) throws NetFileException {
        block17: {
            mknodfilename = "";
            txtouting = "";
            e = null;
            nfFtpClient = null;
            instream = null;
            bos = null;
            this.nfRes = nfrUsrResBundle;
            try {
                try {
                    buftxt = new StringBuffer(4096);
                    newftpdir = "";
                    random = new Long(System.currentTimeMillis());
                    mknodfilename = tmpdir + "/" + random.toString() + usernam.toUpperCase() + mainfilenam;
                    newfil = new File(mknodfilename);
                    if (newfil.exists()) {
                        newfil.delete();
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(newfil));
                    nfFtpClient = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
                    instream = nfFtpClient.get(mainfilenam);
                    while (true) {
                        if ((c = instream.read()) <= -1) {
                            instream.close();
                            bos.flush();
                            bos.close();
                            txtouting = buftxt.toString();
                            if (!txtouting.startsWith("ERROR:") && txtouting.indexOf(nfrUsrResBundle.getString("permissiondenied")) < 0 && txtouting.indexOf(nfrUsrResBundle.getString("nosuchfile")) < 0) break block17;
                            this.logMgr.doError(nfrUsrResBundle.getString("error6"));
                            var21_22 = "ERROR:" + nfrUsrResBundle.getString("error6");
                            var23_23 = null;
                            break;
                        }
                        bos.write((int)var16_20);
                        buftxt.append((char)var16_20);
                    }
                }
                catch (Exception ex) {
                    e = ex;
                    this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.4"), nfFtpClient);
                    var23_25 = null;
                    try {
                        if (instream != null) {
                            instream.close();
                        }
                        if (bos == null) return mknodfilename;
                        bos.close();
                        return mknodfilename;
                    }
                    catch (IOException ioe) {
                        return mknodfilename;
                    }
                }
            }
            catch (Throwable var22_31) {
                var23_26 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 344->367)] { 
lbl54:
                // 1 sources

                if (instream != null) {
                    instream.close();
                }
                if (bos == null) throw var22_31;
                bos.close();
                throw var22_31;
lbl59:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                throw var22_31;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 344->367)] { 
lbl64:
            // 1 sources

            if (instream != null) {
                instream.close();
            }
            if (bos == null) return var21_22;
            bos.close();
            return var21_22;
lbl69:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return var21_22;
        }
        var23_24 = null;
        try {}
        catch (IOException ioe) {}
        if (instream != null) {
            instream.close();
        }
        if (bos == null) return mknodfilename;
        bos.close();
        return mknodfilename;
        return mknodfilename;
    }

    /*
     * Loose catch block
     */
    String putFTPFile(String usernam, String passwrd, String machnam, String VMSnam, String localfil_arg, String remotefil_arg, String dir_nam, NetFileResource nfrUsrResBundle) throws NetFileException {
        block18: {
            Exception e = null;
            Object nfFtpClient = null;
            OutputStream out = null;
            FileInputStream fin = null;
            this.nfRes = nfrUsrResBundle;
            out = this.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, remotefil_arg, dir_nam, nfrUsrResBundle);
            fin = new FileInputStream(localfil_arg);
            int fileSize = fin.available();
            int blockSize = 0x800000;
            byte[] data = null;
            data = fileSize > blockSize ? new byte[blockSize] : new byte[fileSize];
            int bytesRead = 0;
            do {
                bytesRead = fin.read(data);
                out.write(data, 0, bytesRead);
            } while (bytesRead == blockSize);
            out.flush();
            Object var18_18 = null;
            try {
                if (fin != null) {
                    fin.close();
                }
                if (out != null) {
                    out.close();
                }
                if (this.ffc != null) {
                    this.ffc.quit();
                }
                break block18;
            }
            catch (IOException ioe) {}
            break block18;
            {
                catch (Exception ex) {
                    e = ex;
                    this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.3"), this.ffc);
                    Object var18_19 = null;
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        if (this.ffc != null) {
                            this.ffc.quit();
                        }
                        break block18;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                try {
                    if (fin != null) {
                        fin.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (this.ffc != null) {
                        this.ffc.quit();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return nfrUsrResBundle.getString("info6");
    }

    String delFTPFile(String username, String password, String machine, String share, String szDelFileName, String directory, NetFileResource nfrUsrResBundle) throws NetFileException {
        FullFtpClient fullFtpClient = null;
        Exception e = null;
        this.nfRes = nfrUsrResBundle;
        try {
            fullFtpClient = this.initialiseFtpClient(username, password, machine, share, directory);
            fullFtpClient.delete(szDelFileName);
            fullFtpClient.closeServer();
        }
        catch (Exception ex) {
            e = ex;
            this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.5", new Object[]{szDelFileName}), fullFtpClient);
        }
        return nfrUsrResBundle.getString("FileDeleted");
    }

    public String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfrUsrResBundle) throws NetFileException {
        return this.getFTPDir(username, password, machname, VMSname, dirS, nfrUsrResBundle, true);
    }

    /*
     * Unable to fully structure code
     */
    private String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfrUsrResBundle, boolean closeConn) throws NetFileException {
        block17: {
            full_ftp_client = null;
            e = null;
            file_listing = new String[]{};
            this.nfRes = nfrUsrResBundle;
            try {
                if (this.ffc == null) {
                    full_ftp_client = this.initialiseFtpClient(username, password, machname, VMSname, dirS);
                } else {
                    full_ftp_client = this.ffc;
                    full_ftp_client.cd(VMSname + dirS);
                }
                names_list = this.getNamesList(full_ftp_client);
                full_listing = this.getList(full_ftp_client, false);
                listing = this.processListings(names_list, full_listing);
                number_of_files = names_list.size();
                file_listing = new String[number_of_files * 4];
                j = 0;
                i = 0;
                while (i < number_of_files) {
                    if (!listing[i][1].equals("..") && !listing[i][1].startsWith(".")) {
                        file_listing[j++] = listing[i][0];
                        file_listing[j++] = listing[i][1];
                        sb = new StringBuffer();
                        multibyte = false;
                        l = 0;
                        while (l < listing[i][1].length()) {
                            k = Character.getNumericValue(listing[i][1].charAt(l));
                            sb.append(k).append(",");
                            if (k > 255) {
                                multibyte = true;
                            }
                            ++l;
                        }
                        file_listing[j++] = listing[i][3];
                        file_listing[j++] = listing[i][2];
                    }
                    ++i;
                }
                var22_22 = null;
                ** if (!closeConn) goto lbl-1000
            }
            catch (Throwable var21_28) {
                var22_24 = null;
                if (closeConn) {
                    try {
                        full_ftp_client.quit();
                    }
                    catch (Exception ge) {
                        // empty catch block
                    }
                }
                throw var21_28;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    full_ftp_client.quit();
                }
                catch (Exception ge) {}
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (Exception ex) {
                    e = ex;
                    var22_23 = null;
                    if (closeConn) {
                        try {
                            full_ftp_client.quit();
                        }
                        catch (Exception ge) {}
                    }
                }
            }
        }
        this.performFinalProcessing(e, nfrUsrResBundle.getString("ff.6"), full_ftp_client);
        return file_listing;
    }

    private Vector getNamesList(FullFtpClient full_ftp_client) throws Exception {
        return this.getList(full_ftp_client, true);
    }

    private Vector getList(FullFtpClient full_ftp_client, boolean names_only) throws Exception {
        if (full_ftp_client == null) {
            throw new IllegalArgumentException("null full ftp client");
        }
        TelnetInputStream list = null;
        Vector<String> v_list = new Vector<String>();
        list = names_only ? full_ftp_client.nlist() : full_ftp_client.list(true);
        InputStreamReader ipsr_list = new InputStreamReader((InputStream)list, this.szEncoding);
        BufferedReader br_list = new BufferedReader(ipsr_list);
        String s_input_line = null;
        while ((s_input_line = br_list.readLine()) != null) {
            v_list.add(s_input_line);
        }
        br_list.close();
        ipsr_list.close();
        list.close();
        s_input_line = null;
        br_list = null;
        ipsr_list = null;
        list = null;
        return v_list;
    }

    private String[][] processListings(Vector v_file_names, Vector v_full_listing) throws Exception {
        int listing_size = v_full_listing.size();
        if (listing_size <= 0) {
            return new String[0][];
        }
        String last_entry = (String)v_full_listing.elementAt(listing_size - 1);
        boolean is_windows = !last_entry.startsWith("-") && !last_entry.startsWith("d") && !last_entry.startsWith("l") && !last_entry.startsWith("d") && !last_entry.startsWith("b") && !last_entry.startsWith("c") && !last_entry.startsWith("p") && !last_entry.startsWith("s") && !last_entry.startsWith("D");
        String[][] listing = null;
        listing = is_windows ? this.processMSDirectoryListingType(v_file_names, v_full_listing) : this.processUnixDirectoryListingType(v_file_names, v_full_listing);
        return listing;
    }

    private String[][] processUnixDirectoryListingType(Vector v_file_names, Vector v_full_listing) throws Exception {
        int number_of_files = v_file_names.size();
        int full_listing_length = v_full_listing.size();
        String[][] listing = new String[number_of_files][4];
        String file_name = null;
        String full_listing_row = null;
        int i = number_of_files - 1;
        int j = full_listing_length - 1;
        while (i >= 0) {
            listing[i][1] = file_name = (String)v_file_names.elementAt(i);
            full_listing_row = (String)v_full_listing.elementAt(j);
            listing[i][0] = full_listing_row.charAt(0) == 'd' ? "d" : full_listing_row.charAt(0) + "";
            int k = -1;
            if (listing[i][0].equals("l")) {
                k = full_listing_row.indexOf(file_name + " ->") - 1;
                listing[i][1] = file_name = full_listing_row.substring(k, full_listing_row.length());
            } else {
                k = full_listing_row.lastIndexOf(file_name) - 1;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            int end_of_date = k + 1;
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            listing[i][2] = full_listing_row.substring(k + 1, end_of_date);
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            int end_of_length = k + 1;
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            listing[i][3] = full_listing_row.substring(k + 1, end_of_length);
            --i;
            --j;
        }
        return listing;
    }

    private String[][] processMSDirectoryListingType(Vector v_file_names, Vector v_full_listing) throws Exception {
        int number_of_files = v_file_names.size();
        String[][] listing = new String[number_of_files][4];
        String file_name = null;
        String full_listing_row = null;
        int i = number_of_files - 1;
        while (i >= 0) {
            listing[i][1] = file_name = (String)v_file_names.elementAt(i);
            full_listing_row = (String)v_full_listing.elementAt(i);
            if (full_listing_row.indexOf("<DIR>") > 0) {
                listing[i][3] = "0";
                listing[i][0] = "d";
            } else {
                listing[i][0] = "-";
            }
            int j = 0;
            while (j < full_listing_row.length()) {
                if (full_listing_row.charAt(j) == ' ') break;
                ++j;
            }
            while (j < full_listing_row.length()) {
                if (full_listing_row.charAt(j) != ' ') break;
                ++j;
            }
            while (j < full_listing_row.length()) {
                if (full_listing_row.charAt(j) == ' ') break;
                ++j;
            }
            listing[i][2] = full_listing_row.substring(0, j);
            if (listing[i][3] == null) {
                int start_of_length = -1;
                while (j < full_listing_row.length()) {
                    if (full_listing_row.charAt(j) != ' ') break;
                    ++j;
                }
                start_of_length = j;
                while (j < full_listing_row.length()) {
                    if (full_listing_row.charAt(j) == ' ') break;
                    ++j;
                }
                listing[i][3] = full_listing_row.substring(start_of_length, j);
            }
            --i;
        }
        return listing;
    }

    private String extractPermissionsForFile(String listing_line, String file) throws Exception, NetFileException {
        this.debug.message("Listing line=" + listing_line);
        String suffix = " " + file;
        char ch_file_type = '-';
        if (listing_line.endsWith(suffix)) {
            int i_index_of_blank;
            ch_file_type = listing_line.charAt(0);
            if (ch_file_type == 'd' || ch_file_type == 'D') {
                throw new NetFileException();
            }
            if (!Character.isDigit(ch_file_type) && (i_index_of_blank = listing_line.indexOf(" ", 0)) > 0) {
                return listing_line.substring(0, i_index_of_blank);
            }
        }
        return null;
    }

    private boolean isPermissionOk(String s_permission_string, String permission, String user_type) {
        this.debug.message("Permission line=" + s_permission_string);
        char ch_permission = 'r';
        int i_check_position = 0;
        int i_offset = 1;
        if (permission.equals("write")) {
            i_check_position = 1;
            ch_permission = 'w';
        } else if (permission.equals("execute")) {
            i_check_position = 2;
            ch_permission = 'x';
        }
        if (user_type.equals("group")) {
            i_offset = 4;
        } else if (user_type.equals("others")) {
            i_offset = 7;
        }
        return s_permission_string.charAt(i_offset + i_check_position) == ch_permission;
    }

    /*
     * Loose catch block
     */
    void rename(String username, String password, String machine, String share, String directory, String szOldName, String szNewName, NetFileResource nfrUsrResBundle) throws NetFileException {
        block12: {
            FullFtpClient fullFtpClient = null;
            Exception e = null;
            this.nfRes = nfrUsrResBundle;
            fullFtpClient = this.initialiseFtpClient(username, password, machine, share, directory);
            fullFtpClient.rename(szOldName, szNewName);
            Object var13_11 = null;
            try {
                if (fullFtpClient != null) {
                    fullFtpClient.closeServer();
                }
                break block12;
            }
            catch (Exception e1) {}
            break block12;
            {
                catch (Exception ex) {
                    e = ex;
                    if (ex instanceof FileNotFoundException) {
                        throw new NetFileException(500, this.nfRes.getString("ff.7", new Object[]{szNewName}));
                    }
                    this.performFinalProcessing(e, "Could not rename file " + szOldName, fullFtpClient);
                    Object var13_12 = null;
                    try {
                        if (fullFtpClient != null) {
                            fullFtpClient.closeServer();
                        }
                        break block12;
                    }
                    catch (Exception e1) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                try {
                    if (fullFtpClient != null) {
                        fullFtpClient.closeServer();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void performFinalProcessing(Exception ex, String szDebugMsg, FullFtpClient ffc) throws NetFileException {
        if (ex != null) {
            try {
                if (ffc != null) {
                    ffc.closeServer();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.writeDebug(szDebugMsg, ex);
            if (ex instanceof FileNotFoundException) {
                throw new NetFileException(500, this.nfRes.getString("ff.8"));
            }
            if (ex instanceof NetFileException) {
                throw (NetFileException)ex;
            }
            throw new NetFileException(500, this.nfRes.getString("ff.9"));
        }
    }

    protected FullFtpClient initialiseFtpClient(String username, String password, String machine, String share, String directory) throws NetFileException {
        FullFtpClient ffc = null;
        try {
            ffc = new FullFtpClient(machine, this.szEncoding);
            ffc.setMachineToAccess(machine);
        }
        catch (Exception ioe) {
            this.writeDebug("Failed to Bind on Port 21 to host: " + machine, ioe);
            throw new NetFileException(500, this.nfRes.getString("ff.10", new Object[]{machine}));
        }
        try {
            ffc.login(username, password);
        }
        catch (Exception e) {
            this.writeDebug("Login error to " + machine, e);
            throw new NetFileException(500, this.nfRes.getString("ff.11", new Object[]{machine}));
        }
        try {
            ffc.cd(share + directory);
        }
        catch (FileNotFoundException fnfe) {
            this.writeDebug("Cannot change to directory " + share + directory, fnfe);
            throw new NetFileException(500, this.nfRes.getString("ff.12", new Object[]{share, directory}));
        }
        catch (Exception ioe) {
            this.writeDebug("Cannot change to directory " + share + directory, ioe);
            throw new NetFileException(500, this.nfRes.getString("ff.13", new Object[]{share, directory}));
        }
        try {
            ffc.binary();
        }
        catch (Exception ioe) {
            this.writeDebug("Cannot change mode to binary", ioe);
            throw new NetFileException(500, this.nfRes.getString("ff.14"));
        }
        return ffc;
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }
}

