/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.uri.URISyntaxException;
import java.io.Serializable;

public final class URI
implements Comparable,
Serializable {
    private transient String scheme;
    private transient String fragment;
    private transient String authority;
    private transient String userInfo;
    private transient String host;
    private transient int port = -1;
    private transient String path;
    private transient String query;
    private volatile transient String schemeSpecificPart;
    private volatile transient int hash;
    private volatile transient String decodedUserInfo = null;
    private volatile transient String decodedAuthority = null;
    private volatile transient String decodedPath = null;
    private volatile transient String decodedQuery = null;
    private volatile transient String decodedFragment = null;
    private volatile transient String decodedSchemeSpecificPart = null;
    private volatile String string;
    int length = 16;
    private static final long L_DIGIT = URI.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URI.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URI.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = URI.highMask('A', 'F') | URI.highMask('a', 'f');
    private static final long L_MARK = URI.lowMask("-_.!~*'()");
    private static final long H_MARK = URI.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_RESERVED = URI.lowMask(";/?:@&=+$,[]");
    private static final long H_RESERVED = URI.highMask(";/?:@&=+$,[]");
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = L_RESERVED | L_UNRESERVED | 1L;
    private static final long H_URIC = H_RESERVED | H_UNRESERVED | 0L;
    private static final long L_PCHAR = L_UNRESERVED | 1L | URI.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | 0L | URI.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | URI.lowMask(";/");
    private static final long H_PATH = H_PCHAR | URI.highMask(";/");
    private static final long L_DASH = URI.lowMask("-");
    private static final long H_DASH = URI.highMask("-");
    private static final long L_DOT = URI.lowMask(".");
    private static final long H_DOT = URI.highMask(".");
    private static final long L_USERINFO = L_UNRESERVED | 1L | URI.lowMask(";:&=+$,");
    private static final long H_USERINFO = H_UNRESERVED | 0L | URI.highMask(";:&=+$,");
    private static final long L_REG_NAME = L_UNRESERVED | 1L | URI.lowMask("$,;:@&=+");
    private static final long H_REG_NAME = H_UNRESERVED | 0L | URI.highMask("$,;:@&=+");
    private static final long L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | URI.lowMask(".:@[]");
    private static final long H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | URI.highMask(".:@[]");
    private static final long L_SCHEME = 0L | L_DIGIT | URI.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | URI.highMask("+-.");
    private static final long L_URIC_NO_SLASH = L_UNRESERVED | 1L | URI.lowMask(";?:@&=+$,");
    private static final long H_URIC_NO_SLASH = H_UNRESERVED | 0L | URI.highMask(";?:@&=+$,");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URI() {
    }

    public URI(String string) throws URISyntaxException {
        this.length = string.length();
        new Parser(string).parse(false);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URISyntaxException {
        String string7 = this.toString(string, null, null, string2, string3, n, string4, string5, string6);
        URI.checkPath(string7, string, string4);
        new Parser(string7).parse(true);
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        String string6 = this.toString(string, null, string2, null, null, -1, string3, string4, string5);
        URI.checkPath(string6, string, string3);
        new Parser(string6).parse(false);
    }

    public URI(String string, String string2, String string3, String string4) throws URISyntaxException {
        this(string, null, string2, -1, string3, null, string4);
    }

    public URI(String string, String string2, String string3) throws URISyntaxException {
        new Parser(this.toString(string, string2, null, null, null, -1, null, null, string3)).parse(false);
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (this.host != null || this.authority == null) {
            return this;
        }
        this.defineString();
        new Parser(this.string).parse(true);
        return this;
    }

    public URI normalize() {
        return URI.normalize(this);
    }

    public URI resolve(URI uRI) {
        return URI.resolve(this, uRI);
    }

    public URI relativize(URI uRI) {
        return URI.relativize(this, uRI);
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getRawSchemeSpecificPart() {
        this.defineSchemeSpecificPart();
        return this.schemeSpecificPart;
    }

    public String getSchemeSpecificPart() {
        return this.getRawSchemeSpecificPart();
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        if (this.isOpaque() != uRI.isOpaque()) {
            return false;
        }
        if (!URI.equalIgnoringCase(this.scheme, uRI.scheme)) {
            return false;
        }
        if (!URI.equal(this.fragment, uRI.fragment)) {
            return false;
        }
        if (this.isOpaque()) {
            return URI.equal(this.schemeSpecificPart, uRI.schemeSpecificPart);
        }
        if (!URI.equal(this.path, uRI.path)) {
            return false;
        }
        if (!URI.equal(this.query, uRI.query)) {
            return false;
        }
        if (this.authority == uRI.authority) {
            return true;
        }
        if (this.host != null) {
            if (!URI.equal(this.userInfo, uRI.userInfo)) {
                return false;
            }
            if (!URI.equalIgnoringCase(this.host, uRI.host)) {
                return false;
            }
            if (this.port != uRI.port) {
                return false;
            }
        } else if (this.authority != null ? !URI.equal(this.authority, uRI.authority) : this.authority != uRI.authority) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = URI.hashIgnoringCase(0, this.scheme);
        n = URI.hash(n, this.fragment);
        if (this.isOpaque()) {
            n = URI.hash(n, this.schemeSpecificPart);
        } else {
            n = URI.hash(n, this.path);
            n = URI.hash(n, this.query);
            if (this.host != null) {
                n = URI.hash(n, this.userInfo);
                n = URI.hashIgnoringCase(n, this.host);
                n += 1949 * this.port;
            } else {
                n = URI.hash(n, this.authority);
            }
        }
        this.hash = n;
        return n;
    }

    public int compareTo(Object object) {
        URI uRI = (URI)object;
        int n = URI.compareIgnoringCase(this.scheme, uRI.scheme);
        if (n != 0) {
            return n;
        }
        if (this.isOpaque()) {
            if (uRI.isOpaque()) {
                n = URI.compare(this.schemeSpecificPart, uRI.schemeSpecificPart);
                if (n != 0) {
                    return n;
                }
                return URI.compare(this.fragment, uRI.fragment);
            }
            return 1;
        }
        if (uRI.isOpaque()) {
            return -1;
        }
        if (this.host != null && uRI.host != null) {
            n = URI.compare(this.userInfo, uRI.userInfo);
            if (n != 0) {
                return n;
            }
            n = URI.compareIgnoringCase(this.host, uRI.host);
            if (n != 0) {
                return n;
            }
            n = this.port - uRI.port;
            if (n != 0) {
                return n;
            }
        } else {
            n = URI.compare(this.authority, uRI.authority);
            if (n != 0) {
                return n;
            }
        }
        if ((n = URI.compare(this.path, uRI.path)) != 0) {
            return n;
        }
        n = URI.compare(this.query, uRI.query);
        if (n != 0) {
            return n;
        }
        return URI.compare(this.fragment, uRI.fragment);
    }

    public String toString() {
        this.defineString();
        return this.string;
    }

    private static int toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c + 32;
        }
        return c;
    }

    private static boolean equal(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            if (string.length() != string2.length()) {
                return false;
            }
            if (string.indexOf(37) < 0) {
                return string.equals(string2);
            }
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                char c2 = string2.charAt(n2);
                if (c != '%') {
                    if (c != c2) {
                        return false;
                    }
                    ++n2;
                    continue;
                }
                if (URI.toLower(string.charAt(++n2)) != URI.toLower(string2.charAt(n2))) {
                    return false;
                }
                if (URI.toLower(string.charAt(++n2)) != URI.toLower(string2.charAt(n2))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static boolean equalIgnoringCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            int n = string.length();
            if (string2.length() != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (URI.toLower(string.charAt(n2)) != URI.toLower(string2.charAt(n2))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static int hash(int n, String string) {
        if (string == null) {
            return n;
        }
        return n * 127 + string.hashCode();
    }

    private static int hashIgnoringCase(int n, String string) {
        if (string == null) {
            return n;
        }
        int n2 = n;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            n2 = 31 * n2 + URI.toLower(string.charAt(n4));
            ++n4;
        }
        return n2;
    }

    private static int compare(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                return string.compareTo(string2);
            }
            return -1;
        }
        return 1;
    }

    private static int compareIgnoringCase(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                int n;
                int n2 = string.length();
                int n3 = n2 < (n = string2.length()) ? n2 : n;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = URI.toLower(string.charAt(n4)) - URI.toLower(string2.charAt(n4));
                    if (n5 != 0) {
                        return n5;
                    }
                    ++n4;
                }
                return n2 - n;
            }
            return 1;
        }
        return -1;
    }

    private static void checkPath(String string, String string2, String string3) throws URISyntaxException {
        if (string2 != null && string3 != null && string3.length() > 0 && string3.charAt(0) != '/') {
            throw new URISyntaxException(string, "Relative path in absolute URI");
        }
    }

    private void appendAuthority(StringBuffer stringBuffer, String string, String string2, String string3, int n) {
        if (string3 != null) {
            boolean bl;
            stringBuffer.append("//");
            if (string2 != null) {
                stringBuffer.append(URI.quote(string2, L_USERINFO, H_USERINFO));
                stringBuffer.append('@');
            }
            boolean bl2 = bl = string3.indexOf(58) >= 0 && !string3.startsWith("[") && !string3.endsWith("]");
            if (bl) {
                stringBuffer.append('[');
            }
            stringBuffer.append(string3);
            if (bl) {
                stringBuffer.append(']');
            }
            if (n != -1) {
                stringBuffer.append(':');
                stringBuffer.append(n);
            }
        } else if (string != null) {
            stringBuffer.append("//");
            stringBuffer.append(URI.quote(string, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
        }
    }

    private void appendSchemeSpecificPart(StringBuffer stringBuffer, String string, String string2, String string3, String string4, int n, String string5, String string6) {
        if (string != null) {
            stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
        } else {
            this.appendAuthority(stringBuffer, string2, string3, string4, n);
            if (string5 != null) {
                stringBuffer.append(URI.quote(string5, L_PATH, H_PATH));
            }
            if (string6 != null) {
                stringBuffer.append('?');
                stringBuffer.append(URI.quote(string6, L_URIC, H_URIC));
            }
        }
    }

    private void appendFragment(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append('#');
            stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
        }
    }

    private String toString(String string, String string2, String string3, String string4, String string5, int n, String string6, String string7, String string8) {
        StringBuffer stringBuffer = new StringBuffer(this.length);
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        this.appendSchemeSpecificPart(stringBuffer, string2, string3, string4, string5, n, string6, string7);
        this.appendFragment(stringBuffer, string8);
        return stringBuffer.toString();
    }

    private void defineSchemeSpecificPart() {
        if (this.schemeSpecificPart != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.length);
        this.appendSchemeSpecificPart(stringBuffer, null, this.authority, this.userInfo, this.host, this.port, this.path, this.query);
        if (stringBuffer.length() == 0) {
            return;
        }
        this.schemeSpecificPart = stringBuffer.toString();
    }

    private void defineString() {
        if (this.string != null) {
            return;
        }
        this.string = this.toString(this.scheme, this.isOpaque() ? this.schemeSpecificPart : null, this.authority, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
    }

    private static String resolvePath(String string, String string2, boolean bl) {
        CharSequence charSequence;
        int n = string.lastIndexOf(47);
        int n2 = string2.length();
        String string3 = "";
        if (n2 == 0) {
            if (n >= 0) {
                string3 = string.substring(0, n + 1);
            }
        } else {
            charSequence = new StringBuffer(string2.length() + n + 1);
            if (n >= 0) {
                ((StringBuffer)charSequence).append(string.substring(0, n + 1));
            }
            ((StringBuffer)charSequence).append(string2);
            string3 = ((StringBuffer)charSequence).toString();
        }
        charSequence = URI.normalize(string3);
        return charSequence;
    }

    private static URI resolve(URI uRI, URI uRI2) {
        if (uRI.isOpaque() || uRI2.isOpaque()) {
            return uRI2;
        }
        if (uRI2.scheme == null && uRI2.authority == null && uRI2.path.equals("") && uRI2.fragment != null && uRI2.query == null) {
            if (uRI.fragment != null && uRI2.fragment.equals(uRI.fragment)) {
                return uRI;
            }
            URI uRI3 = new URI();
            uRI3.scheme = uRI.scheme;
            uRI3.authority = uRI.authority;
            uRI3.userInfo = uRI.userInfo;
            uRI3.host = uRI.host;
            uRI3.port = uRI.port;
            uRI3.path = uRI.path;
            uRI3.fragment = uRI2.fragment;
            uRI3.query = uRI.query;
            return uRI3;
        }
        if (uRI2.scheme != null) {
            return uRI2;
        }
        URI uRI4 = new URI();
        uRI4.scheme = uRI.scheme;
        uRI4.query = uRI2.query;
        uRI4.fragment = uRI2.fragment;
        if (uRI2.authority == null) {
            String string;
            uRI4.authority = uRI.authority;
            uRI4.host = uRI.host;
            uRI4.userInfo = uRI.userInfo;
            uRI4.port = uRI.port;
            String string2 = string = uRI2.path == null ? "" : uRI2.path;
            uRI4.path = string.length() > 0 && string.charAt(0) == '/' ? uRI2.path : URI.resolvePath(uRI.path, string, uRI.isAbsolute());
        } else {
            uRI4.authority = uRI2.authority;
            uRI4.host = uRI2.host;
            uRI4.userInfo = uRI2.userInfo;
            uRI4.host = uRI2.host;
            uRI4.port = uRI2.port;
            uRI4.path = uRI2.path;
        }
        return uRI4;
    }

    private static URI normalize(URI uRI) {
        if (uRI.isOpaque() || uRI.path == null || uRI.path.length() == 0) {
            return uRI;
        }
        String string = URI.normalize(uRI.path);
        if (string == uRI.path) {
            return uRI;
        }
        URI uRI2 = new URI();
        uRI2.scheme = uRI.scheme;
        uRI2.fragment = uRI.fragment;
        uRI2.authority = uRI.authority;
        uRI2.userInfo = uRI.userInfo;
        uRI2.host = uRI.host;
        uRI2.port = uRI.port;
        uRI2.path = string;
        uRI2.query = uRI.query;
        return uRI2;
    }

    private static URI relativize(URI uRI, URI uRI2) {
        String string;
        if (uRI.isOpaque() || uRI2.isOpaque()) {
            return uRI2;
        }
        if (!URI.equalIgnoringCase(uRI.scheme, uRI2.scheme) || !URI.equal(uRI.authority, uRI2.authority)) {
            return uRI2;
        }
        String string2 = URI.normalize(uRI.path);
        if (!string2.equals(string = URI.normalize(uRI2.path))) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!string.startsWith(string2)) {
                return uRI2;
            }
        }
        URI uRI3 = new URI();
        uRI3.path = string.substring(string2.length());
        uRI3.query = uRI2.query;
        uRI3.fragment = uRI2.fragment;
        return uRI3;
    }

    /*
     * Unable to fully structure code
     */
    private static int needsNormalization(String var0) {
        var1_1 = true;
        var2_2 = 0;
        var3_3 = var0.length() - 1;
        var4_4 = 0;
        while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) != '/') break;
            ++var4_4;
        }
        if (var4_4 > 1) {
            var1_1 = false;
        }
        block1: while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) == '.' && (var4_4 == var3_3 || var0.charAt(var4_4 + 1) == '/' || var0.charAt(var4_4 + 1) == '.' && (var4_4 + 1 == var3_3 || var0.charAt(var4_4 + 2) == '/'))) {
                var1_1 = false;
            }
            ++var2_2;
            while (var4_4 <= var3_3) {
                if (var0.charAt(var4_4++) == '/') ** GOTO lbl21
                continue;
                while (var0.charAt(var4_4) == '/') {
                    var1_1 = false;
                    ++var4_4;
lbl21:
                    // 2 sources

                    if (var4_4 <= var3_3) continue;
                    continue block1;
                }
                continue block1;
            }
        }
        return var1_1 != false ? -1 : var2_2;
    }

    private static void split(char[] cArray, int[] nArray) {
        int n = cArray.length - 1;
        int n2 = 0;
        int n3 = 0;
        while (n2 <= n) {
            if (cArray[n2] != '/') break;
            cArray[n2] = '\u0000';
            ++n2;
        }
        block1: while (n2 <= n) {
            nArray[n3++] = n2++;
            while (n2 <= n) {
                if (cArray[n2++] != '/') continue;
                cArray[n2 - 1] = '\u0000';
                while (n2 <= n) {
                    if (cArray[n2] != '/') continue block1;
                    cArray[n2++] = '\u0000';
                }
                continue block1;
            }
        }
        if (n3 != nArray.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n3 = 0;
        if (cArray[n3] == '\u0000') {
            cArray[n3++] = 47;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = nArray[n4];
            if (n5 != -1) {
                if (n3 == n5) {
                    while (n3 <= n2 && cArray[n3] != '\u0000') {
                        ++n3;
                    }
                    if (n3 <= n2) {
                        cArray[n3++] = 47;
                        if (n3 <= n2 && cArray[n3] == '\u0000') {
                            cArray[n3++] = 47;
                        }
                    }
                } else if (n3 < n5) {
                    while (n5 <= n2 && cArray[n5] != '\u0000') {
                        cArray[n3++] = cArray[n5++];
                    }
                    if (n5 <= n2) {
                        cArray[n3++] = 47;
                    }
                } else {
                    throw new InternalError();
                }
            }
            ++n4;
        }
        return n3;
    }

    private static void removeDots(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = 0;
            do {
                if (cArray[n4 = nArray[n3]] != '.') continue;
                if (n4 == n2) {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] == '\u0000') {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] != '.' || n4 + 1 != n2 && cArray[n4 + 2] != '\u0000') continue;
                n5 = 2;
                break;
            } while (++n3 < n);
            if (n3 > n || n5 == 0) break;
            if (n5 == 1) {
                nArray[n3] = -1;
            } else {
                n4 = n3 - 1;
                while (n4 > 0) {
                    if (nArray[n4] != -1) break;
                    --n4;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                nArray[n3] = -1;
                nArray[n4] = -1;
            }
            ++n3;
        }
    }

    private static void maybeAddLeadingDot(char[] cArray, int[] nArray) {
        if (cArray[0] == '\u0000') {
            return;
        }
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] >= 0) break;
            ++n2;
        }
        if (n2 >= n || n2 == 0) {
            return;
        }
        int n3 = nArray[n2];
        boolean bl = false;
        try {
            while (cArray[n3] != ':' && cArray[n3] != '\u0000') {
                ++n3;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl || cArray[n3] == '\u0000') {
            return;
        }
        cArray[0] = 46;
        cArray[1] = '\u0000';
        nArray[0] = 0;
    }

    public static String normalize(String string) {
        int n = URI.needsNormalization(string);
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n];
        URI.split(cArray, nArray);
        URI.removeDots(cArray, nArray);
        URI.maybeAddLeadingDot(cArray, nArray);
        return new String(cArray, 0, URI.join(cArray, nArray));
    }

    private static long lowMask(String string) {
        int n = string.length();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '@') {
                l |= 1L << c;
            }
            ++n2;
        }
        return l;
    }

    private static long highMask(String string) {
        int n = string.length();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '@' && c < '\u0080') {
                l |= 1L << c - 64;
            }
            ++n2;
        }
        return l;
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        int n3 = n;
        while (n3 <= n2) {
            l |= 1L << n3;
            ++n3;
        }
        return l;
    }

    private static long highMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 127), 64) - 64;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        int n3 = n;
        while (n3 <= n2) {
            l |= 1L << n3;
            ++n3;
        }
        return l;
    }

    private static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    private static void appendEscape(StringBuffer stringBuffer, byte by) {
        stringBuffer.append((char)by);
    }

    private static void appendEncoded(StringBuffer stringBuffer, char c) {
        stringBuffer.append(c);
    }

    private static String quote(String string, long l, long l2) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        boolean bl = (l & 1L) != 0L;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                if (!URI.match(c, l, l2)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(0, n2));
                    }
                    URI.appendEscape(stringBuffer, (byte)c);
                } else if (stringBuffer != null) {
                    stringBuffer.append(c);
                }
            } else if (bl && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, n2));
                }
                URI.appendEncoded(stringBuffer, c);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static byte decode(char c, char c2) {
        return (byte)((URI.decode(c) & 0xF) << 4 | (URI.decode(c2) & 0xF) << 0);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "http://rajanagendra.India.Sun.COM/ips/desktop?action=content&provider=ipsdtPopupContainer&last=false&leafChannel=ipsdtSampleRSS&fontFace1=Sans-serif&size=100%&containerName=ipsdtTableContainer3&action=content&provider=ipsdtTabContainer&provider_cmds=%3CA+HREF%3D%22http%3A%2F%2Frajanagendra.India.Sun.COM%2Fips-static%2Fdocs%2Fen%2Fdesktop%2Frsschann.htm%22+target%3D%22wthelp%22+onClick%3D%22javascript%3A+var+helpWin%3Dwindow.open%28%27http%3A%2F%2Frajanagendra.India.Sun.COM%2Fips-static%2Fdocs%2Fen%2Fdesktop%2Frsschann.htm%27%2C+%27wthelp%27%2C+%27width%3D600%2Cheight%3D500%2Chotkeys%3Dno%2Cstatus%3Dno%2Cresizable%3Dyes%2Cscrollbars%3Dyes%2Ctoolbar%3Dyes%27%29%3B+helpWin.focus%28%29%3Breturn+false%3B%22%3E%3CIMG+SRC%3D%27%2Fips-static%2Fdesktop%2Fimages%2Fb_help.gif%27+ALT%3D%27Help%27+BORDER%3D0%3E%3C%2FA%3E%3CA+HREF%3D%22javascript%3Avoid%280%29%22+onClick%3D%22openUrlInParent%28%27desktop%3Faction%3Dprocess%26provider%3DipsdtTableContainer3%26ipsdtTableContainer3.channelAction%3Dattach%26ipsdtTableContainer3.targetProvider%3DipsdtSampleRSS%27%29%3B+window.close%28%29%22%3E%3CIMG+SRC%3D%22%2Fips-static%2Fdesktop%2Fimages%2Fb_attach.gif%22+ALT%3D%22Attach++ipsdtSampleRSS%22+BORDER%3D0%3E%3C%2FA%3E%3CA+HREF%3D%22javascript%3Avoid%280%29%22+onClick%3D%22openUrlInParent%28%27desktop%3Faction%3Dprocess%26provider%3DipsdtTableContainer3%26ipsdtTableContainer3.channelAction%3Dremove%26ipsdtTableContainer3.targetProvider%3DipsdtSampleRSS%27%29%3B+window.close%28%29%22%3E%3CIMG+SRC%3D%22%2Fips-static%2Fdesktop%2Fimages%2Fb_remove.gif%22+ALT%3D%22Remove++ipsdtSampleRSS%22+BORDER%3D0%3E%3C%2FA%3E";
        System.out.println(new URI(string));
    }

    private class Parser {
        private String input;
        private boolean requireServerAuthority = false;
        private int ipv6byteCount = 0;

        Parser(String string) {
            this.input = string;
            URI.this.string = string;
        }

        private void fail(String string) throws URISyntaxException {
            throw new URISyntaxException(this.input, string);
        }

        private void fail(String string, int n) throws URISyntaxException {
            throw new URISyntaxException(this.input, string, n);
        }

        private void failExpecting(String string, int n) throws URISyntaxException {
            this.fail("Expected " + string, n);
        }

        private void failExpecting(String string, String string2, int n) throws URISyntaxException {
            this.fail("Expected " + string + " following " + string2, n);
        }

        private String substring(int n, int n2) {
            return this.input.substring(n, n2);
        }

        private char charAt(int n) {
            return this.input.charAt(n);
        }

        private boolean at(int n, int n2, char c) {
            return n < n2 && this.charAt(n) == c;
        }

        private boolean at(int n, int n2, String string) {
            int n3 = n;
            int n4 = string.length();
            if (n4 > n2 - n3) {
                return false;
            }
            int n5 = 0;
            while (n5 < n4) {
                if (this.charAt(n3++) != string.charAt(n5++)) break;
            }
            return n5 == n4;
        }

        private int scan(int n, int n2, char c) {
            if (n < n2 && this.charAt(n) == c) {
                return n + 1;
            }
            return n;
        }

        private int scan(int n, int n2, String string, String string2) {
            int n3 = n;
            while (n3 < n2) {
                char c = this.charAt(n3);
                if (string.indexOf(c) >= 0) {
                    return -1;
                }
                if (string2.indexOf(c) >= 0) break;
                ++n3;
            }
            return n3;
        }

        private int scanEscape(int n, int n2, char c) throws URISyntaxException {
            int n3 = n;
            char c2 = c;
            if (c2 == '%') {
                if (n3 + 3 <= n2 && URI.match(this.charAt(n3 + 1), L_HEX, H_HEX) && URI.match(this.charAt(n3 + 2), L_HEX, H_HEX)) {
                    return n3 + 3;
                }
                if (this.charAt(n3 + 1) == '&') {
                    return n3 + 1;
                }
                this.fail("Malformed escape pair", n3);
            } else if (c2 > '\u0080' && !Character.isSpaceChar(c2) && !Character.isISOControl(c2)) {
                return n3 + 1;
            }
            return n3;
        }

        private int scan(int n, int n2, long l, long l2) throws URISyntaxException {
            int n3 = n;
            while (n3 < n2) {
                int n4;
                char c = this.charAt(n3);
                if (c == '\\' || URI.match(c, l, l2)) {
                    ++n3;
                    continue;
                }
                if ((l & 1L) == 0L || (n4 = this.scanEscape(n3, n2, c)) <= n3) break;
                n3 = n4;
            }
            return n3;
        }

        private void checkChars(int n, int n2, long l, long l2, String string) throws URISyntaxException {
            int n3 = this.scan(n, n2, l, l2);
            if (n3 < n2) {
                this.fail("Illegal character in " + string, n3);
            }
        }

        private void checkChar(int n, long l, long l2, String string) throws URISyntaxException {
            this.checkChars(n, n + 1, l, l2, string);
        }

        void parse(boolean bl) throws URISyntaxException {
            int n;
            this.requireServerAuthority = bl;
            int n2 = this.input.length();
            int n3 = this.scan(0, n2, "/?#", ":");
            if (n3 >= 0 && this.at(n3, n2, ':')) {
                if (n3 == 0) {
                    this.failExpecting("scheme name", 0);
                }
                this.checkChar(0, 0L, H_ALPHA, "scheme name");
                this.checkChars(1, n3, L_SCHEME, H_SCHEME, "scheme name");
                URI.this.scheme = this.substring(0, n3);
                n = ++n3;
                if (this.at(n3, n2, '/')) {
                    n3 = this.parseHierarchical(n3, n2);
                } else {
                    int n4 = this.scan(n3, n2, "", "#");
                    if (n4 <= n3) {
                        this.failExpecting("scheme-specific part", n3);
                    }
                    this.checkChars(n3, n4, L_URIC, H_URIC, "opaque part");
                    n3 = n4;
                }
            } else {
                n = 0;
                n3 = this.parseHierarchical(0, n2);
            }
            URI.this.schemeSpecificPart = this.substring(n, n3);
            if (this.at(n3, n2, '#')) {
                URI.this.fragment = this.substring(n3 + 1, n2);
                n3 = n2;
            }
            if (n3 < n2) {
                this.fail("end of URI", n3);
            }
        }

        private int parseHierarchical(int n, int n2) throws URISyntaxException {
            int n3;
            int n4 = n;
            if (this.at(n4, n2, '/') && this.at(n4 + 1, n2, '/')) {
                n3 = this.scan(n4 += 2, n2, "", "/?#");
                if (n3 > n4) {
                    n4 = this.parseAuthority(n4, n3);
                } else if (n3 >= n2) {
                    this.failExpecting("authority", n4);
                }
            }
            n3 = this.scan(n4, n2, "", "?#");
            URI.this.path = this.substring(n4, n3);
            n4 = n3;
            if (this.at(n4, n2, '?')) {
                n3 = this.scan(++n4, n2, "", "#");
                URI.this.query = this.substring(n4, n3);
                n4 = n3;
            }
            return n4;
        }

        private int parseAuthority(int n, int n2) throws URISyntaxException {
            boolean bl;
            int n3;
            int n4 = n3 = n;
            URISyntaxException uRISyntaxException = null;
            boolean bl2 = this.scan(n3, n2, L_SERVER, H_SERVER) == n2;
            boolean bl3 = bl = this.scan(n3, n2, L_REG_NAME, H_REG_NAME) == n2;
            if (bl && !bl2) {
                URI.this.authority = this.substring(n3, n2);
                return n2;
            }
            if (bl2) {
                try {
                    n4 = this.parseServer(n3, n2);
                    if (n4 < n2) {
                        this.failExpecting("end of authority", n4);
                    }
                    URI.this.authority = this.substring(n3, n2);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    URI.this.userInfo = null;
                    URI.this.host = null;
                    URI.this.port = -1;
                    if (this.requireServerAuthority) {
                        throw uRISyntaxException2;
                    }
                    uRISyntaxException = uRISyntaxException2;
                    n4 = n3;
                }
            }
            if (n4 < n2) {
                if (bl) {
                    URI.this.authority = this.substring(n3, n2);
                } else {
                    if (uRISyntaxException != null) {
                        throw uRISyntaxException;
                    }
                    this.fail("Illegal character in authority", n4);
                }
            }
            return n2;
        }

        private int parseServer(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, "/?#", "@");
            if (n4 >= n3 && this.at(n4, n2, '@')) {
                this.checkChars(n3, n4, L_USERINFO, H_USERINFO, "user info");
                URI.this.userInfo = this.substring(n3, n4);
                n3 = n4 + 1;
            }
            if (this.at(n3, n2, '[')) {
                if ((n4 = this.scan(++n3, n2, "/?#", "]")) > n3 && this.at(n4, n2, ']')) {
                    this.parseIPv6Reference(n3, n4);
                    n3 = n4 + 1;
                } else {
                    this.failExpecting("closing bracket for IPv6 address", n4);
                }
            } else {
                n4 = this.parseIPv4Address(n3, n2);
                if (n4 <= n3) {
                    n4 = this.parseHostname(n3, n2);
                }
                n3 = n4;
            }
            if (this.at(n3, n2, ':') && (n4 = this.scan(++n3, n2, "", "/")) > n3) {
                this.checkChars(n3, n4, L_DIGIT, 0L, "port number");
                try {
                    URI.this.port = Integer.parseInt(this.substring(n3, n4));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fail("Malformed port number", n3);
                }
                n3 = n4;
            }
            if (n3 < n2) {
                this.failExpecting("port number", n3);
            }
            return n3;
        }

        private int scanByte(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_DIGIT, 0L);
            if (n4 <= n3) {
                return n4;
            }
            if (Integer.parseInt(this.substring(n3, n4)) > 255) {
                return n3;
            }
            return n4;
        }

        private int scanIPv4Address(int n, int n2, boolean bl) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_DIGIT | L_DOT, 0L | H_DOT);
            if (n4 <= n3 || bl && n4 != n2) {
                return -1;
            }
            int n5 = this.scanByte(n3, n4);
            if (n5 > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3) {
                n3 = n5;
                if (n5 >= n4) {
                    return n5;
                }
            }
            this.fail("Malformed IPv4 address", n5);
            return -1;
        }

        private int takeIPv4Address(int n, int n2, String string) throws URISyntaxException {
            int n3 = this.scanIPv4Address(n, n2, true);
            if (n3 <= n) {
                this.failExpecting(string, n);
            }
            return n3;
        }

        private int parseIPv4Address(int n, int n2) throws URISyntaxException {
            int n3 = this.scanIPv4Address(n, n2, false);
            if (n3 > n) {
                URI.this.host = this.substring(n, n3);
            }
            return n3;
        }

        private int parseHostname(int n, int n2) throws URISyntaxException {
            int n3;
            int n4 = n;
            int n5 = -1;
            while ((n3 = this.scan(n4, n2, L_ALPHANUM, H_ALPHANUM)) > n4) {
                n5 = n4;
                if (n3 > n4 && (n3 = this.scan(n4 = n3, n2, L_ALPHANUM | L_DASH, H_ALPHANUM | H_DASH)) > n4) {
                    if (this.charAt(n3 - 1) == '-') {
                        this.fail("Illegal character in hostname", n3 - 1);
                    }
                    n4 = n3;
                }
                if ((n3 = this.scan(n4, n2, '.')) > n4 && (n4 = n3) < n2) continue;
            }
            if (n4 < n2 && !this.at(n4, n2, ':')) {
                this.fail("Illegal character in hostname", n4);
            }
            if (n5 < 0) {
                this.failExpecting("hostname", n);
            }
            if (!URI.match(this.charAt(n5), 0L, H_ALPHA)) {
                this.fail("Illegal character in hostname", n5);
            }
            URI.this.host = this.substring(n, n4);
            return n4;
        }

        private int parseIPv6Reference(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scanHexSeq(n3, n2);
            if (n4 > n3) {
                n3 = n4;
                if (this.at(n3, n2, "::")) {
                    n3 = this.scanHexPost(n3 + 2, n2);
                } else if (this.at(n3, n2, ':')) {
                    n3 = this.takeIPv4Address(n3 + 1, n2, "IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else if (this.at(n3, n2, "::")) {
                n3 = this.scanHexPost(n3 + 2, n2);
            }
            if (n3 < n2) {
                this.fail("Malformed IPv6 address", n);
            }
            if (this.ipv6byteCount > 16) {
                this.fail("IPv6 address too long", n);
            }
            URI.this.host = this.substring(n - 1, n3 + 1);
            return n3;
        }

        private int scanHexPost(int n, int n2) throws URISyntaxException {
            int n3 = n;
            if (n3 == n2) {
                return n3;
            }
            int n4 = this.scanHexSeq(n3, n2);
            if (n4 > n3) {
                n3 = n4;
                if (this.at(n3, n2, ':')) {
                    ++n3;
                    n3 = this.takeIPv4Address(n3, n2, "hex digits or IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else {
                n3 = this.takeIPv4Address(n3, n2, "hex digits or IPv4 address");
                this.ipv6byteCount += 4;
            }
            return n3;
        }

        private int scanHexSeq(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_HEX, H_HEX);
            if (n4 <= n3) {
                return -1;
            }
            if (this.at(n4, n2, '.')) {
                return -1;
            }
            this.ipv6byteCount += 2;
            n3 = n4;
            while (n3 < n2) {
                if (!this.at(n3, n2, ':') || this.at(n3 + 1, n2, ':')) break;
                if ((n4 = this.scan(++n3, n2, L_HEX, H_HEX)) <= n3) {
                    this.failExpecting("digits for an IPv6 address", n3);
                }
                if (this.at(n4, n2, '.')) {
                    --n3;
                    break;
                }
                if (n4 > n3 + 4) {
                    this.fail("IPv6 hexadecimal digit sequence too long", n3);
                }
                this.ipv6byteCount += 2;
                n3 = n4;
            }
            return n3;
        }
    }
}

