/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.DataServiceException;
import com.sun.portal.rewriter.InvalidXMLException;
import com.sun.portal.rewriter.RuleSet;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceFactory;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.TypedHashCache;
import com.sun.portal.rewriter.util.xml.Document;
import java.io.FileReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Set;
import org.xml.sax.SAXException;

public final class RuleSetManager {
    private static final TypedHashCache ruleSetCache = new TypedHashCache(class$com$sun$portal$rewriter$RuleSet == null ? (class$com$sun$portal$rewriter$RuleSet = RuleSetManager.class$("com.sun.portal.rewriter.RuleSet")) : class$com$sun$portal$rewriter$RuleSet);
    private static DataService dataService;
    static /* synthetic */ Class class$com$sun$portal$rewriter$RuleSet;

    public static synchronized DataService init(Properties properties) {
        dataService = DataServiceFactory.create(properties);
        dataService.getChangeNotifier().addObserver(ruleSetCache);
        return dataService;
    }

    public static RuleSet getInstance(String string) throws InvalidXMLException, DataServiceException {
        RuleSet ruleSet = (RuleSet)ruleSetCache.get(string);
        if (ruleSet != null) {
            return ruleSet;
        }
        String string2 = RuleSetManager.retrieve(string);
        RuleSet ruleSet2 = RuleSetManager.create(string2);
        ruleSetCache.put(ruleSet2.getID(), ruleSet2);
        return ruleSet2;
    }

    public static RuleSet create(String string) throws InvalidXMLException {
        try {
            RuleSet ruleSet = new RuleSet(Document.create(string).getRootNode());
            return ruleSet;
        }
        catch (InvalidXMLException invalidXMLException) {
            throw invalidXMLException;
        }
        catch (SAXException sAXException) {
            throw new InvalidXMLException(sAXException.getMessage(), string, sAXException, 1001);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidXMLException(exception.getMessage(), string, exception, 1000);
        }
    }

    public static RuleSet create(Reader reader) throws InvalidXMLException {
        return RuleSetManager.create(Resource.read(reader));
    }

    public static boolean validate(String string) {
        try {
            RuleSetManager.create(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Set getRuleSetNames() throws DataServiceException {
        return dataService.retrieveKeys();
    }

    public static String matchesWithID(String string) throws DataServiceException, InvalidXMLException {
        RuleSet ruleSet = RuleSetManager.create(string);
        return dataService.matchesWithID(ruleSet.getID());
    }

    private static boolean isRuleSetExists(String string) throws DataServiceException, InvalidXMLException {
        return RuleSetManager.matchesWithID(string) != null;
    }

    public static String retrieve(String string) throws DataServiceException {
        return dataService.retrieveXML(string);
    }

    public static String store(String string) throws InvalidXMLException, DataServiceException {
        RuleSet ruleSet = RuleSetManager.create(string);
        String string2 = ruleSet.getID();
        if (RuleSetManager.isRuleSetExists(string)) {
            RuleSetManager.delete(string2);
        }
        return dataService.storeXML(string2, string);
    }

    public static String delete(String string) throws DataServiceException {
        return dataService.deleteKey(string);
    }

    public static void main(String[] stringArray) throws Exception {
        RuleSet ruleSet = RuleSetManager.create(new FileReader(stringArray[0]));
        Debug.println(ruleSet.toXML());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

