/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.server;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.HTTPSession;
import com.sun.portal.rproxy.connectionhandler.Session;
import com.sun.portal.rproxy.server.ConnectionManager;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.mozilla.jss.ssl.SSLServerSocket;

public class HTTPConnectionManager
extends ConnectionManager {
    static final String TIMEOUT = "RProxyPortTimeout";
    static final String HTTPPROXY_PORT = "HTTPProxyPort";
    static final int DEFAULT_PORT = 10443;
    static final int DEFAULT_TIMEOUT = 60000;
    protected ServerSocket _ss;
    protected int _port;
    protected int _timeout;

    public HTTPConnectionManager(int port) {
        this.protocol = "http";
        this.port = port;
        this._timeout = GatewayProfile.getInt(TIMEOUT, 60000);
    }

    public void listen() {
        this._port = GatewayProfile.getInt(HTTPPROXY_PORT, 10443);
        this._ss = this.makeServerSocket(this._port);
        if (this._ss == null) {
            return;
        }
        boolean isHTTPS = this._ss instanceof SSLServerSocket;
        int logId = 0;
        while (true) {
            try {
                Socket sock = this._ss.accept();
                if (PerfContextObject.ENABLE_PERF) {
                    if (isHTTPS) {
                        SocketCount.incrementSSLSockets();
                    } else {
                        SocketCount.incrementPlainSockets();
                    }
                }
                DataInputStream in = new DataInputStream(sock.getInputStream());
                String str = null;
                ++logId;
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("httpcm1", new Object[]{new Integer(logId), sock.getInetAddress().toString(), new Integer(sock.getPort())}));
                }
                this.processConnection(sock, new Integer(logId), str);
                continue;
            }
            catch (Throwable t) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error(this.getName() + "RProxy caught unexpected exception", t);
                continue;
            }
            break;
        }
    }

    protected ServerSocket makeServerSocket(int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
        }
        catch (IOException ex) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("FATAL: RProxy (" + this.getName() + ") exited: " + port, ex);
            }
            return null;
        }
        return ss;
    }

    public void acceptConnection(Socket inSocket, Integer logId, byte[] ip) {
        String ipAddr = null;
        if (ip != null && ip.length == 4) {
            ipAddr = Integer.toString(ip[0] & 0xFF) + "." + Integer.toString(ip[1] & 0xFF) + "." + Integer.toString(ip[2] & 0xFF) + "." + Integer.toString(ip[3] & 0xFF);
        }
        this.processConnection(inSocket, logId, ipAddr);
    }

    protected void processConnection(final Socket inSocket, Integer logId, String ipAddr) {
        Session session = null;
        try {
            inSocket.setSoTimeout(this._timeout);
            final Session tempSession = session = new HTTPSession(inSocket, ipAddr, this.protocol, this.port);
            Runnable r = new Runnable(){
                private Session rSession;
                {
                    this.rSession = tempSession;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        while (true) {
                            block9: {
                                block8: {
                                    if (this.rSession == null) break block8;
                                    if (this.rSession.isStillActive()) break block9;
                                }
                                Object var2_1 = null;
                                if (this.rSession == null) return;
                                this.rSession.close();
                                this.rSession = null;
                                break;
                            }
                            this.rSession.processNextRequest();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        if (this.rSession == null) throw throwable;
                        this.rSession.close();
                        this.rSession = null;
                        try {
                            inSocket.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {
                        return;
                    }
                    inSocket.close();
                }
            };
            GWThreadPool.run(r);
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("RProxy caught exception", e);
            }
            if (session != null) {
                session.close();
            }
            if (inSocket != null) {
                try {
                    inSocket.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            session = null;
        }
    }

    public ServerSocket getServerSocket() {
        return this._ss;
    }
}

