/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.configservlet.client.SrapClient;
import com.sun.portal.util.SystemProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UserProfileGatewayCache
implements Runnable {
    private HashMap cache = new HashMap();
    private static UserProfileGatewayCache instance = null;
    private static final String GET_REQUEST = "GET_USERS";
    private static final String SET_USER_ATTRIBUTES = "SET_USER_ATTRIBUTES";
    private int numCacheEntries = 0;
    private static int MAX_CACHE_SIZE;
    private static long CACHE_SLEEP_TIME;
    private static long CLEANUP_TIME;
    private int numOfCleanCacheSkips = 0;

    private UserProfileGatewayCache() {
    }

    public static Map getResponse(String sessionId) throws SendRequestException, GetResponseException {
        UserProfileGatewayCacheEntry entry = (UserProfileGatewayCacheEntry)instance.getEntry(sessionId);
        if (entry == null && (entry = instance.addEntry(sessionId)) == null) {
            return new HashMap();
        }
        return entry.getValue();
    }

    private synchronized Object getEntry(String sessid) {
        return this.cache.get(sessid);
    }

    private synchronized void addNewEntry(Object key, Object value) {
        if (this.numCacheEntries >= MAX_CACHE_SIZE) {
            this.cleanCache(System.currentTimeMillis(), true);
        }
        this.cache.put(key, value);
        ++this.numCacheEntries;
    }

    private UserProfileGatewayCacheEntry addEntry(String sessid) throws SendRequestException, GetResponseException {
        UserProfileGatewayCacheEntry newEntry = null;
        Request request = new Request(sessid, null, GET_REQUEST);
        Response response = SrapClient.execute(request);
        if (response != null) {
            Map result = (Map)response.getReturnedObject();
            if (result == null) {
                return null;
            }
            newEntry = new UserProfileGatewayCacheEntry(result);
            this.addNewEntry(sessid, newEntry);
        }
        return newEntry;
    }

    public static void setAttribute(String sessionId, String attribute, Set value) throws SendRequestException, GetResponseException {
        Request request = new Request(sessionId, null, SET_USER_ATTRIBUTES, attribute, new Object[]{value});
        Response resp = SrapClient.execute(request);
        UserProfileGatewayCacheEntry entry = (UserProfileGatewayCacheEntry)instance.getEntry(sessionId);
        if (entry != null) {
            Map map = entry.getValue();
            map.put(attribute, value);
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(CACHE_SLEEP_TIME);
                long currtime = System.currentTimeMillis();
                if (this.numOfCleanCacheSkips >= 10) {
                    this.cleanCache(currtime, true);
                    continue;
                }
                ++this.numOfCleanCacheSkips;
                this.cleanCache(currtime, false);
            }
            catch (Throwable throwable) {
            }
        }
    }

    private synchronized void cleanCache(long time, boolean force) {
        if (force || this.numCacheEntries >= MAX_CACHE_SIZE) {
            this.numOfCleanCacheSkips = 0;
            Set keys = this.cache.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                UserProfileGatewayCacheEntry entry = (UserProfileGatewayCacheEntry)this.cache.get(key);
                if (time - entry.getTime() <= CLEANUP_TIME) continue;
                iter.remove();
                --this.numCacheEntries;
            }
        }
    }

    static {
        try {
            MAX_CACHE_SIZE = Integer.parseInt(SystemProperties.get("gateway.userProfile.cacheSize", "1024"));
        }
        catch (Exception ex) {
            MAX_CACHE_SIZE = 1024;
        }
        try {
            CACHE_SLEEP_TIME = Integer.parseInt(SystemProperties.get("gateway.userProfile.cacheSleepTime", "60000"));
        }
        catch (Exception ex) {
            CACHE_SLEEP_TIME = 60000L;
        }
        try {
            CLEANUP_TIME = Integer.parseInt(SystemProperties.get("gateway.userProfile.cacheCleanupTime", "300000"));
        }
        catch (Exception ex) {
            CLEANUP_TIME = 300000L;
        }
        instance = new UserProfileGatewayCache();
        Thread thr = new Thread(instance);
        thr.start();
    }

    private class UserProfileGatewayCacheEntry {
        private Map value = null;
        private long timestamp;

        public UserProfileGatewayCacheEntry(Map value) {
            this.value = value;
            this.timestamp = System.currentTimeMillis();
        }

        public Map getValue() {
            return this.value;
        }

        public long getTime() {
            return this.timestamp;
        }
    }
}

