/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.netlet;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.DesktopException;
import com.sun.portal.desktop.context.ContextException;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.ParameterMap;
import com.sun.portal.desktop.util.Target;
import com.sun.portal.netlet.util.UrlEncoder;
import com.sun.portal.netlet.util.UserAttributes;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetletProvider
extends ProfileProviderAdapter {
    private ResourceBundle bundle = null;
    private final String NETLET_ATTRIBUTE_PREFIX = "sunPortalNetlet";
    private final String NC_NAME = "/NetletConfig";
    private final String NC_STARTURL = "?func=makepage";
    private String editContainer = null;
    private String container = null;
    private String statusMsg = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.bundle = this.getResourceBundle("srapNetletProvider");
    }

    public String getNetletConfigURI(HttpServletRequest req) {
        String cp = req.getContextPath();
        String ncuri = cp + "/NetletConfig";
        return ncuri;
    }

    private int callNetletConfig(String func, HttpServletRequest httpreq) throws IOException, ProviderException, ContextException, SSOException {
        String host = httpreq.getServerName();
        int port = httpreq.getServerPort();
        String proto = httpreq.getScheme();
        String cookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        String ncURI = this.getNetletConfigURI(httpreq);
        String ncURL = proto + "://" + host + ":" + port + ncURI;
        URL nc = new URL(ncURL + "?func=" + func);
        HttpURLConnection ncc = (HttpURLConnection)nc.openConnection();
        ncc.setDoOutput(true);
        ncc.setDoInput(true);
        ncc.setUseCaches(false);
        ncc.setRequestProperty("Cookie", cookieName + "=" + URLEncoder.encode(SSOTokenManager.getInstance().createSSOToken(httpreq).getTokenID().toString()));
        int response = ncc.getResponseCode();
        return response;
    }

    private boolean isReauthEnabled(HttpServletRequest httpreq) {
        UserAttributes attrs = this.getNetletUserAttributes(httpreq);
        return attrs == null ? false : attrs.getBoolean("DoReauth", false);
    }

    private boolean hasStaticRule(List netletRules) {
        if (netletRules == null || netletRules.isEmpty()) {
            return false;
        }
        boolean hasStatic = false;
        int x = 0;
        while (x < netletRules.size()) {
            block8: {
                String nr = (String)netletRules.get(x);
                if (nr.endsWith("EXTEND")) {
                    nr = nr.substring(0, nr.lastIndexOf("|"));
                }
                StringTokenizer tok = new StringTokenizer(nr, "|");
                boolean isTarget = false;
                try {
                    String func = (String)tok.nextElement();
                    String tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    while (tok.hasMoreElements() && !isTarget) {
                        tmp = (String)tok.nextElement();
                        tmp = (String)tok.nextElement();
                        if (tmp.equals("TARGET")) {
                            isTarget = true;
                        }
                        tmp = (String)tok.nextElement();
                    }
                }
                catch (NoSuchElementException nsee) {
                    break block8;
                }
                if (!isTarget) {
                    hasStatic = true;
                }
            }
            ++x;
        }
        return hasStatic;
    }

    private boolean hasDynamicRule(List netletRules, String ruleName) {
        if (netletRules == null || netletRules.isEmpty()) {
            return false;
        }
        int x = 0;
        while (x < netletRules.size()) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                StringTokenizer tempTok = new StringTokenizer(func, "^");
                func = tempTok.nextToken();
                if (ruleName != null && ruleName.trim().length() != 0 && func.equals(ruleName)) {
                    String tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    while (tok.hasMoreElements() && !isTarget) {
                        tmp = (String)tok.nextElement();
                        tmp = (String)tok.nextElement();
                        if (tmp.equals("TARGET")) {
                            return true;
                        }
                        tmp = (String)tok.nextElement();
                    }
                }
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
            ++x;
        }
        return false;
    }

    private boolean hasDynamicRule(List netletRules) {
        if (netletRules == null || netletRules.isEmpty()) {
            return false;
        }
        int x = 0;
        while (x < netletRules.size()) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                String tmp = (String)tok.nextElement();
                tmp = (String)tok.nextElement();
                while (tok.hasMoreElements() && !isTarget) {
                    tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    if (tmp.equals("TARGET")) {
                        return true;
                    }
                    tmp = (String)tok.nextElement();
                }
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
            ++x;
        }
        return false;
    }

    private String trimHostNamesList(String hostNames) {
        String newHostNameList = null;
        StringTokenizer st = new StringTokenizer(hostNames, "+");
        try {
            newHostNameList = st.nextToken().trim();
            while (st.hasMoreTokens()) {
                newHostNameList = newHostNameList + "+";
                newHostNameList = newHostNameList + st.nextToken().trim();
            }
        }
        catch (NoSuchElementException nse) {
            this.getProviderContext().debugError((Object)("NetletProvider: Invalid hostname(s) -> " + nse));
        }
        return newHostNameList;
    }

    private List updateTargets(List currentTargets, List currentRules) {
        ArrayList newTargets = new ArrayList();
        int i = 0;
        while (i < currentTargets.size()) {
            Target target = new Target((String)currentTargets.get(i));
            if (this.hasDynamicRule(currentRules, target.getName())) {
                newTargets.add(currentTargets.get(i));
            }
            ++i;
        }
        return newTargets;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        boolean noNetletRules;
        StringBuffer content = new StringBuffer();
        String ncURI = this.getNetletConfigURI(req);
        String ncStartURL = ncURI + "?func=makepage";
        List<Object> targets = new ArrayList(this.getProviderContext().getCollectionProperty(this.getName(), "targets").values());
        UserAttributes attrs = this.getNetletUserAttributes(req);
        List netletRules = attrs.getStringList("Rules");
        boolean serviceEnabled = attrs.getBoolean("Execute", false);
        boolean bl = noNetletRules = netletRules == null || netletRules.isEmpty();
        if (!serviceEnabled || noNetletRules) {
            content.append("<table><tr><td>\n").append("<font FACE=\"").append(this.getStringProperty("fontFace1")).append("\" size=\"-1\">\n");
            if (!serviceEnabled) {
                content.append(this.bundle.getString("noService"));
            } else {
                content.append(this.bundle.getString("noRules"));
            }
            content.append("</font></td></tr></table>\n");
            this.getProviderContext().setBooleanProperty(this.getName(), "isEditable", false);
            return content;
        }
        if (!this.getProviderContext().getBooleanProperty(this.getName(), "isEditable")) {
            this.getProviderContext().setBooleanProperty(this.getName(), "isEditable", true);
        }
        boolean hasTargets = (targets = this.updateTargets(targets, netletRules)) != null && !targets.isEmpty();
        boolean hasDynamicRule = this.hasDynamicRule(netletRules);
        boolean startNetlet = this.hasStaticRule(netletRules);
        if (!startNetlet) {
            String macload = req.getParameter("macload");
            String agent = req.getHeader("user-agent");
            if (macload != null && macload.equals("dynamic") || agent != null && agent.indexOf("Mac_PowerPC") != -1 && agent.indexOf("MSIE") != -1) {
                startNetlet = true;
            }
        }
        content.append("<table><tr><td>\n").append("<font FACE=\"[tag:iwtDesktop-fontFace1]\" ").append("size=\"-1\">\n");
        if (!hasTargets && hasDynamicRule) {
            content.append(this.bundle.getString("noTargets"));
        } else {
            String wait = "";
            wait = startNetlet ? this.bundle.getString("wait") : this.bundle.getString("targets");
            content.append(wait);
        }
        content.append("</font>\n");
        if (startNetlet) {
            int response = 0;
            try {
                response = this.callNetletConfig("isLoaded", req);
                if (response == 204) {
                    this.callNetletConfig("setLoading", req);
                    content.append("<script language=\"JavaScript\">\n").append("netletWinOpen(\"").append(ncStartURL).append("\", true );\n").append("</script>\n");
                }
            }
            catch (IOException mue) {
                this.getProviderContext().debugError((Object)("NetletProvider.getContent()" + mue));
                throw new ProviderException("invalid netlet config url", (Throwable)mue);
            }
            catch (ProviderException ioe) {
                this.getProviderContext().debugError((Object)("NetletProvider.getContent()" + (Object)((Object)ioe)));
                throw new ProviderException("error calling netlet config", (Throwable)ioe);
            }
            catch (ContextException ce) {
                this.getProviderContext().debugError((Object)("NetletProvider.getContent()" + (Object)((Object)ce)));
                throw new ProviderException("error calling netlet config", (Throwable)ce);
            }
            catch (SSOException ssoe) {
                this.getProviderContext().debugError((Object)("NetletProvider.getContent()" + (Object)((Object)ssoe)));
                throw new ProviderException("error calling netlet config", (Throwable)ssoe);
            }
        }
        content.append("<br><hr></td></tr>\n");
        int x = 0;
        while (x < targets.size()) {
            String targ = (String)targets.get(x);
            Target target = new Target(targ);
            StringBuffer url = new StringBuffer().append(ncURI).append("?func=").append(UrlEncoder.encode(target.getName())).append("&machine=").append(this.trimHostNamesList(target.getValue()));
            StringTokenizer st = new StringTokenizer(target.getValue(), "+");
            String displayName = "";
            if (st.countTokens() == 1) {
                displayName = target.getValue().trim();
            } else {
                try {
                    displayName = "[ " + st.nextToken().trim();
                    while (st.hasMoreElements()) {
                        displayName = displayName + ", ";
                        displayName = displayName + st.nextToken().trim();
                    }
                    displayName = displayName + " ]";
                }
                catch (NoSuchElementException nse) {
                    this.getProviderContext().debugError((Object)"NetletProvider.getContent(): error reading target hosts");
                }
            }
            StringBuffer href = new StringBuffer().append("<a href=\"#").append("\" onClick=\"netletConfigOpen('").append(ncStartURL + "', '").append(url.toString()).append("'); return false;\">").append(target.getName()).append(" " + this.bundle.getString("NameHostSeparator") + " ").append(displayName).append("</a>\n");
            StringBuffer row = new StringBuffer().append("<tr><td><font FACE=\"[tag:iwtDesktop-fontFace1]\" ").append("size=\"-1\">").append(href.toString()).append("</font></td></tr>\n");
            content.append((Object)row);
            ++x;
        }
        content.append("</table>\n");
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("content", content.toString());
        tagTable.put("iwtDesktop-fontFace1", this.getStringProperty("fontFace1"));
        content = this.getTemplate("display.template", tagTable);
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String invalidHost;
        StringBuffer content = new StringBuffer();
        StringBuffer targetList = new StringBuffer("");
        this.editContainer = req.getParameter("provider");
        this.container = req.getParameter("containerName");
        List<Object> targets = null;
        UserAttributes attrs = this.getNetletUserAttributes(req);
        List netletRules = attrs.getStringList("Rules");
        targets = new ArrayList(this.getProviderContext().getCollectionProperty(this.getName(), "targets").values());
        targets = this.updateTargets(targets, netletRules);
        int count = 0;
        int x = 0;
        while (x < targets.size()) {
            String targ = (String)targets.get(x);
            Target target = new Target(targ);
            targetList.append("<TR><TD><CENTER><INPUT TYPE=\"CHECKBOX\" ").append("VALUE=\"1\" NAME=\"remove").append(count).append("\"></CENTER></TD>\n").append("<TD><FONT FACE=\"[tag:iwtDesktop-fontFace1]\" ").append("SIZE=\"+0\">\n").append(this.genRuleSelect("rule" + count, target.getName(), req)).append("\n</FONT></TD>\n").append("<TD><FONT FACE=").append("\"[tag:iwtDesktop-fontFace1]\" ").append("SIZE=\"+0\"><INPUT TYPE=\"TEXT\" ").append("RPROXY-NOPARSE VALUE=\"").append(this.trimHostNamesList(target.getValue())).append("\" SIZE=\"30\" NAME=\"host").append(count).append("\"></FONT></TD></TR>\n");
            ++count;
            ++x;
        }
        String newRuleSelect = this.genRuleSelect("newRule", req);
        String newAlgorithmSelect = this.genAlgorithmSelect(req);
        String string = invalidHost = this.bundle == null ? null : this.bundle.getString("invalidHost");
        if (invalidHost == null || invalidHost.trim().length() == 0) {
            invalidHost = new String("You must enter a valid host name(s).");
        }
        Hashtable<String, CharSequence> tagTable = new Hashtable<String, CharSequence>();
        String targetCount = Integer.toString(count);
        tagTable.put("targetCount", targetCount);
        tagTable.put("targetList", targetList.toString());
        tagTable.put("newRuleSelect", newRuleSelect);
        tagTable.put("newAlgorithmSelect", newAlgorithmSelect);
        tagTable.put("invalidHostName", invalidHost);
        tagTable.put("iwtDesktop-fontFace1", this.getStringProperty("fontFace1"));
        if (this.isReauthEnabled(req)) {
            Hashtable<String, String> changePasswordTagTable = new Hashtable<String, String>();
            if (this.statusMsg != null && this.statusMsg.trim().length() != 0) {
                changePasswordTagTable.put("changePasswdMsg", this.statusMsg);
                this.statusMsg = null;
            }
            StringBuffer changePasswordTemplate = this.getTemplate("changepassword.template", changePasswordTagTable);
            tagTable.put("changePasswordTemplate", changePasswordTemplate);
        }
        content = this.getTemplate("edit.template", tagTable);
        return content;
    }

    public Vector getExistingTargets(ParameterMap params, boolean ignoreRemove) {
        int targetCount = params.getInt("targetCount");
        Vector<String> targets = new Vector<String>();
        boolean removeFlag = false;
        int i = 0;
        while (i < targetCount) {
            if (!ignoreRemove) {
                String checkBoxValue = params.getString("remove" + i);
                boolean bl = checkBoxValue == null ? false : (removeFlag = checkBoxValue.trim().equals("1"));
            }
            if (!removeFlag) {
                String ruleString = "rule" + i;
                String hostString = "host" + i;
                String rule = params.getString(ruleString);
                String host = params.getString(hostString);
                if (!I18n.isAscii((String)host)) {
                    this.getProviderContext().debugError((Object)"NetletProvider: Non ascii host name(s) is not allowed");
                } else if (host == null || host.trim().equals("")) {
                    this.getProviderContext().debugError((Object)"NetletProvider: Empty host name(s) is not allowed");
                } else {
                    Target target = new Target(rule, host);
                    targets.add(target.toString());
                }
            }
            ++i;
        }
        return targets;
    }

    private SSOToken getSSOToken(HttpServletRequest req) {
        SSOToken ssoToken = null;
        try {
            ssoToken = SSOTokenManager.getInstance().createSSOToken(req);
        }
        catch (SSOException ssoe) {
            this.getProviderContext().debugError((Object)("NetletProvider: Unable to create ssoToken -> " + (Object)((Object)ssoe)));
        }
        return ssoToken;
    }

    private UserAttributes getNetletUserAttributes(HttpServletRequest req) {
        SSOToken ssoToken = this.getSSOToken(req);
        UserAttributes netletuserAttrs = new UserAttributes(ssoToken, "sunPortalNetlet");
        return netletuserAttrs;
    }

    private ParameterMap getParameterMap(HttpServletRequest req) {
        ParameterMap map = null;
        try {
            map = new ParameterMap(this.getProviderContext().getCharset(), req, true);
        }
        catch (DesktopException de) {
            this.getProviderContext().debugError((Object)("NetletProvider: Unable to get page parameters -> " + (Object)((Object)de)));
        }
        return map;
    }

    private URL getNetletProviderURL(HttpServletRequest req) {
        URL netletProviderURL = null;
        try {
            netletProviderURL = new URL(this.getProviderContext().getDesktopURL(req) + "?action=edit&provider=" + URLEncoder.encode(this.editContainer) + "&targetprovider=" + URLEncoder.encode(this.getName()) + "&containerName=" + URLEncoder.encode(this.container));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return netletProviderURL;
    }

    private void addTarget(ParameterMap params, Vector targets) {
        String newHost = params.getString("newHost");
        if (newHost != null && !newHost.equals("")) {
            if (!I18n.isAscii((String)newHost)) {
                this.getProviderContext().debugError((Object)"NetletProvider: Can not add non ascii host name.");
            }
            String newRule = params.getString("newRule");
            Target target = new Target(newRule, newHost);
            targets.add(target.toString());
        }
        this.getProviderContext().setCollectionProperty(this.getName(), "targets", (List)targets);
    }

    private void changePassword(ParameterMap params, UserAttributes netletuserAttrs) {
        String password = netletuserAttrs.getString("Password", "srap-netlet");
        String oldPassword = params.getString("oldPassword");
        String newPassword = params.getString("newPassword");
        String confirmNewPassword = params.getString("confirmNewPassword");
        if (!password.equals(oldPassword)) {
            this.statusMsg = this.bundle.getString("authError");
        } else if (newPassword == null || newPassword.trim().length() == 0) {
            this.statusMsg = this.bundle.getString("emptyPasswd");
        } else if (!newPassword.equals(confirmNewPassword)) {
            this.statusMsg = this.bundle.getString("checkFailed");
        } else {
            netletuserAttrs.setString("Password", newPassword);
            this.statusMsg = this.bundle.getString("passwdChanged");
        }
    }

    private void changeAlgorithm(ParameterMap params, UserAttributes netletuserAttrs) {
        List netletRules = netletuserAttrs.getStringList("Rules");
        ArrayList<String> userCiphers = new ArrayList<String>();
        int x = 0;
        while (x < netletRules.size()) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                tok = new StringTokenizer(func, "^");
                String rulename = (String)tok.nextElement();
                String algo = params.getString(rulename);
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append(rulename + "|" + algo);
                userCiphers.add(sbuffer.toString());
            }
            catch (NoSuchElementException nsee) {
                this.getProviderContext().debugError((Object)("processEdit() - " + nsee));
            }
            ++x;
        }
        netletuserAttrs.setStringList("UserCipher", userCiphers);
    }

    private void processFinished(ParameterMap params, Vector targets, UserAttributes netletuserAttrs) {
        this.addTarget(params, targets);
        this.changeAlgorithm(params, netletuserAttrs);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ParameterMap params = this.getParameterMap(req);
        if (params == null) {
            return null;
        }
        UserAttributes netletuserAttrs = this.getNetletUserAttributes(req);
        Vector targets = null;
        String addMore = params.getString("add_more");
        String changePassword = params.getString("change_password");
        if (addMore != null && addMore.length() > 0) {
            targets = new Vector(this.getProviderContext().getCollectionProperty(this.getName(), "targets").values());
            this.addTarget(params, targets);
            return this.getNetletProviderURL(req);
        }
        if (changePassword != null && changePassword.trim().length() > 0) {
            this.changePassword(params, netletuserAttrs);
            return this.getNetletProviderURL(req);
        }
        targets = this.getExistingTargets(params, false);
        this.processFinished(params, targets, netletuserAttrs);
        super.processEdit((Map)params);
        return null;
    }

    private String genRuleSelect(String name, HttpServletRequest httpreq) {
        return this.genRuleSelect(name, "", httpreq);
    }

    private String genRuleSelect(String name, String selected, HttpServletRequest httpreq) {
        StringBuffer ruleSelect = new StringBuffer(512);
        ruleSelect.append("<select name=\"").append(name).append("\">\n");
        UserAttributes attrs = this.getNetletUserAttributes(httpreq);
        List netletRules = attrs.getStringList("Rules");
        int x = 0;
        while (x < netletRules.size()) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                String tmp = (String)tok.nextElement();
                tmp = (String)tok.nextElement();
                while (tok.hasMoreElements() && !isTarget) {
                    tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    if (tmp.equals("TARGET")) {
                        isTarget = true;
                    }
                    tmp = (String)tok.nextElement();
                }
                if (isTarget) {
                    tok = new StringTokenizer(func, "^");
                    if ((func = (String)tok.nextElement()).equals(selected)) {
                        ruleSelect.append("<option selected>").append(func).append("</option>\n");
                    } else {
                        ruleSelect.append("<option>").append(func).append("</option>\n");
                    }
                }
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
            ++x;
        }
        ruleSelect.append("</select>\n");
        return ruleSelect.toString();
    }

    private String genAlgorithmSelect(HttpServletRequest httpreq) {
        StringBuffer algorithmSelect = new StringBuffer();
        UserAttributes netletuserAttrs = this.getNetletUserAttributes(httpreq);
        List netletRules = netletuserAttrs.getStringList("Rules");
        List netletUserciphers = netletuserAttrs.getStringList("UserCipher");
        int x = 0;
        while (x < netletRules.size()) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                tok = new StringTokenizer(func, "^");
                String rulename = (String)tok.nextElement();
                String algo = null;
                algo = !tok.hasMoreElements() ? netletuserAttrs.getString("DefaultCipher", "Rijndael") : (String)tok.nextElement();
                algorithmSelect.append("<TR><TD WIDTH=50% ALIGN=RIGHT><FONT FACE=\"[tag:iwtDesktop-fontFace1]\" SIZE=+0><B>");
                algorithmSelect.append(rulename);
                algorithmSelect.append(": </B></FONT></TD>");
                algorithmSelect.append("<TD ALIGN=LEFT><FONT FACE=\"[tag:iwtDesktop-fontFace1]\" SIZE=+0>");
                algorithmSelect.append("<SELECT name=\"" + rulename + "\">");
                String selectAlgo = "";
                if (tok.hasMoreElements()) {
                    int i = 0;
                    while (i < netletUserciphers.size()) {
                        String algoString = (String)netletUserciphers.get(i);
                        StringTokenizer tmp_st = new StringTokenizer(algoString, "|");
                        String tmp_rulename = tmp_st.nextToken();
                        String tmp_algorithm = tmp_st.nextToken();
                        if (rulename.equals(tmp_rulename)) {
                            selectAlgo = tmp_algorithm;
                            break;
                        }
                        ++i;
                    }
                    tok = new StringTokenizer((String)tok.nextElement(), "+");
                    while (tok.hasMoreElements()) {
                        algo = (String)tok.nextElement();
                        if (algo.equals(selectAlgo)) {
                            algorithmSelect.append("<option selected value=\"" + algo + "\">" + algo);
                            continue;
                        }
                        algorithmSelect.append("<option value=\"" + algo + "\">" + algo);
                    }
                } else {
                    algorithmSelect.append("<option selected value=\"" + algo + "\">" + algo);
                }
                algorithmSelect.append("</select></font></TD></TR>");
            }
            catch (NoSuchElementException nsee) {
                this.getProviderContext().debugError((Object)("genAlgorithmSelect() - " + nsee));
            }
            catch (Exception ex) {
                this.getProviderContext().debugError((Object)("genAlgorithmSelect() - " + ex));
            }
            ++x;
        }
        return algorithmSelect.toString();
    }
}

