/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.crypt.ciph.CipherGroup;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;
import com.sun.portal.netlet.econnection.CipherMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SessionCipherMsg
extends CipherMsg {
    protected final int MAX_SESSID_LEN = 200;
    protected byte[] sessId = null;

    public SessionCipherMsg() {
    }

    public SessionCipherMsg(CipherGroup c) {
        super((byte)1, (short)1, c);
    }

    public SessionCipherMsg(byte[] sid, int sidlen, CipherGroup c) {
        super((byte)1, (short)1, c);
        if (sidlen <= 200) {
            this.msgLen = sidlen;
            this.sessId = new byte[sidlen];
            System.arraycopy(sid, 0, this.sessId, 0, sidlen);
        }
    }

    public int readMsg(DataInputStream in) {
        int rc = 0;
        int outLen = 0;
        rc = this.readHeader(in);
        if (rc == 0) {
            if (this.msgLen > 0 && this.msgLen <= 200) {
                if (this.sessId != null) {
                    this.sessId = null;
                }
                byte[] tmpId = new byte[this.msgLen];
                try {
                    in.readFully(tmpId, 0, this.msgLen);
                    try {
                        tmpId = this.ciphergroup.getDecryptCipher().doFinal(tmpId);
                        outLen = tmpId.length;
                    }
                    catch (NetletCryptoException sce) {
                        sce.printStackTrace();
                    }
                    if (outLen >= 0) {
                        this.sessId = new byte[outLen];
                        System.arraycopy(tmpId, 0, this.sessId, 0, outLen);
                        this.msgLen = outLen;
                    } else {
                        this.msgLen = 0;
                        rc = -1;
                    }
                }
                catch (IOException e) {
                    System.out.println("SessionMsg: readMsg IOE: " + e);
                    rc = -1;
                }
                tmpId = null;
            } else {
                rc = -1;
            }
        }
        return rc;
    }

    public int writeMsg(DataOutputStream out) {
        int rc = 0;
        int outLen = 0;
        try {
            byte[] tmpId = new byte[this.sessId.length];
            System.arraycopy(this.sessId, 0, tmpId, 0, this.msgLen);
            try {
                tmpId = this.ciphergroup.getEncryptCipher().doFinal(tmpId);
                outLen = tmpId.length;
            }
            catch (NetletCryptoException sce) {
                sce.printStackTrace();
            }
            if (outLen >= 0) {
                ByteArrayOutputStream b_out = new ByteArrayOutputStream(11 + this.sessId.length);
                DataOutputStream db_out = new DataOutputStream(b_out);
                int oldmsgLen = this.msgLen;
                this.msgLen = outLen;
                this.writeHeaderToByteArray(b_out);
                if (outLen >= 0) {
                    b_out.write(tmpId, 0, outLen);
                    b_out.writeTo(out);
                    out.flush();
                    this.msgLen = oldmsgLen;
                } else {
                    rc = -1;
                }
                tmpId = null;
            } else {
                rc = -1;
            }
        }
        catch (IOException e) {
            System.out.println("SessionMsg: writeMsg IOE: " + e);
            rc = -1;
        }
        return rc;
    }

    public byte[] getToDataStream() {
        ByteArrayOutputStream b_out = new ByteArrayOutputStream(200);
        b_out.write(this.sessId, 0, this.msgLen);
        return b_out.toByteArray();
    }

    public int setFromDataStream(byte[] buffer, int buffer_len) {
        int rc = 0;
        if (buffer_len > 0 && buffer_len <= 200) {
            ByteArrayInputStream b_in = new ByteArrayInputStream(buffer);
            this.msgLen = buffer_len;
            b_in.read(this.sessId, 0, this.msgLen);
        } else {
            rc = -1;
        }
        return rc;
    }

    public byte[] getSessionId() {
        if (this.msgLen > 0 && this.msgLen <= 200) {
            byte[] id = new byte[this.msgLen];
            System.arraycopy(this.sessId, 0, id, 0, this.msgLen);
            return id;
        }
        return null;
    }

    public void setSessionId(byte[] id, int id_len) {
        this.msgLen = 0;
        if (id_len <= 200) {
            if (this.sessId != null) {
                this.sessId = null;
            }
            this.sessId = new byte[id_len];
            System.arraycopy(id, 0, this.sessId, 0, id_len);
            this.msgLen = id_len;
        }
    }
}

