/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.crypt.ciph;

import com.sun.portal.netlet.crypt.ciph.BlockCipher;
import com.sun.portal.netlet.crypt.ciph.DES;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;

public final class TripleDES
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 24;
    private static final int DES_KEY_LENGTH = 64;
    private DES des1 = new DES();
    private DES des2 = new DES();
    private DES des3 = new DES();

    public TripleDES() {
        super(8);
    }

    protected void coreInit(byte[] key, boolean decrypt) throws NetletCryptoException {
        if (key == null) {
            throw new NetletCryptoException("Null user key");
        }
        if (key.length != 24) {
            throw new NetletCryptoException("Invalid user key length");
        }
        byte[] k = new byte[8];
        System.arraycopy(key, 0, k, 0, 8);
        this.des1.coreInit(k, decrypt);
        System.arraycopy(key, 8, k, 0, 8);
        this.des2.coreInit(k, !decrypt);
        System.arraycopy(key, 16, k, 0, 8);
        this.des3.coreInit(k, decrypt);
        if (decrypt) {
            DES des = this.des1;
            this.des1 = this.des3;
            this.des3 = des;
        }
    }

    protected void coreCrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        this.des1.coreCrypt(in, inOffset, out, outOffset);
        this.des2.coreCrypt(out, outOffset, out, outOffset);
        this.des3.coreCrypt(out, outOffset, out, outOffset);
    }
}

