/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet;

import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import com.sun.portal.rproxy.configservlet.server.GatewayServiceHandler;
import com.sun.portal.rproxy.configservlet.server.GlobalAttributesServiceHandler;
import com.sun.portal.rproxy.configservlet.server.UserAttributesServiceHandler;
import com.sun.portal.rproxy.configservlet.server.UserAttributesSetHandler;
import com.sun.portal.rproxy.rewriter.services.idsame.IDSAMEDataServiceSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteConfigServlet
extends HttpServlet {
    private static final String GET_GLOBALS = "GET_GLOBALS";
    private static final String GET_USERS = "GET_USERS";
    private static final String SET_USER_ATTRIBUTES = "SET_USER_ATTRIBUTES";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Request rq = this.getRequest(request);
        Response rsp = this.handleRequest(rq);
        this.sendResponse(response, rsp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private Request getRequest(HttpServletRequest request) throws ServletException, IOException {
        try {
            ObjectInputStream objectStream = new ObjectInputStream((InputStream)request.getInputStream());
            Request ret = (Request)objectStream.readObject();
            return ret;
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(e.getMessage());
        }
    }

    private void sendResponse(HttpServletResponse response, Response rsp) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream((OutputStream)out);
        objectStream.writeObject(rsp);
        out.close();
    }

    private Response handleRequest(Request request) {
        ServiceHandler handler = this.getServiceHandler(request);
        try {
            return handler.handleRequest(request);
        }
        catch (RuntimeException e) {
            return new Response(request.getServiceName(), request.getRequestType(), e);
        }
        catch (RemoteException e) {
            return new Response(request.getServiceName(), request.getRequestType(), e);
        }
    }

    private ServiceHandler getServiceHandler(Request request) {
        if ("srapGatewayService".equals(request.getServiceName())) {
            return new GatewayServiceHandler();
        }
        if (GET_GLOBALS.equals(request.getRequestType())) {
            return new GlobalAttributesServiceHandler();
        }
        if (GET_USERS.equals(request.getRequestType())) {
            return new UserAttributesServiceHandler();
        }
        if (SET_USER_ATTRIBUTES.equals(request.getRequestType())) {
            return new UserAttributesSetHandler();
        }
        if ("HTTPDataService".equals(request.getServiceName())) {
            return new IDSAMEDataServiceSkeleton();
        }
        return null;
    }
}

