/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.perf.netlet.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class NetletServer {
    public static int MAXBUFFERSIZE;

    public int getFreeSlot(ServerThread[] st, int RRLoc) {
        int i = RRLoc;
        do {
            if (st[i] != null && st[i].t.isAlive()) continue;
            return i;
        } while ((i = (i + 1) % st.length) != RRLoc);
        return -1;
    }

    public NetletServer(String[] args) {
        int serverPort = 0;
        ServerSocket serverSocket = null;
        int RRLoc = 0;
        if (args.length != 4) {
            System.out.println("Usage : java com.sun.portal.perf.netlet.server.NetletServer <bind-host> <bind-port> <thredpool-size> <num-of-bytes>");
            System.exit(1);
        }
        MAXBUFFERSIZE = Integer.parseInt(args[3]);
        ServerThread[] st = new ServerThread[Integer.parseInt(args[2])];
        try {
            serverPort = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Invalid port number...Binding to 30000...");
            serverPort = 30000;
        }
        try {
            serverSocket = new ServerSocket(serverPort, 50, InetAddress.getByName(args[0]));
        }
        catch (UnknownHostException uhe) {
            System.out.println("Exception in making serverSocket .... " + uhe);
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println("Exception in making serverSocket .... " + ioe);
            System.exit(1);
        }
        while (true) {
            try {
                Socket inConnection = serverSocket.accept();
                RRLoc = this.getFreeSlot(st, RRLoc);
                if (RRLoc == -1) {
                    while (RRLoc == -1) {
                        System.out.println("Unable to get free slot in server pool. Sleeping for 1000 msecs");
                        Thread.sleep(20000 / Integer.parseInt(args[2]));
                        RRLoc = this.getFreeSlot(st, 0);
                    }
                }
                System.out.println("Got connection from : " + inConnection.getInetAddress());
                st[RRLoc] = new ServerThread(inConnection.getInputStream(), inConnection.getOutputStream());
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Exception occured in accepting connection...." + ioe);
                continue;
            }
            catch (InterruptedException ie) {
                System.out.println("Exception occured in accepting connection...." + ie);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        new NetletServer(args);
    }

    class ServerThread
    implements Runnable,
    Serializable {
        public Thread t = null;
        DataOutputStream d_out;
        DataInputStream d_in;

        public ServerThread(InputStream in, OutputStream out) {
            this.d_in = new DataInputStream(in);
            this.d_out = new DataOutputStream(out);
            this.t = new Thread(this);
            this.t.start();
        }

        public void run() {
            byte[] b = new byte[MAXBUFFERSIZE];
            boolean flag = true;
            int count = 0;
            while (flag) {
                try {
                    this.d_in.readFully(b, 0, MAXBUFFERSIZE);
                    this.d_out.write(b, 0, MAXBUFFERSIZE);
                    this.d_out.flush();
                    ++count;
                }
                catch (IOException ioe) {
                    flag = false;
                }
            }
        }
    }
}

