/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.crypt.ciph;

import com.sun.portal.netlet.crypt.ciph.Mode;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;
import com.sun.portal.netlet.crypt.ciph.PaddingNone;
import com.sun.portal.netlet.crypt.ciph.PaddingPKCS5;

abstract class Padding {
    private final Mode mode;
    private byte[] scratchBuf;
    private int blSize;
    private boolean isBuffered;
    protected boolean decrypt;

    Padding(Mode mode) {
        this.mode = mode;
        this.blSize = this.getBlockSize();
        this.scratchBuf = new byte[this.blSize];
        this.isBuffered = false;
    }

    static Padding getInstance(String padding, Mode mode) throws NetletCryptoException {
        if (padding.equalsIgnoreCase("None") || padding.equalsIgnoreCase("NoPadding")) {
            return new PaddingNone(mode);
        }
        if (padding.equalsIgnoreCase("PKCS5") || padding.equalsIgnoreCase("PKCS#5") || padding.equalsIgnoreCase("PKCS5Padding") || padding.equalsIgnoreCase("PKCS7") || padding.equalsIgnoreCase("PKCS#7")) {
            return new PaddingPKCS5(mode);
        }
        throw new NetletCryptoException("Padding not available [" + padding + "]");
    }

    final int getBlockSize() {
        return this.mode.getBlockSize();
    }

    final int getOutputSize(int inputLen) {
        return this.mode.getOutputSize(inputLen + this.getPadSize(inputLen));
    }

    final byte[] getIV() {
        return this.mode.getIV();
    }

    final void init(boolean decrypt, byte[] key) throws NetletCryptoException {
        this.decrypt = decrypt;
        this.mode.init(this.decrypt, key);
    }

    final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws NetletCryptoException {
        if (output.length < this.getOutputSize(inputLen)) {
            throw new NetletCryptoException("The output buffer is too short");
        }
        if (this.decrypt) {
            int i = 0;
            if (!this.isBuffered) {
                i = this.mode.update(input, inputOffset, inputLen - this.blSize, output, outputOffset);
                System.arraycopy(input, inputOffset + (inputLen - this.blSize), this.scratchBuf, 0, this.blSize);
                this.isBuffered = true;
            } else {
                i = this.mode.update(this.scratchBuf, 0, this.blSize, output, outputOffset);
                System.arraycopy(input, inputOffset + (inputLen - this.blSize), this.scratchBuf, 0, this.blSize);
                i += this.mode.update(input, inputOffset, inputLen - this.blSize, output, outputOffset + this.blSize);
            }
            return i;
        }
        return this.mode.update(input, inputOffset, inputLen, output, outputOffset);
    }

    final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws NetletCryptoException {
        if (output.length < this.getOutputSize(inputLen)) {
            throw new NetletCryptoException("The output buffer is too short");
        }
        if (this.decrypt) {
            if (input == null && !this.isBuffered) {
                return 0;
            }
            if (input != null && inputLen < this.getPadSize(inputLen)) {
                throw new NetletCryptoException("Input data not bounded by the padding size");
            }
            int i = 0;
            if (this.isBuffered) {
                i = this.mode.update(this.scratchBuf, 0, this.blSize, output, outputOffset);
                if (input != null) {
                    i += this.mode.update(input, inputOffset, inputLen, output, outputOffset + this.blSize);
                }
            } else {
                i = this.mode.update(input, inputOffset, inputLen, output, outputOffset);
            }
            this.isBuffered = false;
            return this.coreUnPad(output, i);
        }
        byte[] t = this.corePad(input, inputLen);
        return this.mode.update(t, inputOffset, t.length, output, outputOffset);
    }

    protected int getBufSize() {
        return this.mode.getBufSize();
    }

    abstract byte[] corePad(byte[] var1, int var2) throws NetletCryptoException;

    abstract int coreUnPad(byte[] var1, int var2);

    abstract int getPadSize(int var1);
}

