/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.StandardURI;
import com.sun.portal.rewriter.util.uri.URIHelper;
import com.sun.portal.rewriter.util.uri.URIIntf;
import java.net.MalformedURLException;

public class DecoratedURI
implements URIIntf {
    private final StandardURI uriImpl;
    private String portString = null;
    private String networkURI = null;
    private String baseHREF = null;
    private String relativeURI = null;
    private String resolveURIString = null;
    private String userInfo = null;
    private String query = null;
    private String reference = null;
    private String fileURI = null;
    private String fullFileURI = null;
    private String externalForm = null;
    private DecoratedURI resolveURI = null;

    private DecoratedURI(StandardURI standardURI) {
        this.uriImpl = standardURI;
    }

    public DecoratedURI(String string) throws MalformedURLException {
        this.uriImpl = new StandardURI(string);
    }

    public String getNetworkURI() {
        if (this.networkURI == null) {
            this.networkURI = this.getProtocol() + "://" + this.getHost();
            if (this.getPortString().length() > 0) {
                this.networkURI = this.networkURI + this.getPortString();
            }
        }
        return this.networkURI;
    }

    public String getRelativeURI() {
        this.relativeURI = this.relativeURI == null ? this.getFileURI() + this.getQuery() + this.getReference() : "";
        return this.relativeURI;
    }

    public String getProtocol() {
        return this.uriImpl.getProtocol();
    }

    public String getHost() {
        return this.uriImpl.getHost();
    }

    public String getResolveURIString() {
        if (this.resolveURIString == null) {
            this.resolveURIString = this.getBaseHREF() + this.uriImpl.getFileName();
        }
        return this.resolveURIString;
    }

    public DecoratedURI getResolveURI() throws Exception {
        if (this.resolveURI == null) {
            this.resolveURI = new DecoratedURI(this.getResolveURIString());
        }
        return this.resolveURI;
    }

    public int getPort() {
        int n = this.uriImpl.getPort();
        if (n == this.uriImpl.getDefaultPort()) {
            return -1;
        }
        return n;
    }

    public String getPortString() {
        if (this.portString == null) {
            int n = this.getPort();
            this.portString = n != -1 ? ":" + n : "";
        }
        return this.portString;
    }

    public String getUserInfo() {
        if (this.userInfo == null) {
            this.userInfo = this.uriImpl.getUserInfo().equals("") ? "" : this.uriImpl.getUserInfo() + "@";
        }
        return this.userInfo;
    }

    public String getPath() {
        return this.uriImpl.getPath();
    }

    public String getParameterValue(String string) {
        return this.uriImpl.getParameterValue(string);
    }

    public String getInputString() {
        return this.uriImpl.getInputString();
    }

    public final String toExternalForm() {
        if (this.externalForm == null) {
            if (!this.isValid()) {
                this.externalForm = this.uriImpl.toExternalForm();
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.getInputString().length());
                stringBuffer.append(this.getProtocol()).append("://").append(this.getUserInfo()).append(this.getHost()).append(this.getPortString()).append(this.getPath()).append(this.getQuery()).append(this.getReference());
                this.externalForm = stringBuffer.toString();
            }
        }
        return this.externalForm;
    }

    public boolean isAbsolute() {
        return this.uriImpl.isAbsolute();
    }

    public int getDefaultPort() {
        return this.uriImpl.getDefaultPort();
    }

    public String getFileURI() {
        if (this.fileURI == null) {
            this.fileURI = StringHelper.normalize(this.uriImpl.getFileURI());
            if (URIHelper.needsToAppendDirectorySeperator(this.fileURI)) {
                this.fileURI = this.uriImpl.getFileURI() + "/";
            }
        }
        return this.fileURI;
    }

    public String getDirURI() {
        return this.uriImpl.getDirURI();
    }

    public String getFileName() {
        return this.uriImpl.getFileName();
    }

    public String getQuery() {
        if (this.query == null) {
            this.query = this.hasQuery() ? "?" + this.uriImpl.getQuery() : "";
        }
        return this.query;
    }

    public String getReference() {
        if (this.reference == null) {
            this.reference = this.hasReference() ? "#" + this.uriImpl.getReference() : "";
        }
        return this.reference;
    }

    public boolean hasReference() {
        return this.uriImpl.hasReference();
    }

    public boolean hasQuery() {
        return this.uriImpl.hasQuery();
    }

    public String getBaseHREF() {
        if (this.baseHREF == null) {
            this.baseHREF = this.getNetworkURI() + this.uriImpl.getDirURI();
        }
        return this.baseHREF;
    }

    public String getFullFileURI() {
        if (this.fullFileURI == null) {
            this.fullFileURI = this.getNetworkURI() + this.getFileURI();
        }
        return this.fullFileURI;
    }

    public boolean isValid() {
        return this.uriImpl.isValid();
    }

    public DecoratedURI resolve(String string) throws MalformedURLException {
        return new DecoratedURI(this.uriImpl.resolve(string));
    }

    public URIIntf getDecoratee() {
        return this.uriImpl;
    }

    public String toString() {
        return "Contents of URISpec Object:\n\tOriginal: " + this.getInputString() + "\n\tTranslated: " + this.toExternalForm() + "\n\tProtocol: " + this.getProtocol() + "\n\tHost: " + this.getHost() + "\n\tPort: " + this.getPortString() + "\n\tServerURI: " + this.getNetworkURI() + "\n\tFileURI: " + this.getFileURI() + "\n\tDirPath: " + this.getDirURI() + "\n\tFileName:" + this.getFileName() + "\n\tReference: " + this.getReference() + "\n\tQuery: " + this.getQuery() + "\n\tRelativeURI: " + this.getRelativeURI() + "\n\tBaseHREF: " + this.getBaseHREF();
    }

    public String getImplID() {
        return "DecoratedURI";
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"https://zeus.nawab.inda.com:443/index.html", "https://rajanagendra.sun.com:443/home/rule.jsp#rajesh", "https://rajanagendra.sun.com:443/home/rule.jsp#rajesh?ab=12&&34=yu", "https://rajanagendra.sun.com:443/home/..", "http://rajanagendra.sun.com/Base/Raja/raja.html", "http://raja.com", "http://rajanagendra.sun.com/avc/abc.jsp", "http://rajanagendra.sun.com/", "http://rajanagendra.sun.com:80/home/rule.jsp?ab=12&&34=yu", "https://rajanagendra.sun.com:1443/home/rule.jsp#rajesh?ab=12&&34=yu"};
        int n = 0;
        while (n < stringArray2.length) {
            DecoratedURI decoratedURI = new DecoratedURI(stringArray2[n]);
            System.out.println(decoratedURI.getPort());
            ++n;
        }
    }
}

