/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.NetFileException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class NetFileResource {
    private static Debug debug = null;
    private HashMap ht_resource_bundle_entry_set;
    private String s_bundle;
    private String s_locale;
    private String s_empty_string = "";
    private static final HashMap ht_locales = new HashMap(6);
    private static final HashMap ht_s_locales = new HashMap(6);
    private static NetFileResource nfRes;

    private NetFileResource() {
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    private NetFileResource(String bundle, String locale) throws NetFileException {
        this();
        if (bundle == null) {
            throw new NetFileException("null bundle name passed");
        }
        if (locale == null) {
            throw new NetFileException("null locale name passed");
        }
        this.s_bundle = bundle;
        this.s_locale = locale;
        this.ht_resource_bundle_entry_set = this.getLocalisedBundle(bundle, this.s_locale);
    }

    private NetFileResource(String bundle) throws NetFileException {
        this();
        if (bundle == null) {
            throw new NetFileException("null bundle name passed");
        }
        ResourceBundle rb_amconfig = ResourceBundle.getBundle("AMConfig");
        String s_locale = rb_amconfig.getString("com.iplanet.am.locale");
        if (s_locale == null) {
            throw new NetFileException("There is no key as com.iplanet.am.locale in AMConfig.properties");
        }
        if (s_locale.equals(this.s_empty_string)) {
            throw new NetFileException("There is no value for com.iplanet.am.locale in AMConfig.properties");
        }
        this.s_bundle = bundle;
        this.s_locale = s_locale;
        this.ht_resource_bundle_entry_set = this.getLocalisedBundle(bundle, s_locale);
    }

    public static synchronized NetFileResource getInstance(String bundle, String locale) throws NetFileException {
        if (nfRes == null) {
            nfRes = new NetFileResource(bundle, locale);
            return nfRes;
        }
        return nfRes;
    }

    public static synchronized NetFileResource getInstance(String bundle) throws NetFileException {
        if (nfRes == null) {
            nfRes = new NetFileResource(bundle);
            return nfRes;
        }
        return nfRes;
    }

    private HashMap getLocalisedBundle(String bundle, String locale) throws NetFileException {
        HashMap ht_locale_specific_bundles = this.getLocaleHashtable(locale);
        HashMap ht_locale_specific_bundle = (HashMap)ht_locale_specific_bundles.get(bundle);
        if (ht_locale_specific_bundle == null) {
            ht_locale_specific_bundle = this.populatei18nBucket(bundle, locale);
            ht_locale_specific_bundles.put(bundle, ht_locale_specific_bundle);
        }
        return ht_locale_specific_bundle;
    }

    private HashMap getLocaleHashtable(String locale) throws NetFileException {
        try {
            int index = locale.indexOf("_", 0);
            if (index < 0) {
                throw new Exception("Invalid locale name " + locale);
            }
            HashMap ht_locale_specific_bundles = (HashMap)ht_locales.get(locale);
            if (ht_locale_specific_bundles == null) {
                ht_locale_specific_bundles = new HashMap(6);
            }
            ht_locales.put(locale, ht_locale_specific_bundles);
            return ht_locale_specific_bundles;
        }
        catch (Exception e) {
            debug.error("Exception in searching for hashtable containg bundles in a locale", (Throwable)e);
            throw new NetFileException(e);
        }
    }

    public String getString(String s_key) {
        Object o_value = this.ht_resource_bundle_entry_set.get(s_key);
        if (o_value == null) {
            debug.error("Key " + s_key + " does not exist in bundle " + this.s_bundle + " for locale " + this.s_locale);
            return s_key;
        }
        return (String)o_value;
    }

    public String getAppletResources(String bundle, String locale) throws NetFileException {
        String bundle_as_string;
        int index = locale.indexOf("_", 0);
        if (index < 0) {
            throw new NetFileException("Invalid locale name " + locale);
        }
        HashMap<String, String> locale_specific_bundles = (HashMap<String, String>)ht_s_locales.get(locale);
        if (locale_specific_bundles == null) {
            locale_specific_bundles = new HashMap<String, String>(6);
            ht_s_locales.put(locale, locale_specific_bundles);
        }
        if ((bundle_as_string = (String)locale_specific_bundles.get(bundle)) == null) {
            HashMap localised_bundle = this.getLocalisedBundle(bundle, locale);
            StringBuffer st = new StringBuffer();
            String value = this.s_empty_string;
            String key = this.s_empty_string;
            Set keySet = localised_bundle.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = (String)localised_bundle.get(key);
                st.append(key + "=" + value).append('\n');
            }
            bundle_as_string = st.toString();
            locale_specific_bundles.put(bundle, bundle_as_string);
        }
        return bundle_as_string;
    }

    private HashMap populatei18nBucket(String bundle, String locale) throws NetFileException {
        int index = locale.indexOf("_", 0);
        if (index < 0) {
            throw new NetFileException("Invalid locale name " + locale);
        }
        HashMap<String, Object> bucket = new HashMap<String, Object>();
        try {
            String key = null;
            Object value = null;
            Locale loc = new Locale(locale.substring(0, index), locale.substring(index + 1));
            ResourceBundle resBundle = ResourceBundle.getBundle(bundle, loc);
            Enumeration<String> e = resBundle.getKeys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                value = resBundle.getObject(key);
                bucket.put(key, value);
            }
        }
        catch (Exception e) {
            throw new NetFileException(e);
        }
        return bucket;
    }
}

