/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.sun.portal.netfile.NetFileCompress;
import com.sun.portal.netfile.NetFileGZipOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class NetFileCompression
implements NetFileCompress {
    private int bufSize = 4096;
    int compressLevel = 6;
    String compressMethod = null;

    public NetFileCompression(int cmpLevel, String cmpMethod) {
        this.compressLevel = cmpLevel;
        this.compressMethod = cmpMethod;
    }

    public NetFileCompression() {
        this.compressLevel = 6;
        this.compressMethod = "ZIP";
    }

    public void setCompressLevel(int i) {
        this.compressLevel = i;
    }

    public void setCompressMethod(String s) {
        this.compressMethod = s == null || s.equals("") ? "ZIP" : s;
    }

    public void setBufferSize(int i) {
        this.bufSize = i <= 1024 ? 1024 : 4096;
    }

    private ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    public void doCompress(InputStream istream, OutputStream ostream, Object obj) throws IOException {
        if (istream == null) {
            throw new NullPointerException("Cannot Read. InputStream is null");
        }
        if (ostream == null) {
            throw new NullPointerException("Cannot Write. OutputStream is null");
        }
        String name = "";
        if (this.compressMethod.equalsIgnoreCase("gzip")) {
            this.doGZipCompress(istream, ostream, new Deflater(this.compressLevel));
        } else if (this.compressMethod.equalsIgnoreCase("zip")) {
            name = (String)obj;
            this.doZipCompress(istream, ostream, name);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doZipCompress(InputStream ist, OutputStream ost, String entry) throws IOException {
        int len = 0;
        byte[] buf = new byte[this.bufSize];
        ZipOutputStream zos = new ZipOutputStream(ost);
        zos.closeEntry();
        zos.putNextEntry(this.createZipEntry(entry));
        zos.setMethod(8);
        zos.setLevel(this.compressLevel);
        try {
            try {
                while ((len = ist.read(buf)) > -1) {
                    zos.write(buf, 0, len);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (zos != null) {
                    zos.close();
                }
                if (ist == null) throw throwable;
                ist.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (zos != null) {
            zos.close();
        }
        if (ist == null) return;
        ist.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGZipCompress(InputStream ist, OutputStream ost, Deflater deflater) throws IOException {
        int len = 0;
        byte[] buffer = new byte[this.bufSize];
        NetFileGZipOutputStream gzos = new NetFileGZipOutputStream(ost, this.bufSize);
        gzos.setLevel(this.compressLevel);
        try {
            try {
                while ((len = ist.read(buffer)) > -1) {
                    gzos.write(buffer, 0, len);
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                throw ioe;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (gzos != null) {
                    gzos.close();
                }
                if (ist == null) throw throwable;
                ist.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (gzos != null) {
            gzos.close();
        }
        if (ist == null) return;
        ist.close();
        return;
    }
}

