/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.template.table;

import com.sun.portal.desktop.util.IURLEncoder;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.template.TemplateContainerProvider;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.context.Theme;
import com.sun.portal.providers.util.PropertyUtil;
import com.sun.portal.providers.util.ProviderCommands;
import com.sun.portal.providers.util.ProviderOrder;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateTableContainerProvider
extends TemplateContainerProvider {
    private static Map templateMap = null;

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        StringBuffer ob = new StringBuffer();
        List userProviders = this.getSelectedChannels();
        String channelAction = req.getParameter(this.getName() + ".channelAction");
        if (channelAction == null) {
            ob = !userProviders.isEmpty() ? this.buildPage(req, res) : this.buildEmptyPage(req);
        } else if (channelAction.equals("popup")) {
            ob = this.getPopupProviderContents(req, res);
        } else if (pc.isDebugMessageEnabled()) {
            pc.debugMessage("FrontProvider.getContent: Invalid channel action");
        }
        return ob;
    }

    protected StringBuffer buildPage(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer leftContent = new StringBuffer();
        StringBuffer centerContent = new StringBuffer();
        StringBuffer rightContent = new StringBuffer();
        StringBuffer fullTopContent = new StringBuffer();
        StringBuffer fullBottomContent = new StringBuffer();
        StringBuffer detachedContent = new StringBuffer(128);
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        ResourceBundle bundle = this.getResourceBundle();
        HashMap<String, StringBuffer> completedProviderContent = new HashMap<String, StringBuffer>();
        int timeout = 1800;
        timeout = this.getIntegerProperty("timeout");
        HashMap pContent = new HashMap();
        Hashtable tags = this.getStandardTags(req);
        String desktopURL = pc.getDesktopURL(req);
        String sContext = pc.getStaticContentPath();
        int pwidth = 0;
        int pheight = 0;
        boolean dFramed = true;
        String selectedTabName = (String)req.getAttribute("selectedTabName");
        if (selectedTabName != null) {
            tags.put("selectedTabName", IURLEncoder.encode(selectedTabName));
        } else {
            tags.put("selectedTabName", "");
        }
        tags.put("frontContainerName", this.getName());
        Map channelsHasFrame = this.getMapProperty("channelsHasFrame");
        Map channelsBackgroundColor = this.getMapProperty("channelsBackgroundColor");
        Map channelsIsDetached = this.getMapProperty("channelsIsDetached");
        Map channelsIsDetachable = this.getMapProperty("channelsIsDetachable");
        Map channelsIsMinimized = this.getMapProperty("channelsIsMinimized");
        Map channelsIsMinimizable = this.getMapProperty("channelsIsMinimizable");
        Map channelsIsRemovable = this.getMapProperty("channelsIsRemovable");
        Map borderlessChannels = this.getMapProperty("borderlessChannels");
        boolean dIsMinimizable = this.getBooleanProperty("defaultChannelIsMinimizable");
        boolean dIsMinimized = this.getBooleanProperty("defaultChannelIsMinimized");
        boolean dIsDetachable = this.getBooleanProperty("defaultChannelIsDetachable");
        boolean dIsDetached = this.getBooleanProperty("defaultChannelIsDetached");
        boolean dIsRemovable = this.getBooleanProperty("defaultChannelIsRemovable");
        boolean dBorderlessChannel = this.getBooleanProperty("defaultBorderlessChannel");
        List nonMinimizedList = this.getSelectedChannels();
        this.genMinimizedContent(channelsIsMinimized, nonMinimizedList, pContent, dIsMinimized);
        pContent.putAll(cpc.getContent(req, res, this.getName(), nonMinimizedList, timeout));
        tags.put("frontContainerName", this.getName());
        dFramed = this.getBooleanProperty("defaultChannelHasFrame");
        String dBgColor = null;
        String bgColor = null;
        String dBorderwidth = null;
        try {
            dBgColor = Theme.getAttribute(this.getName(), pc, "bgColor");
            dBorderwidth = Theme.getAttribute(this.getName(), pc, "borderWidth");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("TemplateTableContainerProvider.buildPage(): failed to get theme related attribute", pce);
        }
        StringBuffer paramsb = new StringBuffer("");
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            String value = req.getParameter(param);
            paramsb.append("&").append(param).append("=").append(IURLEncoder.encode(value));
        }
        List userProviders = this.getSelectedChannels();
        Iterator i = userProviders.iterator();
        while (i.hasNext()) {
            String provider = (String)i.next();
            if (pc.isDebugMessageEnabled()) {
                pc.debugMessage("FrontProvider.buildPage, loop through for " + provider);
            }
            if (!channelsBackgroundColor.isEmpty()) {
                bgColor = (String)channelsBackgroundColor.get(provider);
            }
            if (PropertyUtil.getBooleanValueFromMap(borderlessChannels, provider, dBorderlessChannel)) {
                tags.put("borderWidth", "0");
            } else {
                tags.put("borderWidth", dBorderwidth);
            }
            StringBuffer populatedProviderWrapper = new StringBuffer();
            StringBuffer provider_cmds = new StringBuffer();
            StringBuffer providerContent = null;
            Provider p = null;
            providerContent = pContent.containsKey(provider) ? (StringBuffer)pContent.get(provider) : (bundle != null ? new StringBuffer(bundle.getString("error_channel_timedout")) : new StringBuffer("ERROR:Channel Timed Out"));
            if (providerContent == null && (providerContent = cpc.getCachedContent(provider)) == null) {
                providerContent = this.buildErrorMsg("error_content_not_available");
            }
            if ((p = cpc.getProvider(req, this.getName(), provider)) == null) continue;
            int width = 1;
            try {
                width = p.getWidth();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (width != -1) {
                switch (width) {
                    case 2: {
                        pwidth = this.getIntegerProperty("fullwidth_popup_width");
                        pheight = this.getIntegerProperty("fullwidth_popup_height");
                        break;
                    }
                    case 3: {
                        pwidth = this.getIntegerProperty("fullwidth_popup_width");
                        pheight = this.getIntegerProperty("fullwidth_popup_height");
                        break;
                    }
                    case 1: {
                        pwidth = this.getIntegerProperty("thin_popup_width");
                        pheight = this.getIntegerProperty("thin_popup_height");
                        break;
                    }
                    case 0: {
                        pwidth = this.getIntegerProperty("thick_popup_width");
                        pheight = this.getIntegerProperty("thick_popup_height");
                        break;
                    }
                    default: {
                        pc.debugError("FrontProvider.buildPage(): unknown width=" + width);
                    }
                }
            }
            boolean isDetached = PropertyUtil.getBooleanValueFromMap(channelsIsDetached, provider, dIsDetached);
            boolean isMinimized = PropertyUtil.getBooleanValueFromMap(channelsIsMinimized, provider, dIsMinimized);
            String window_name = this.getName() + p.getName();
            String new_window_name = PropertyUtil.replaceChannelName(URLEncoder.encode(window_name));
            if (isDetached) {
                detachedContent.append("<script language=\"JavaScript\">\n").append("launchPopup(").append("'dt?action=content&provider=").append(this.getName()).append("&last=false").append("&").append(this.getName()).append(".channelAction=popup&").append(this.getName()).append(".targetProvider=").append(p.getName()).append(paramsb.toString()).append("' ,'").append(new_window_name).append("', ").append(pwidth).append(", ").append(pheight).append(");\n").append("</script>\n");
                continue;
            }
            String title = null;
            try {
                title = p.getTitle();
            }
            catch (Throwable t) {
                pc.debugError("FrontProvider.buildPage(), title property not found for: " + provider);
                StringBuffer msg = this.buildErrorMsg("error_missing_property");
                providerContent = msg.append((Object)providerContent);
                title = "";
            }
            boolean framed = PropertyUtil.getBooleanValueFromMap(channelsHasFrame, provider, dFramed);
            if (title != null) {
                tags.put("title", title);
            }
            Hashtable tagtable = ProviderCommands.getProviderCommands(p, this.getName(), cpc, req, bundle, desktopURL, sContext, channelsIsDetachable, channelsIsDetached, channelsIsMinimizable, channelsIsMinimized, channelsIsRemovable, dIsDetachable, dIsDetached, dIsMinimizable, dIsMinimized, dIsRemovable);
            tags.put("provider_cmds", this.getTemplate("providerCommands.template", tagtable));
            tags.put("content", providerContent.toString());
            tags.put("size", "100%");
            if (bgColor != null) {
                tags.put("bgColor", bgColor);
            } else {
                tags.put("bgColor", dBgColor);
            }
            String wrapper = null;
            wrapper = framed ? (providerContent.length() != 0 && !isMinimized ? "providerWrapper.template" : "minimized.template") : "bareProviderWrapper.template";
            StringBuffer thePopulatedProviderWrapper = this.getTemplate(wrapper, tags);
            populatedProviderWrapper.append(thePopulatedProviderWrapper.toString());
            completedProviderContent.put(provider, populatedProviderWrapper);
        }
        List providerOrder = ProviderOrder.order(this.getSelectedChannels(), this.getName(), cpc, req);
        Map channelsColumn = null;
        int layout = -1;
        layout = this.getIntegerProperty("layout");
        channelsColumn = this.getMapProperty("channelsColumn");
        Iterator i2 = providerOrder.iterator();
        while (i2.hasNext()) {
            String providerName = (String)i2.next();
            Provider p = null;
            p = cpc.getProvider(req, this.getName(), providerName);
            if (p == null) continue;
            if (!completedProviderContent.containsKey(providerName)) {
                if (!pc.isDebugWarningEnabled()) continue;
                pc.debugWarning("FrontProvider.buildPage(): no content for providerName=" + providerName);
                continue;
            }
            StringBuffer completed = (StringBuffer)completedProviderContent.get(providerName);
            int column = 1;
            int width = 1;
            String defaultChannelColumn = this.getStringProperty("defaultChannelColumn");
            try {
                width = p.getWidth();
                column = Integer.parseInt(PropertyUtil.getStringValueFromMap(channelsColumn, providerName, defaultChannelColumn));
                if (pc.isDebugMessageEnabled()) {
                    pc.debugMessage("FrontProvider.buildPage(): got column: " + column);
                }
            }
            catch (NumberFormatException e) {
                pc.debugError("FrontProvider.buildPage(), width property not valid for: " + providerName);
                completed = this.buildErrorMsg("error_missing_property");
                completed.append((Object)((StringBuffer)completedProviderContent.get(providerName)));
            }
            catch (Throwable t) {
                pc.debugError("FrontProvider.buildPage(), width property not found for: " + providerName);
                completed = this.buildErrorMsg("error_missing_property");
                completed.append((Object)((StringBuffer)completedProviderContent.get(providerName)));
            }
            if (width == -1) continue;
            block10 : switch (width) {
                case 2: {
                    fullTopContent.append((Object)completed);
                    break;
                }
                case 3: {
                    fullBottomContent.append((Object)completed);
                    break;
                }
                case 1: {
                    switch (layout) {
                        case 1: {
                            leftContent.append((Object)completed);
                            break block10;
                        }
                        case 2: {
                            rightContent.append((Object)completed);
                            break block10;
                        }
                        case 3: {
                            if (column == 1) {
                                leftContent.append((Object)completed);
                                break block10;
                            }
                            rightContent.append((Object)completed);
                            break block10;
                        }
                        case 4: {
                            if (column == 2) {
                                rightContent.append((Object)completed);
                                break block10;
                            }
                            if (column == 1) {
                                leftContent.append((Object)completed);
                                break block10;
                            }
                            centerContent.append((Object)completed);
                            break block10;
                        }
                    }
                    pc.debugError("FrontProvider.buildPage(): unknown layout=" + layout);
                    break;
                }
                case 0: {
                    switch (layout) {
                        case 1: {
                            rightContent.append((Object)completed);
                            break block10;
                        }
                        case 2: {
                            leftContent.append((Object)completed);
                            break block10;
                        }
                        case 3: {
                            centerContent.append((Object)completed);
                            break block10;
                        }
                    }
                    break;
                }
                default: {
                    pc.debugError("FrontProvider.buildPage(): unknown width=" + width);
                }
            }
        }
        int centerWidth = 0;
        int rightWidth = 0;
        int leftWidth = 0;
        switch (layout) {
            case 1: {
                leftWidth = 30;
                rightWidth = 70;
                break;
            }
            case 2: {
                rightWidth = 30;
                leftWidth = 70;
                break;
            }
            case 3: {
                rightWidth = 25;
                centerWidth = 50;
                leftWidth = 25;
                break;
            }
            case 4: {
                rightWidth = 33;
                centerWidth = 33;
                leftWidth = 33;
            }
        }
        StringBuffer content = new StringBuffer();
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage("FrontProvider.buildPage(): center width=" + leftWidth);
            pc.debugMessage("FrontProvider.buildPage(): center content =" + leftContent.toString());
        }
        tags.put("fullTopContent", fullTopContent);
        tags.put("leftWidth", Integer.toString(leftWidth));
        tags.put("leftContent", leftContent);
        tags.put("centerWidth", Integer.toString(centerWidth));
        tags.put("centerContent", centerContent);
        tags.put("rightWidth", Integer.toString(rightWidth));
        tags.put("rightContent", rightContent);
        tags.put("fullBottomContent", fullBottomContent);
        tags.put("detachedContent", detachedContent.toString());
        tags.put("help_link", this.getHelpLink("frontPage", req));
        tags.put("launchPopup", this.getTemplate("launchPopup.js"));
        StringBuffer ob = this.getTemplate("userTemplate.template", tags);
        return ob;
    }

    private void genMinimizedContent(Map channelsIsMinimized, List nonMinimizedList, Map content, boolean dIsMinimized) throws ProviderException {
        List pList = this.getSelectedChannels();
        Iterator i = pList.iterator();
        while (i.hasNext()) {
            String provider = (String)i.next();
            boolean isMinimized = PropertyUtil.getBooleanValueFromMap(channelsIsMinimized, provider, dIsMinimized);
            if (!isMinimized) continue;
            nonMinimizedList.remove(provider);
            content.put(provider, new StringBuffer(""));
        }
    }

    protected StringBuffer buildEmptyPage(HttpServletRequest req) throws ProviderException {
        Hashtable tags = this.getStandardTags(req);
        StringBuffer content = new StringBuffer();
        ResourceBundle bundle = this.getResourceBundle();
        ContainerProviderContext cpc = this.getContainerProviderContext();
        String warning = null;
        if (bundle != null) {
            warning = bundle.getString("warning_no_providers_available");
        }
        content.append("<TABLE WIDTH=100% BGCOLOR=\"#333366\" BORDER=0 CELLPADDING=2 CELLSPACING=0><TR><TD VALIGN=TOP><CENTER>");
        content.append("<FONT COLOR=\"#FFFFFF\">");
        content.append("<B>").append(warning).append("</B></FONT>");
        content.append("</CENTER></TD></TR></TABLE>");
        tags.put("frontContainerName", this.getName());
        tags.put("content", content.toString());
        try {
            tags.put("help_link", this.getHelpLink("frontPage", req));
        }
        catch (ProviderException pe) {
            tags.put("help_link", "");
        }
        tags.put("launchPopup", this.getTemplate("launchPopup.js"));
        StringBuffer ob = this.getTemplate("userTemplate.template", tags);
        return ob;
    }

    protected StringBuffer buildErrorPage(HttpServletRequest req, String err, String container, String key) throws ProviderException {
        Hashtable tags = this.getStandardTags(req);
        StringBuffer content = new StringBuffer();
        ResourceBundle bundle = this.getResourceBundle();
        ContainerProviderContext cpc = this.getContainerProviderContext();
        String error_msg1 = null;
        String error_msg2 = null;
        if (bundle != null) {
            error_msg1 = bundle.getString(key);
            error_msg2 = bundle.getString("error_property_not_defined2");
        }
        content.append(error_msg1).append(err).append(error_msg2).append(container).append("</TR>");
        content.append("</B></FONT></CENTER></TD></TR></TABLE>");
        tags.put("frontContainerName", this.getName());
        tags.put("content", content.toString());
        tags.put("launchPopup", this.getTemplate("launchPopup.js"));
        StringBuffer ob = this.getTemplate("userTemplate.template", tags);
        return ob;
    }

    protected StringBuffer buildErrorMsg(String key) throws ProviderException {
        StringBuffer content = new StringBuffer();
        ResourceBundle bundle = this.getResourceBundle();
        String error_msg = bundle.getString(key);
        content.append(error_msg).append("</B></FONT>");
        content.append("</CENTER></TD></TR></TABLE>");
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        String containerEdit = req.getParameter(this.getName() + ".containerEdit");
        if (containerEdit.equals("option")) {
            return this.getOptionsEdit(req, res);
        }
        if (containerEdit.equals("content")) {
            return this.getContentEdit(req, res);
        }
        if (containerEdit.equals("layout")) {
            return this.getLayoutEdit(req, res);
        }
        StringBuffer b = new StringBuffer("option");
        return b;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Map<String, Boolean> channelsIsDetached = new HashMap();
        Map<String, Boolean> channelsIsMinimized = new HashMap();
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        String channelAction = req.getParameter(this.getName() + ".channelAction");
        String targetProvider = req.getParameter(this.getName() + ".targetProvider");
        if (channelAction != null) {
            channelsIsDetached = this.getMapProperty("channelsIsDetached");
            channelsIsMinimized = this.getMapProperty("channelsIsMinimized");
            if (channelAction.equals("detach")) {
                Boolean detach_value = new Boolean(true);
                channelsIsDetached.put(targetProvider, detach_value);
                this.setMapProperty("channelsIsDetached", channelsIsDetached);
            } else if (channelAction.equals("attach")) {
                Boolean detach_value = new Boolean(false);
                channelsIsDetached.put(targetProvider, detach_value);
                this.setMapProperty("channelsIsDetached", channelsIsDetached);
            } else if (channelAction.equals("minimize")) {
                Boolean minimize_value = new Boolean(true);
                channelsIsMinimized.put(targetProvider, minimize_value);
                this.setMapProperty("channelsIsMinimized", channelsIsMinimized);
            } else if (channelAction.equals("maximize")) {
                Boolean maximize_value = new Boolean(false);
                channelsIsMinimized.put(targetProvider, maximize_value);
                this.setMapProperty("channelsIsMinimized", channelsIsMinimized);
            } else if (channelAction.equals("remove")) {
                List userProviders = this.getSelectedChannels();
                int size = userProviders.size();
                int i = 0;
                while (i < size) {
                    String provider = (String)userProviders.get(i);
                    if (provider.equals(targetProvider)) {
                        userProviders.remove(provider);
                        break;
                    }
                    ++i;
                }
                this.setSelectedChannels(userProviders);
            }
            return null;
        }
        String containerEdit = req.getParameter(this.getName() + ".containerEdit");
        if (containerEdit.equals("option")) {
            return this.processOptionsEdit(req, res);
        }
        if (containerEdit.equals("content")) {
            return this.processContentEdit(req, res);
        }
        if (containerEdit.equals("layout")) {
            return this.processLayoutEdit(req, res);
        }
        return null;
    }

    public StringBuffer getOptionsEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String oneChecked = "";
        String twoChecked = "";
        String threeChecked = "";
        String fourChecked = "";
        int layout = -1;
        layout = this.getIntegerProperty("layout");
        switch (layout) {
            case 1: {
                oneChecked = "CHECKED";
                break;
            }
            case 2: {
                twoChecked = "CHECKED";
                break;
            }
            case 3: {
                threeChecked = "CHECKED";
                break;
            }
            case 4: {
                fourChecked = "CHECKED";
            }
        }
        Hashtable tags = this.getStandardTags(req);
        ContainerProviderContext cpc = this.getContainerProviderContext();
        tags.put("frontContainerName", this.getName());
        tags.put("help_link", this.getHelpLink("optionsPage", req));
        tags.put("layoutOneChecked", oneChecked);
        tags.put("layoutTwoChecked", twoChecked);
        tags.put("layoutThreeChecked", threeChecked);
        tags.put("layoutFourChecked", fourChecked);
        tags.put("serviceTimeout", this.getIntegerProperty("timeout") + "");
        StringBuffer ob = this.getTemplate("optionsTemplate.template", tags);
        return ob;
    }

    public URL processOptionsEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ResourceBundle bundle = this.getResourceBundle();
        String serviceTimeout = req.getParameter("serviceTimeout");
        String layout = req.getParameter("layout");
        int timeout = 0;
        try {
            timeout = Integer.parseInt(serviceTimeout);
            if (timeout < 0) {
                req.setAttribute("containerEdit", (Object)"option");
                String err = bundle.getString("error_timeout_lessthan_zero");
                throw new InvalidEditFormDataException(err);
            }
        }
        catch (NumberFormatException e) {
            String err = bundle.getString("error_timeout_notnumber");
            req.setAttribute("containerEdit", (Object)"option");
            throw new InvalidEditFormDataException(err);
        }
        this.setIntegerProperty("timeout", timeout);
        int new_layout = 0;
        try {
            new_layout = Integer.parseInt(layout);
        }
        catch (NumberFormatException e) {
            String err = "Please enter a valid layout value";
            throw new InvalidEditFormDataException(err);
        }
        this.setIntegerProperty("layout", new_layout);
        return null;
    }

    public URL processContentEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        List allProviders = this.getAvailableChannels();
        List userProviders = this.getSelectedChannels();
        Map channelsRemovable = null;
        boolean defaultIsRemovable = false;
        channelsRemovable = this.getMapProperty("channelsIsRemovable");
        defaultIsRemovable = this.getBooleanProperty("defaultChannelIsRemovable");
        int numProviders = allProviders.size();
        int i = 0;
        while (i < numProviders) {
            String provider = (String)allProviders.get(i);
            if (PropertyUtil.getBooleanValueFromMap(channelsRemovable, provider, defaultIsRemovable)) {
                String checkBoxValue = req.getParameter(provider);
                if (checkBoxValue == null) {
                    userProviders.remove(provider);
                } else if (checkBoxValue.equals("1") && !userProviders.contains(provider)) {
                    userProviders.add(provider);
                }
            }
            ++i;
        }
        this.setSelectedChannels(userProviders);
        return null;
    }

    public StringBuffer getContentEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        ContainerProviderContext cpc = this.getContainerProviderContext();
        Map channelsRemovable = new HashMap();
        boolean defaultIsRemovable = false;
        channelsRemovable = this.getMapProperty("channelsIsRemovable");
        defaultIsRemovable = this.getBooleanProperty("defaultChannelIsRemovable");
        String emptyMsg = "This list is empty";
        StringBuffer wideProviders = new StringBuffer();
        StringBuffer thinProviders = new StringBuffer();
        StringBuffer fullProviders = new StringBuffer();
        List allProviders = this.getAvailableChannels();
        List userProviders = this.getSelectedChannels();
        int numProviders = allProviders.size();
        int i = 0;
        while (i < numProviders) {
            String provider = (String)allProviders.get(i);
            Provider theProvider = null;
            theProvider = cpc.getProvider(req, this.getName(), provider);
            if (theProvider == null) {
                pc.debugError("TemplateTableContainerProvider.getContentEdit(): provider class name was null for channel=" + provider);
            } else {
                int width = theProvider.getWidth();
                String title = theProvider.getTitle();
                String description = theProvider.getDescription();
                boolean remove = PropertyUtil.getBooleanValueFromMap(channelsRemovable, provider, defaultIsRemovable);
                int layout = this.getIntegerProperty("layout");
                String checked = "";
                if (userProviders.contains(provider)) {
                    checked = "CHECKED";
                }
                if (remove) {
                    if (width == 1) {
                        thinProviders.append("<INPUT TYPE=CHECKBOX NAME=\"").append(provider).append("\" VALUE=1 ").append(checked).append("><B>").append(title).append("</B><BR>\n").append(description).append("<P>");
                    } else if (width == 0) {
                        if (layout != 4) {
                            wideProviders.append("<INPUT TYPE=CHECKBOX NAME=\"").append(provider).append("\" VALUE=1 ").append(checked).append("><B>").append(title).append("</B><BR>\n").append(description).append("<P>");
                        }
                    } else if (width == 2 || width == 3) {
                        fullProviders.append("<INPUT TYPE=CHECKBOX NAME=\"").append(provider).append("\" VALUE=1 ").append(checked).append("><B>").append(title).append("</B><BR>\n").append(description).append("<P>");
                    }
                }
            }
            ++i;
        }
        if (thinProviders.length() == 0) {
            thinProviders.append(emptyMsg);
        }
        thinProviders.insert(0, "<FONT SIZE=\"+0\" FACE=\"[tag:desktop-fontFace1]\">");
        if (wideProviders.length() == 0) {
            wideProviders.append(emptyMsg);
        }
        wideProviders.insert(0, "<FONT SIZE=\"+0\" FACE=\"[tag:desktop-fontFace1]\">");
        if (fullProviders.length() == 0) {
            fullProviders.append(emptyMsg);
        }
        fullProviders.insert(0, "<FONT SIZE=\"+0\" FACE=\"[tag:desktop-fontFace1]\">");
        thinProviders.append("</FONT>");
        wideProviders.append("</FONT>");
        fullProviders.append("</FONT>");
        Hashtable tags = this.getStandardTags(req);
        String selected = req.getParameter("selected");
        if (selected != null) {
            tags.put("selectedTabName", selected);
            tags.put("selectedName", IURLEncoder.encode(selected));
        }
        tags.put("contentBarInContent", this.getTemplate("contentBarInContent.template"));
        tags.put("frontContainerName", this.getName());
        tags.put("help_link", this.getHelpLink("contentPage", req));
        tags.put("thinProviders", thinProviders.toString());
        tags.put("wideProviders", wideProviders.toString());
        tags.put("fullProviders", fullProviders.toString());
        StringBuffer ob = this.getTemplate("contentTemplate.template", tags);
        return ob;
    }

    public URL processLayoutEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        ContainerProviderContext cpc = this.getContainerProviderContext();
        Map channelsColumn = null;
        Map channelsRow = null;
        channelsColumn = this.getMapProperty("channelsColumn");
        channelsRow = this.getMapProperty("channelsRow");
        String layoutIDString = req.getParameter("layoutID");
        if (layoutIDString != null) {
            int i;
            switch (Integer.valueOf(layoutIDString)) {
                default: 
            }
            String[] one = req.getParameterValues("one");
            String[] two = req.getParameterValues("two");
            String[] three = req.getParameterValues("three");
            String[] fulltop = req.getParameterValues("fulltop");
            String[] fullbottom = req.getParameterValues("fullbottom");
            if (one != null) {
                i = 0;
                while (i < one.length) {
                    if (!one[i].equals(".none") && !one[i].equals("spacer")) {
                        channelsColumn.put(one[i], "1");
                        channelsRow.put(one[i], i + 1 + "");
                        if (pc.isDebugMessageEnabled()) {
                            pc.debugMessage("Value of 1st row = " + Integer.parseInt((String)channelsRow.get(one[i])));
                            pc.debugMessage("Value of 1st col = " + Integer.parseInt((String)channelsColumn.get(one[i])));
                        }
                    }
                    ++i;
                }
            }
            if (two != null) {
                i = 0;
                while (i < two.length) {
                    if (!two[i].equals(".none") && !two[i].equals("spacer")) {
                        channelsColumn.put(two[i], "2");
                        channelsRow.put(two[i], i + 1 + "");
                        if (pc.isDebugMessageEnabled()) {
                            pc.debugMessage("Value of 2nd col = " + Integer.parseInt((String)channelsColumn.get(two[i])));
                            pc.debugMessage("Value of 2nd row = " + Integer.parseInt((String)channelsRow.get(two[i])));
                        }
                    }
                    ++i;
                }
            }
            if (three != null) {
                i = 0;
                while (i < three.length) {
                    if (!three[i].equals(".none") && !three[i].equals("spacer")) {
                        channelsColumn.put(three[i], "3");
                        channelsRow.put(three[i], i + 1 + "");
                        if (pc.isDebugMessageEnabled()) {
                            pc.debugMessage("Value of 3rd col = " + Integer.parseInt((String)channelsColumn.get(three[i])));
                            pc.debugMessage("Value of 3nd row = " + Integer.parseInt((String)channelsRow.get(three[i])));
                        }
                    }
                    ++i;
                }
            }
            if (fulltop != null) {
                i = 0;
                while (i < fulltop.length) {
                    if (!fulltop[i].equals(".none") && !fulltop[i].equals("spacer")) {
                        channelsRow.put(fulltop[i], i + 1 + "");
                    }
                    ++i;
                }
            }
            if (fullbottom != null) {
                i = 0;
                while (i < fullbottom.length) {
                    if (!fullbottom[i].equals(".none") && !fullbottom[i].equals("spacer")) {
                        channelsRow.put(fullbottom[i], i + 1 + "");
                    }
                    ++i;
                }
            }
            this.setMapProperty("channelsColumn", channelsColumn);
            this.setMapProperty("channelsRow", channelsRow);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuffer getLayoutEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Object layoutTemplate = null;
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        List userProviders = null;
        userProviders = ProviderOrder.order(this.getSelectedChannels(), this.getName(), cpc, req);
        int size = userProviders.size();
        StringBuffer leftUserProviderList = new StringBuffer();
        leftUserProviderList.append("<SELECT NAME=\"one\" SIZE=").append(size).append(" MULTIPLE>");
        StringBuffer centerUserProviderList = new StringBuffer();
        centerUserProviderList.append("<SELECT NAME=\"three\" SIZE=").append(size).append(" MULTIPLE>");
        StringBuffer rightUserProviderList = new StringBuffer();
        rightUserProviderList.append("<SELECT NAME=\"two\" SIZE=").append(size).append(" MULTIPLE>");
        StringBuffer fulltopUserProviderList = new StringBuffer();
        fulltopUserProviderList.append("<SELECT NAME=\"fulltop\" SIZE=").append(size).append(" MULTIPLE>");
        StringBuffer fullbottomUserProviderList = new StringBuffer();
        fullbottomUserProviderList.append("<SELECT NAME=\"fullbottom\" SIZE=").append(size).append(" MULTIPLE>");
        int layout = -1;
        layout = this.getIntegerProperty("layout");
        switch (layout) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new ProviderException("FrontProvider.getLayoutEdit: invalid layout");
            }
        }
        boolean hasFullTop = false;
        boolean hasFullBottom = false;
        Map layout_channelsColumn = null;
        Map channelsMovable = null;
        layout_channelsColumn = this.getMapProperty("channelsColumn");
        channelsMovable = this.getMapProperty("channelsIsMovable");
        Iterator i = userProviders.iterator();
        while (i.hasNext()) {
            String providerName = (String)i.next();
            Provider theProvider = null;
            theProvider = cpc.getProvider(req, this.getName(), providerName);
            if (theProvider == null) {
                pc.debugError("TemplateTableContainerProvider.getLayoutEdit(): provider class name was null for channel=" + theProvider);
                continue;
            }
            String title = theProvider.getTitle();
            int width = 1;
            int column = 1;
            boolean dIsMovable = this.getBooleanProperty("defaultChannelIsMovable");
            String defaultChannelColumn = this.getStringProperty("defaultChannelColumn");
            try {
                width = theProvider.getWidth();
                column = Integer.parseInt(PropertyUtil.getStringValueFromMap(layout_channelsColumn, providerName, defaultChannelColumn));
                if (pc.isDebugMessageEnabled()) {
                    pc.debugMessage("FrontProvider.buildPage(): got column: " + column);
                }
            }
            catch (NumberFormatException e) {
                throw new ProviderException("FrontProvider.buildPage(): got NumberFormatException for column");
            }
            if (!PropertyUtil.getBooleanValueFromMap(channelsMovable, providerName, dIsMovable)) continue;
            String providerOption = TemplateTableContainerProvider.genProviderOption(providerName, title);
            switch (width) {
                case 2: {
                    fulltopUserProviderList.append(providerOption);
                    hasFullTop = true;
                    break;
                }
                case 3: {
                    fullbottomUserProviderList.append(providerOption);
                    hasFullBottom = true;
                    break;
                }
                case 1: {
                    switch (layout) {
                        case 1: {
                            leftUserProviderList.append(providerOption);
                            break;
                        }
                        case 2: {
                            rightUserProviderList.append(providerOption);
                            break;
                        }
                        case 3: {
                            StringBuffer list = null;
                            list = column == 1 ? leftUserProviderList : rightUserProviderList;
                            list.append(providerOption);
                            break;
                        }
                        case 4: {
                            StringBuffer list2 = null;
                            if (column == 1) {
                                list2 = leftUserProviderList;
                            } else if (column == 3) {
                                list2 = centerUserProviderList;
                            } else if (column == 2) {
                                list2 = rightUserProviderList;
                            }
                            list2.append(providerOption);
                            break;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (layout) {
                        case 1: {
                            rightUserProviderList.append(providerOption);
                            break;
                        }
                        case 2: {
                            leftUserProviderList.append(providerOption);
                            break;
                        }
                        case 3: {
                            centerUserProviderList.append(providerOption);
                            break;
                        }
                        case 4: {
                            if (!pc.isDebugWarningEnabled()) break;
                            pc.debugWarning("LayoutProvider.getEdit(): attempt to display thick channel inthin-thin-thin layout");
                        }
                    }
                    break;
                }
            }
        }
        leftUserProviderList.append(TemplateTableContainerProvider.genProviderOption("spacer", "---------------------------------"));
        leftUserProviderList.append("</SELECT>");
        centerUserProviderList.append(TemplateTableContainerProvider.genProviderOption("spacer", "---------------------------------"));
        centerUserProviderList.append("</SELECT>");
        rightUserProviderList.append(TemplateTableContainerProvider.genProviderOption("spacer", "---------------------------------"));
        rightUserProviderList.append("</SELECT>");
        fulltopUserProviderList.append(TemplateTableContainerProvider.genProviderOption("spacer", "---------------------------------"));
        fulltopUserProviderList.append("</SELECT>");
        fullbottomUserProviderList.append(TemplateTableContainerProvider.genProviderOption("spacer", "---------------------------------"));
        fullbottomUserProviderList.append("</SELECT>");
        Hashtable tags = this.getStandardTags(req);
        String selected = req.getParameter("selected");
        if (selected != null) {
            tags.put("selectedTabName", selected);
            tags.put("selectedName", IURLEncoder.encode(selected));
        }
        tags.put("contentBarInLayout", this.getTemplate("contentBarInLayout.template"));
        tags.put("frontContainerName", this.getName());
        tags.put("help_link", this.getHelpLink("layoutPage", req));
        tags.put("leftUserProviderList", leftUserProviderList.toString());
        tags.put("centerUserProviderList", centerUserProviderList.toString());
        tags.put("rightUserProviderList", rightUserProviderList.toString());
        tags.put("arrangeProvider", this.getTemplate("arrangeProvider.js"));
        tags.put("removeProvider", this.getTemplate("removeProvider.js"));
        tags.put("performSubstitution", this.getTemplate("performSubstitution.js"));
        tags.put("performColumnSubstitution", this.getTemplate("performColumnSubstitution.js"));
        tags.put("selectAll", this.getTemplate("selectAll.js"));
        tags.put("switchColumns", this.getTemplate("switchColumns.js"));
        if (hasFullTop) {
            tags.put("fulltopUserProviderList", fulltopUserProviderList.toString());
            tags.put("layoutFullTop", this.getTemplate("layoutFullTop.template"));
        } else {
            tags.put("layoutFullTop", new String());
        }
        if (hasFullBottom) {
            tags.put("fullbottomUserProviderList", fullbottomUserProviderList.toString());
            tags.put("layoutFullBottom", this.getTemplate("layoutFullBottom.template"));
            return this.getTemplate((String)templateMap.get(Integer.toString(layout)), tags);
        } else {
            tags.put("layoutFullBottom", new String());
        }
        return this.getTemplate((String)templateMap.get(Integer.toString(layout)), tags);
    }

    private static String genProviderOption(String providerName, String title) {
        StringBuffer list = new StringBuffer(64);
        list.append("<OPTION VALUE=").append(providerName).append("> ").append(title).append("</OPTION>\n");
        return list.toString();
    }

    public StringBuffer getPopupProviderContents(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        String desktopURL = cpc.getDesktopURL(req);
        String sContext = cpc.getStaticContentPath();
        Provider cp = null;
        ResourceBundle bundle = this.getResourceBundle();
        StringBuffer provider_cmds = new StringBuffer();
        String providerName = req.getParameter(this.getName() + ".targetProvider");
        Map channelsIsDetached = this.getMapProperty("channelsIsDetached");
        Map channelsIsDetachable = this.getMapProperty("channelsIsDetachable");
        Map channelsIsMinimized = this.getMapProperty("channelsIsMinimized");
        Map channelsIsMinimizable = this.getMapProperty("channelsIsMinimizable");
        Map channelsIsRemovable = this.getMapProperty("channelsIsRemovable");
        Map channelsBackgroundColor = this.getMapProperty("channelsBackgroundColor");
        boolean dIsMinimizable = this.getBooleanProperty("defaultChannelIsMinimizable");
        boolean dIsDetachable = this.getBooleanProperty("defaultChannelIsDetachable");
        boolean dIsRemovable = this.getBooleanProperty("defaultChannelIsRemovable");
        boolean dIsMinimized = this.getBooleanProperty("defaultChannelIsMinimized");
        boolean dIsDetached = this.getBooleanProperty("defaultChannelIsDetached");
        cp = cpc.getProvider(req, this.getName(), providerName);
        StringBuffer content = null;
        try {
            content = cp.getContent(req, res);
        }
        catch (ProviderException pe) {
            throw new ProviderException("PopupProvider.getContent(): \t\t\t      Contents for providerName=" + providerName + " is null");
        }
        String providerTitle = cp.getTitle();
        providerName = cp.getName();
        String title = cp.getTitle();
        Hashtable tags = this.getStandardTags(req);
        Hashtable tagtable = ProviderCommands.getProviderCommands(cp, this.getName(), cpc, req, bundle, desktopURL, sContext, channelsIsDetachable, channelsIsDetached, channelsIsMinimizable, channelsIsMinimized, channelsIsRemovable, dIsDetachable, dIsDetached, dIsMinimizable, dIsMinimized, dIsRemovable);
        tags.put("provider_cmds", this.getTemplate("providerCommands.template", tagtable));
        tags.put("providerTitle", providerTitle);
        tags.put("frontContainerName", this.getName());
        tags.put("providerName", providerName);
        tags.put("content", content.toString());
        tags.put("title", title);
        tags.put("size", "100%");
        String dBgColor = null;
        String bgColor = null;
        try {
            dBgColor = Theme.getAttribute(this.getName(), cpc, "bgColor");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("TemplateTableContainerProvider.getPopupProviderContent(): failed to get theme related attribute", pce);
        }
        if (!channelsBackgroundColor.isEmpty()) {
            bgColor = (String)channelsBackgroundColor.get(providerName);
        }
        if (bgColor != null) {
            tags.put("bgColor", bgColor);
        } else {
            tags.put("bgColor", dBgColor);
        }
        StringBuffer wrapContent = this.getTemplate("providerWrapper.template", tags);
        tags.put("providerContent", wrapContent.toString());
        StringBuffer popup = this.getTemplate("popupMenubar.template", tags);
        tags.put("popupMenubar", popup.toString());
        StringBuffer openURLInParent = this.getTemplate("openURLInParent.js", tags);
        tags.put("openURLInParent", openURLInParent.toString());
        StringBuffer ob = this.getTemplate("popupTemplate.template", tags);
        return ob;
    }

    static {
        templateMap = new HashMap();
        templateMap.put(Integer.toString(1), "layout1Template.template");
        templateMap.put(Integer.toString(2), "layout2Template.template");
        templateMap.put(Integer.toString(3), "layout3Template.template");
        templateMap.put(Integer.toString(4), "layout4Template.template");
    }
}

