/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPBoolean;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPInteger;
import com.sun.portal.desktop.dp.DPLocale;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPString;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPLocale;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDPProperties
extends XMLDPCollection
implements DPProperties,
XMLDPTags {
    private Element holderElement = null;

    XMLDPProperties(DPContext dpc, DPRoot r, Document d) {
        super(dpc, r, XMLDPProperties.createElement(dpc, d));
    }

    XMLDPProperties(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
    }

    public DPProperty getParentProperty() {
        return null;
    }

    Element getPropertyHolderElement() {
        if (this.holderElement == null) {
            Node parentNode = this.getElement().getParentNode();
            if (parentNode == null) {
                throw new DPError("XMLDPProperties.getPropertyHolderElement(): could not get parent node");
            }
            if (parentNode.getNodeType() != 1) {
                throw new DPError("XMLDPProperties.getPropertyHolderElement(): parent node was not an element");
            }
            this.holderElement = (Element)parentNode;
        }
        return this.holderElement;
    }

    protected DPPropertyHolder getPropertyHolderFromThis() {
        Element holderElement = this.getPropertyHolderElement();
        DPPropertyHolder holder = (DPPropertyHolder)this.getObject(holderElement);
        if (holder == null) {
            holder = XMLDPFactory.getInstance().getPropertyHolder(this.getContext(), this.getRoot(), holderElement);
            this.putObject(holder);
        }
        return holder;
    }

    protected DPPropertyHolder getPropertyHolder() {
        DPPropertyHolder holder = this.getPropertyHolderFromThis();
        if (holder == null || !holder.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPProperties dpp = (DPProperties)i.next();
                DPPropertyHolder dpph = ((XMLDPProperties)dpp).getPropertyHolderFromThis();
                holder.addMerger(dpph);
            }
        }
        return holder;
    }

    public short getType() {
        return 7;
    }

    public String getTag() {
        return "Properties";
    }

    public DPProperty add(DPProperty dpp, Locale locale) {
        if (locale == null) {
            return this.add(dpp);
        }
        DPLocale dpLocale = this.getLocale(locale, true);
        DPProperty addedProperty = null;
        if (dpLocale == null) {
            dpLocale = XMLDPFactory.getInstance().createLocale(this.getContext(), this.getRoot(), this.getDocument(), locale.getLanguage(), locale.getCountry(), locale.getVariant());
            dpLocale = (DPLocale)this.add(dpLocale);
        }
        addedProperty = dpLocale.add(dpp);
        return addedProperty;
    }

    DPProperty add(DPProperty dpp, boolean copy, boolean deep, boolean dummy, Locale locale) {
        if (locale == null) {
            return this.add(dpp, copy, deep, dummy);
        }
        DPLocale dpLocale = this.getLocale(locale, true);
        DPProperty addedProperty = null;
        if (dpLocale == null) {
            dpLocale = XMLDPFactory.getInstance().createLocale(this.getContext(), this.getRoot(), this.getDocument(), locale.getLanguage(), locale.getCountry(), locale.getVariant());
            dpLocale = (DPLocale)this.add(dpLocale);
        }
        addedProperty = ((XMLDPLocale)dpLocale).add(dpp, copy, deep, dummy);
        return addedProperty;
    }

    public DPProperty get(String key) {
        return this.get(key, null, true, true);
    }

    public DPProperty get(String key, boolean scoped) {
        return this.get(key, null, true, scoped);
    }

    public DPProperty get(String key, Locale locale, boolean exact) {
        return this.get(key, locale, exact, true);
    }

    public DPProperty get(String key, Locale locale, boolean exact, boolean scoped) {
        DPProperties dpProperties;
        DPLocale dpLocale;
        DPProperty dpp = null;
        if (locale != null && (dpLocale = this.getLocale(locale, exact)) != null && (dpp = dpLocale.get(key)) != null) {
            return dpp;
        }
        if (!(locale != null && exact || (dpp = super.get(key)) == null)) {
            return dpp;
        }
        if (!scoped) {
            return null;
        }
        DPPropertyHolder dpph = this.getPropertyHolder();
        if (!(dpph instanceof DPChannel)) {
            return null;
        }
        DPChannel dpc = (DPChannel)dpph;
        DPProvider dpProvider = dpc.getProvider();
        if (dpProvider != null && (dpp = (dpProperties = dpProvider.getProperties()).get(key, locale, exact)) != null) {
            return dpp;
        }
        DPPropertyHolder parentDPPH = dpph.getParentPropertyHolder();
        if (parentDPPH == null) {
            return null;
        }
        dpp = parentDPPH.getProperties().get(key, locale, exact);
        return dpp;
    }

    public void set(String key, Object val, Locale locale) {
        DPProperty oldProperty = this.get(key, locale, true);
        if (oldProperty == null) {
            throw new DPError("XMLDPProperties.set(): property does not exist name=" + key + ", locale=" + locale);
        }
        DPProperty newProperty = null;
        if (!oldProperty.isPropagate()) {
            newProperty = oldProperty;
            newProperty.setPropagate(false);
        } else {
            newProperty = !this.isPropertyFromThis(oldProperty) ? this.add(oldProperty, locale) : oldProperty;
        }
        newProperty.setValue(val);
    }

    public DPLocale getLocale(Locale locale, boolean exact) {
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        return this.getLocale(language, country, variant, exact);
    }

    public DPLocale getLocale(String language, String country, String variant, boolean exact) {
        DPLocale dpLocale = null;
        while (dpLocale == null && language != null) {
            dpLocale = this.getLocaleFromThis(language, country, variant, exact);
            if (dpLocale == null || !dpLocale.isMerged()) {
                Iterator i = this.getMergers().iterator();
                while (i.hasNext()) {
                    DPProperties dpp = (DPProperties)i.next();
                    DPLocale dplc = ((XMLDPProperties)dpp).getLocaleFromThis(language, country, variant, exact);
                    if (dplc == null) continue;
                    if (dpLocale == null) {
                        DPLocale ddpl = (DPLocale)((XMLDPLocale)dplc).createDummy(this.getRoot());
                        dpLocale = (DPLocale)this.add(ddpl, false, false, true);
                    }
                    if (!dpLocale.isMergeLocked() && dplc.isLocked() && dplc.isRemove()) {
                        dpLocale = null;
                        break;
                    }
                    dpLocale.addMerger(dplc);
                }
                if (dpLocale != null && !dpLocale.isMergeLocked() && dpLocale.isRemove()) {
                    dpLocale = null;
                }
            }
            if (exact) {
                language = null;
                continue;
            }
            if (variant != null) {
                variant = null;
                continue;
            }
            if (country != null) {
                country = null;
                continue;
            }
            if (language == null) continue;
            language = null;
        }
        return dpLocale;
    }

    protected DPLocale getLocaleFromThis(Locale locale, boolean exact) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        return this.getLocaleFromThis(language, country, variant, exact);
    }

    protected DPLocale getLocaleFromThis(String language, String country, String variant, boolean exact) {
        Element e = this.getLocaleElement(language, country, variant, exact);
        DPLocale dpl = null;
        if (e != null && (dpl = (DPLocale)this.getObject(e)) == null) {
            dpl = new XMLDPLocale(this.getContext(), this.getRoot(), e);
            this.putObject(dpl);
        }
        return dpl;
    }

    Element getLocaleElement(Locale locale, boolean exact) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        return this.getLocaleElement(language, country, variant, exact);
    }

    Element getLocaleElement(String language, String country, String variant, boolean exact) {
        Element localeElement = null;
        localeElement = this.getLocaleElement(language, country, variant);
        if (localeElement != null) {
            return localeElement;
        }
        if (exact) {
            return localeElement;
        }
        if (variant != null && variant.length() > 0 && (localeElement = this.getLocaleElement(language, country, null)) != null) {
            return localeElement;
        }
        if (country != null && country.length() > 0 && (localeElement = this.getLocaleElement(language, null, null)) != null) {
            return localeElement;
        }
        return null;
    }

    static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }

    Element getLocaleElement(String language, String country, String variant) {
        String localeName = XMLDPObject.getLocaleName(language, country, variant);
        Element localeElement = (Element)this.propertiesTable.get(localeName);
        return localeElement;
    }

    public Set getNames() {
        return this.getNames(true);
    }

    public Set getNames(boolean scoped) {
        DPPropertyHolder owner;
        Set providerNames;
        Set names = super.getNames();
        if (!scoped) {
            return names;
        }
        DPPropertyHolder dpph = this.getPropertyHolder();
        if (!(dpph instanceof DPChannel)) {
            this.message("XMLDPProperties.getNames():owner not a channel, returning names");
            return names;
        }
        this.message("XMLDPProperties.getNames():owner was a channel, getting provider");
        DPChannel dpc = (DPChannel)dpph;
        DPProvider dpp = dpc.getProvider();
        if (dpp != null && (providerNames = dpp.getProperties().getNames()) != null) {
            names.addAll(providerNames);
        }
        if ((owner = this.getPropertyHolder()) == null) {
            throw new DPError("XMLDPProperties.getNames(): no owner for properties");
        }
        DPPropertyHolder ownerParent = owner.getParentPropertyHolder();
        if (ownerParent == null) {
            return names;
        }
        Set ownerNames = ownerParent.getProperties().getNames();
        if (ownerNames != null) {
            names.addAll(ownerNames);
        }
        return names;
    }

    public DPString getString(String key, Locale locale, boolean exact) {
        DPProperty dpp = this.get(key, locale, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 1) {
            return null;
        }
        return (DPString)dpp;
    }

    public DPString getString(String key) {
        return this.getString(key, null, true);
    }

    public void setString(String key, String val) {
        this.setString(key, val, null);
    }

    boolean isPropertyFromThis(DPProperty dpp) {
        DPProperties dppp = dpp.getProperties();
        return dppp == this;
    }

    public void setString(String key, String val, Locale locale) {
        DPString oldString = this.getString(key, locale, true);
        if (oldString == null) {
            throw new DPError("XMLDPProperties.setString(): property does not exist name=" + key + ", locale=" + locale);
        }
        DPString newString = null;
        if (!oldString.isPropagate()) {
            newString = oldString;
            newString.setPropagate(false);
        } else {
            newString = !this.isPropertyFromThis(oldString) ? (DPString)this.add(oldString, locale) : oldString;
        }
        newString.setStringValue(val);
    }

    public DPInteger getInteger(String key) {
        return this.getInteger(key, null, true);
    }

    public DPInteger getInteger(String key, Locale locale, boolean exact) {
        DPProperty dpp = this.get(key, locale, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 3) {
            return null;
        }
        return (DPInteger)dpp;
    }

    public void setInteger(String key, int val) {
        this.setInteger(key, val, null);
    }

    public void setInteger(String key, int val, Locale locale) {
        DPInteger oldInt = this.getInteger(key, locale, true);
        if (oldInt == null) {
            throw new DPError("XMLDPProperties.setInteger(): property does not exist name=" + key);
        }
        DPInteger newInt = null;
        if (!oldInt.isPropagate()) {
            newInt = oldInt;
            newInt.setPropagate(false);
        } else {
            newInt = !this.isPropertyFromThis(oldInt) ? (DPInteger)this.add(oldInt, locale) : oldInt;
        }
        newInt.setIntValue(val);
    }

    public DPBoolean getBoolean(String key) {
        return this.getBoolean(key, null, true);
    }

    public DPBoolean getBoolean(String key, Locale locale, boolean exact) {
        DPProperty dpp = this.get(key, locale, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 4) {
            return null;
        }
        return (DPBoolean)dpp;
    }

    public void setBoolean(String key, boolean val) {
        this.setBoolean(key, val, null);
    }

    public void setBoolean(String key, boolean val, Locale locale) {
        DPBoolean oldBool = this.getBoolean(key, locale, true);
        if (oldBool == null) {
            throw new DPError("XMLDPProperties.setBoolean(): property does not exist name=" + key);
        }
        DPBoolean newBool = null;
        newBool = !this.isPropertyFromThis(oldBool) ? (DPBoolean)this.add(oldBool, locale) : oldBool;
        newBool.setBooleanValue(val);
    }

    public DPCollection getCollection(String key) {
        return this.getCollection(key, null, true);
    }

    public DPCollection getCollection(String key, Locale locale, boolean exact) {
        DPProperty dpp = this.get(key, locale, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 14) {
            return null;
        }
        return (DPCollection)dpp;
    }

    public DPCollection setCollection(String key, Map val) {
        return this.setCollection(key, val, null);
    }

    public DPCollection setCollection(String key, Map val, Locale locale) {
        DPCollection oldColl = this.getCollection(key, locale, true);
        if (oldColl == null) {
            throw new DPError("XMLDPProperties.setCollection(): property does not exist name=" + key);
        }
        DPCollection newColl = null;
        if (!oldColl.isPropagate()) {
            newColl = oldColl;
            newColl.setPropagate(false);
        } else if (!this.isPropertyFromThis(oldColl)) {
            this.add(oldColl, true, false, false, locale);
            newColl = this.getCollection(key, locale, true);
        } else {
            newColl = oldColl;
        }
        newColl.setCollectionValue(val);
        return newColl;
    }

    public DPCollection setCollection(String key, List val) {
        return this.setCollection(key, val, null);
    }

    public DPCollection setCollection(String key, List val, Locale locale) {
        DPCollection oldColl = this.getCollection(key, locale, true);
        if (oldColl == null) {
            throw new DPError("XMLDPProperties.setCollection(): property does not exist name=" + key);
        }
        DPCollection newColl = null;
        if (!oldColl.isPropagate()) {
            newColl = oldColl;
            newColl.setPropagate(false);
        } else if (!this.isPropertyFromThis(oldColl)) {
            this.add(oldColl, true, false, false, locale);
            newColl = this.getCollection(key, locale, true);
        } else {
            newColl = oldColl;
        }
        newColl.setCollectionValue(val);
        return newColl;
    }

    static Element createElement(DPContext dpc, Document d) {
        Element e = XMLDPObject.createElement(dpc, d, "Properties");
        XMLDPCollection.setMergeDefaultsElement(e);
        return e;
    }
}

