/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPAttrs;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XMLDPNode
extends XMLDPPropertyHolder
implements DPNode,
DPTypes,
XMLDPTags,
XMLDPAttrs {
    private Map channelsTable = null;
    private Element channelsElement = null;
    private Element parentNodeElement = null;

    XMLDPNode(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
        Element channelsElement = this.getChannelsElement(this.getElement());
        if (channelsElement != null) {
            this.channelsTable = XMLDPObject.createElementTable(channelsElement);
        }
    }

    public DPPropertyHolder getParentPropertyHolder() {
        return this.getParentNode();
    }

    Element getParentNodeElement() {
        if (this.parentNodeElement == null) {
            Node n = this.getElement().getParentNode();
            if (n == null) {
                return null;
            }
            if ((n = n.getParentNode()) == null) {
                return null;
            }
            if (n.getNodeType() != 1) {
                throw new DPError("XMLDPNode.getParentElement(): parent was not an element!");
            }
            this.parentNodeElement = (Element)n;
        }
        return this.parentNodeElement;
    }

    protected DPNode getParentNodeFromThis() {
        Element e = this.getParentNodeElement();
        DPNode dpn = null;
        if (e != null && (dpn = (DPNode)this.getObject(e)) == null) {
            dpn = XMLDPFactory.getInstance().getNode(this.getContext(), this.getRoot(), e);
            this.putObject(dpn);
        }
        return dpn;
    }

    public DPNode getParentNode() {
        DPNode dp = this.getParentNodeFromThis();
        if (dp == null || !dp.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPNode dpn = (DPNode)i.next();
                if (this.getType() != dpn.getType()) {
                    throw new DPError("XMLDPNode.getParentNode(): type mismatch");
                }
                DPNode parentDPN = ((XMLDPNode)dpn).getParentNodeFromThis();
                if (parentDPN == null) continue;
                dp.addMerger(parentDPN);
            }
        }
        return dp;
    }

    public DPChannel addChannel(DPChannel dpc) {
        return this.addChannel(dpc, true, true, false);
    }

    public DPChannel addChannel(DPChannel dpc, boolean copy, boolean deep, boolean dummy) {
        this.removeObject(dpc);
        XMLDPChannel xmldpc = null;
        xmldpc = copy ? (XMLDPChannel)dpc.copy(this.getRoot(), deep) : (XMLDPChannel)dpc;
        Element e = xmldpc.getElement();
        String channelName = xmldpc.getName();
        XMLDPNode.addChannelElement(this.getElement(), e);
        this.channelsTable.put(channelName, e);
        this.putObject(xmldpc);
        xmldpc.setDummy(dummy);
        return xmldpc;
    }

    DPChannel getChannelFromMergers(String key) {
        DPChannel dpChannel = null;
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPNode dpn = (DPNode)i.next();
            DPChannel dpc = ((XMLDPNode)dpn).getChannelFromThis(key);
            if (dpc == null) continue;
            dpChannel = dpc;
            break;
        }
        return dpChannel;
    }

    public DPChannel removeChannel(String key) {
        DPChannel dpcFromMerger;
        DPChannel removedDPC = null;
        DPChannel dpcFromThis = this.getChannelFromThis(key);
        if (dpcFromThis != null) {
            this.removeChannelElement(dpcFromThis);
            this.channelsTable.remove(key);
            this.removeObject(dpcFromThis);
            removedDPC = dpcFromThis;
            this.setDummy(false);
        }
        if ((dpcFromMerger = this.getChannelFromMergers(key)) != null) {
            DPChannel dpc = this.addChannel(dpcFromMerger, true, false, false);
            dpc.setMergeType((short)3);
            if (removedDPC == null) {
                removedDPC = dpc;
            }
        }
        return removedDPC;
    }

    void removeChannelElement(DPChannel dpc) {
        XMLDPChannel xmldpc = (XMLDPChannel)dpc;
        Element childElement = xmldpc.getElement();
        Element parentElement = (Element)childElement.getParentNode();
        parentElement.removeChild(childElement);
    }

    public DPProvider addProvider(DPProvider dpp) {
        return this.getRoot().addProvider(dpp);
    }

    static void addChannelElement(Element parentNodeElement, Element channelElement) {
        Element channelsElement = XMLDPObject.getChildElement(parentNodeElement, "Channels");
        if (channelsElement == null) {
            throw new DPError("XMLDPRoot.addChannelElement(): could not find child channels element");
        }
        channelsElement.appendChild(channelElement);
    }

    public DPProvider removeProvider(String name) {
        return this.getRoot().removeProvider(name);
    }

    Set getChannelNamesFromMergers() {
        Set names = new HashSet();
        HashSet locked = new HashSet();
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            XMLDPNode dpn = (XMLDPNode)i.next();
            if (dpn.isRemove()) {
                names = this.clearChannelNames(names, locked);
            } else if (dpn.getMergeType() == 2) {
                names = this.clearChannelNames(names, locked);
                names = dpn.mergeChannelNamesFromThis(names, locked);
            } else {
                names = dpn.mergeChannelNamesFromThis(names, locked);
            }
            if (!dpn.isLocked()) continue;
            return names;
        }
        return names;
    }

    public Set getChannelNames() {
        Set names = new HashSet();
        HashSet locked = new HashSet();
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPNode dpn = (DPNode)i.next();
            if (dpn.isRemove()) {
                names = this.clearChannelNames(names, locked);
            } else if (dpn.getMergeType() == 2) {
                names = this.clearChannelNames(names, locked);
                names = ((XMLDPNode)dpn).mergeChannelNamesFromThis(names, locked);
            } else {
                names = ((XMLDPNode)dpn).mergeChannelNamesFromThis(names, locked);
            }
            if (!dpn.isLocked()) continue;
            return names;
        }
        if (!this.isDummy()) {
            if (this.isReplace()) {
                names = this.clearChannelNames(names, locked);
            }
            names = this.mergeChannelNamesFromThis(names, locked);
        }
        return names;
    }

    public Set getChannelNamesFromThis() {
        Set names = this.channelsTable.keySet();
        return names;
    }

    protected Set mergeChannelNamesFromThis(Set names, Set locked) {
        Set namesFromThis = this.getChannelNamesFromThis();
        Iterator i = namesFromThis.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DPChannel dpc = this.getChannelFromThis(name);
            if (dpc == null) {
                throw new DPError("XMLDPNode.mergeChanelNamesFromThis(): mismatch, could not get object from this for name from this, name=" + name + ", namesFromThis=" + namesFromThis);
            }
            if (dpc.isDummy() || locked.contains(name)) continue;
            if (dpc.isLocked()) {
                locked.add(name);
            }
            if (dpc.getMergeType() == 3) {
                names.remove(name);
                continue;
            }
            names.add(name);
        }
        return names;
    }

    public Set getProviderNames() {
        return this.getRoot().getProviderNames();
    }

    Element getChannelsElement(Element e) {
        if (this.channelsElement == null) {
            this.channelsElement = XMLDPObject.getChildElement(e, "Channels", null);
        }
        return this.channelsElement;
    }

    Element getChannelElement(String name) {
        Element channelElement = (Element)this.channelsTable.get(name);
        return channelElement;
    }

    public DPChannel getChannelFromThis(String name) {
        short type = this.getType();
        if (type != 5 && type != 13) {
            return null;
        }
        String subName = null;
        String lastName = null;
        int i = name.indexOf(47);
        if (i != -1) {
            subName = name.substring(0, i);
            lastName = name.substring(i + 1);
        } else {
            subName = name;
        }
        Element e = this.getChannelElement(subName);
        DPChannel dpc = null;
        if (e != null && (dpc = (DPChannel)this.getObject(e)) == null) {
            dpc = XMLDPFactory.getInstance().getChannel(this.getContext(), this.getRoot(), e);
            this.putObject(dpc);
        }
        if (dpc == null) {
            return null;
        }
        if (lastName == null) {
            return dpc;
        }
        return ((XMLDPChannel)dpc).getChannelFromThis(lastName);
    }

    public DPChannel getChannel(String name) {
        DPChannel dpChannel = this.getChannelFromThis(name);
        boolean mergeLockedAndRemoved = false;
        if (dpChannel == null || !dpChannel.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPNode dpn = (DPNode)i.next();
                DPChannel dpc = ((XMLDPNode)dpn).getChannelFromThis(name);
                if (dpc != null) {
                    if (dpChannel == null) {
                        dpChannel = ((XMLDPRoot)this.getRoot()).addChannelHierarchy(dpc);
                    }
                    dpChannel.addMerger(dpc);
                }
                if (dpChannel == null || !dpChannel.isMergeLocked() || !dpChannel.isMergeRemove()) continue;
                dpChannel = null;
                mergeLockedAndRemoved = true;
                break;
            }
        }
        if (dpChannel != null && !dpChannel.isMergeLocked() && dpChannel.isRemove()) {
            dpChannel = null;
        }
        return dpChannel;
    }

    public boolean channelExists(String name) {
        return this.getChannel(name) != null;
    }

    public boolean providerExists(String name) {
        return this.getRoot().providerExists(name);
    }

    public DPChannel createChannel(String name, String providerName) {
        int i = name.lastIndexOf(47);
        if (i == -1) {
            DPChannel dpc = XMLDPFactory.getInstance().createChannel(this.getContext(), this.getRoot(), this.getDocument(), name, providerName);
            dpc = this.addChannel(dpc, false, true, false);
            return dpc;
        }
        String containerName = name.substring(0, i);
        String channelName = name.substring(i + 1);
        DPChannel dpc = this.getChannel(containerName);
        return dpc.createChannel(channelName, providerName);
    }

    public DPContainerChannel createContainerChannel(String name, String providerName) {
        int i = name.lastIndexOf(47);
        DPContainerChannel dpcc = null;
        if (i == -1) {
            dpcc = XMLDPFactory.getInstance().createContainerChannel(this.getContext(), this.getRoot(), this.getDocument(), name, providerName);
            dpcc = (DPContainerChannel)this.addChannel(dpcc, false, true, false);
        } else {
            String containerName = name.substring(0, i);
            String channelName = name.substring(i + 1);
            DPChannel dpc = this.getChannel(containerName);
            if (dpc.getType() != 5) {
                throw new DPError("XMLDPNode.createContainerChannel(): trying to add a channel to a non-container=" + containerName);
            }
            dpcc = dpc.createContainerChannel(channelName, providerName);
        }
        return dpcc;
    }

    Set clearChannelNames(Set names, Set locked) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (locked.contains(name)) continue;
            i.remove();
        }
        return names;
    }

    public abstract DPProvider getProvider(String var1);
}

