/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ExOChannel;
import com.sun.portal.desktop.deployment.ExOProvider;
import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFileBuilder;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ProviderPackageContext;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;

public class ExportFile {
    private Vector m_PPF = new Vector();
    private ExtractOp m_Op = null;
    private Document m_Doc = null;
    private int m_LineNumber = 0;

    private ExportFile(String fn, BufferedReader rdr, String dpnode, ProviderPackageContext ctx) throws ParFileException {
        try {
            this.processReader(rdr, dpnode, ctx);
        }
        catch (ParFileException ex) {
            if (this.m_LineNumber == 0) {
                throw ex;
            }
            StringBuffer mess = new StringBuffer();
            mess.append("Error on line " + this.m_LineNumber);
            if (fn != null) {
                mess.append(" of ");
                mess.append(fn);
            }
            throw new ParFileException(mess.toString(), ex);
        }
    }

    public static ExportFile makeExportFile(String fn, String dpnode, ProviderPackageContext ctx) throws ParFileException {
        BufferedReader rdr = null;
        try {
            if (fn.toLowerCase().startsWith("from:")) {
                StringBuffer buf = new StringBuffer();
                StringTokenizer toks = new StringTokenizer(fn, ";");
                while (toks.hasMoreTokens()) {
                    buf.append(toks.nextToken());
                    buf.append("\n");
                }
                rdr = new BufferedReader(new StringReader(buf.toString()));
            } else {
                rdr = new BufferedReader(new FileReader(fn));
            }
        }
        catch (Exception ex) {
            throw new ParFileException("Exception opening file.", ex);
        }
        return new ExportFile(fn, rdr, dpnode, ctx);
    }

    public static ExportFile makeExportFile(BufferedReader rdr, String dpnode, ProviderPackageContext ctx) throws ParFileException {
        return new ExportFile(null, rdr, dpnode, ctx);
    }

    public void addEntry(ParFileBuilder pfb) throws ParFileException {
        pfb.addDPEntry(this.m_Doc, this.m_PPF, this.m_Op);
    }

    public String getDPEntryName() throws ParFileException {
        return Par.findDPEntryName(this.m_Doc);
    }

    /*
     * WARNING - void declaration
     */
    private void processReader(BufferedReader rdr, String dpnode, ProviderPackageContext ctx) throws ParFileException {
        String rec;
        this.m_PPF.clear();
        this.m_Op = null;
        this.m_Doc = null;
        String objname = null;
        String entryname = null;
        int types = 0;
        StringBuffer dbuf = new StringBuffer();
        String dpfx = "";
        boolean defop = true;
        this.m_LineNumber = 1;
        while ((rec = ExportFile.readLine(rdr)) != null) {
            String label;
            void var10_10;
            StringTokenizer st = new StringTokenizer((String)var10_10, ": \t");
            if (st.hasMoreTokens() && !(label = st.nextToken()).startsWith("#")) {
                if (label.equalsIgnoreCase("from")) {
                    String x;
                    types = this.typeArg(st, 0);
                    try {
                        objname = URLDecoder.decode(this.nextToken(st));
                    }
                    catch (Exception ex) {
                        throw new ParFileException("Exception handling from line of exportfile.", ex);
                    }
                    ctx.setObject(objname, types);
                    boolean dobasic = true;
                    if (st.hasMoreTokens() && (x = st.nextToken()).equalsIgnoreCase("nobasic")) {
                        dobasic = false;
                    }
                    if (dobasic) {
                        ctx.addBasicFiles(this.m_PPF);
                    }
                } else if (label.equalsIgnoreCase("entry")) {
                    entryname = this.nextToken(st);
                } else if (label.equalsIgnoreCase("desc")) {
                    while (st.hasMoreTokens()) {
                        dbuf.append(dpfx);
                        dbuf.append(st.nextToken());
                        dpfx = " ";
                    }
                    dpfx = "\n";
                } else if (label.equalsIgnoreCase("auto")) {
                    String opstr = this.nextToken(st);
                    defop = false;
                    if (!opstr.equalsIgnoreCase("none")) {
                        this.m_Op = ExtractOp.makeOpFromArgument(dpnode, opstr);
                    }
                } else {
                    if (objname == null) {
                        throw new ParFileException("No \"from:\" line in file.");
                    }
                    if (label.equalsIgnoreCase("file")) {
                        String rootprop = this.nextToken(st);
                        String path = this.nextToken(st);
                        int pbty = this.typeArg(st, 2);
                        if (rootprop.equals(".")) {
                            this.m_PPF.add(ctx.getStaticFile(path, pbty));
                        } else {
                            this.m_PPF.add(ctx.getPropLocFile(rootprop, path, pbty));
                        }
                    } else if (label.equalsIgnoreCase("class")) {
                        String fullname = this.nextToken(st);
                        int cty = this.typeArg(st, 1);
                        this.m_PPF.add(ctx.getClassFile(fullname, cty));
                    } else if (label.equalsIgnoreCase("directory")) {
                        String prop = this.nextToken(st);
                        String dir = this.nextToken(st);
                        String how = this.nextToken(st);
                        types = this.typeArg(st, 2);
                        if (prop.equals(".")) {
                            prop = null;
                        }
                        if (dir.equals(".")) {
                            dir = null;
                        }
                        if (how.equals(".")) {
                            ctx.addDirectory(prop, dir, false, null, types, this.m_PPF);
                        } else if (how.equals("+")) {
                            ctx.addDirectory(prop, dir, true, null, types, this.m_PPF);
                        } else {
                            ctx.addDirectory(prop, dir, true, how, types, this.m_PPF);
                        }
                    } else {
                        throw new ParFileException("Unrecognized line - " + label);
                    }
                }
            }
            ++this.m_LineNumber;
        }
        if (objname == null) {
            throw new ParFileException("No \"from:\" line in file.");
        }
        if (entryname == null) {
            entryname = objname;
        }
        StringTokenizer toks = new StringTokenizer(entryname, " \t?[]/\\=+:;\",.");
        String pfx = "";
        StringBuffer buf = new StringBuffer();
        while (toks.hasMoreTokens()) {
            buf.append(pfx);
            pfx = "_";
            buf.append(toks.nextToken());
        }
        entryname = buf.toString();
        if (defop) {
            if ((types & 1) != 0) {
                this.m_Op = new ExOProvider(dpnode);
                if ((types & 2) != 0) {
                    String cname = ctx.getContainerName(objname);
                    ExOChannel cop = new ExOChannel(dpnode, cname);
                    cop.setAvail(cname);
                    this.m_Op.add(cop);
                }
            } else if ((types & 2) != 0) {
                this.m_Op = new ExOChannel(dpnode, ctx.getContainerName(objname));
            }
        }
        this.m_Doc = ctx.getParEntry(entryname, dbuf.length() > 0 ? dbuf.toString() : null);
    }

    private static String readLine(BufferedReader rdr) throws ParFileException {
        try {
            return rdr.readLine();
        }
        catch (Exception ex) {
            throw new ParFileException("Exception reading line from file.", ex);
        }
    }

    private String nextToken(StringTokenizer st) throws ParFileException {
        if (!st.hasMoreTokens()) {
            throw new ParFileException("Not enough tokens on line.");
        }
        return st.nextToken();
    }

    private int typeArg(StringTokenizer st, int def) throws ParFileException {
        if (!st.hasMoreTokens() && def != 0) {
            return def;
        }
        StringTokenizer typst = new StringTokenizer(this.nextToken(st), ",+");
        int ty = 0;
        while (typst.hasMoreTokens()) {
            String ts = typst.nextToken();
            if (ts.equalsIgnoreCase("provider")) {
                ty |= 1;
                continue;
            }
            if (ts.equalsIgnoreCase("channel")) {
                ty |= 2;
                continue;
            }
            throw new ParFileException("Unrecognized operation type - " + ts);
        }
        return ty;
    }
}

