/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.ParFileException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;

public class CmdOpts {
    public static final int STD_NONE = 0;
    public static final int STD_DPONLY = 1;
    public static final int STD_PARONLY = 2;
    public static final int STD_BOTH = 3;
    public static final int STD_DPOPT = 4;
    public static final int REM_NONE = 0;
    public static final int REM_OPTIONAL = 1;
    public static final int REM_REQUIRED = 3;
    public static final String GLOBAL_DN = "global";
    private HashMap m_Short = new HashMap();
    private Vector m_Remaining = new Vector();
    private boolean m_Modify = false;
    private boolean m_Verbose = false;
    private boolean m_Overwrite = false;
    private boolean m_AutoExtract = false;
    private boolean m_Debug = false;
    private boolean m_Login = false;
    private String m_ParFile = null;
    private BufferedReader m_BRd = null;
    private DPRootSpecifier m_DRoot = null;
    private String m_User = null;
    private String m_Pwd = null;
    private String m_DN = null;
    private static final String SINGLEPFX = "-";
    private static final String DOUBLEPFX = "--";
    private static final String NEGATEPFX = "--no-";

    private CmdOpts(String[] args, int stdargs, int rem, String allowopts) throws ParFileException {
        this.m_Short.put("r", "runasdn");
        this.m_Short.put("p", "password");
        this.m_Short.put("m", "modify");
        this.m_Short.put("v", "verbose");
        this.m_Short.put("a", "auto");
        this.m_Short.put("o", "overwrite");
        this.m_Short.put("d", "debug");
        int idx = 0;
        while (idx < args.length) {
            String opts = this.stripOpt(args[idx], allowopts);
            boolean boolset = true;
            if (opts == null) break;
            if (opts.startsWith("!") && opts.length() > 1) {
                boolset = false;
                opts = opts.substring(1);
            }
            boolean hasarg = false;
            char o1 = opts.charAt(0);
            switch (o1) {
                case 'p': 
                case 'r': {
                    if (opts.length() > 1) {
                        throw new ParFileException(args[idx] + " must be used by itself.");
                    }
                    hasarg = true;
                    break;
                }
            }
            if (hasarg && ++idx >= args.length) {
                throw new ParFileException(args[idx] + " without an argument specified.");
            }
            switch (o1) {
                case 'r': {
                    this.m_User = args[idx];
                    break;
                }
                case 'p': {
                    this.m_Pwd = args[idx];
                    break;
                }
                default: {
                    if (hasarg) {
                        throw new ParFileException("Logic error - hasarg should not be true.");
                    }
                    int cidx = 0;
                    while (cidx < opts.length()) {
                        switch (opts.charAt(cidx)) {
                            case 'm': {
                                this.m_Modify = boolset;
                                break;
                            }
                            case 'v': {
                                this.m_Verbose = boolset;
                                break;
                            }
                            case 'o': {
                                this.m_Overwrite = boolset;
                                break;
                            }
                            case 'a': {
                                this.m_AutoExtract = boolset;
                                break;
                            }
                            case 'd': {
                                this.m_Debug = boolset;
                                break;
                            }
                            default: {
                                throw new ParFileException(args[idx] + " contains unrecognized option characters.");
                            }
                        }
                        ++cidx;
                    }
                    break block3;
                }
            }
            ++idx;
        }
        if (idx < args.length && args[idx].equals(DOUBLEPFX)) {
            ++idx;
        }
        int req = 1;
        this.m_Login = true;
        switch (stdargs) {
            case 0: {
                req = 0;
                this.m_Login = false;
                break;
            }
            case 2: {
                this.m_Login = false;
                break;
            }
            case 3: {
                req = 2;
                break;
            }
        }
        if (args.length - idx < req) {
            throw new ParFileException("Not enough arguments specified");
        }
        switch (stdargs) {
            case 2: 
            case 3: 
            case 4: {
                this.m_ParFile = args[idx];
                ++idx;
                break;
            }
        }
        switch (stdargs) {
            case 1: 
            case 3: {
                this.m_DN = args[idx];
                ++idx;
                break;
            }
            case 4: {
                if (idx >= args.length) break;
                this.m_DN = args[idx];
                ++idx;
                break;
            }
        }
        switch (rem) {
            case 0: {
                if (args.length <= idx) break;
                throw new ParFileException("Unrecognized arguments at end of the command.");
            }
            case 3: {
                if (args.length > idx) break;
                throw new ParFileException("Not enough arguments specified.");
            }
        }
        if (this.m_Login) {
            if (this.m_User == null) {
                this.m_User = this.promptFor("runasdn");
            }
            if (this.m_Pwd == null) {
                this.m_Pwd = this.promptFor("password");
            }
        }
        while (idx < args.length) {
            this.m_Remaining.add(args[idx]);
            ++idx;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static CmdOpts parseOpts(String[] args, int stdargs, int rem, String usage, String allowopts) {
        opts = null;
        try {
            opts = new CmdOpts(args, stdargs, rem, allowopts);
            if (opts.m_Login) {
                try {
                    if (opts.m_Verbose || opts.m_Debug) {
                        System.out.println("AUTHENTICATING");
                    }
                    opts.m_DRoot = DPRootSpecifier.makeSpecifier(opts.m_User, opts.m_Pwd);
                    if ((opts.m_Verbose || opts.m_Debug) && opts.m_DN != null) {
                        System.out.println("AUTHENTICATED - Setting DN - " + opts.m_DN);
                    }
                    opts.m_DRoot.setDN(opts.m_DN);
                }
                catch (Exception ex) {
                    opts.produceErrorMessage(ex);
                    return null;
                }
            }
            return opts;
        }
        catch (ParFileException pex) {
            System.err.println("ERROR: " + pex.getMessage());
            System.err.println("USAGE: " + usage);
            System.err.println("OPTIONS:");
            i = 0;
            ** while (i < allowopts.length())
        }
lbl-1000:
        // 1 sources

        {
            o = allowopts.charAt(i);
            switch (o) {
                case 'r': {
                    System.err.println("\t--runasdn <dn>");
                    break;
                }
                case 'p': {
                    System.err.println("\t--password <password>");
                    break;
                }
                case 'm': {
                    System.err.println("\t--modify");
                    break;
                }
                case 'v': {
                    System.err.println("\t--verbose");
                    break;
                }
                case 'o': {
                    System.err.println("\t--overwrite");
                    break;
                }
                case 'a': {
                    System.err.println("\t--auto");
                    break;
                }
                case 'd': {
                    System.err.println("\t--debug");
                    break;
                }
                default: {
                    System.err.println("\tLOGIC ERROR - CmdOpts doesn't recognize '" + o + "'");
                }
            }
            ++i;
            continue;
        }
lbl50:
        // 1 sources

        return null;
    }

    public Vector remaining() {
        return this.m_Remaining;
    }

    public boolean modify() {
        return this.m_Modify;
    }

    public boolean verbose() {
        return this.m_Verbose;
    }

    public boolean overwrite() {
        return this.m_Overwrite;
    }

    public boolean autoextract() {
        return this.m_AutoExtract;
    }

    public String parfile() {
        return this.m_ParFile;
    }

    public DPRootSpecifier dproot() {
        return this.m_DRoot;
    }

    public boolean debug() {
        return this.m_Debug;
    }

    public void produceErrorMessage(Exception ex) {
        System.err.println("ERROR: " + ex.getMessage());
        if (this.m_Debug) {
            ex.printStackTrace(System.err);
        }
    }

    private String promptFor(String prompt) throws ParFileException {
        try {
            if (this.m_BRd == null) {
                this.m_BRd = new BufferedReader(new InputStreamReader(System.in));
            }
            int i = 0;
            while (i < 3) {
                System.out.print(prompt + ": ");
                String resp = this.m_BRd.readLine();
                if (resp.length() > 0) {
                    return resp;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ParFileException("Exception using buffered reader for prompt.", ex);
        }
        throw new ParFileException(prompt + " not provided.");
    }

    private String stripOpt(String arg, String allowopts) throws ParFileException {
        if (arg.startsWith(DOUBLEPFX)) {
            if (arg.equals(DOUBLEPFX)) {
                return null;
            }
            String retpfx = "";
            int plen = DOUBLEPFX.length();
            if (arg.startsWith(NEGATEPFX)) {
                if (arg.equals(NEGATEPFX)) {
                    throw new ParFileException("--no- with no option attached.");
                }
                retpfx = "!";
                plen = NEGATEPFX.length();
            }
            String ochar = arg.substring(plen, plen + 1);
            String oword = arg.substring(plen);
            String olookup = (String)this.m_Short.get(ochar);
            if (olookup == null || !olookup.equals(oword)) {
                throw new ParFileException(arg + " is not a recognized option.");
            }
            if (allowopts.indexOf(ochar) < 0) {
                throw new ParFileException(arg + " is not allowed by this command.");
            }
            return retpfx + ochar;
        }
        if (arg.startsWith(SINGLEPFX)) {
            int i = 1;
            while (i < arg.length()) {
                char o = arg.charAt(i);
                if (allowopts.indexOf(o) < 0) {
                    throw new ParFileException(SINGLEPFX + o + " is not allowed by this command.");
                }
                ++i;
            }
            return arg.substring(1);
        }
        return null;
    }
}

