/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextException;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.context.ContainerProviderContext;
import javax.servlet.http.HttpServletRequest;

public class ProviderGetter
extends Thread {
    private String providerName = null;
    private String parent = null;
    private Monitor monitor = null;
    private Provider provider = null;
    private boolean terminated = false;
    protected HttpServletRequest req = null;
    protected ContainerProviderContext context = null;

    public ProviderGetter(ContainerProviderContext context, String parent, String providerName, Monitor m, HttpServletRequest req) {
        this.context = context;
        this.providerName = providerName;
        this.parent = parent;
        this.monitor = m;
        this.req = req;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() {
        this.terminated = true;
        this.interrupt();
    }

    public void run() {
        this.context.debugMessage("ProviderGetter.run(): entered for " + this.providerName);
        try {
            if (this.isTerminated()) {
                throw new ContextException("ProviderGetter.run(): attempted to run a terminated provider getter thread, providerName=" + this.providerName);
            }
            if (this.providerName == null) {
                throw new ContextException("ProviderGetter.run() attempted to run with null provider name");
            }
            this.provider = this.context.getProvider(this.req, this.parent, this.providerName);
            this.monitor.put(this.providerName, this.provider);
            this.context.debugMessage("ProviderGetter.run(): finished " + this.providerName);
        }
        catch (Throwable e) {
            this.context.debugError("ProviderGetter.run(): failed providerName=" + this.providerName, e);
            this.monitor.put(this.providerName, null);
        }
    }
}

