/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ConfigContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DebugLevels;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;

public class PropertiesConfigContext
implements ConfigContext,
DebugLevels {
    public static final String PROPERTIESFILE = "desktop.propertiesFile";
    public static final String LOGLEVEL_KEY = "debugLevel";
    public static final String PERFLEVEL_KEY = "perfLevel";
    public static final String SERVICEAPPCONTEXTCLASSNAME_KEY = "serviceAppContextClassName";
    public static final String TEMPLATEBASEDIR_KEY = "templateBaseDir";
    public static final String PROVIDERCLASSBASEDIR_KEY = "providerClassBaseDir";
    public static final String JSPCOMPILERWARCLASSPATH_KEY = "jspCompilerWARClassPath";
    public static final String DEFAULT_DESKTOPTYPE_KEY = "defaultDesktopType";
    public static final String TEMPLATE_SCAN_INTERVAL = "templateScanInterval";
    public static final String GETTER_POOL_MIN_SIZE_KEY = "getterPoolMinSize";
    public static final String GETTER_POOL_MAX_SIZE_KEY = "getterPoolMaxSize";
    public static final String GETTER_POOL_PARTITION_SIZE_KEY = "getterPoolPartitionSize";
    public static final String CALLER_POOL_MIN_SIZE_KEY = "callerPoolMinSize";
    public static final String CALLER_POOL_MAX_SIZE_KEY = "callerPoolMaxSize";
    public static final String CALLER_POOL_PARTITION_SIZE_KEY = "callerPoolPartitionSize";
    public static final String PERF_AUDIT_PORT_PARAM = "htmlAdaptorPortNumber";
    public static final String PERF_AUDIT_ENABLED_PARAM = "perfAuditEnabled";
    public static final String COOKIEPREFIX_KEY = "cookiePrefix";
    protected static Properties properties = null;

    public void init(ServletConfig sc) {
        String propertiesFile = sc.getServletContext().getInitParameter(PROPERTIESFILE);
        this.init(propertiesFile);
    }

    public void init(String filename) {
        properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new ContextError("PropertiesConfigContext.init(): ", fnfe);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesConfigContext.init(): ", ioe);
        }
    }

    public short getDebugLevel() {
        String level = properties.getProperty(LOGLEVEL_KEY);
        if (level.equalsIgnoreCase("ERROR")) {
            return 1;
        }
        if (level.equalsIgnoreCase("OFF")) {
            return 0;
        }
        if (level.equalsIgnoreCase("WARNING")) {
            return 2;
        }
        if (level.equalsIgnoreCase("MESSAGE")) {
            return 3;
        }
        throw new ContextError("PropertiesConfigContext.getDebugLevel(): invalid log level: " + level);
    }

    public short getPerfLevel() {
        String level = properties.getProperty(PERFLEVEL_KEY);
        if (level.equalsIgnoreCase("ERROR")) {
            return 1;
        }
        if (level.equalsIgnoreCase("OFF")) {
            return 0;
        }
        if (level.equalsIgnoreCase("WARNING")) {
            return 2;
        }
        if (level.equalsIgnoreCase("MESSAGE")) {
            return 3;
        }
        throw new ContextError("PropertiesConfigContext.getPerfLevel(): invalid perf level: " + level);
    }

    public String getServiceAppContextClassName() {
        return properties.getProperty(SERVICEAPPCONTEXTCLASSNAME_KEY);
    }

    public String getConfigProperty(String key) {
        return properties.getProperty(key);
    }

    public String getTemplateBaseDir() {
        return properties.getProperty(TEMPLATEBASEDIR_KEY);
    }

    public String getCookiePrefix() {
        return properties.getProperty(COOKIEPREFIX_KEY);
    }

    public String getProviderClassBaseDir() {
        return properties.getProperty(PROVIDERCLASSBASEDIR_KEY);
    }

    public String getJSPCompilerWARClassPath() {
        return properties.getProperty(JSPCOMPILERWARCLASSPATH_KEY);
    }

    public String getDefaultDesktopType() {
        return properties.getProperty(DEFAULT_DESKTOPTYPE_KEY);
    }

    public int getGetterPoolMinSize() {
        return this.getIntegerProperty(GETTER_POOL_MIN_SIZE_KEY);
    }

    public int getGetterPoolMaxSize() {
        return this.getIntegerProperty(GETTER_POOL_MAX_SIZE_KEY);
    }

    public int getGetterPoolPartitionSize() {
        return this.getIntegerProperty(GETTER_POOL_PARTITION_SIZE_KEY);
    }

    public int getCallerPoolMinSize() {
        return this.getIntegerProperty(CALLER_POOL_MIN_SIZE_KEY);
    }

    public int getCallerPoolMaxSize() {
        return this.getIntegerProperty(CALLER_POOL_MAX_SIZE_KEY);
    }

    public int getCallerPoolPartitionSize() {
        return this.getIntegerProperty(CALLER_POOL_PARTITION_SIZE_KEY);
    }

    public int getTemplateScanInterval() {
        return this.getIntegerProperty(TEMPLATE_SCAN_INTERVAL);
    }

    private int getIntegerProperty(String key) {
        String strInt = properties.getProperty(key);
        int result = 0;
        if (strInt != null && strInt.length() > 0) {
            try {
                result = Integer.parseInt(strInt);
            }
            catch (NumberFormatException e) {
                throw new ContextError("PropertiesConfigContext.getIntegerProperty(): invalid number format for key " + key, e);
            }
        }
        return result;
    }

    public boolean isPasEnabled() {
        String param = properties.getProperty(PERF_AUDIT_ENABLED_PARAM);
        if (param == null) {
            return false;
        }
        return Boolean.valueOf(param);
    }

    public int[] getPasPortNumbers() {
        String param = properties.getProperty(PERF_AUDIT_PORT_PARAM);
        int[] ports = null;
        if (param != null) {
            StringTokenizer st = new StringTokenizer(param);
            ports = new int[st.countTokens()];
            int index = 0;
            while (st.hasMoreTokens()) {
                String port = st.nextToken();
                try {
                    ports[index++] = Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    throw new ContextError("PropertiesConfigContext.getPasPortNumber(): invalid port number: " + port, e);
                }
            }
        }
        return ports;
    }
}

