/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMESessionEvent;
import com.sun.portal.desktop.context.DSAMEUserEvent;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.SessionContext;
import com.sun.portal.desktop.context.SessionEvent;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserEvent;
import com.sun.portal.desktop.context.UserListener;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

class DSAMESessionContext
implements SessionContext,
SSOTokenListener {
    static int counter = 0;
    static Set sids = new HashSet();
    private SSOToken _token = null;
    protected static Map sessionListeners = new HashMap();
    protected static Map userListeners = new HashMap();
    protected static Map sessionIDs = new HashMap();
    protected boolean ssoTokenListenerAdded = false;
    String sid = null;
    String uid = null;
    DesktopAppContext desktopAppContext = null;

    private static synchronized void incCounter() {
        ++counter;
    }

    private static synchronized void addSID(String sid) {
        sids.add(sid);
    }

    private static synchronized void decCounter() {
        --counter;
    }

    private static synchronized void removeSID(String sid) {
        sids.remove(sid);
    }

    private static synchronized int sidsSize() {
        return sids.size();
    }

    public void init(HttpServletRequest req) {
        this._token = this.getSSOToken(req);
        this.desktopAppContext = DesktopAppContextThreadLocalizer.get();
        this.initSessionID();
        this.initUserID();
    }

    protected DesktopAppContext getDesktopAppContext() {
        return this.desktopAppContext;
    }

    /*
     * WARNING - void declaration
     */
    public String getStringProperty(String name) {
        try {
            void ssoe;
            String val = this.getSSOToken().getProperty(name);
            return ssoe;
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMESessionContext.getStringProperty(): ", ssoe);
        }
    }

    public void setStringProperty(String name, String val) {
        try {
            this.getSSOToken().setProperty(name, val);
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMESessionContext.setStringProperty(): ", ssoe);
        }
    }

    private synchronized SSOToken getSSOToken() {
        if (this._token == null) {
            throw new ContextError("DSAMESessionContext.getSSOToken(): not initialized");
        }
        return this._token;
    }

    private synchronized SSOToken getSSOToken(HttpServletRequest req) {
        SSOToken token = null;
        try {
            token = DSAMEConnection.getSSOTokenManager().createSSOToken(req);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMESessionContext.getSSOToken(): Failed to get SSOToken.  ", se);
        }
        return token;
    }

    public String getSessionID() {
        if (this.sid == null) {
            throw new ContextError("DSAMESessionContext.getSessionID(): not initialized");
        }
        return this.sid;
    }

    protected void initSessionID() {
        this.sid = this.getSSOToken().getTokenID().toString();
    }

    public String getUserID() {
        if (this.uid == null) {
            throw new ContextError("DSAMESessionContext.getUserID(): not initialized");
        }
        return this.uid;
    }

    protected void initUserID() {
        Principal p = null;
        try {
            p = this.getSSOToken().getPrincipal();
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMESessionContext.getUserID(): ", ssoe);
        }
        this.uid = p.toString();
    }

    protected void addSSOTokenListener() {
        block6: {
            String sid = this.getSessionID();
            try {
                if (this.ssoTokenListenerAdded) break block6;
                DSAMESessionContext dSAMESessionContext = this;
                synchronized (dSAMESessionContext) {
                    if (!this.ssoTokenListenerAdded) {
                        this.getSSOToken().addSSOTokenListener((SSOTokenListener)this);
                        DSAMESessionContext.incCounter();
                        DSAMESessionContext.addSID(this.getSessionID());
                        this.ssoTokenListenerAdded = true;
                    }
                }
            }
            catch (SSOException ssoe) {
                throw new ContextError("DSAMESessionAppContext.addSSOTokenListener(): ", ssoe);
            }
        }
    }

    public void addSessionListener(SessionListener sl) {
        String sid = this.getSessionID();
        Map map = sessionListeners;
        synchronized (map) {
            HashSet<SessionListener> listeners = (HashSet<SessionListener>)sessionListeners.get(sid);
            if (listeners == null) {
                listeners = new HashSet<SessionListener>();
                sessionListeners.put(sid, listeners);
            }
            listeners.add(sl);
        }
        this.addSSOTokenListener();
    }

    public void addUserListener(UserListener ul) {
        String uid = this.getUserID();
        String sid = this.getSessionID();
        Map map = userListeners;
        synchronized (map) {
            UserListenersReference ref = (UserListenersReference)userListeners.get(uid);
            if (ref == null) {
                ref = new UserListenersReference();
                userListeners.put(uid, ref);
            }
            if (ref.getListeners(sid) == null) {
                sessionIDs.put(sid, uid);
            }
            ref.addListener(sid, ul);
        }
        this.addSSOTokenListener();
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        DSAMESessionContext.decCounter();
        SSOToken token = evt.getToken();
        String sid = token.getTokenID().toString();
        DSAMESessionContext.removeSID(sid);
        int type = -1;
        try {
            type = evt.getType();
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMESessionContext.ssoTokenChanged(): ", ssoe);
        }
        this.ssoTokenChangedUsers(sid, type);
        this.ssoTokenChangedSessions(sid, type);
    }

    public String encodeURL(String url) {
        String val = null;
        try {
            val = this.getSSOToken().encodeURL(url);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMESessionContext.encodeURL(): Failed to encode URL: " + url, se);
        }
        return val;
    }

    protected void ssoTokenChangedSessions(String sid, int type) {
        Set listeners = null;
        boolean destroySession = false;
        DSAMESessionEvent se = null;
        Map map = sessionListeners;
        synchronized (map) {
            listeners = (Set)sessionListeners.get(sid);
            if (listeners == null) {
                return;
            }
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    se = new DSAMESessionEvent();
                    se.setSessionID(sid);
                    sessionListeners.remove(sid);
                    destroySession = true;
                    break;
                }
                default: {
                    throw new ContextError("DSAMESessionContext.ssoTokenChangedSessions(): unknown event type=" + type);
                }
            }
        }
        if (destroySession) {
            this.destroySessions(listeners, se);
        }
    }

    protected void ssoTokenChangedUsers(String sid, int type) {
        Set listeners = null;
        boolean logoutUser = false;
        DSAMEUserEvent ue = null;
        Map map = userListeners;
        synchronized (map) {
            String uid = (String)sessionIDs.get(sid);
            if (uid == null) {
                throw new ContextError("DSAMESessionContext.ssoTokenChangedUsers(): could not lookup uid for sid=" + sid);
            }
            UserListenersReference ref = (UserListenersReference)userListeners.get(uid);
            if (ref == null) {
                return;
            }
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    sessionIDs.remove(sid);
                    listeners = ref.removeSID(sid);
                    if (ref.size() > 0) break;
                    ue = new DSAMEUserEvent();
                    ue.setUserID(uid);
                    userListeners.remove(uid);
                    logoutUser = true;
                    break;
                }
                default: {
                    throw new ContextError("DSAMESessionContext.ssoTokenChangedUsers(): unknown event type=" + type);
                }
            }
        }
        if (logoutUser) {
            this.logoutUsers(listeners, ue);
        }
    }

    protected void destroySessions(Set listeners, SessionEvent se) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            SessionListener sl = (SessionListener)i.next();
            sl.sessionDestroyed(se);
        }
    }

    protected void logoutUsers(Set listenersForSID, UserEvent ue) {
        Iterator j = listenersForSID.iterator();
        while (j.hasNext()) {
            UserListener ul = (UserListener)j.next();
            ul.userLogout(ue);
        }
    }

    private static class UserListenersReference {
        private Map listeners = new HashMap();

        public int getReferences() {
            return this.listeners.size();
        }

        public Set removeSID(String sid) {
            Set s = (Set)this.listeners.remove(sid);
            return s;
        }

        public int size() {
            return this.listeners.size();
        }

        public Iterator getSIDs() {
            return this.listeners.keySet().iterator();
        }

        public Set getListeners(String sid) {
            Set listenersForSID = (Set)this.listeners.get(sid);
            return listenersForSID;
        }

        public void addListener(String sid, UserListener ul) {
            HashSet<UserListener> listenersForSID = (HashSet<UserListener>)this.listeners.get(sid);
            if (listenersForSID == null) {
                listenersForSID = new HashSet<UserListener>();
                this.listeners.put(sid, listenersForSID);
            }
            listenersForSID.add(ul);
        }

        public String toString() {
            return this.listeners.toString();
        }
    }
}

