/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;

class DPAList {
    XMLDPFactory dpf = XMLDPFactory.getInstance();

    DPAList() {
    }

    public String process(DSAMEAdminDPContext dadc, String dn, boolean global, String name, boolean verbose) throws DPAException {
        if (verbose) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            DPAUtil.debug("dbgRetrievingDP", tokens);
        }
        String doc = null;
        try {
            doc = !global ? dadc.getDPDocumentByDN(dn) : dadc.getGlobalDPDocument();
            if (doc == null || doc.length() == 0) {
                return null;
            }
            if (name == null) {
                return doc.toString();
            }
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorRetrieveDP", ex, tokens);
        }
        if (verbose) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            DPAUtil.debug("dbgBuildingDPRoot", tokens);
        }
        DPRoot dpr = null;
        try {
            dpr = this.dpf.createRoot((DPContext)dadc, doc);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorCreateDPRoot", ex, tokens);
        }
        if (verbose) {
            Object[] tokens = new Object[]{name};
            DPAUtil.debug("dbgFindPropertyHolder", tokens);
        }
        DPPropertyHolder ph = null;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            ph = xdpr.getChannelFromThis(name);
            if (ph == null) {
                ph = xdpr.getProviderFromThis(name);
            }
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new DPAException("errorFindPropertyHolder", ex, tokens);
        }
        if (ph != null) {
            return ph.toString();
        }
        return null;
    }
}

