/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPString;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Vector;

abstract class DPBasedContext {
    private String DTPROPFILE = "desktop.propertiesFile";
    private String STATICDIR = "ps.staticDir";
    private DPPropertyHolder m_Prop = null;
    private DPChannel m_Chan = null;
    private Vector m_Classes = null;
    private int m_Types;
    private Properties m_DTProps = null;

    DPBasedContext() {
    }

    protected void setPropertyHolder(DPNode root, String objname, int types) throws ParFileException {
        try {
            if ((types & 2) != 0) {
                this.m_Chan = root.getChannel(objname);
                this.m_Prop = this.m_Chan;
            } else {
                this.m_Prop = root.getProvider(objname);
                this.m_Chan = null;
            }
            this.m_Types = types;
        }
        catch (Exception ex) {
            throw new ParFileException("Exception attempting to obtain provider or channel from DP Root.", ex);
        }
        if (this.m_Prop == null) {
            throw new ParFileException("No such object - " + objname);
        }
    }

    protected String getPBFProperty(String prop, boolean nullok) throws ParFileException {
        if (this.m_Prop == null) {
            throw new ParFileException("Logic error - PropertyHolder node not set.");
        }
        String val = this.getDesktopProperty(prop, true);
        if (val != null) {
            return val;
        }
        try {
            DPString dps = this.m_Prop.getProperties().getString(prop);
            if (dps != null) {
                val = dps.getStringValue();
            }
        }
        catch (Exception ex) {
            val = null;
        }
        if (val != null || nullok) {
            return val;
        }
        throw new ParFileException("Root property \"" + prop + "\" is undefined.");
    }

    protected Vector getClassPath() throws ParFileException {
        if (this.m_Classes != null) {
            return this.m_Classes;
        }
        this.m_Classes = new Vector();
        String bdir = this.getDesktopProperty("providerClassBaseDir", false);
        this.m_Classes.add(bdir);
        File f = new File(bdir);
        String[] names = f.list();
        if (names == null) {
            return this.m_Classes;
        }
        int i = 0;
        while (i < names.length) {
            if (names[i].endsWith(".jar")) {
                this.m_Classes.add(bdir + "/" + names[i]);
            }
            ++i;
        }
        return this.m_Classes;
    }

    protected boolean isJar(String fn) {
        File f = new File(fn);
        return f.isFile();
    }

    protected DPChannel getChannel() {
        return this.m_Chan;
    }

    protected DPProvider getProvider() throws ParFileException {
        if (this.m_Chan != null) {
            try {
                return this.m_Chan.getProvider();
            }
            catch (Exception ex) {
                throw new ParFileException("Exception getting provider for channel.", ex);
            }
        }
        return (DPProvider)this.m_Prop;
    }

    protected int getTypes() {
        return this.m_Types;
    }

    protected String getStaticDirectory() throws ParFileException {
        String dir = System.getProperty(this.STATICDIR);
        if (dir == null) {
            throw new ParFileException(this.STATICDIR + " is undefined.");
        }
        return dir;
    }

    protected boolean deployDynamic() throws ParFileException {
        return true;
    }

    protected boolean deployStatic() throws ParFileException {
        return true;
    }

    private String getDesktopProperty(String key, boolean nullok) throws ParFileException {
        String val;
        if (this.m_DTProps == null) {
            String sysprop = System.getProperty(this.DTPROPFILE);
            if (sysprop == null) {
                throw new ParFileException(this.DTPROPFILE + " is undefined.");
            }
            try {
                this.m_DTProps = new Properties();
                this.m_DTProps.load(new FileInputStream(sysprop));
            }
            catch (Exception ex) {
                throw new ParFileException("Exception loading desktop properties.", ex);
            }
        }
        if ((val = this.m_DTProps.getProperty(key)) != null || nullok) {
            return val;
        }
        throw new ParFileException("Desktop property " + key + " not defined in " + this.DTPROPFILE);
    }
}

