/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.CmdOpts;
import com.sun.portal.desktop.deployment.DPBasedExCtx;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.ParFile;
import com.sun.portal.desktop.deployment.ParFileException;
import java.io.PrintStream;
import java.util.Vector;

public class CmdImport {
    public static void doImport(boolean verbose, boolean overwrite, boolean autoextract, String parfile, DPRootSpecifier droot, Vector ops, PrintStream out) throws ParFileException {
        ParFile par = ParFile.makeParFile(parfile);
        DPBasedExCtx pex = new DPBasedExCtx(droot, overwrite, verbose, out);
        if (autoextract) {
            if (ops.size() > 0) {
                throw new ParFileException("Cannot specify operations with an automated extraction.");
            }
            par.performAutoExtraction(pex, droot.getDN());
            return;
        }
        int i = 0;
        while (i < ops.size()) {
            String opstr = (String)ops.elementAt(i);
            ExtractOp op = ExtractOp.makeOpFromArgument(droot.getDN(), opstr);
            par.performExtraction(pex, op);
            ++i;
        }
    }

    public static void main(String[] args) {
        CmdOpts opts = CmdOpts.parseOpts(args, 4, 1, "import [<options>] -- <parfile> [<dn|global> [<op> ....]]", "rpdvoa");
        if (opts != null) {
            try {
                CmdImport.doImport(opts.verbose(), opts.overwrite(), opts.autoextract(), opts.parfile(), opts.dproot(), opts.remaining(), System.out);
            }
            catch (Exception ex) {
                opts.produceErrorMessage(ex);
            }
        }
        System.exit(0);
    }
}

