/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.DesktopThreadLocalManager;
import com.sun.portal.desktop.PerfData;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProviderCaller
extends Thread {
    private static ResourceBundle bundle = null;
    private ContainerProviderContext providerContext = null;
    private DesktopContext desktopContext = null;
    private DesktopAppContext desktopAppContext = null;
    private Provider provider = null;
    private StringBuffer content = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private Monitor monitor = null;
    private long responseTime = 0L;
    private boolean terminated = false;
    private ServletConfig servletConfig;
    private PerfData perfData = null;

    public ProviderCaller(DesktopAppContext desktopAppContext, DesktopContext desktopContext, ContainerProviderContext providerContext, Provider provider, Monitor monitor, HttpServletRequest req, HttpServletResponse res, ServletConfig servletConfig, PerfData perfData) {
        this.providerContext = providerContext;
        this.desktopContext = desktopContext;
        this.desktopAppContext = desktopAppContext;
        this.provider = provider;
        this.monitor = monitor;
        this.perfData = perfData;
        this.request = req;
        this.response = res;
        this.servletConfig = servletConfig;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() {
        this.terminated = true;
        this.interrupt();
    }

    public void run() {
        DesktopThreadLocalManager.init(this.desktopAppContext, this.request, this.response, this.servletConfig, this.perfData);
        DesktopThreadLocalManager.init(this.desktopContext, this.providerContext);
        String name = null;
        try {
            long start = 0L;
            long now = 0L;
            if (this.isTerminated()) {
                throw new ContextError("attempt to run terminated provider");
            }
            if (this.provider == null) {
                throw new ContextError("attempt to run with null provider!");
            }
            name = this.provider.getName();
            if (this.desktopAppContext.isPasContextActivated()) {
                start = System.currentTimeMillis();
            }
            this.content = this.provider.getContent(this.request, this.response);
            if (this.provider.getRefreshTime() > 0L) {
                this.providerContext.putCachedContent(name, this.content);
            }
            if (this.desktopAppContext.isPasContextActivated()) {
                now = System.currentTimeMillis();
                this.desktopAppContext.logProcessTime("channel", "get_content", name, now - start);
            }
            if (this.content == null) {
                throw new ContextError("couldn't fetch content");
            }
            this.monitor.put(name, this.content);
        }
        catch (Throwable e) {
            this.providerContext.debugError("ProviderCaller.run()", e);
            this.monitor.put(name, this.content);
        }
        DesktopThreadLocalManager.release();
    }
}

