/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.Locale;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.ServiceContext;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEServiceContext
implements ServiceContext,
DSAMEConstants {
    private static Set prefetchAttrs = new HashSet();
    protected DSAMEConnection dsameConn = null;
    protected String accept_locale = null;
    protected static final String defaultLocaleString;

    public void init(HttpServletRequest req) {
        this.dsameConn = new DSAMEConnection(req);
        this.dsameConn.prefetchAttributes(prefetchAttrs);
        this.accept_locale = Locale.getLocaleStringFromAcceptLangHeader((String)req.getHeader("accept-language"));
    }

    public void init(HttpServletRequest req, String uid, String pw) {
        this.dsameConn = new DSAMEConnection(uid, pw);
        this.dsameConn.prefetchAttributes(prefetchAttrs);
        this.accept_locale = Locale.getLocaleStringFromAcceptLangHeader((String)req.getHeader("accept-language"));
    }

    public String getLocaleString() {
        String localeString = this.dsameConn.getAttributeFromROC("preferredlocale");
        if (localeString == null) {
            localeString = this.accept_locale;
        }
        if (localeString == null) {
            localeString = this.dsameConn.getOrgAttributeFromROC("iPlanetAMAuthService", "iplanet-am-auth-locale");
        }
        if (localeString == null) {
            localeString = defaultLocaleString;
        }
        return localeString;
    }

    public String getDesktopType() {
        return this.dsameConn.getAttributeFromROC("sunPortalDesktopType");
    }

    public String getDefaultChannelName() {
        return this.dsameConn.getAttributeFromROC("sunPortalDesktopDefaultChannelName");
    }

    public String getEditProviderContainerName() {
        return this.dsameConn.getAttributeFromROC("sunPortalDesktopEditProviderContainerName");
    }

    public String getDPContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDpContextClassName");
    }

    public String getDPUserContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDpUserContextClassName");
    }

    public String getContainerProviderContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopContainerProviderContextClassName");
    }

    public String getProviderManagerContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopProviderManagerContextClassName");
    }

    public String getPropertiesContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopPropertiesContextClassName");
    }

    public String getTemplateContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopTemplateContextClassName");
    }

    public String getClientContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopClientContextClassName");
    }

    static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    public boolean isExecutable() {
        String b = this.dsameConn.getAttributeFromROC("sunPortalDesktopExecutable");
        return DSAMEServiceContext.toBoolean(b);
    }

    public String getLogoutURL() {
        return this.dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-logout-url");
    }

    public String getDebugContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDebugContextClassName");
    }

    public String getSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionContextClassName");
    }

    public String getAuthlessSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopAuthlessSessionContextClassName");
    }

    public String getStringAttribute(String name) {
        return this.dsameConn.getAttributeFromROC(name);
    }

    public void setStringAttribute(String name, String val) {
        this.dsameConn.setAttribute(name, val);
    }

    static {
        prefetchAttrs.add("sunPortalDesktopDefaultChannelName");
        prefetchAttrs.add("sunPortalDesktopEditProviderContainerName");
        prefetchAttrs.add("sunPortalDesktopType");
        prefetchAttrs.add("preferredlocale");
        prefetchAttrs.add("sunPortalDesktopExecutable");
        prefetchAttrs.add("sunPortalDesktopDpDocumentUser");
        prefetchAttrs.add("sunPortalDesktopDpLastModifiedUser");
        defaultLocaleString = java.util.Locale.getDefault().toString();
    }
}

