/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.authentication.AuthPrincipal;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.ServiceAppContext;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DSAMEServiceAppContext
implements ServiceAppContext,
DSAMEConstants {
    private static final String ROC_AUTHORIZED_AUTHLESS_UIDS = "authorizedAuthlessUIDs";
    private static DSAMEConnection dsameConn = null;

    public synchronized void init() {
        this.initAdminDSAMEConnection();
    }

    protected DSAMEConnection getAdminDSAMEConnection() {
        if (dsameConn == null) {
            throw new ContextError("DSAMEServiceAppContext.getAdminDSAMEConnection(): not initialized");
        }
        return dsameConn;
    }

    private DSAMEConnection initAdminDSAMEConnection() {
        if (dsameConn == null) {
            String bindDN = AdminUtils.getAdminDN();
            String password = new String(AdminUtils.getAdminPassword());
            try {
                SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
                AuthPrincipal ap = new AuthPrincipal(bindDN);
                SSOToken sso = ssom.createSSOToken((Principal)ap, password);
                dsameConn = new DSAMEConnection(sso);
            }
            catch (SSOException se) {
                throw new ContextError("DSAMEServiceAppContext.initAdminDSAMEConnection()", se);
            }
        }
        return dsameConn;
    }

    public String getDebugContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDebugContextClassName");
    }

    public String getSessionAppContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionAppContextClassName");
    }

    public String getDesktopContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDesktopContextClassName");
    }

    public String getSessionContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionContextClassName");
    }

    public String getServiceContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopServiceContextClassName");
    }

    public String getClientContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopClientContextClassName");
    }

    public String getTemplateContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopTemplateContextClassName");
    }

    public String getNoSessionURL() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-login-url");
    }

    public String getSessionReturnURLParamName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionReturnURLParamName");
    }

    public Map getAuthorizedAuthlessUIDs() {
        HashMap<String, String> authorized = (HashMap<String, String>)ROC.getObject(ROC_AUTHORIZED_AUTHLESS_UIDS);
        if (authorized == null) {
            Set uidPasswordPairs = this.getAdminDSAMEConnection().getGlobalAttributeMultiValueFromROC("SunPortalDesktopService", "sunPortalDesktopAuthorizedAuthlessUIDs");
            authorized = new HashMap<String, String>();
            Iterator i = uidPasswordPairs.iterator();
            while (i.hasNext()) {
                String pair = (String)i.next();
                int sep = pair.indexOf(124);
                String uid = pair.substring(0, sep);
                String pw = pair.substring(sep + 1);
                authorized.put(uid, pw);
            }
            ROC.setObject(ROC_AUTHORIZED_AUTHLESS_UIDS, authorized);
        }
        return authorized;
    }

    public String getDefaultAuthlessUID() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDefaultAuthlessUID");
    }

    public long getReapInterval() {
        long interval = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionReapInterval"));
        return interval;
    }

    public long getInactiveMax() {
        long maxInactive = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionInactiveMaximum"));
        return maxInactive;
    }

    public String getStringAttribute(String name) {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", name);
    }

    public void setStringAttribute(String name, String val) {
        this.getAdminDSAMEConnection().setGlobalAttribute("SunPortalDesktopService", name, val);
    }
}

