/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.SessionContext;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieSessionContext
implements SessionContext {
    private static final String ROC_COOKIES = "cookies";
    private static String cookiePrefix = null;
    private static String suidKey = null;
    private static DesktopAppContext dac = null;

    public void init(HttpServletRequest req) {
        if (dac == null) {
            dac = DesktopAppContextThreadLocalizer.get();
            cookiePrefix = dac.getCookiePrefix();
            suidKey = dac.getSUIDCookieName();
        }
    }

    private static String getParameter(HttpServletRequest req, String name) {
        String value = req.getParameter(name);
        return value;
    }

    private static String getAttribute(HttpServletRequest req, String name) {
        String value = (String)req.getAttribute(name);
        return value;
    }

    private static Map getCookieMap(HttpServletRequest req) {
        HashMap<String, Cookie> cookieMap = (HashMap<String, Cookie>)ROC.getObject(ROC_COOKIES);
        if (cookieMap == null) {
            Cookie[] cookies = req.getCookies();
            cookieMap = new HashMap<String, Cookie>();
            int i = 0;
            while (i < cookies.length) {
                Cookie c = cookies[i];
                cookieMap.put(c.getName(), c);
                ++i;
            }
            ROC.setObject(ROC_COOKIES, cookieMap);
        }
        return cookieMap;
    }

    private static Cookie getCookie(HttpServletRequest req, String name) {
        Map cookieMap = CookieSessionContext.getCookieMap(req);
        if (cookieMap == null) {
            return null;
        }
        return (Cookie)cookieMap.get(name);
    }

    public String getStringProperty(String name) {
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        String value = CookieSessionContext.getParameter(req, name = cookiePrefix + name);
        if (value != null && value.length() > 0) {
            return value;
        }
        value = CookieSessionContext.getAttribute(req, name);
        if (value != null && value.length() > 0) {
            return value;
        }
        Cookie c = CookieSessionContext.getCookie(req, name);
        if (c != null && (value = c.getValue()) != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    public void setStringProperty(String name, String val) {
        HttpServletResponse res = RequestThreadLocalizer.getResponse();
        name = cookiePrefix + name;
        Cookie c = new Cookie(name, val);
        res.addCookie(c);
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        req.setAttribute(name, (Object)val);
    }

    public String getSessionID() {
        return this.getUserID();
    }

    public String getUserID() {
        String uid = this.getStringProperty("suid");
        return uid;
    }

    public void addSessionListener(SessionListener sl) {
    }

    public void addUserReference() {
    }

    public void addUserListener(UserListener sl) {
    }

    public String encodeURL(String url) {
        return url;
    }
}

