/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.DesktopException;
import com.sun.portal.desktop.DesktopRequest;
import com.sun.portal.desktop.DesktopResponse;
import com.sun.portal.desktop.DesktopThreadLocalManager;
import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextFactory;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderEditTypes;
import com.sun.portal.providers.error.ErrorProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DesktopServlet
extends HttpServlet
implements ProviderEditTypes {
    private static Provider errorProvider = new ErrorProvider();
    private static DesktopAppContext appContext = null;
    private static DesktopContextFactory dcFactory = null;

    protected static String getDCFClassName(ServletConfig sc) {
        return sc.getInitParameter("desktopContextFactoryClassName");
    }

    private static void printSystemProperties() {
        Properties envProps = System.getProperties();
        DesktopAppContextThreadLocalizer.get().debugError("__________________________ BEGIN JAVA SETTINGS _______________________________");
        Enumeration<?> e = envProps.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            DesktopAppContextThreadLocalizer.get().debugError(prop + " : " + envProps.getProperty(prop));
        }
        DesktopAppContextThreadLocalizer.get().debugError("_____________________________END JAVA SETTINGS _______________________________");
    }

    protected static DesktopContextFactory getDesktopContextFactory(ServletConfig sc) {
        if (dcFactory == null) {
            String dcfClassName = DesktopServlet.getDCFClassName(sc);
            if (dcfClassName == null) {
                throw new DesktopError("DesktopServlet.getDesktopContextFactory(): dcf class name was null");
            }
            try {
                dcFactory = (DesktopContextFactory)Class.forName(dcfClassName).newInstance();
                dcFactory.init(sc);
            }
            catch (ClassNotFoundException cnfe) {
                throw new DesktopError("DesktopServlet.getDesktopContextFactory(): ", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new DesktopError("DesktopServlet.getDesktopContextFactory(): ", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new DesktopError("DesktopServlet.getDesktopContextFactory(): ", iae);
            }
            catch (ClassCastException cce) {
                throw new DesktopError("DesktopServlet.getDesktopContextFactory(): ", cce);
            }
            catch (InstantiationException ie) {
                throw new DesktopError("DesktopServlet.getDesktopContextFactory(): ", ie);
            }
            catch (SecurityException se) {
                throw new DesktopError("DesktopServlet.getDesktopContextFactory(): ", se);
            }
        }
        return dcFactory;
    }

    private void printConfigAttributes() {
        DesktopServlet.printConfigAttributes(this.getServletConfig().getServletContext());
    }

    public static void printConfigAttributes(ServletContext sc) {
        appContext.debugError("__________________________ BEGIN CONTEXT ATTRS __________________________");
        Enumeration e = sc.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object val = sc.getAttribute(name);
            appContext.debugError(name + "=" + val);
        }
        appContext.debugError("__________________________ END CONTEXT ATTRs ________________________");
    }

    private void printInitParameters() {
        appContext.debugError("__________________________ BEGIN INIT PARAMS  _______________________________");
        Enumeration e = this.getServletConfig().getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String val = this.getServletConfig().getInitParameter(name);
            appContext.debugError(name + "=" + val);
        }
        appContext.debugError("__________________________ END INIT PARAMS  _________________________________");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        DesktopServlet.getDesktopContextFactory(config);
        appContext = dcFactory.getDesktopAppContext();
    }

    /*
     * Loose catch block
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block25: {
            int i;
            Writer out;
            String contentType;
            String charset;
            block24: {
                block23: {
                    charset = "UTF-8";
                    contentType = null;
                    out = null;
                    i = -1;
                    long start = 0L;
                    long end = 0L;
                    if (appContext == null) {
                        throw new DesktopException("DesktopServlet.service(): app context was null");
                    }
                    if (appContext.isPasContextActivated()) {
                        start = System.currentTimeMillis();
                    }
                    String clientType = appContext.getClientType();
                    contentType = appContext.getContentType(clientType);
                    DesktopRequest dreq = new DesktopRequest(req, false);
                    DesktopThreadLocalManager.init(appContext, dreq, res, this.getServletConfig(), null);
                    i = PerfThreadLocalizer.mark();
                    int j = PerfThreadLocalizer.mark();
                    boolean isValidSession = appContext.validateSession(dreq);
                    PerfThreadLocalizer.add(j, "DesktopServlet.service():validateSession");
                    if (isValidSession) {
                        this.doGetPost(dreq, res);
                        if (appContext.isPasContextActivated()) {
                            end = System.currentTimeMillis();
                            appContext.logProcessTime("servlet", "doGetPost", "desktop", end - start);
                        }
                        break block23;
                    }
                    String noSessionURL = appContext.getNoSessionURL();
                    if (noSessionURL == null) {
                        if (appContext.isDebugWarningEnabled()) {
                            appContext.debugWarning("DesktopServlet.service(): Failed to get no session URL. Using default URL /");
                        }
                        noSessionURL = "/";
                    }
                    StringBuffer redirectURL = new StringBuffer(noSessionURL);
                    String returnParam = appContext.getSessionReturnURLParamName();
                    if (returnParam != null && returnParam.length() > 0) {
                        StringBuffer returnURL = new StringBuffer(DesktopServlet.getAbsURL(dreq, appContext, dreq.getRequestURI()));
                        if (dreq.getParameterMap().size() > 0) {
                            String query = dreq.getQueryString();
                            returnURL.append("?").append(query);
                        }
                        redirectURL.append(noSessionURL.indexOf(63) < 0 ? "?" : "&");
                        redirectURL.append(returnParam).append("=").append(URLEncoder.encode(returnURL.toString()));
                    }
                    if (appContext.isDebugMessageEnabled()) {
                        appContext.debugMessage("DesktopServlet.service(): Invalid session - redirecting to : " + redirectURL);
                    }
                    appContext.debugMessage("DesktopServlet.doGetPost(): redirectURL=" + redirectURL);
                    out = DesktopServlet.getWriter(res, contentType, charset);
                    DesktopServlet.sendRedirect(req, res, out, redirectURL.toString());
                }
                Object var21_19 = null;
                if (out == null) break block24;
                try {
                    out.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            PerfThreadLocalizer.add(i, "DesktopServlet.service()");
            appContext.perfError("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results());
            DesktopThreadLocalManager.release();
            {
                break block25;
                catch (IOException ioe) {
                    Object var21_20 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    PerfThreadLocalizer.add(i, "DesktopServlet.service()");
                    appContext.perfError("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results());
                    DesktopThreadLocalManager.release();
                    break block25;
                }
                catch (Throwable t) {
                    if (out == null) {
                        out = DesktopServlet.getWriter(res, contentType, charset);
                    }
                    this.handleException(req, res, out, t);
                    Object var21_21 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    PerfThreadLocalizer.add(i, "DesktopServlet.service()");
                    appContext.perfError("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results());
                    DesktopThreadLocalManager.release();
                }
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                PerfThreadLocalizer.add(i, "DesktopServlet.service()");
                appContext.perfError("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results());
                DesktopThreadLocalManager.release();
                throw throwable;
            }
        }
    }

    private static Writer getWriter(HttpServletResponse res, String contentType, String charset) throws IOException {
        if (contentType != null) {
            if (charset != null) {
                res.setContentType(contentType + "; charset=" + charset);
            } else {
                res.setContentType(contentType);
            }
        }
        OutputStreamWriter writer = null;
        writer = new OutputStreamWriter((OutputStream)res.getOutputStream(), charset);
        return writer;
    }

    protected DesktopContext getDesktopContext(HttpServletRequest req) throws DesktopException {
        return dcFactory.getDesktopContext(req);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doGetPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block52: {
            block51: {
                block49: {
                    block47: {
                        i = PerfThreadLocalizer.mark();
                        out = null;
                        charset = "UTF-8";
                        contentType = null;
                        context = null;
                        name = null;
                        try {
                            try {
                                context = this.getDesktopContext(req);
                                context.refresh();
                                charset = DesktopServlet.getCharset();
                                if (context == null) {
                                    out = DesktopServlet.getWriter(res, contentType, charset);
                                    this.handleException(req, res, out, new Exception());
                                    var22_9 = null;
                                    if (out == null) return;
                                    break block47;
                                }
                                dreq = (DesktopRequest)req;
                                dreq.decodeParams(charset);
                                clientType = DesktopServlet.appContext.getClientType();
                                contentType = DesktopServlet.appContext.getContentType(clientType);
                                dres = new DesktopResponse(res);
                                action = dreq.getParameter("action");
                                if (action == null || action.length() == 0) {
                                    action = "content";
                                }
                                err = dreq.getParameter("error");
                                outBuffer = null;
                                res.setContentType(context.getContentType() + "; charset=" + charset);
                                DesktopServlet.setNoCacheHeaders(res);
                                if (!context.isExecutable()) {
                                    throw new DesktopException("DesktopServlet.doGetPost(): no privilige to execute desktop");
                                }
                                if (context.isDebugMessageEnabled()) {
                                    context.debugMessage("DesktopServlet.doGetPost(): action=" + action);
                                    context.debugMessage("DesktopServlet.doGetPost(): name=" + name);
                                }
                                next = null;
                                if (action.equalsIgnoreCase("content")) {
                                    name = this.getChannelName(dreq, true);
                                    p = context.getProvider(dreq, name);
                                    if (p == null) {
                                        throw new DesktopException("attempt to reference unknown channel=" + name);
                                    }
                                    if (p.isPresentable()) {
                                        last = dreq.getParameter("last");
                                        if (last == null || last.equalsIgnoreCase("true")) {
                                            context.setDefaultChannelName(name);
                                        }
                                        j = PerfThreadLocalizer.mark();
                                        outBuffer = context.getContent(dreq, dres, name);
                                        PerfThreadLocalizer.add(j, "DesktopServlet.doGetPost():getContent");
                                    } else {
                                        res.sendError(406);
                                    }
                                } else if (action.equalsIgnoreCase("edit")) {
                                    name = this.getChannelName(dreq, false);
                                    p = context.getProvider(dreq, name);
                                    if (p == null) {
                                        throw new DesktopException("attempt to reference unknown channel=" + name);
                                    }
                                    if (!p.isEditable()) {
                                        throw new DesktopException("attempt to edit non-editable channel=" + name);
                                    }
                                    if (p.getEditType() == 3) {
                                        containerName = context.getEditProviderContainerName();
                                        editProvider = context.getProvider(dreq, containerName);
                                        dreq.getParameterMap().put("targetprovider", p.getName());
                                        outBuffer = editProvider.getEdit(dreq, dres);
                                    } else {
                                        outBuffer = p.getEdit(dreq, dres);
                                    }
                                } else {
                                    if (!action.equalsIgnoreCase("process")) {
                                        if (action.equalsIgnoreCase("logout") == false) throw new DesktopException("DestopServlet.doGetPost(): unknown action=" + action + ", channel name=" + name);
                                        context.store();
                                        out = DesktopServlet.getWriter(res, contentType, charset);
                                        DesktopServlet.sendRedirect(req, res, out, context.getLogoutURL());
                                        break block49;
                                    }
                                    name = this.getChannelName(dreq, false);
                                    p = context.getProvider(dreq, name);
                                    if (p == null) {
                                        throw new DesktopException("attempt to reference unknown channel=" + name);
                                    }
                                    if (!p.isEditable()) {
                                        throw new DesktopException("attempt to process non-editable channel=" + name);
                                    }
                                    try {
                                        next = p.processEdit(dreq, dres);
                                    }
                                    catch (InvalidEditFormDataException e) {
                                        if (context.isDebugWarningEnabled()) {
                                            context.debugWarning("DesktopServlet.doGetPost()", e);
                                        }
                                        error = URLEncoder.encode(e.getMessage());
                                        args = new StringBuffer(64);
                                        containerEdit = (String)req.getAttribute("containerEdit");
                                        args.append("?action=edit&provider=").append(name).append("&error=").append(error);
                                        if (containerEdit != null && containerEdit.equals("option")) {
                                            args.append("&" + name + ".containerEdit=option");
                                        }
                                        if (dreq.getParameter("targetprovider") != null) {
                                            args.append("&targetprovider=").append(dreq.getParameter("targetprovider"));
                                        }
                                        next = new URL(context.getDesktopURL(req) + args.toString());
                                    }
                                }
                                out = DesktopServlet.getWriter(res, contentType, charset);
                                if (action.equalsIgnoreCase("process")) {
                                    if (next == null) {
                                        nextString = new StringBuffer(context.getDesktopURL(req));
                                        last = context.getClientProperty("desktop.lastChannelName");
                                        if (last != null && context.getProvider(dreq, last) != null) {
                                            nextString.append("?action=content&provider=").append(last);
                                        } else {
                                            nextString.append("?action=content&provider=").append(context.getDefaultChannelName());
                                        }
                                        DesktopServlet.sendRedirect(req, res, out, nextString.toString());
                                    } else {
                                        if (context.isDebugMessageEnabled()) {
                                            context.debugMessage("DesktopServlet.doPost(): next=" + next.toString());
                                        }
                                        DesktopServlet.sendRedirect(req, res, out, next.toString());
                                    }
                                } else {
                                    if (outBuffer == null) throw new DesktopException("Channel content is empty for " + name);
                                    out.write(outBuffer.toString());
                                }
                                context.store();
                                break block51;
                            }
                            catch (IOException ioe) {
                                var22_12 = null;
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException ioe) {}
                                }
                                break block52;
                            }
                            catch (Throwable e) {
                                if (out == null) {
                                    out = DesktopServlet.getWriter(res, contentType, charset);
                                }
                                this.handleException(req, res, out, e);
                                var22_13 = null;
                                if (out != null) {
                                    try {}
                                    catch (IOException ioe) {}
                                    out.close();
                                }
                                break block52;
                            }
                        }
                        catch (Throwable var21_38) {
                            var22_14 = null;
                            if (out == null) throw var21_38;
                            ** try [egrp 3[TRYBLOCK] [4 : 1307->1315)] { 
lbl148:
                            // 1 sources

                            out.close();
                            throw var21_38;
lbl150:
                            // 1 sources

                            catch (IOException ioe) {
                                // empty catch block
                            }
                            throw var21_38;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [4 : 1307->1315)] { 
lbl155:
                    // 1 sources

                    out.close();
                    return;
lbl157:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
                var22_10 = null;
                if (out == null) return;
                ** try [egrp 3[TRYBLOCK] [4 : 1307->1315)] { 
lbl164:
                // 1 sources

                out.close();
                return;
lbl166:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            var22_11 = null;
            if (out != null) {
                try {}
                catch (IOException ioe) {}
                out.close();
            }
        }
        PerfThreadLocalizer.add(i, "DesktopServlet.doGetPost()");
    }

    private static void sendRedirect(HttpServletRequest req, HttpServletResponse res, Writer out, String u) throws IOException, DesktopException {
        DesktopContext dc;
        block9: {
            dc = null;
            try {
                dc = DesktopContextThreadLocalizer.get();
            }
            catch (ContextError c) {
                if (!appContext.isDebugMessageEnabled()) break block9;
                appContext.debugMessage("DesktopServlet.sendRedirect(): could not getDesktopContext");
            }
        }
        u = DesktopServlet.getAbsURL(req, appContext, u);
        if (!req.getMethod().equalsIgnoreCase("head")) {
            String clientType = appContext.getClientType();
            String clientPath = appContext.getClientPath(clientType);
            StringBuffer redirect = null;
            if (clientType != null) {
                String contentType = appContext.getContentType(clientType);
                String charset = DesktopServlet.getCharset();
                if (dc != null) {
                    u = dc.encodeURL(u);
                }
                Hashtable<String, String> tags = new Hashtable<String, String>();
                tags.put("url", u);
                redirect = appContext.getTemplate("default", Locale.getDefault().toString(), null, null, clientPath, "redirect.template", tags);
                if (appContext.isDebugMessageEnabled()) {
                    appContext.debugMessage("DesktopServlet.sendRedirect(): redirect (302) body=" + redirect);
                }
                if (redirect != null) {
                    out.write(redirect.toString());
                } else if (appContext.isDebugWarningEnabled()) {
                    appContext.debugWarning("DesktopServlet.sendRedirect(): could not get redirect template");
                }
            }
        }
        res.sendRedirect(u);
    }

    private static String getAbsURL(HttpServletRequest req, DesktopAppContext appContext, String u) throws IOException {
        if (!u.regionMatches(true, 0, "http://", 0, 7) && !u.regionMatches(true, 0, "https://", 0, 7)) {
            StringBuffer ru = appContext.getRequestServer(req);
            URL requestURL = new URL(ru.toString());
            String scheme = requestURL.getProtocol();
            StringBuffer absURL = new StringBuffer().append(scheme).append("://").append(requestURL.getHost()).append(":");
            int port = requestURL.getPort();
            if (scheme.equals("http") && port <= 0) {
                port = 80;
            } else if (scheme.equals("https") && port <= 0) {
                port = 443;
            }
            absURL.append(port).append(u);
            return absURL.toString();
        }
        return u;
    }

    private void handleException(HttpServletRequest req, HttpServletResponse res, Writer out, Throwable e) {
        DesktopContext dc = null;
        String lastChannelName = null;
        try {
            StringBuffer content;
            if (out == null || res.isCommitted()) {
                appContext.debugError("DesktopServlet.handleException()", e);
                return;
            }
            res.reset();
            lastChannelName = this.getChannelName(req, true);
            if (DesktopContextThreadLocalizer.exists()) {
                dc = DesktopContextThreadLocalizer.get();
            }
            if (dc != null) {
                req.setAttribute(errorProvider.getName() + ".desktopContext", (Object)dc);
            }
            if (appContext != null) {
                req.setAttribute(errorProvider.getName() + ".desktopAppContext", (Object)appContext);
            }
            if (lastChannelName != null) {
                req.setAttribute(errorProvider.getName() + ".lastChannelName", (Object)lastChannelName);
            }
            if (e != null) {
                req.setAttribute(errorProvider.getName() + ".exception", (Object)e);
            }
            if ((content = errorProvider.getContent(req, res)) != null) {
                out.write(content.toString());
            }
            appContext.debugError("DesktopServlet.handleException()", e);
        }
        catch (Throwable e2) {
            this.log("DesktopServlet.handleException(): primary=", e2);
            this.log("DesktopServlet.handleException(): root=", e);
            try {
                res.sendError(500);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    protected static void setNoCacheHeaders(HttpServletResponse res) {
        res.addHeader("Pragma", "no-cache");
        res.addHeader("Expires", "Mon, 01 Jan 1990 12:00:00 GMT");
        res.addHeader("Cache-control", "no-cache");
        res.addHeader("Cache-control", "must-revalidate");
        res.addHeader("Cache-control", "max-age=0");
    }

    protected static String getCharset() {
        DesktopContext context = null;
        String charset = null;
        if (DesktopContextThreadLocalizer.exists()) {
            context = DesktopContextThreadLocalizer.get();
            charset = context.getCharset();
        } else {
            Locale locale = Locale.getDefault();
            charset = appContext.getCharset(appContext.getClientType(), locale);
        }
        return charset;
    }

    private String getChannelName(HttpServletRequest req, boolean useDefaults) throws DesktopException {
        String name = req.getParameter("provider");
        if (name == null && useDefaults && DesktopContextThreadLocalizer.exists()) {
            DesktopContext dc = DesktopContextThreadLocalizer.get();
            name = dc.getDefaultChannelName();
        }
        return name;
    }
}

