/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.StringHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class URIHelper {
    public static final String COFFEE_SCHEME = "coffee";
    public static final String DATA_SCHEME = "data";
    public static final String FILE_SCHEME = "file";
    public static final String FTP_SCHEME = "ftp";
    public static final String GOPHER_SCHEME = "gopher";
    public static final String HNEWS_SCHEME = "hnews";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTP_NG_SCHEME = "http-ng";
    public static final String HTTPS_SCHEME = "https";
    public static final String IMAP_SCHEME = "imap";
    public static final String IRC_SCHEME = "irc";
    public static final String JAR_SCHEME = "jar";
    public static final String LDAP_SCHEME = "ldap";
    public static final String MAILTO_SCHEME = "mailto:";
    public static final String NEWS_SCHEME = "news";
    public static final String NFS_SCHEME = "nfs";
    public static final String NNTP_SCHEME = "nntp";
    public static final String POP_SCHEME = "pop";
    public static final String PROSPERO_SCHEME = "prospero";
    public static final String RWHOIS_SCHEME = "rwhois";
    public static final String SHTTP_SCHEME = "shttp";
    public static final String SMTP_SCHEME = "smtp";
    public static final String SNEWS_SCHEME = "snews";
    public static final String TELNET_SCHEME = "telnet";
    public static final String URN_SCHEME = "urn";
    public static final String VEMMI_SCHEME = "vemmi";
    public static final String VIDEOTEX_SCHEME = "videotex";
    public static final String WAIS_SCHEME = "wais";
    public static final String WHOIS_SCHEME = "whois";
    public static final String WHOIS_PLUS_SCHEME = "whois++";
    public static final String Z3950R_SCHEME = "z39.50r";
    public static final String Z3950S_SCHEME = "z39.50s";
    public static final int COFFEE_PORT = 80;
    public static final int FTP_PORT = 21;
    public static final int GOPHER_PORT = 70;
    public static final int HNEWS_PORT = 80;
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final int HTTP_NG_PORT = 80;
    public static final int IMAP_PORT = 143;
    public static final int IRC_PORT = 194;
    public static final int LDAP_PORT = 389;
    public static final int NNTP_PORT = 119;
    public static final int NEWS_PORT = 119;
    public static final int NFS_PORT = 2049;
    public static final int POP_PORT = 110;
    public static final int PROSPERO_PORT = 1525;
    public static final int RWHOIS_PORT = 4321;
    public static final int SHTTP_PORT = 80;
    public static final int SMTP_PORT = 25;
    public static final int SNEWS_PORT = 563;
    public static final int TELNET_PORT = 23;
    public static final int VEMMI_PORT = 575;
    public static final int VIDEOTEX_PORT = 516;
    public static final int WAIS_PORT = 210;
    public static final int WHOIS_PORT = 43;
    public static final int WHOIS_PLUS_PORT = 63;
    public static final int Z3950R_PORT = 210;
    public static final int Z3950S_PORT = 210;
    private static final HashMap protocolPorts = new HashMap(30);

    public static int getDefaultPort(String string) {
        int n = 0;
        Integer n2 = (Integer)protocolPorts.get(string.toLowerCase());
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public static Map parseQueryString(String string) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        if (StringHelper.normalize(string).length() == 0) {
            return hashMap;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            String string3 = URIHelper.parseName(string2.substring(0, n), stringBuffer);
            String string4 = URIHelper.parseName(string2.substring(n + 1, string2.length()), stringBuffer);
            if (hashMap.containsKey(string3)) {
                String[] stringArray2 = (String[])hashMap.get(string3);
                stringArray = new String[stringArray2.length + 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n2];
                    ++n2;
                }
                stringArray[stringArray2.length] = string4;
            } else {
                stringArray = new String[]{string4};
            }
            hashMap.put(string3, stringArray);
        }
        return hashMap;
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                        n += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(n);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) break;
                        ++n;
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String deparameterize(String string, Map map) {
        int n = string.lastIndexOf(63);
        if (n == -1) {
            return string;
        }
        String[] stringArray = StringHelper.separateTokens(string.substring(n + 1), "&");
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            int n3 = string2.indexOf(61);
            if (n3 == -1) break;
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1);
            map.put(string3, string4);
            ++n2;
        }
        return string.substring(0, n);
    }

    public static String parameterize(String string, Map map) {
        if (string == null || string.length() == 0 || map == null || map.size() == 0) {
            return string;
        }
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.lastIndexOf(63);
        if (n == -1) {
            stringBuffer.append('?');
        } else {
            stringBuffer.append('&');
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append('&');
        }
        return stringBuffer.toString();
    }

    public static boolean needsToAppendDirectorySeperator(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        if (string.endsWith(".")) {
            bl = true;
            int n = string.length() - 2;
            while (n >= 0) {
                char c = string.charAt(n);
                if (c == '/') break;
                if (c != '.') {
                    bl = false;
                    break;
                }
                --n;
            }
        }
        return bl;
    }

    static {
        protocolPorts.put(HTTP_SCHEME, new Integer(80));
        protocolPorts.put(SHTTP_SCHEME, new Integer(80));
        protocolPorts.put(HTTPS_SCHEME, new Integer(443));
        protocolPorts.put(HTTP_NG_SCHEME, new Integer(80));
        protocolPorts.put(COFFEE_SCHEME, new Integer(80));
        protocolPorts.put(FTP_SCHEME, new Integer(21));
        protocolPorts.put(TELNET_SCHEME, new Integer(23));
        protocolPorts.put(NNTP_SCHEME, new Integer(119));
        protocolPorts.put(NEWS_SCHEME, new Integer(119));
        protocolPorts.put(SNEWS_SCHEME, new Integer(563));
        protocolPorts.put(HNEWS_SCHEME, new Integer(80));
        protocolPorts.put(SMTP_SCHEME, new Integer(25));
        protocolPorts.put(GOPHER_SCHEME, new Integer(70));
        protocolPorts.put(WAIS_SCHEME, new Integer(210));
        protocolPorts.put(WHOIS_SCHEME, new Integer(43));
        protocolPorts.put(WHOIS_PLUS_SCHEME, new Integer(63));
        protocolPorts.put(RWHOIS_SCHEME, new Integer(4321));
        protocolPorts.put(IMAP_SCHEME, new Integer(143));
        protocolPorts.put(POP_SCHEME, new Integer(110));
        protocolPorts.put(PROSPERO_SCHEME, new Integer(1525));
        protocolPorts.put(IRC_SCHEME, new Integer(194));
        protocolPorts.put(LDAP_SCHEME, new Integer(389));
        protocolPorts.put(Z3950R_SCHEME, new Integer(210));
        protocolPorts.put(Z3950S_SCHEME, new Integer(210));
        protocolPorts.put(VEMMI_SCHEME, new Integer(575));
        protocolPorts.put(VIDEOTEX_SCHEME, new Integer(516));
        protocolPorts.put(NFS_SCHEME, new Integer(2049));
    }
}

