/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.servlet;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMPasswordUtil;
import com.iplanet.am.util.Debug;
import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.log.LogRecord;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netmail.protocol.Preferences;
import com.sun.portal.netmail.servlet.NetMailContext;
import com.sun.portal.netmail.servlet.NetMailServlet;
import com.sun.portal.netmail.servlet.NetMailSession;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

class PortalServerContext
implements NetMailContext,
SSOTokenListener {
    public static final String SUN_NETMAIL_SERVICE = "SunPortalNetMailService";
    public static final String DSAME_USER_SERVICE = "iPlanetAMUserService";
    private static SSOTokenManager _tokenMgr = null;
    protected AMStoreConnection connection = null;
    protected AMUser user = null;
    private String dsameSessionID = null;
    private SSOToken token = null;
    NetMailSession session;
    TimeZone usertz = TimeZone.getDefault();
    Preferences oldPrefs;
    Hashtable oldpab = new Hashtable();
    boolean executeOk = false;
    private boolean isIMAPChanged = false;
    long lastAccess = System.currentTimeMillis();
    static Locale userLocale = Locale.getDefault();
    ResourceBundle userResources = null;
    ResourceBundle adminResources = null;
    Debug debug = null;
    static String logFileName = "psNetMail";

    PortalServerContext() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.userResources == null) {
                this.adminResources = ResourceBundle.getBundle("psNetMailServlet", userLocale);
            }
        }
        this.debug = Debug.getInstance((String)logFileName);
    }

    protected static SSOTokenManager getSSOTokenManager() throws ServletException {
        if (_tokenMgr == null) {
            try {
                _tokenMgr = SSOTokenManager.getInstance();
                if (_tokenMgr == null) {
                    throw new ServletException("PortalServerContext.getSSOTokenMgr(): Failed to get SSOTokenManager. ");
                }
            }
            catch (SSOException sSOException) {
                throw new ServletException("PortalServerContext.getSSOTokenMgr(): Failed to get SSOTokenManager.  " + (Object)((Object)sSOException));
            }
        }
        return _tokenMgr;
    }

    public void setSession(NetMailSession netMailSession) {
        this.session = netMailSession;
    }

    public Preferences loadPreferences() {
        Preferences preferences = new Preferences();
        try {
            Object object;
            Object object2;
            Object object3;
            Map map = this.user.getServiceAttributes(DSAME_USER_SERVICE);
            String string = this.getStringAttr(map.get("preferredTimeZone"), null);
            if (string != null) {
                this.usertz = TimeZone.getTimeZone(string);
            }
            preferences.fromAddress = this.getStringAttr(map.get("mail"), preferences.fromAddress);
            Map map2 = this.user.getServiceAttributes(SUN_NETMAIL_SERVICE);
            preferences.IMAPServerName = this.getStringAttr(map2.get("sunPortalNetmailIMAPServerName"), preferences.IMAPServerName);
            preferences.IMAPUserName = this.getStringAttr(map2.get("sunPortalNetmailIMAPUserid"), preferences.IMAPUserName);
            String string2 = this.getStringAttr(map2.get("sunPortalNetmailIMAPPassword"), preferences.IMAPPassword);
            preferences.IMAPPassword = string2 == null || string2.length() == 0 ? string2 : AMPasswordUtil.decrypt((String)string2);
            preferences.SMTPServerName = this.getStringAttr(map2.get("sunPortalNetmailSMTPServerName"), preferences.SMTPServerName);
            preferences.replyToAddress = this.getStringAttr(map2.get("sunPortalNetmailReplyToAddress"), preferences.replyToAddress);
            preferences.defaultDomain = this.getStringAttr(map2.get("sunPortalNetmailDefaultMailDomain"), preferences.defaultDomain);
            preferences.locale = this.getUserLocale();
            preferences.rootFolder = this.getStringAttr(map2.get("sunPortalNetmailRootFolder"), preferences.rootFolder);
            preferences.sentMessagesFolder = this.getStringAttr(map2.get("sunPortalNetmailSentMessagesFolder"), preferences.sentMessagesFolder);
            preferences.logMessages = this.getBooleanAttr(map2.get("sunPortalNetmailLogMessages"), preferences.logMessages);
            preferences.replyWithAuthor = this.getBooleanAttr(map2.get("sunPortalNetmailReplyWithAuthor"), preferences.replyWithAuthor);
            preferences.replyWithDate = this.getBooleanAttr(map2.get("sunPortalNetmailReplyWithDate"), preferences.replyWithDate);
            preferences.replyWithBody = this.getBooleanAttr(map2.get("sunPortalNetmailReplyWithBody"), preferences.replyWithBody);
            preferences.indentPrefix = this.getStringAttr(map2.get("sunPortalNetmailIndentPrefix"), preferences.indentPrefix);
            preferences.addSignature = this.getBooleanAttr(map2.get("sunPortalNetmailAddSignature"), preferences.addSignature);
            preferences.signature = this.getStringAttr(map2.get("sunPortalNetmailSignature"), preferences.signature);
            preferences.initialHeaders = this.getIntegerAttr(map2.get("sunPortalNetmailInitialHeaders"), preferences.initialHeaders);
            preferences.inactivityInterval = this.getIntegerAttr(map2.get("sunPortalNetmailInactivityInterval"), preferences.inactivityInterval);
            preferences.maxAttachLen = this.getIntegerAttr(map2.get("sunPortalNetmailMaxAttachLen"), preferences.maxAttachLen);
            preferences.autoload = this.getIntegerAttr(map2.get("sunPortalNetmailAutoload"), preferences.autoload);
            preferences.autosave = this.getBooleanAttr(map2.get("sunPortalNetmailAutosave"), preferences.autosave);
            preferences.autopurge = this.getBooleanAttr(map2.get("sunPortalNetmailAutopurge"), preferences.autopurge);
            preferences.autoFolderLoad = this.getBooleanAttr(map2.get("sunPortalNetmailAutoFolderLoad"), preferences.autoFolderLoad);
            preferences.multipleReadWindows = this.getBooleanAttr(map2.get("sunPortalNetmailMultipleReadWindows"), preferences.multipleReadWindows);
            preferences.sortKey = this.getIntegerAttr(map2.get("sunPortalNetmailSortKey"), preferences.sortKey);
            preferences.viewKey = this.getIntegerAttr(map2.get("sunPortalNetmailViewKey"), preferences.viewKey);
            preferences.noPrefsList = this.getTokenizedNoPrefList((Set)map2.get("sunPortalNetmailNoPrefsList"));
            preferences.readWinBounds = this.getRectangleAttr(map2.get("sunPortalNetmailReadWinBounds"), preferences.readWinBounds);
            preferences.composeWinBounds = this.getRectangleAttr(map2.get("sunPortalNetmailComposeWinBounds"), preferences.composeWinBounds);
            preferences.folderWinBounds = this.getRectangleAttr(map2.get("sunPortalNetmailFolderWinBounds"), preferences.folderWinBounds);
            preferences.gridHeight = this.getIntegerAttr(map2.get("sunPortalNetmailGridHeight"), preferences.gridHeight);
            preferences.gridColWidths = this.getStringAttr(map2.get("sunPortalNetmailGridColWidths"), preferences.gridColWidths);
            preferences.textColor = this.getStringAttr(map2.get("sunPortalNetmailTextColor"), preferences.textColor);
            preferences.backgroundColor = this.getStringAttr(map2.get("sunPortalNetmailBackgroundColor"), preferences.backgroundColor);
            preferences.textSize = this.getIntegerAttr(map2.get("sunPortalNetmailTextSize"), preferences.textSize);
            preferences.textStyle = this.getIntegerAttr(map2.get("sunPortalNetmailTextStyle"), preferences.textStyle);
            preferences.charset = this.getStringRes("iwtNetMail-charset", preferences.charset);
            String[] stringArray = this.getArrayAttr(map2.get("sunPortalNetmailLDAPServers"), new String[0]);
            preferences.LDAPServerNames = new String[stringArray.length];
            preferences.LDAPDirectoryNames = new String[stringArray.length];
            preferences.LDAPSearchBases = new String[stringArray.length];
            preferences.LDAPSearchAttributes = new String[stringArray.length];
            preferences.LDAPResultAttributes = new String[stringArray.length];
            preferences.LDAPExtraSearchFilters = new String[stringArray.length];
            preferences.LDAPReferrals = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                preferences.LDAPSearchBases[n] = "";
                preferences.LDAPSearchAttributes[n] = "cn,gn,sn";
                preferences.LDAPResultAttributes[n] = "mail";
                preferences.LDAPExtraSearchFilters[n] = "";
                preferences.LDAPReferrals[n] = "follow";
                try {
                    object3 = new StreamTokenizer(new StringReader(stringArray[n]));
                    ((StreamTokenizer)object3).resetSyntax();
                    ((StreamTokenizer)object3).wordChars(97, 122);
                    ((StreamTokenizer)object3).quoteChar(34);
                    ((StreamTokenizer)object3).whitespaceChars(32, 32);
                    ((StreamTokenizer)object3).whitespaceChars(44, 44);
                    ((StreamTokenizer)object3).whitespaceChars(61, 61);
                    while (((StreamTokenizer)object3).nextToken() != -1) {
                        if (((StreamTokenizer)object3).ttype != -3) {
                            throw new IOException(this.getString("wc.a", new Object[]{stringArray[n]}));
                        }
                        object2 = ((StreamTokenizer)object3).sval;
                        if (((StreamTokenizer)object3).nextToken() != 34) {
                            throw new IOException(this.getString("wc.a", new Object[]{stringArray[n]}));
                        }
                        object = ((StreamTokenizer)object3).sval;
                        if (((String)object2).equals("name")) {
                            preferences.LDAPDirectoryNames[n] = object;
                            continue;
                        }
                        if (((String)object2).equals("server")) {
                            preferences.LDAPServerNames[n] = object;
                            continue;
                        }
                        if (((String)object2).equals("base")) {
                            preferences.LDAPSearchBases[n] = object;
                            continue;
                        }
                        if (((String)object2).equals("searchin")) {
                            preferences.LDAPSearchAttributes[n] = object;
                            continue;
                        }
                        if (((String)object2).equals("result")) {
                            preferences.LDAPResultAttributes[n] = object;
                            continue;
                        }
                        if (((String)object2).equals("filter")) {
                            preferences.LDAPExtraSearchFilters[n] = object;
                            continue;
                        }
                        if (((String)object2).equals("referral")) {
                            preferences.LDAPReferrals[n] = object;
                            continue;
                        }
                        throw new IOException(this.getString("wc.a", new Object[]{stringArray[n]}));
                    }
                    if (preferences.LDAPServerNames[n] == null) {
                        throw new IOException(this.getString("wc.a", new Object[]{stringArray[n]}));
                    }
                    if (preferences.LDAPDirectoryNames[n] == null) {
                        preferences.LDAPDirectoryNames[n] = preferences.LDAPServerNames[n];
                    }
                }
                catch (IOException iOException) {
                    this.error(iOException.getMessage());
                }
                ++n;
            }
            preferences.favoriteFolders = this.getArrayAttr(map2.get("sunPortalNetmailFavoriteFolders"), preferences.favoriteFolders);
            preferences.headersPerPage = this.getIntegerAttr(map2.get("sunPortalNetmailHeadersPerPage"), preferences.headersPerPage);
            preferences.newestFirst = this.getBooleanAttr(map2.get("sunPortalNetmailNewestFirst"), preferences.newestFirst);
            this.oldPrefs = (Preferences)preferences.clone();
            if (this.debug.messageEnabled()) {
                this.debug.message("clone of Preferences after creation");
                this.debug.message(this.debugPreferences(this.oldPrefs));
            }
            if (!(object3 = (Set)map2.get("sunPortalNetmailPersonalAddressBook")).isEmpty()) {
                object2 = object3.iterator();
                object = null;
                try {
                    while (object2.hasNext()) {
                        object = new StringTokenizer((String)object2.next(), ",");
                        this.oldpab.put(((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken());
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            return preferences;
        }
        catch (Exception exception) {
            this.debug.error("cannot access profile: ", (Throwable)exception);
            throw new RuntimeException("cannot access profile: " + exception);
        }
    }

    String getFirstAttr(Object object) {
        block4: {
            Set set = null;
            try {
                set = (Set)object;
                if (set == null || set.isEmpty()) {
                    return null;
                }
                return (String)set.iterator().next();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (ClassCastException classCastException) {
                if (!this.debug.messageEnabled()) break block4;
                this.debug.message("ClassCastException in getFirstAttr\n for attribute: " + object.toString());
                this.debug.message("value = " + set.toString(), (Throwable)classCastException);
            }
        }
        return null;
    }

    String getStringAttr(Object object, String string) {
        String string2 = this.getFirstAttr(object);
        return string2 == null ? string : string2;
    }

    boolean getBooleanAttr(Object object, boolean bl) {
        String string = this.getFirstAttr(object);
        return string == null ? bl : string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }

    int getIntegerAttr(Object object, int n) {
        try {
            String string = this.getFirstAttr(object);
            return string == null ? n : Integer.parseInt(string);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    Rectangle getRectangleAttr(Object object, Rectangle rectangle) {
        try {
            String string = this.getFirstAttr(object);
            if (string == null) {
                return rectangle;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            return new Rectangle(Integer.parseInt((String)stringTokenizer.nextElement()), Integer.parseInt((String)stringTokenizer.nextElement()), Integer.parseInt((String)stringTokenizer.nextElement()), Integer.parseInt((String)stringTokenizer.nextElement()));
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rectangle;
    }

    String[] getArrayAttr(Object object, String[] stringArray) {
        try {
            Set set = (Set)object;
            if (set == null || set.isEmpty()) {
                return stringArray;
            }
            return set.toArray(new String[0]);
        }
        catch (ClassCastException classCastException) {
            return stringArray;
        }
    }

    private Set getSet(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>(1);
        hashSet.add(object);
        return hashSet;
    }

    private Set getSet(Rectangle rectangle) {
        this.debug("get set Rect called");
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add("" + rectangle.x + ":" + rectangle.y + ":" + rectangle.width + ":" + rectangle.height);
        return hashSet;
    }

    private Set getSet(boolean bl) {
        return this.getSet(bl ? "true" : "false");
    }

    private Set getSet(int n) {
        return this.getSet("" + n);
    }

    private Map getChangedPreferences(Preferences preferences, Preferences preferences2) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        this.isIMAPChanged = false;
        try {
            if (!preferences.IMAPServerName.equals(preferences2.IMAPServerName)) {
                hashMap.put("sunPortalNetmailIMAPServerName", this.getSet(preferences2.IMAPServerName));
                preferences.IMAPServerName = preferences2.IMAPServerName;
                this.isIMAPChanged = true;
            }
            if (!preferences.IMAPUserName.equals(preferences2.IMAPUserName)) {
                hashMap.put("sunPortalNetmailIMAPUserid", this.getSet(preferences2.IMAPUserName));
                preferences.IMAPUserName = preferences2.IMAPUserName;
                this.isIMAPChanged = true;
            }
            if (!preferences.IMAPPassword.equals(preferences2.IMAPPassword)) {
                hashMap.put("sunPortalNetmailIMAPPassword", this.getSet(AMPasswordUtil.encrypt((String)preferences2.IMAPPassword)));
                preferences.IMAPPassword = preferences2.IMAPPassword;
                this.isIMAPChanged = true;
            }
            if (!preferences.SMTPServerName.equals(preferences2.SMTPServerName)) {
                hashMap.put("sunPortalNetmailSMTPServerName", this.getSet(preferences2.SMTPServerName));
            }
            if (!preferences.rootFolder.equals(preferences2.rootFolder)) {
                hashMap.put("sunPortalNetmailRootFolder", this.getSet(preferences2.rootFolder));
            }
            if (!preferences.sentMessagesFolder.equals(preferences2.sentMessagesFolder)) {
                hashMap.put("sunPortalNetmailSentMessagesFolder", this.getSet(preferences2.sentMessagesFolder));
            }
            if (preferences.logMessages != preferences2.logMessages) {
                hashMap.put("sunPortalNetmailLogMessages", this.getSet(preferences2.logMessages));
            }
            if (preferences.replyWithAuthor != preferences2.replyWithAuthor) {
                hashMap.put("sunPortalNetmailReplyWithAuthor", this.getSet(preferences2.replyWithAuthor));
            }
            if (preferences.replyWithDate != preferences2.replyWithDate) {
                hashMap.put("sunPortalNetmailReplyWithDate", this.getSet(preferences2.replyWithDate));
            }
            if (preferences.replyWithBody != preferences2.replyWithBody) {
                hashMap.put("sunPortalNetmailReplyWithBody", this.getSet(preferences2.replyWithBody));
            }
            if (!preferences.replyToAddress.equals(preferences2.replyToAddress)) {
                hashMap.put("sunPortalNetmailReplyToAddress", this.getSet(preferences2.replyToAddress));
            }
            if (!preferences.indentPrefix.equals(preferences2.indentPrefix)) {
                hashMap.put("sunPortalNetmailIndentPrefix", this.getSet(preferences2.indentPrefix));
            }
            if (preferences.addSignature != preferences2.addSignature) {
                hashMap.put("sunPortalNetmailAddSignature", this.getSet(preferences2.addSignature));
            }
            if (!preferences.signature.equals(preferences2.signature)) {
                hashMap.put("sunPortalNetmailSignature", this.getSet(preferences2.signature));
            }
            if (preferences.initialHeaders != preferences2.initialHeaders) {
                hashMap.put("sunPortalNetmailInitialHeaders", this.getSet(preferences2.initialHeaders));
            }
            if (preferences.inactivityInterval != preferences2.inactivityInterval) {
                hashMap.put("sunPortalNetmailInactivityInterval", this.getSet(preferences2.inactivityInterval));
            }
            if (preferences.maxAttachLen != preferences2.maxAttachLen) {
                hashMap.put("sunPortalNetmailMaxAttachLen", this.getSet(preferences2.maxAttachLen));
            }
            if (preferences.autoload != preferences2.autoload) {
                hashMap.put("sunPortalNetmailAutoload", this.getSet(preferences2.autoload));
            }
            if (preferences.autosave != preferences2.autosave) {
                hashMap.put("sunPortalNetmailAutosave", this.getSet(preferences2.autosave));
            }
            if (preferences.autopurge != preferences2.autopurge) {
                hashMap.put("sunPortalNetmailAutopurge", this.getSet(preferences2.autopurge));
            }
            if (preferences.autoFolderLoad != preferences2.autoFolderLoad) {
                hashMap.put("sunPortalNetmailAutoFolderLoad", this.getSet(preferences2.autoFolderLoad));
            }
            if (preferences.multipleReadWindows != preferences2.multipleReadWindows) {
                hashMap.put("sunPortalNetmailMultipleReadWindows", this.getSet(preferences2.multipleReadWindows));
            }
            if (preferences.sortKey != preferences2.sortKey) {
                hashMap.put("sunPortalNetmailSortKey", this.getSet(preferences2.sortKey));
            }
            if (preferences.viewKey != preferences2.viewKey) {
                hashMap.put("sunPortalNetmailViewKey", this.getSet(preferences2.viewKey));
            }
            if (!preferences.readWinBounds.equals(preferences2.readWinBounds)) {
                hashMap.put("sunPortalNetmailReadWinBounds", this.getSet(preferences2.readWinBounds));
            }
            if (!preferences.composeWinBounds.equals(preferences2.composeWinBounds)) {
                hashMap.put("sunPortalNetmailComposeWinBounds", this.getSet(preferences2.composeWinBounds));
            }
            if (!preferences.folderWinBounds.equals(preferences2.folderWinBounds)) {
                hashMap.put("sunPortalNetmailFolderWinBounds", this.getSet(preferences2.folderWinBounds));
            }
            if (preferences.gridHeight != preferences2.gridHeight) {
                hashMap.put("sunPortalNetmailGridHeight", this.getSet(preferences2.gridHeight));
            }
            if (!preferences.gridColWidths.equals(preferences2.gridColWidths)) {
                hashMap.put("sunPortalNetmailGridColWidths", this.getSet(preferences2.gridColWidths));
            }
            if (!preferences.textColor.equals(preferences2.textColor)) {
                hashMap.put("sunPortalNetmailTextColor", this.getSet(preferences2.textColor));
            }
            if (!preferences.backgroundColor.equals(preferences2.backgroundColor)) {
                hashMap.put("sunPortalNetmailBackgroundColor", this.getSet(preferences2.backgroundColor));
            }
            if (preferences.textSize != preferences2.textSize) {
                hashMap.put("sunPortalNetmailTextSize", this.getSet(preferences2.textSize));
            }
            if (preferences.textStyle != preferences2.textStyle) {
                hashMap.put("sunPortalNetmailTextStyle", this.getSet(preferences2.textStyle));
            }
            if (preferences2.areTransientsSet) {
                if (!Arrays.equals(preferences.favoriteFolders, preferences2.favoriteFolders)) {
                    hashMap.put("sunPortalNetmailFavoriteFolders", new HashSet<String>(Arrays.asList(preferences2.favoriteFolders)));
                }
                if (preferences.headersPerPage != preferences2.headersPerPage) {
                    hashMap.put("sunPortalNetmailHeadersPerPage", this.getSet(preferences2.headersPerPage));
                }
                if (preferences.newestFirst != preferences2.newestFirst) {
                    hashMap.put("sunPortalNetmailNewestFirst", this.getSet(preferences2.newestFirst));
                }
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("getChangedPreferences difference map = ");
                this.debug.message(this.mapToString(hashMap));
            }
        }
        catch (Exception exception) {
            this.debug.error("Exception in getChangedPreferences", (Throwable)exception);
        }
        return hashMap;
    }

    public boolean savePreferences(Preferences preferences) {
        if (this.debug.messageEnabled()) {
            this.debug.message("saving preferences");
        }
        if (this.oldPrefs == null) {
            this.loadPreferences();
        }
        try {
            this.user.setAttributes(this.getChangedPreferences(this.oldPrefs, preferences));
            if (this.debug.messageEnabled()) {
                this.debug.message("preferences saved");
            }
        }
        catch (AMException aMException) {
            throw new RuntimeException("cannot save profile: " + (Object)((Object)aMException));
        }
        catch (SSOException sSOException) {
            throw new RuntimeException("cannot save profile - SSO pb : " + (Object)((Object)sSOException));
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot save profile: other problem" + exception);
        }
        try {
            this.user.store();
            return true;
        }
        catch (Exception exception) {
            this.debug.error("Exception in savePreferences() user.store() : ", (Throwable)exception);
            return false;
        }
    }

    public boolean isIMAPAttributesChanged() {
        return this.isIMAPChanged;
    }

    public String debugPreferences(Preferences preferences) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IMAPServerName=" + preferences.IMAPServerName + "\n");
        stringBuffer.append("IMAPUserId=" + preferences.IMAPUserName + "\n");
        stringBuffer.append("IMAPPassword=" + preferences.IMAPPassword + "\n");
        stringBuffer.append("SMTPServerName=" + preferences.SMTPServerName + "\n");
        stringBuffer.append("rootFolder=" + preferences.rootFolder + "\n");
        stringBuffer.append("sentMessagesFolder=" + preferences.sentMessagesFolder + "\n");
        stringBuffer.append("logMessages=" + preferences.logMessages + "\n");
        stringBuffer.append("replyWithAuthor=" + preferences.replyWithAuthor + "\n");
        stringBuffer.append("replyWithDate=" + preferences.replyWithDate + "\n");
        stringBuffer.append("replyWithBody=" + preferences.replyWithBody + "\n");
        stringBuffer.append("replyToAddress=" + preferences.replyToAddress + "\n");
        stringBuffer.append("indentPrefix=" + preferences.indentPrefix + "\n");
        stringBuffer.append("addSignature=" + preferences.addSignature + "\n");
        stringBuffer.append("signature=" + preferences.signature + "\n");
        stringBuffer.append("initialHeaders=" + preferences.initialHeaders + "\n");
        stringBuffer.append("inactivityInterval=" + preferences.inactivityInterval + "\n");
        stringBuffer.append("maxAttachLen=" + preferences.maxAttachLen + "\n");
        stringBuffer.append("autoload=" + preferences.autoload + "\n");
        stringBuffer.append("autosave=" + preferences.autosave + "\n");
        stringBuffer.append("autopurge=" + preferences.autopurge + "\n");
        stringBuffer.append("autoFolderLoad=" + preferences.autoFolderLoad + "\n");
        stringBuffer.append("sortKey=" + preferences.sortKey + "\n");
        stringBuffer.append("viewKey=" + preferences.viewKey + "\n");
        stringBuffer.append("readWinBounds=" + preferences.readWinBounds + "\n");
        stringBuffer.append("composeWinBounds=" + preferences.composeWinBounds + "\n");
        stringBuffer.append("folderWinBounds=" + preferences.folderWinBounds + "\n");
        stringBuffer.append("gridHeight=" + preferences.gridHeight + "\n");
        stringBuffer.append("gridColWidths=" + preferences.gridColWidths + "\n");
        stringBuffer.append("textColor=" + preferences.textColor + "\n");
        stringBuffer.append("backgroundColor=" + preferences.backgroundColor + "\n");
        stringBuffer.append("textSize=" + preferences.textSize + "\n");
        stringBuffer.append("textStyle=" + preferences.textStyle + "\n");
        stringBuffer.append("charset=" + preferences.charset + "\n");
        if (preferences.areTransientsSet) {
            stringBuffer.append("favoriteFolders=" + preferences.favoriteFolders + "\n");
            stringBuffer.append("headersPerPage=" + preferences.headersPerPage + "\n");
            stringBuffer.append("newestFirst=" + preferences.newestFirst + "\n");
        }
        return stringBuffer.toString();
    }

    public Hashtable loadPab() {
        Hashtable hashtable = (Hashtable)this.oldpab.clone();
        return hashtable;
    }

    private String getTokenizedNoPrefList(Set set) {
        if (set == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next()).append(",");
        }
        return stringBuffer.toString();
    }

    public boolean savePab(Hashtable hashtable) {
        Object object;
        if (this.oldpab.equals(hashtable)) {
            if (this.debug.messageEnabled()) {
                this.debug.message("not saving addressbook because no change");
            }
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)hashtable.get(object);
            hashSet.add((String)object + "," + string);
        }
        object = new HashMap();
        ((HashMap)object).put("sunPortalNetmailPersonalAddressBook", hashSet);
        if (this.debug.messageEnabled()) {
            this.debug.message("saving addressbook");
        }
        try {
            this.user.setAttributes((Map)object);
            if (this.debug.messageEnabled()) {
                this.debug.message("addressbook saved");
            }
        }
        catch (AMException aMException) {
            throw new RuntimeException("cannot save addressbook: " + (Object)((Object)aMException));
        }
        catch (SSOException sSOException) {
            throw new RuntimeException("cannot save addressbook - SSO pb : " + (Object)((Object)sSOException));
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot save addressbook: other problem" + exception);
        }
        try {
            this.user.store();
            return true;
        }
        catch (Exception exception) {
            if (this.debug.messageEnabled()) {
                this.debug.message("Exception in savePab() user.store() : ", (Throwable)exception);
            }
            return false;
        }
    }

    public String getString(String string) {
        return this.userResources.getString(string);
    }

    public String getStringRes(String string, String string2) {
        String string3 = this.userResources.getString(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String getString(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(userLocale);
        messageFormat.applyPattern(this.getString(string));
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public Locale getUserLocale() {
        return userLocale;
    }

    public String getHelpURL(String string) {
        return this.session.getServlet().getServletConfig().getServletContext().getInitParameter("staticContext") + "/docs/" + this.getUserLocale() + "/" + string;
    }

    public String getHelpLink(String string, String string2) {
        return "<a href=" + this.getHelpURL(string) + " target=netmailhelp>" + string2 + "</a>";
    }

    public String getExitHTML() {
        return "";
    }

    public void log(String string) {
        try {
            LogManager logManager = new LogManager(this.token);
            logManager.create(logFileName);
            logManager.write(new LogRecord("INFO", this.adminResources.getString(string)), logFileName);
        }
        catch (LogException logException) {
            this.debug("cannot write to log file: " + (Object)((Object)logException));
        }
    }

    public void log(String string, Object[] objectArray) {
        try {
            MessageFormat messageFormat = new MessageFormat(this.getString(string));
            messageFormat.setLocale(userLocale);
            String string2 = messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
            LogManager logManager = new LogManager(this.token);
            logManager.create(logFileName);
            logManager.write(new LogRecord("INFO", string2), logFileName);
        }
        catch (LogException logException) {
            this.debug("cannot write to log file: " + (Object)((Object)logException));
        }
    }

    public String getSessionID(HttpServletRequest httpServletRequest) throws ServletException {
        SSOToken sSOToken = null;
        try {
            sSOToken = PortalServerContext.getSSOTokenManager().createSSOToken(httpServletRequest);
        }
        catch (SSOException sSOException) {
            return null;
        }
        if (sSOToken == null) {
            throw new ServletException("PortalServerContext.getSessionID(): could not get sso token");
        }
        SSOTokenID sSOTokenID = sSOToken.getTokenID();
        if (sSOTokenID == null) {
            throw new ServletException("PortalServerContext.getSessionID(): could not get sso token id");
        }
        return sSOTokenID.toString();
    }

    public boolean updateContext(HttpServletRequest httpServletRequest) throws ServletException {
        try {
            if (this.dsameSessionID == null) {
                this.dsameSessionID = this.getSessionID(httpServletRequest);
                this.token = PortalServerContext.getSSOTokenManager().createSSOToken(this.dsameSessionID);
                this.connection = new AMStoreConnection(this.token);
                try {
                    this.user = this.connection.getUser(this.token.getPrincipal().getName());
                    if (this.debug.messageEnabled()) {
                        this.debug.message("User logged in : \n" + this.debugUser());
                    }
                }
                catch (SSOException sSOException) {
                    throw new ServletException("PortalServerContext.updateContext(): Cannot get userDSAME Exception:  ", (Throwable)sSOException);
                }
                this.token.addSSOTokenListener((SSOTokenListener)this);
                if (this.userResources == null) {
                    try {
                        StringTokenizer stringTokenizer;
                        String string = this.user.getStringAttribute("preferredlocale");
                        if (string == null || string.equals("")) {
                            string = Locale.getDefault().toString();
                        }
                        String string2 = (stringTokenizer = new StringTokenizer(string, "_")).hasMoreTokens() ? stringTokenizer.nextToken() : "";
                        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                        String string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string4 = string4 + "_" + stringTokenizer.nextToken();
                        }
                        userLocale = new Locale(string2, string3, string4);
                        this.userResources = ResourceBundle.getBundle("psNetMailServlet", userLocale);
                    }
                    catch (AMException aMException) {
                        throw new ServletException("cannot access preferredlocale: " + (Object)((Object)aMException));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new ServletException("invalid locale value: " + noSuchElementException);
                    }
                }
            } else if (!this.dsameSessionID.equals(this.getSessionID(httpServletRequest))) {
                return false;
            }
            if (!PortalServerContext.getSSOTokenManager().isValidToken(this.token)) {
                return false;
            }
            if (!this.executeOk) {
                try {
                    this.executeOk = this.isExecutable();
                }
                catch (Exception exception) {
                    this.error("cannot access user profile for checking execute privilege");
                }
            }
        }
        catch (Exception exception) {
            throw new ServletException("PortalServerContext.updateContext: " + exception);
        }
        return this.executeOk;
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        try {
            SSOToken sSOToken = sSOTokenEvent.getToken();
            int n = sSOTokenEvent.getType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    NetMailServlet netMailServlet = this.session.getServlet();
                    netMailServlet.removeSession(this.session);
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
        }
    }

    public boolean isExecutable() throws Exception {
        Map map = null;
        Set set = null;
        map = this.user.getPolicy(SUN_NETMAIL_SERVICE);
        if (this.debug.messageEnabled()) {
            this.debug.message("policy map\n******\n" + this.mapToString(map) + "\n******\n");
        }
        if (map.isEmpty()) {
            if (this.debug.messageEnabled()) {
                this.debug.message("no policy attribute is defined in the specified service");
            }
            return false;
        }
        set = (Set)map.get("sunPortalNetmailExecutable");
        if (set == null || set.size() < 1) {
            if (this.debug.messageEnabled()) {
                this.debug.message("no policy for this user");
            }
            return false;
        }
        return Boolean.valueOf((String)set.iterator().next());
    }

    public boolean isValid() {
        try {
            if (this.token == null) {
                return false;
            }
            if (!PortalServerContext.getSSOTokenManager().isValidToken(this.token)) {
                return false;
            }
        }
        catch (Exception exception) {
            this.debug.error("Cannot get TokenManager in isValid()", (Throwable)exception);
            return false;
        }
        return true;
    }

    public String debugUser() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.user == null) {
                return "user == null";
            }
            Map map = this.user.getAttributes();
            stringBuffer.append("Map for user.getAttributes()\n");
            stringBuffer.append(this.mapToString(map));
            map = this.user.getServiceAttributes(SUN_NETMAIL_SERVICE);
            stringBuffer.append("Map for user.getServiceAttributes(SUN_NETMAIL_SERVICE) \n");
            stringBuffer.append(this.mapToString(map));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "PortalServerContext.debugUser() Exception: " + exception.toString();
        }
    }

    public String mapToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("**************\n");
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        Object object = null;
        Object object2 = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            object2 = map.get(object);
            stringBuffer.append(object.toString() + "=" + map.get(object).toString() + " of class " + object2.getClass().getName() + "\n");
        }
        stringBuffer.append("**************\n");
        return stringBuffer.toString();
    }

    public synchronized void debug(String string) {
        if (this.debug == null) {
            return;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message(string);
        }
    }

    public synchronized void error(String string) {
        this.debug.error(string);
    }
}

