/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import com.sun.portal.netmail.protocol.Account;
import com.sun.portal.netmail.protocol.AddressBook;
import com.sun.portal.netmail.protocol.Controller;
import com.sun.portal.netmail.protocol.Folder;
import com.sun.portal.netmail.protocol.Outbox;
import com.sun.portal.netmail.protocol.PersonalAddressBook;
import com.sun.portal.netmail.protocol.Preferences;
import com.sun.portal.netmail.protocol.Requestor;
import java.io.Serializable;

public class Session
implements Serializable,
Requestor {
    private static String sessionClass;
    private static String newSessionId;
    public String sessionId = newSessionId;
    private boolean havePrefsFromServer = false;
    public Preferences prefs = new Preferences();
    public PersonalAddressBook pab = new PersonalAddressBook();
    public Account primaryAccount = new Account(0);
    public AddressBook[] addressBooks = new AddressBook[0];
    public Outbox outbox = new Outbox();
    public static final int OK = 0;
    public static final int LOGINFAILED = 1;
    public static final int WRONGUSER = 2;
    public static final int PROFILESAVEFAILED = 3;
    public int problemCode = 0;

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConnected() {
        return !this.sessionId.equals(newSessionId);
    }

    public void init(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 0, (Serializable[])null);
        this.outbox.sendAllMessages(controller);
    }

    public void saveProfile(Controller controller) {
        if (this.havePrefsFromServer) {
            Serializable[] serializableArray = new Serializable[]{this.prefs, this.pab};
            controller.getRequest().startOp((Requestor)this, 2, serializableArray);
        }
    }

    public void reconnect(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 1, new Serializable[]{this.prefs, this.pab});
        this.primaryAccount.reconnect(controller);
        this.outbox.sendAllMessages(controller);
    }

    public void disconnect(Controller controller) {
        Folder folder;
        if (this.prefs.autopurge && (folder = this.primaryAccount.getFolder("INBOX")) != null) {
            folder.expunge(controller);
        }
        controller.getRequest().startOp((Requestor)this, 3, new Serializable[]{this.prefs});
    }

    public void forceDisconnect() {
        this.sessionId = newSessionId;
    }

    public void opCompleted(Controller controller, int n, Serializable[] serializableArray, Serializable[] serializableArray2) {
        switch (n) {
            case 0: {
                Session session = (Session)serializableArray2[0];
                this.problemCode = session.problemCode;
                this.sessionId = newSessionId;
                this.prefs = session.prefs;
                this.pab = session.pab;
                this.havePrefsFromServer = true;
                this.addressBooks = session.addressBooks;
                switch (session.problemCode) {
                    case 0: {
                        this.sessionId = session.sessionId;
                        this.primaryAccount = session.primaryAccount;
                    }
                }
                controller.sessionUpdated(this);
                break;
            }
            case 1: {
                Session session = (Session)serializableArray2[0];
                if (session.problemCode == 0 || session.problemCode == 3) {
                    this.sessionId = session.sessionId;
                    this.addressBooks = session.addressBooks;
                    this.addressBooks[0] = this.pab;
                }
                this.problemCode = session.problemCode;
                controller.sessionUpdated(this);
                break;
            }
            case 2: {
                Boolean bl = (Boolean)serializableArray2[0];
                controller.profileSaved(bl);
                break;
            }
            case 3: {
                this.sessionId = newSessionId;
                controller.sessionUpdated(this);
            }
        }
    }

    public static void setContext(String string) {
        newSessionId = sessionClass + "&context=" + string;
    }

    static {
        newSessionId = sessionClass = "newAppletSession";
    }
}

