/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.util.SystemProperties;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class ApprovalCallback
implements SSLCertificateApprovalCallback {
    private String reqHost = null;
    private static ApprovalCallback theInstance = null;
    public static boolean trustAllServerCerts = false;
    public static boolean trustAllServerCertDomains = false;

    private ApprovalCallback() {
    }

    public ApprovalCallback(String host) {
        if (host != null) {
            this.reqHost = host.toLowerCase();
        }
    }

    public static ApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate cert, SSLCertificateApprovalCallback.ValidityStatus status) {
        JSSDebug.debug.message("ApprovalCallback: SubjectDN = " + cert.getSubjectDN().getName());
        Enumeration errors = status.getReasons();
        if (this.reqHost == null) {
            int numReasons = 0;
            while (errors.hasMoreElements()) {
                SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
                int reason = item.getReason();
                JSSDebug.debug.message("ApprovalCallback: reason " + reason);
                if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                    if (trustAllServerCerts) continue;
                    ++numReasons;
                    continue;
                }
                if (reason == -12276) {
                    if (trustAllServerCertDomains) continue;
                    ++numReasons;
                    continue;
                }
                ++numReasons;
            }
            return numReasons == 0;
        }
        boolean trust = true;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            JSSDebug.debug.message("ApprovalCallback: reason " + reason);
            if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                if (trustAllServerCerts) continue;
                trust = false;
                continue;
            }
            if (reason != -12276) {
                trust = false;
                continue;
            }
            if (trustAllServerCertDomains) continue;
            String subjectDN = cert.getSubjectDN().getName();
            StringTokenizer st = new StringTokenizer(subjectDN, ",");
            boolean cnFound = false;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim().toLowerCase();
                if (!token.startsWith("cn=")) continue;
                String cn = token.substring(3);
                cnFound = true;
                if (cn.equals(this.reqHost)) break;
                trust = false;
                break;
            }
            if (cnFound) continue;
            trust = false;
        }
        return trust;
    }

    static {
        String tmp = SystemProperties.get("gateway.trust_all_server_certs");
        trustAllServerCerts = tmp != null && tmp.equals("true");
        tmp = SystemProperties.get("gateway.trust_all_server_cert_domains");
        trustAllServerCertDomains = tmp != null && tmp.equals("true");
    }
}

