/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.RWGroupJSSProxy;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import sun.net.www.protocol.http.HttpURLConnection;

public class JSSProxyRunnable
implements Runnable {
    public static HashMap connectHashMap = new HashMap();
    private ServerSocket sconnection = null;

    JSSProxyRunnable(ServerSocket ss) {
        this.sconnection = ss;
    }

    public void run() {
        boolean go = true;
        boolean isHTTPS = this.sconnection instanceof SSLServerSocket;
        while (go) {
            try {
                Socket inconnection;
                block30: {
                    try {
                        inconnection = this.sconnection.accept();
                        if (!PerfContextObject.ENABLE_PERF) break block30;
                        if (isHTTPS) {
                            SocketCount.incrementSSLSockets();
                        } else {
                            SocketCount.incrementPlainSockets();
                        }
                    }
                    catch (IOException e) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("JSSProxyRunnable: Unable to accept new connection." + e);
                        }
                        if (this.sconnection != null) {
                            Object var7_14;
                            try {
                                block31: {
                                    try {
                                        this.sconnection.close();
                                        if (!PerfContextObject.ENABLE_PERF) break block31;
                                        SocketCount.decrementServerSockets();
                                    }
                                    catch (IOException ee) {
                                        if (GWDebug.debug.errorEnabled()) {
                                            GWDebug.debug.error("JSSProxyRunnable: Unable to close server socket." + e);
                                        }
                                        var7_14 = null;
                                        this.sconnection = null;
                                    }
                                }
                                var7_14 = null;
                                this.sconnection = null;
                            }
                            catch (Throwable throwable) {
                                var7_14 = null;
                                this.sconnection = null;
                                throw throwable;
                            }
                        }
                        go = false;
                        continue;
                    }
                }
                try {
                    inconnection.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    Object var9_15;
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("JSSProxyRunnable: Unable to  TcpNoDelay." + e);
                    }
                    if (inconnection == null) continue;
                    try {
                        block33: {
                            try {
                                inconnection.close();
                                if (!PerfContextObject.ENABLE_PERF) break block33;
                                if (isHTTPS) {
                                    SocketCount.decrementSSLSockets();
                                    break block33;
                                }
                                SocketCount.decrementPlainSockets();
                            }
                            catch (IOException ee) {
                                var9_15 = null;
                                inconnection = null;
                                continue;
                            }
                        }
                        var9_15 = null;
                        inconnection = null;
                        continue;
                    }
                    catch (Throwable throwable) {
                        var9_15 = null;
                        inconnection = null;
                        throw throwable;
                    }
                }
                JSSProxySessionRunnable p = new JSSProxySessionRunnable(inconnection);
                try {
                    GWThreadPool.run(p);
                }
                catch (InterruptedException e) {
                    Object var11_16;
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("JSSProxyRunnable: Unable to run new JSSProxySession", e);
                    }
                    if (inconnection == null) continue;
                    try {
                        block34: {
                            try {
                                inconnection.close();
                                if (!PerfContextObject.ENABLE_PERF) break block34;
                                if (isHTTPS) {
                                    SocketCount.decrementSSLSockets();
                                    break block34;
                                }
                                SocketCount.decrementPlainSockets();
                            }
                            catch (IOException ee) {
                                var11_16 = null;
                                inconnection = null;
                                p = null;
                                continue;
                            }
                        }
                        var11_16 = null;
                        inconnection = null;
                        p = null;
                    }
                    catch (Throwable throwable) {
                        var11_16 = null;
                        inconnection = null;
                        p = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable t) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error("JSSProxyRunnable: Uncaught exception:", t);
            }
        }
    }

    private class JSSProxySessionRunnable
    implements Runnable {
        private Socket inconnection = null;
        private Socket toProxySocket = null;

        JSSProxySessionRunnable(Socket socket) {
            this.inconnection = socket;
        }

        public void run() {
            String replyStr;
            String host;
            Request req;
            byte[] prebuffer;
            block25: {
                Integer remotePort = new Integer(this.inconnection.getPort());
                prebuffer = new byte[1];
                try {
                    DataInputStream inFrom = new DataInputStream(this.inconnection.getInputStream());
                    inFrom.readFully(prebuffer, 0, 1);
                }
                catch (IOException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("JSSProxySessionRunnable: Unable to open input stream on " + this.inconnection, e);
                    }
                    connectHashMap.remove(remotePort);
                    this.closeSockets();
                    return;
                }
                req = (Request)connectHashMap.remove(remotePort);
                host = req.getProxyHost();
                int port = req.getProxyPort();
                try {
                    this.toProxySocket = new Socket(host, port);
                    this.toProxySocket.setTcpNoDelay(true);
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.incrementPlainSockets();
                    }
                }
                catch (Exception ex) {
                    this.toProxySocket = null;
                    if (!GWDebug.debug.errorEnabled()) break block25;
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to connect to " + host + ":" + port + ". " + ex);
                }
            }
            if (this.toProxySocket == null) {
                this.closeSockets();
                return;
            }
            String desthost = req.getHost();
            String destport = req.getPort();
            OutputStream out = null;
            InputStream in = null;
            byte[] reply = new byte[200];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            try {
                byte[] b;
                out = this.toProxySocket.getOutputStream();
                StringBuffer strsb = new StringBuffer();
                String msg = null;
                strsb.append("CONNECT ").append(desthost).append(":").append(destport).append(" HTTP/1.0\r\n").append("User-Agent: ").append(HttpURLConnection.userAgent);
                String authinfo = HTTPRetriever.getProxyPassword(host);
                if (authinfo != null) {
                    strsb.append("\r\nProxy-Authorization: Basic ").append(authinfo);
                }
                strsb.append("\r\n\r\n");
                msg = strsb.toString();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message(msg);
                }
                try {
                    b = msg.getBytes("ASCII7");
                }
                catch (UnsupportedEncodingException ignored) {
                    b = msg.getBytes();
                }
                out.write(b);
                out.flush();
                in = this.toProxySocket.getInputStream();
                boolean error = false;
                while (newlinesSeen < 2) {
                    int i = in.read();
                    if (i < 0) {
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("JSSProxySessionRunnable: Unexpected EOF from proxy");
                        }
                        this.closeSockets();
                        return;
                    }
                    if (i == 10) {
                        headerDone = true;
                        ++newlinesSeen;
                        continue;
                    }
                    if (i == 13) continue;
                    newlinesSeen = 0;
                    if (headerDone || replyLen >= reply.length) continue;
                    reply[replyLen++] = (byte)i;
                }
            }
            catch (IOException ioe) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to get OutputStream" + ioe);
                }
                this.closeSockets();
                return;
            }
            try {
                replyStr = new String(reply, 0, replyLen, "ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                replyStr = new String(reply, 0, replyLen);
            }
            if (!replyStr.startsWith("HTTP/1.0 200")) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to tunnel through ");
                }
                this.closeSockets();
                return;
            }
            try {
                out.write(prebuffer);
                out.flush();
            }
            catch (IOException ioe) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to write prebuffer." + ioe);
                }
                this.closeSockets();
                return;
            }
            new RWGroupJSSProxy(this.inconnection, this.toProxySocket);
        }

        void closeSockets() {
            if (this.inconnection != null) {
                try {
                    block12: {
                        try {
                            this.inconnection.close();
                            if (!PerfContextObject.ENABLE_PERF) break block12;
                            if (this.inconnection instanceof SSLSocket) {
                                SocketCount.decrementSSLSockets();
                                break block12;
                            }
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception e1) {
                            Object var3_2 = null;
                            this.inconnection = null;
                        }
                    }
                    Object var3_1 = null;
                    this.inconnection = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.inconnection = null;
                    throw throwable;
                }
            }
            if (this.toProxySocket != null) {
                boolean isHTTPS = this.toProxySocket instanceof SSLSocket;
                try {
                    block14: {
                        try {
                            this.toProxySocket.close();
                            if (!PerfContextObject.ENABLE_PERF) break block14;
                            if (this.toProxySocket instanceof SSLSocket) {
                                SocketCount.decrementSSLSockets();
                                break block14;
                            }
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception e1) {
                            Object var5_9 = null;
                            this.toProxySocket = null;
                        }
                    }
                    Object var5_8 = null;
                    this.toProxySocket = null;
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    this.toProxySocket = null;
                    throw throwable;
                }
            }
        }
    }
}

