/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

class SConn {
    SConn() {
    }

    public static Socket connect(int p, String h) {
        Socket conn;
        block7: {
            conn = null;
            try {
                conn = new Socket(h, p);
                conn.setTcpNoDelay(true);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementPlainSockets();
                }
            }
            catch (UnknownHostException e) {
                conn = null;
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot open connection to " + h + ":" + p, e);
                }
            }
            catch (SocketException e) {
                conn = null;
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot set tcpNoDelay on connection to " + h + ":" + p, e);
                }
            }
            catch (IOException e) {
                conn = null;
                if (!GWDebug.debug.errorEnabled()) break block7;
                GWDebug.debug.error("Cannot open connection to " + h + ":" + p, e);
            }
        }
        return conn;
    }

    public static Socket connect(String p, String h) {
        Socket conn = null;
        StringTokenizer hosts = new StringTokenizer(h, "+");
        StringTokenizer portlist = new StringTokenizer(p, "-");
        int portlistLen = portlist.countTokens();
        if (hosts.countTokens() == portlistLen || portlistLen == 1) {
            while (hosts.hasMoreElements() && conn == null) {
                String strPorts = "";
                strPorts = portlistLen == 1 ? p : (String)portlist.nextElement();
                StringTokenizer ports = new StringTokenizer(strPorts, "+");
                String host = (String)hosts.nextElement();
                while (ports.hasMoreElements() && conn == null) {
                    String strPort = (String)ports.nextElement();
                    int port = -999;
                    try {
                        port = Integer.parseInt(strPort);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    try {
                        conn = new Socket(host, port);
                        conn.setTcpNoDelay(true);
                        if (!PerfContextObject.ENABLE_PERF) continue;
                        SocketCount.incrementPlainSockets();
                    }
                    catch (UnknownHostException e) {
                        conn = null;
                        if (!GWDebug.debug.errorEnabled()) continue;
                        GWDebug.debug.error("Cannot open connection to " + host + ":" + port, e);
                    }
                    catch (SocketException e) {
                        conn = null;
                        if (!GWDebug.debug.errorEnabled()) continue;
                        GWDebug.debug.error("Cannot set tcpNoDelay on connection to " + host + ":" + port, e);
                    }
                    catch (IOException e) {
                        conn = null;
                        if (!GWDebug.debug.errorEnabled()) continue;
                        GWDebug.debug.error("Cannot open connection to " + host + ":" + port, e);
                    }
                }
            }
        } else {
            conn = null;
        }
        return conn;
    }
}

