/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.crypt.ciph;

import com.sun.portal.netlet.crypt.ciph.CipherSpi;
import com.sun.portal.netlet.crypt.ciph.NetletCrypto;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;
import com.sun.portal.netlet.crypt.ciph.Provider;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int PRIVATE_KEY = 3;
    public static final int PUBLIC_KEY = 4;
    public static final int SECRET_KEY = 5;
    public static final int UNWRAP_MODE = 6;
    public static final int WRAP_MODE = 7;
    private final CipherSpi spi;
    private final Provider provider;
    private final String transformation;
    private boolean isInitialized = false;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String transformation) {
        this.spi = cipherSpi;
        this.provider = provider;
        this.transformation = transformation;
    }

    public String toString() {
        return "Cipher object: " + this.transformation;
    }

    private static Object[] getCipherImplementation(String transformation, Provider p) throws NetletCryptoException {
        String part_alg;
        String part_mode = "CBC";
        String part_pad = "PKCS#7";
        int index_1 = transformation.indexOf(47);
        int index_2 = transformation.indexOf(47, index_1 + 1);
        if (index_1 == -1) {
            part_alg = transformation;
        } else if (index_2 == -1) {
            part_alg = transformation.substring(0, index_1);
            part_mode = transformation.substring(index_1 + 1);
        } else {
            part_alg = transformation.substring(0, index_1);
            part_mode = transformation.substring(index_1 + 1, index_2);
            part_pad = transformation.substring(index_2 + 1);
        }
        try {
            Object[] res = new Object[2];
            res[1] = p;
            String class_name = Cipher.getClassName("Cipher", part_alg, p);
            if (class_name != null) {
                CipherSpi spi = (CipherSpi)Class.forName(class_name).newInstance();
                spi.engineSetMode(part_mode);
                spi.engineSetPadding(part_pad);
                res[0] = spi;
                return res;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static Cipher getInstance(String transformation) throws NetletCryptoException {
        Provider provider = NetletCrypto.getInstance();
        Object[] res = Cipher.getCipherImplementation(transformation, provider);
        if (res != null) {
            return new Cipher((CipherSpi)res[0], (Provider)res[1], transformation);
        }
        throw new NetletCryptoException("Algorithm not found. [Cipher." + transformation + "]");
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        return this.spi.engineGetBlockSize();
    }

    public final void init(int opmode, byte[] key) throws NetletCryptoException {
        this.spi.engineInit(opmode, key);
        this.isInitialized = true;
    }

    public final byte[] doFinal(byte[] input) throws NetletCryptoException {
        return this.spi.engineDoFinal(input, 0, input.length);
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws NetletCryptoException {
        return this.spi.engineDoFinal(input, inputOffset, inputLen);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalStateException, NetletCryptoException {
        return this.spi.engineDoFinal(input, inputOffset, inputLen, output, 0);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalStateException, NetletCryptoException {
        return this.spi.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    static Object[] getImplementation(String type, String algorithm) throws NetletCryptoException {
        Provider prov = NetletCrypto.getInstance();
        Object[] res = Cipher.getImplementation(type, algorithm, prov);
        if (res != null) {
            return res;
        }
        throw new NetletCryptoException("Algorithm not found. [" + type + "." + algorithm + "]");
    }

    static Object[] getImplementation(String type, String algorithm, String provider) throws NetletCryptoException {
        if (provider.indexOf("NetletCrypto") < 0) {
            throw new NetletCryptoException("Provider not found. [" + provider + "]");
        }
        Provider prov = NetletCrypto.getInstance();
        Object[] res = Cipher.getImplementation(type, algorithm, prov);
        if (res != null) {
            return res;
        }
        throw new NetletCryptoException("Algorithm not found. [" + type + "." + algorithm + "]");
    }

    static Object[] getImplementation(String algType, String algName, Provider p) {
        try {
            String class_name = p.getProperty("Alg.Alias." + algType + "." + algName);
            class_name = class_name == null ? p.getProperty(algType + "." + algName) : p.getProperty(algType + "." + class_name);
            if (class_name == null) {
                return null;
            }
            Object[] res = new Object[]{Class.forName(class_name).newInstance(), p};
            return res;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    static String getClassName(String algType, String algName, Provider p) {
        String class_name = p.getProperty(algType + "." + algName);
        if (class_name == null) {
            System.out.println("Failed for algType=" + algType + " algName=" + algName);
        }
        return class_name;
    }
}

