/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class LocaleHelper {
    private static Map localeHelperList = new HashMap();
    private final String RESOURCE_BASE;
    private ResourceBundle resourceBundle;

    public LocaleHelper(String string) {
        this(string, Locale.getDefault());
    }

    public LocaleHelper(String string, Locale locale) {
        this.RESOURCE_BASE = string;
        this.setLocale(locale);
    }

    public void setLocale(Locale locale) {
        this.resourceBundle = ResourceBundle.getBundle(this.RESOURCE_BASE, locale);
    }

    public String getResourceBase() {
        return this.RESOURCE_BASE;
    }

    public String getLocalizedString(String string) {
        return this.resourceBundle.getString(string);
    }

    public String getLocalizedString(String string, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(this.resourceBundle.getLocale());
            messageFormat.applyPattern(this.resourceBundle.getString(string));
            return messageFormat.format(objectArray);
        }
        return this.resourceBundle.getString(string);
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Object[] objectArray) {
        String string2 = this.getLocalizedString(string, objectArray);
        Object[] objectArray2 = new Object[]{string2};
        System.out.println(this.getLocalizedString("msgDebug", objectArray2));
    }

    public void warning(String string) {
        this.warning(string, null);
    }

    public void warning(String string, Object[] objectArray) {
        String string2 = this.getLocalizedString(string, objectArray);
        Object[] objectArray2 = new Object[]{string2};
        System.out.println(this.getLocalizedString("msgWarning", objectArray2));
    }

    public static Locale getLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        return new Locale(string2, string3, string4);
    }

    public static void store(String string, Locale locale) {
        localeHelperList.put(string, new LocaleHelper(string, locale));
    }

    public static LocaleHelper getLocaleHelper(String string) {
        return (LocaleHelper)localeHelperList.get(string);
    }
}

