/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.eproxy.EProxyConfigConstants;
import com.sun.portal.netlet.eproxy.ESession;
import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.netlet.eproxy.RWGroupClear;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.server.HTTPConnectionManager;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.SRAPServerSocket;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.mozilla.jss.ssl.SSLServerSocket;

public class EProxyConnection
implements EProxyConfigConstants {
    private HTTPConnectionManager httpConnectionManager;
    protected static final String unMakeToken = "dummy";
    private Socket inconnection;
    private ServerSocket sconnection = null;
    private volatile boolean go = true;
    private int srcPort;
    private byte[] emptyIP = new byte[]{0, 0, 0, 0};
    private int logId = 0;

    protected EProxyConnection() {
    }

    public EProxyConnection(int sport, HTTPConnectionManager cm) {
        this.srcPort = sport;
        this.httpConnectionManager = cm;
        this.start();
    }

    public void start() {
        Thread.currentThread().setName("EProxy");
        this.sconnection = this.makeServerSocket();
        this.go = this.sconnection != null;
        Integer logid = new Integer(0);
        GW.run_GW();
        boolean isHTTPS = this.sconnection instanceof SSLServerSocket;
        while (this.go) {
            try {
                block34: {
                    try {
                        this.inconnection = this.sconnection.accept();
                        if (!PerfContextObject.ENABLE_PERF) break block34;
                        if (isHTTPS) {
                            SocketCount.incrementSSLSockets();
                        } else {
                            SocketCount.incrementPlainSockets();
                        }
                    }
                    catch (SocketException se) {
                        continue;
                    }
                    catch (IOException e) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("EProxyConnection cannot accept new connection on " + this.sconnection, e);
                        }
                        if (this.sconnection != null) {
                            Object var7_15;
                            try {
                                block35: {
                                    try {
                                        this.sconnection.close();
                                        if (!PerfContextObject.ENABLE_PERF) break block35;
                                        SocketCount.decrementServerSockets();
                                    }
                                    catch (IOException ee) {
                                        if (GWDebug.debug.errorEnabled()) {
                                            GWDebug.debug.error("EProxyConnection cannot close server socket", e);
                                        }
                                        var7_15 = null;
                                        this.sconnection = null;
                                    }
                                }
                                var7_15 = null;
                                this.sconnection = null;
                            }
                            catch (Throwable throwable) {
                                var7_15 = null;
                                this.sconnection = null;
                                throw throwable;
                            }
                        }
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException ee) {
                            // empty catch block
                        }
                        String ee = unMakeToken;
                        synchronized (ee) {
                            GW.unrun_GW();
                            GW.setNumberOfInstances(1);
                            this.sconnection = this.makeServerSocket();
                            GW.run_GW();
                        }
                        if (this.sconnection != null) continue;
                        this.go = false;
                        continue;
                    }
                }
                if (GWLogManager.loggingEnabled) {
                    logid = new Integer(GWLogManager.getLogId());
                    GWLogManager.write("EProxy", GWLocale.getPFString("epc1", new Object[]{logid, this.inconnection.getInetAddress().toString(), new Integer(this.inconnection.getPort())}));
                }
                try {
                    this.inconnection.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    Object var10_16;
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("EProxyConnection cannot set TcpNoDelay on " + this.inconnection, e);
                    }
                    if (this.inconnection == null) continue;
                    try {
                        block37: {
                            try {
                                this.inconnection.close();
                                if (!PerfContextObject.ENABLE_PERF) break block37;
                                SocketCount.decrementPlainSockets();
                            }
                            catch (IOException ee) {
                                var10_16 = null;
                                this.inconnection = null;
                                continue;
                            }
                        }
                        var10_16 = null;
                        this.inconnection = null;
                        continue;
                    }
                    catch (Throwable throwable) {
                        var10_16 = null;
                        this.inconnection = null;
                        throw throwable;
                    }
                }
                ESessionThread p = new ESessionThread(this.inconnection, logid);
                try {
                    GWThreadPool.run(p);
                }
                catch (InterruptedException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Cannot run new ESession", e);
                    }
                    if (this.inconnection == null) continue;
                    try {
                        this.inconnection.close();
                        if (PerfContextObject.ENABLE_PERF) {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                    catch (IOException ee) {
                        // empty catch block
                    }
                    p = null;
                }
            }
            catch (Throwable t) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error("EProxy: Uncaught exception:", t);
            }
        }
        this.stop();
    }

    public void stop() {
        if (GWDebug.debug.errorEnabled()) {
            GWDebug.debug.error("FATAL ERROR: EProxy exited");
        }
    }

    private ServerSocket makeServerSocket() {
        return this.makeServerSocket(this.srcPort);
    }

    protected ServerSocket makeServerSocket(int serverPort) {
        SRAPServerSocket sock = null;
        int qlen = GatewayProfile.getInt("EProxyConnectionQueue", 50);
        String _address = SystemProperties.get("gateway.bindipaddress");
        try {
            sock = _address == null ? new SRAPServerSocket(serverPort, qlen) : new SRAPServerSocket(serverPort, qlen, InetAddress.getByName(_address));
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
        }
        catch (IOException e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("EProxyConnection cannot create server socket on " + serverPort, e);
            }
            sock = null;
        }
        return sock;
    }

    private class ESessionThread
    implements Runnable {
        private Socket inconnection;
        private Integer logId;

        public String toString() {
            if (this.inconnection != null) {
                return "ESessionThread-" + this.inconnection.toString();
            }
            return "Inactive ESessionThread";
        }

        public void run() {
            DataInputStream in;
            if (this.inconnection == null) {
                return;
            }
            try {
                in = new DataInputStream(this.inconnection.getInputStream());
            }
            catch (IOException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("EProxyConnection cannot open input stream on " + this.inconnection, e);
                }
                try {
                    this.inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return;
            }
            ESessionMsg emsg = new ESessionMsg();
            try {
                this.inconnection.getInputStream().mark(512);
            }
            catch (Exception e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot mark " + this.inconnection, e);
                }
                try {
                    this.inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return;
            }
            if (emsg.readMsg(in) == 0) {
                ESession es = new ESession(this.inconnection, this.logId);
                try {
                    GWThreadPool.run(es);
                }
                catch (InterruptedException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Cannot run ESession", e);
                    }
                    try {
                        this.inconnection.close();
                        if (PerfContextObject.ENABLE_PERF) {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (ServiceIdentifier.isGateway()) {
                try {
                    this.inconnection.getInputStream().reset();
                }
                catch (Exception e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Cannot reset incoming socket", e);
                    }
                    if (this.inconnection != null) {
                        try {
                            this.inconnection.close();
                            if (PerfContextObject.ENABLE_PERF) {
                                SocketCount.decrementPlainSockets();
                            }
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    return;
                }
                if (EProxyConnection.this.httpConnectionManager != null) {
                    GWLogManager.logIdMap.put(new Integer(this.inconnection.getPort()), new LogInfoContainer(this.logId, this.inconnection));
                    EProxyConnection.this.httpConnectionManager.acceptConnection(this.inconnection, this.logId, null);
                } else {
                    new RWGroupClear(this.inconnection, this.logId);
                }
            } else {
                try {
                    this.inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.inconnection = null;
            }
            in = null;
            Object var2_3 = null;
        }

        ESessionThread(Socket socket, Integer _logId) {
            this.inconnection = socket;
            this.logId = _logId;
        }
    }
}

