/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.xml;

import com.sun.portal.rewriter.InvalidXMLException;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.xml.Document;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class Node {
    static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    private NamedNodeMap nodeMap = null;
    private String name = "";
    private String value = "";
    private org.w3c.dom.Node w3cNode;
    private Document source = null;

    public Node(org.w3c.dom.Node node) {
        if (node != null) {
            this.w3cNode = node;
            this.source = new Document(node.getOwnerDocument());
            this.name = node.getNodeName();
            this.nodeMap = node.getAttributes();
            org.w3c.dom.Node node2 = node.getFirstChild();
            if (node2 != null) {
                this.value = node2.getNodeValue();
                if (this.value == null) {
                    this.value = "";
                }
            }
        }
    }

    public org.w3c.dom.Node getW3CNode() {
        return this.w3cNode;
    }

    public String getAttributeValue(String string) {
        if (this.nodeMap != null) {
            try {
                return this.nodeMap.getNamedItem(string).getNodeValue();
            }
            catch (Exception exception) {
                Debug.warning("Error: NodeName: " + this.getW3CNode().getNodeName() + " Attribute Absent: " + string, exception);
            }
        }
        return "";
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public Node selectNode(String string) throws InvalidXMLException {
        Node[] nodeArray = this.selectNodes(string);
        Node node = new Node(null);
        int n = nodeArray.length;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                node = nodeArray[0];
                break;
            }
            default: {
                throw new InvalidXMLException("More than One Element of '" + string + "' present : ", null, string, 1003);
            }
        }
        return node;
    }

    public Document getDocument() {
        return this.source;
    }

    public Node[] selectNodes(String string) {
        return Document.selectNodes(this.source, string);
    }

    public Node[] getChildren(String string) {
        return Node.getChildNodes(this, string);
    }

    public static Node[] getChildNodes(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node.getW3CNode() != null) {
            NodeList nodeList = node.getW3CNode().getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                org.w3c.dom.Node node2 = nodeList.item(n);
                if (node2.getNodeName().equals(string)) {
                    arrayList.add(new Node(node2));
                }
                ++n;
            }
        }
        return arrayList.toArray(EMPTY_NODE_ARRAY);
    }
}

