/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.yahoo;

import com.sun.portal.rproxy.rewriter.yahoo.OrderedHashMap;
import com.sun.portal.util.GWDebug;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QueryStringParser {
    private String rawQueryString = null;
    private OrderedHashMap properties = null;

    public QueryStringParser(URL url) {
        this.rawQueryString = url.getQuery();
    }

    public QueryStringParser(String queryString) {
        if (queryString.startsWith("?")) {
            this.rawQueryString = queryString.substring(1);
        }
        this.rawQueryString = queryString;
    }

    public OrderedHashMap getProperties() {
        if (this.properties == null) {
            this.properties = new OrderedHashMap();
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Raw Query String :" + this.rawQueryString);
        }
        if (this.rawQueryString.indexOf(38) >= 0) {
            StringTokenizer ampersandTokenizer = new StringTokenizer(this.rawQueryString, "&");
            while (ampersandTokenizer.hasMoreTokens()) {
                this.populatePropertiesNoAmbersand(ampersandTokenizer.nextToken());
            }
        } else {
            this.populatePropertiesNoAmbersand(this.rawQueryString);
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Query Parser  Output:" + this.properties);
        }
        return this.properties;
    }

    private synchronized void populatePropertiesNoAmbersand(String nameValue) {
        int equalIndex = nameValue.indexOf(61);
        String key = null;
        String value = null;
        key = nameValue.substring(0, equalIndex);
        value = nameValue.substring(equalIndex + 1, nameValue.length());
        this.properties.put(key, value);
    }

    private synchronized void populateProperties(String nameValue) {
        StringTokenizer nameValueTokenizer = new StringTokenizer(nameValue, "=");
        String key = null;
        String value = null;
        try {
            key = nameValueTokenizer.nextElement().toString();
            value = nameValueTokenizer.nextElement().toString();
        }
        catch (NoSuchElementException ne) {
            // empty catch block
        }
        this.properties.put(key, value);
    }

    public String toExternalForm() {
        return "?" + this.rawQueryString;
    }

    public String toRawExternalForm() {
        return this.rawQueryString;
    }
}

