/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter;

import com.sun.portal.rewriter.AbstractTranslator;
import com.sun.portal.rewriter.JSFunctionSpec;
import com.sun.portal.rewriter.URISpec;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.rewriter.SRAPJSFunctionSpec;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import com.sun.portal.rproxy.rewriter.yahoo.YahooProfile;
import com.sun.portal.rproxy.rewriter.yahoo.YahooTranslator;
import com.sun.portal.util.GWDebug;
import java.net.URLDecoder;

public class SRAPTranslator
extends AbstractTranslator {
    private final JSFunctionSpec srapJSSpec;
    private DecoratedURI decoratedGatewayURI;
    private String yahooEditServer;
    private Request req;

    public SRAPTranslator(Request aReq) {
        this(aReq, null);
    }

    public SRAPTranslator(Request aReq, String aMIME) {
        this(aReq.getGatewayURL(), aReq.getURL(), aMIME);
        this.req = aReq;
    }

    public SRAPTranslator(String aGatewayURI, String aBaseURI, String aMIME) {
        super(new URISpec(aBaseURI, aMIME));
        YahooProfile.getInstance();
        this.yahooEditServer = YahooProfile.getString("EditServer", "_NoServer_");
        this.req = null;
        try {
            this.decoratedGatewayURI = new DecoratedURI(aGatewayURI);
        }
        catch (Exception e) {
            Debug.error((String)("Gateway URI Can't be invalid:" + aGatewayURI));
        }
        this.srapJSSpec = new SRAPJSFunctionSpec(this.decoratedGatewayURI.getNetworkURI());
    }

    public JSFunctionSpec getJSFunctionSpec() {
        return this.srapJSSpec;
    }

    public String translate(String aOriginalURI, DecoratedURI aAbsoluteURI) {
        String lAbsoluteURIString = aAbsoluteURI.toExternalForm();
        if (lAbsoluteURIString.indexOf(63) > 0 && (lAbsoluteURIString.indexOf("ypburl") > 0 && this.isYahooURL(lAbsoluteURIString) || lAbsoluteURIString.indexOf(".done") > 0 && this.isYahooURL(lAbsoluteURIString))) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Orginal Query String : " + lAbsoluteURIString);
            }
            YahooTranslator yt = new YahooTranslator(this.req);
            int queryIndex = lAbsoluteURIString.indexOf(63);
            lAbsoluteURIString = lAbsoluteURIString.substring(0, queryIndex) + yt.translateQueryString(aAbsoluteURI.getQuery());
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Rewritten Query String : " + lAbsoluteURIString);
            }
        }
        if (!this.needs2Translate(aAbsoluteURI, lAbsoluteURIString)) {
            return lAbsoluteURIString;
        }
        return this.prefixGateway(aAbsoluteURI, lAbsoluteURIString);
    }

    protected String prefixGateway(DecoratedURI aAbsoluteURI, String aAbsoluteURIString) {
        if (aAbsoluteURIString.toLowerCase().startsWith(this.decoratedGatewayURI.getNetworkURI().toLowerCase()) && this.decoratedGatewayURI.getPort() == aAbsoluteURI.getPort()) {
            return aAbsoluteURIString;
        }
        String netURI = this.decoratedGatewayURI.getNetworkURI();
        StringBuffer sb = new StringBuffer(netURI.length() + aAbsoluteURIString.length() + 1);
        return sb.append(netURI).append("/").append(aAbsoluteURIString).toString();
    }

    protected String prefixGateway(String aAbsoluteURIString) {
        try {
            if (aAbsoluteURIString.toLowerCase().startsWith(this.decoratedGatewayURI.getNetworkURI().toLowerCase()) && this.decoratedGatewayURI.getPort() == new DecoratedURI(aAbsoluteURIString).getPort()) {
                return aAbsoluteURIString;
            }
            try {
                String decodedURI = URLDecoder.decode(aAbsoluteURIString);
                if (decodedURI.toLowerCase().startsWith(this.decoratedGatewayURI.getNetworkURI().toLowerCase()) && this.decoratedGatewayURI.getPort() == new DecoratedURI(decodedURI).getPort()) {
                    return aAbsoluteURIString;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String netURI = this.decoratedGatewayURI.getNetworkURI();
            StringBuffer sb = new StringBuffer(netURI.length() + aAbsoluteURIString.length() + 1);
            return sb.append(netURI).append("/").append(aAbsoluteURIString).toString();
        }
        catch (Exception e) {
            return aAbsoluteURIString;
        }
    }

    private boolean needs2Translate(DecoratedURI aAbsoluteURI, String aAbsoluteURIString) {
        String lLowerCaseProtocol = aAbsoluteURI.getProtocol().toLowerCase();
        String lLowerCaseHost = aAbsoluteURI.getHost().toLowerCase();
        if (!lLowerCaseProtocol.equals("http") && !lLowerCaseProtocol.equals("https") || lLowerCaseHost.equals("localhost") || lLowerCaseHost.equals("127.0.0.1")) {
            return false;
        }
        if (SRAPConfigManager.isIntranet(lLowerCaseHost)) {
            return true;
        }
        return this.lookAheadInfo.isSRC() && lLowerCaseProtocol.equals("http") && this.decoratedGatewayURI.getProtocol().equalsIgnoreCase("https");
    }

    private boolean isYahooURL(String url) {
        return url.indexOf(this.yahooEditServer) >= 0;
    }
}

