/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.jsp.tab.util;

import com.sun.portal.desktop.util.I18n;
import com.sun.portal.providers.containers.jsp.tab.ModifiableTab;
import com.sun.portal.providers.containers.jsp.tab.util.TabException;
import java.util.HashMap;
import java.util.Map;

class Tab
implements ModifiableTab {
    protected String name = null;
    protected String displayname = null;
    protected String desc = null;
    protected boolean removable = false;
    protected boolean renamable = false;
    protected boolean predefined = true;

    Tab(String n, String d, String dn, boolean rem, boolean ren, boolean pd) throws TabException {
        this.name = n;
        this.desc = d;
        this.displayname = dn;
        this.removable = rem;
        this.renamable = ren;
        this.predefined = pd;
    }

    Tab(String t, Map props) throws TabException {
        if (props.containsKey(t)) {
            Map tab = (Map)props.get(t);
            this.create(t, tab);
        } else {
            this.name = t;
            this.displayname = t;
            this.desc = t;
        }
    }

    private void create(String t, Map tab) throws TabException {
        this.name = t;
        this.removable = (Boolean)tab.get("removable");
        this.renamable = (Boolean)tab.get("renamable");
        this.predefined = (Boolean)tab.get("predefined");
        this.displayname = (String)tab.get("title");
        this.desc = (String)tab.get("desc");
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public boolean isRenamable() {
        return this.renamable;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String n) {
        this.displayname = n;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String d) {
        this.desc = d;
    }

    public String getEncodedName() {
        return I18n.IURLEncode((String)this.name);
    }

    public Map getTabMap() {
        HashMap<String, Object> tabMap = new HashMap<String, Object>();
        tabMap.put("title", this.getDisplayname());
        tabMap.put("desc", this.getDesc());
        tabMap.put("removable", new Boolean(this.isRemovable()));
        tabMap.put("renamable", new Boolean(this.isRenamable()));
        tabMap.put("predefined", new Boolean(this.isPredefined()));
        return tabMap;
    }
}

