function $CONVERT_EXPRESSION( aURI )
{
    var requestHomeURI = '$REQUEST_HOME_URI';
    var requestBaseURI = '$REQUEST_BASE_URI';
    var gatewayHomeURI = '$GATEWAY_HOME_URI';

    if( aURI == null ||
	'string' != ( typeof aURI ) )
    {
	return aURI;
    }

    var splitArray = psSplit( aURI );
    if( splitArray[1].length == 0 ||
	splitArray[1].indexOf( '#' ) == 0 )
    {
	return aURI;
    }

    var lURI;
    var lProtocol = psGetProtocol( splitArray[1] );
    if( lProtocol != -1 )
    {
	//absolute URL
        var bDefaultPort = psGetDefaultPort( lProtocol );
	if( bDefaultPort == -1 )
	{
	    //protocol is other than 'http' or 'https'
	    return aURI;
	}
	else
	{
	    lURI = psNormalizePort( splitArray[1], bDefaultPort );
	}
    }
    else
    {
	//check if this starts with '/'
	if ( splitArray[1].charAt( 0 ) == '/' )
	{
	    lURI = requestHomeURI + splitArray[1];
	}
	else
	{
	    //check if this is relative path
	    if ( ( splitArray[1].charAt(0) == '.' ) ||
		 ( splitArray[1].charAt( splitArray[1].length - 1 ) == '.' ) )
	    {
	       lURI = requestBaseURI + splitArray[1];
	    }
	    else
	    {
		//this mean that URI does not start with . or / but like dir/abc.html
		lURI = requestBaseURI + splitArray[1];
	    }
	}
    }

    var lowerURI = lURI.toLowerCase();
    if ( (lowerURI.indexOf('http://127.0.0.1') == 0) ||
	 (lowerURI.indexOf('https://127.0.0.1') == 0) ||
	 (lowerURI.indexOf('http://localhost') == 0) ||
	 (lowerURI.indexOf('https://localhost') == 0) )
    {
	return aURI;
    }

    var refNetworkURI = psGetNetworkURI( lowerURI );
    if ( refNetworkURI.indexOf( gatewayHomeURI.toLowerCase() ) == 0 &&
         gatewayHomeURI.toLowerCase().indexOf( refNetworkURI ) == 0 )
    {
	return lURI;
    }

    //After converting to Absolute check the protocol..
    var kProtocol = psGetProtocol( lURI );
    if( kProtocol != null )
    {
	//absolute URL
        var bDefaultPort = psGetDefaultPort( kProtocol );
	if( bDefaultPort == -1 )
	{
	    //protocol is other than 'http' or 'https'
	    return aURI;
	}
    }

    return splitArray[0] + gatewayHomeURI + '/redirect/' + lURI + splitArray[2];
}//$CONVERT_EXPRESSION()
