/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.EProxyConfigConstants;
import com.sun.portal.netlet.eproxy.EProxyConnection;
import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.netlet.eproxy.PlatformConfigConstants;
import com.sun.portal.netlet.eproxy.RProxyConnection;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.server.HTTPConnectionManager;
import com.sun.portal.rproxy.server.ReverseProxy;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EProxy
implements EProxyConfigConstants,
PlatformConfigConstants {
    static final String watchdogInfoFileBase = "/var/opt/SUNWps/.gw.";
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$RewriterAdopter;

    public static void main(String[] argv) {
        int eproxyport;
        boolean onlyRProxy;
        boolean bl = onlyRProxy = !GatewayProfile.getBoolean("EProxyEnable", true);
        if (GWLogManager.loggingEnabled) {
            GWLogManager.write("EProxy", GWLocale.getPFString("StartEProxy"));
        }
        boolean httpMode = GatewayProfile.getBoolean("EProxyEnableHTTP", false);
        boolean httpsMode = GatewayProfile.getBoolean("EProxyEnableHTTPS", true);
        int httpPort = GatewayProfile.getInt("EProxyHTTPPort", 80);
        int httpsPort = GatewayProfile.getInt("EProxyHTTPSPort", 443);
        HTTPConnectionManager connectionManager = null;
        if (!httpMode && !httpsMode) {
            return;
        }
        EProxy.writePortInfoForWatchdog(httpMode, httpsMode, httpPort, httpsPort);
        if (onlyRProxy) {
            EProxy.handleNoEProxy(httpMode, httpsMode, httpPort, httpsPort);
        }
        if (httpsMode) {
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("RProxy", GWLocale.getPFString("StartRProxy"));
            }
            new ReverseProxy();
        }
        if (httpMode) {
            connectionManager = new HTTPConnectionManager(httpPort);
        }
        if (httpMode && httpsMode) {
            GW.setNumberOfInstances(2);
            final int tmpHttpsPort = httpsPort;
            Runnable r = new Runnable(){

                public void run() {
                    new EProxyConnection(tmpHttpsPort, null);
                }
            };
            Thread thr = new Thread(r);
            thr.start();
            eproxyport = httpPort;
        } else {
            GW.setNumberOfInstances(1);
            eproxyport = httpMode ? httpPort : httpsPort;
        }
        new EProxyConnection(eproxyport, connectionManager);
    }

    private static void writePortInfoForWatchdog(boolean httpMode, boolean httpsMode, int httpPort, int httpsPort) {
        block5: {
            File watchdogInfoFile = new File(watchdogInfoFileBase + System.getProperty("conf.suffix"));
            if (watchdogInfoFile.exists()) {
                watchdogInfoFile.delete();
            }
            try {
                FileWriter fw = new FileWriter(watchdogInfoFile);
                if (httpMode) {
                    fw.write(httpPort + "\n");
                }
                if (httpsMode) {
                    fw.write(httpsPort + "\n");
                }
                fw.flush();
                fw.close();
            }
            catch (IOException ex) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("Unable to enter information for watchdog information");
            }
        }
    }

    private static void handleNoEProxy(boolean httpMode, boolean httpsMode, int httpPort, int httpsPort) {
        HTTPConnectionManager connectionManager = null;
        if (httpsMode) {
            ReverseProxy rprxy;
            if (httpMode) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("No EProxy. HTTPS Mode being initialised : HTTP also present !");
                }
                GW.setNumberOfInstances(2);
                rprxy = new ReverseProxy();
                Runnable r = new Runnable(){

                    public void run() {
                        RProxyConnection rpconn = new RProxyConnection(rprxy.getConnectionManager());
                        rpconn.accept();
                    }
                };
                Thread thr = new Thread(r);
                thr.start();
            } else {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("No EProxy. HTTPS Mode being initialised : Only HTTPS present !");
                }
                GW.setNumberOfInstances(1);
                rprxy = new ReverseProxy();
                RProxyConnection rpconn = new RProxyConnection(rprxy.getConnectionManager());
                rpconn.accept();
                EProxy.exit(1);
            }
        }
        if (httpMode) {
            connectionManager = new HTTPConnectionManager(httpPort);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("No EProxy. HTTP Mode being initialised");
            }
            RProxyConnection rpconn = new RProxyConnection(connectionManager, httpPort);
            rpconn.accept();
            EProxy.exit(1);
        }
    }

    public static void exit(int status) {
        System.exit(status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer logsb;
        GWDebug.createDefault("srapGateway");
        if (!GWNSSInit.initialize()) {
            System.exit(1);
        }
        ServiceIdentifier.createDefault("srapGateway");
        try {
            String profileName = System.getProperty("gateway.profilename", "default");
            GatewayProfile.init("this-should-be-sid", profileName);
            PlatformProfile.init("this-should-be-sid");
            Class clazz = class$com$sun$portal$rproxy$connectionhandler$RewriterAdopter == null ? (class$com$sun$portal$rproxy$connectionhandler$RewriterAdopter = EProxy.class$("com.sun.portal.rproxy.connectionhandler.RewriterAdopter")) : class$com$sun$portal$rproxy$connectionhandler$RewriterAdopter;
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to initialize GatewayProfile/PlatformProfile", e);
            }
            System.exit(1);
        }
        if (GWLogManager.loggingEnabled) {
            logsb = new StringBuffer();
            logsb.append("srapGateway_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            GWLogManager.createDefault(logsb.toString());
        }
        if (NetletLogMgr.loggingEnabled) {
            logsb = new StringBuffer();
            logsb.append("srapNetlet_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            NetletLogMgr.createDefault(logsb.toString());
        }
        GWLocale.createDefault();
        GWThreadPool.init();
    }
}

