/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.crypt.ciph.CipherGroup;
import com.sun.portal.netlet.econnection.DataCipherMsg;
import com.sun.portal.netlet.econnection.MessageConstants;
import com.sun.portal.netlet.econnection.ReaderWriterCrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;

public class ReaderWriterEncrypt
extends ReaderWriterCrypt
implements MessageConstants {
    private long activityTime = System.currentTimeMillis();
    private int netletKeepAliveInterval = 0;

    public ReaderWriterEncrypt(ReaderWriterLock l, CipherGroup cg, Socket fs, Socket ts, int netletKeepAliveInterval) {
        super(l, cg, fs, ts);
        this.netletKeepAliveInterval = netletKeepAliveInterval;
        if (netletKeepAliveInterval > 0) {
            try {
                fs.setSoTimeout(netletKeepAliveInterval * 60000);
            }
            catch (SocketException se) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            int numBytes = 0;
            byte[] buffer = new byte[8192];
            DataCipherMsg dMsg = new DataCipherMsg(this.ciphergroup);
            while (this.go) {
                try {
                    numBytes = this.in.read(buffer, 0, 4096);
                    if (numBytes > 0) {
                        dMsg.setDataByRef(buffer, numBytes);
                        if (dMsg.writeMsg(this.out) != 0) continue;
                        this.sent = true;
                        this.activityTime = System.currentTimeMillis();
                        continue;
                    }
                    if (numBytes == 0) {
                        System.out.println("ReaderWriterEncrypt received 0 bytes");
                        continue;
                    }
                    this.go = false;
                    Object var7_7 = null;
                    this.stop();
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
                catch (InterruptedIOException iioe) {
                    int rc = this.writeDummyMsg(this.out);
                    if ((this.netletKeepAliveInterval <= 0 || this.rwLock.getLastActivityTime() <= 0L || System.currentTimeMillis() - this.rwLock.getLastActivityTime() < (long)(this.netletKeepAliveInterval * 60000)) && rc != -1) continue;
                    this.go = false;
                    Object var7_8 = null;
                    this.stop();
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
                catch (Exception e) {
                    System.out.println("ReaderWriterEncrypt caught exception:");
                    e.printStackTrace();
                    this.go = false;
                    Object var7_9 = null;
                    this.stop();
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.stop();
            this.rwLock.notifyFinished(this);
            this.rwLock = null;
            throw throwable;
        }
        Object var7_10 = null;
        this.stop();
        this.rwLock.notifyFinished(this);
        this.rwLock = null;
    }

    protected int writeDummyMsg(DataOutputStream out) {
        try {
            out.writeByte(1);
            out.writeShort(4);
            out.writeInt(0);
            out.writeInt(0);
        }
        catch (IOException ioe) {
            System.out.println("ReaderWriterEncrypt caught exception while sending dummy msg:");
            ioe.printStackTrace();
            return -1;
        }
        return 0;
    }

    public long getLastActivityTime() {
        return this.activityTime;
    }
}

