/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.server;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.server.HTTPConnectionManager;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;

public class HTTPSConnectionManager
extends HTTPConnectionManager {
    static final String PORT = "RProxyPort";
    static final String TIMEOUT = "RProxyPortTimeout";
    static final String HTTPPROXY_PORT = "HTTPProxyPort";
    public static int rProxyPort = 0;
    static final int DEFAULT_TIMEOUT = 1000;
    static final int HTTPPROXY_DEFAULT_PORT = 10443;
    private static boolean allow40bitBrowser;
    private static boolean enableSSLV2;
    private static boolean individualCipherSelectionMode;
    private static List enabledSSL2CipherList;
    private static List enabledSSL3CipherList;
    private static List enabledTLSCipherList;
    private SSLServerSocket _ss;
    private static int _httpproxyport;
    private int _timeout;
    private boolean onlyRProxy = false;

    public HTTPSConnectionManager(int port) {
        super(port);
        this.protocol = "https";
    }

    public HTTPSConnectionManager(int port, boolean createServerSocketSocket) {
        super(port);
        this.protocol = "https";
        if (createServerSocketSocket) {
            this.onlyRProxy = true;
            this._ss = this.makeServerSocket();
        }
    }

    public void setName(String n) {
        super.setName(n);
        this._timeout = GatewayProfile.getInt(TIMEOUT, 1000);
    }

    public void listen() {
        this._ss = this.makeServerSocket();
        if (this._ss == null) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error(this.getName() + ":" + "Service Network Error " + PORT);
            }
            return;
        }
        Integer logid = new Integer(0);
        while (true) {
            try {
                Socket sock = this._ss.accept();
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementSSLSockets();
                }
                this.processConnection(sock, logid, null);
                continue;
            }
            catch (Throwable t) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error(this.getName() + "ERROR: HTTPSConnectionManager caught unexpected exception", t);
                continue;
            }
            break;
        }
    }

    private SSLServerSocket makeServerSocket() {
        SSLServerSocket sock;
        block30: {
            boolean doingPDC;
            SSLServerSocket.configServerSessionIDCache((int)15000, (int)86400, (int)86400, null);
            if (individualCipherSelectionMode) {
                int i;
                GWNSSInit.disableAllCiphers();
                int size = 0;
                if (enabledSSL2CipherList != null) {
                    size = enabledSSL2CipherList.size();
                    i = 0;
                    while (i < size) {
                        this.enableCipher((String)enabledSSL2CipherList.get(i));
                        ++i;
                    }
                }
                if (enabledSSL3CipherList != null) {
                    size = enabledSSL3CipherList.size();
                    i = 0;
                    while (i < size) {
                        this.enableCipher((String)enabledSSL3CipherList.get(i));
                        ++i;
                    }
                }
                if (enabledTLSCipherList != null) {
                    size = enabledTLSCipherList.size();
                    i = 0;
                    while (i < size) {
                        this.enableCipher((String)enabledTLSCipherList.get(i));
                        ++i;
                    }
                }
            } else {
                if (!enableSSLV2) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites128BitSSL2);
                }
                if (!allow40bitBrowser) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersTLS);
                } else if (!enableSSLV2) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                }
            }
            sock = null;
            int qlen = GatewayProfile.getInt("EProxyConnectionQueue", 50);
            String _address = SystemProperties.get("gateway.bindipaddress");
            try {
                if (ServiceIdentifier.isGateway()) {
                    Object tmpSS = null;
                    if (this.onlyRProxy) {
                        rProxyPort = GatewayProfile.getInt("EProxyHTTPSPort", 443);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPSConnectionManager: port number = " + rProxyPort);
                        }
                        sock = _address == null ? new SSLServerSocket(rProxyPort, qlen) : new SSLServerSocket(rProxyPort, qlen, InetAddress.getByName(_address));
                    } else {
                        sock = new SSLServerSocket(0, qlen);
                        rProxyPort = sock.getLocalPort();
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPSConnectionManager: port number = " + rProxyPort);
                        }
                    }
                } else {
                    sock = new SSLServerSocket(_httpproxyport, qlen, InetAddress.getByName(_address));
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("HTTPSConnectionManager: nickname = " + GWNSSInit.nickname);
                }
                sock.setServerCertNickname(GWNSSInit.nickname);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementServerSockets();
                }
            }
            catch (UnknownHostException ue) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTSConnectionManager localhost unknown host", ue);
                }
                sock = null;
            }
            catch (IOException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTSConnectionManager cannot create server socket", e);
                }
                sock = null;
            }
            String rphost = SystemProperties.get("gateway.host", null);
            List certSet = GatewayProfile.getStringList("CertificateEnabledList");
            ArrayList<String> certSet_lc = new ArrayList<String>();
            Iterator it = certSet.iterator();
            while (it.hasNext()) {
                String host = (String)it.next();
                certSet_lc.add(host.toLowerCase());
            }
            boolean bl = doingPDC = certSet_lc.contains(rphost.toLowerCase()) && ServiceIdentifier.isGateway();
            if (doingPDC) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Doing PDC");
                }
                try {
                    sock.requestClientAuth(true);
                }
                catch (SocketException se) {
                    if (!GWDebug.debug.errorEnabled()) break block30;
                    GWDebug.debug.error("Unable to request client authentication");
                }
            }
        }
        return sock;
    }

    private void enableCipher(String cipher) {
        if (!enableSSLV2 && cipher.toLowerCase().indexOf("ssl2") != -1) {
            return;
        }
        cipher = cipher.trim();
        if (!allow40bitBrowser && (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5") || cipher.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5") || cipher.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5") || cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA") || cipher.equalsIgnoreCase("TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA"))) {
            return;
        }
        if (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65283, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC4_128_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65281, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_3DES_EDE_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)10, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_MD5")) {
            SSLSocket.setCipherPreference((int)4, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_SHA")) {
            SSLSocket.setCipherPreference((int)5, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65284, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65282, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5")) {
            SSLSocket.setCipherPreference((int)3, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5")) {
            SSLSocket.setCipherPreference((int)6, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreference((int)65286, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)9, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5")) {
            SSLSocket.setCipherPreference((int)1, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)98, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA")) {
            SSLSocket.setCipherPreference((int)100, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreference((int)99, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA")) {
            SSLSocket.setCipherPreference((int)101, (boolean)true);
        }
    }

    public ServerSocket getServerSocket() {
        return this._ss;
    }

    static {
        enableSSLV2 = true;
        enabledSSL2CipherList = null;
        enabledSSL3CipherList = null;
        enabledTLSCipherList = null;
        _httpproxyport = 10443;
        String tmpstr = GatewayProfile.getString("Allow40BitConnections", "true");
        allow40bitBrowser = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableSSLv2", "true");
        enableSSLV2 = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableIndividualCipherSelectionMode", "false");
        individualCipherSelectionMode = tmpstr.equals("true");
        if (individualCipherSelectionMode) {
            enabledSSL2CipherList = GatewayProfile.getStringList("EnabledSSL2CipherList");
            enabledSSL3CipherList = GatewayProfile.getStringList("EnabledSSL3CipherList");
            enabledTLSCipherList = GatewayProfile.getStringList("EnabledTLSCipherList");
        }
        if (!ServiceIdentifier.isGateway()) {
            _httpproxyport = GatewayProfile.getInt(HTTPPROXY_PORT, 10443);
        }
    }
}

