/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.PLLNotificationServlet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.perf.rproxy.TimerData;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.Base64;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.DomainWebProxyConfig;
import com.sun.portal.rproxy.connectionhandler.ErrorResponse;
import com.sun.portal.rproxy.connectionhandler.GatewayServletResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.RedirectResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.RetrievalFactory;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.rproxy.connectionhandler.RewriterAdopter;
import com.sun.portal.rproxy.connectionhandler.ServersList;
import com.sun.portal.rproxy.connectionhandler.StatisticsResponse;
import com.sun.portal.rproxy.connectionhandler.URLTranslator;
import com.sun.portal.util.Debug;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLSocket;

public abstract class Session {
    protected Socket _theSocket;
    protected boolean _moreElements = true;
    protected Integer _logId;
    protected static String _platformloginURL;
    protected static String _platformlogoutURL;
    protected static boolean _useHTTPProxy;
    protected static String _hpport;
    protected static String _hpprot;
    protected static String rphost;
    protected static List srapGateway_certificateEnabledList_lc;
    private static List virtualHost;
    private static List nonAuthPathList;
    protected String _gwport;
    protected String _gwprotocol;
    protected int port;
    private static int _numRequests;
    public static int _numBytesRead;
    public static int _numBytesSent;
    private static final String UNKNOWN_HOST = "Unknown Host";
    private static Debug server_traffic;
    private static Debug browser_traffic;
    static final String defaultLocale;
    static final String exceptionErrorMessage = "ExceptionErrorMessage";
    static final String notificationErrorMessage = "NotificationErrorMessage";
    static final String invalidGatewayHostNameErrorMessage = "InvalidGatewayHostNameErrorMessage";
    static final String accessDeniedErrorMessage = "AccessDeniedErrorMessage";
    static final String webProxErrorMessage = "WebProxErrorMessage";
    static final String hostConnectErrorMessage = "HostConnectErrorMessage";
    static final String loginToAnotherOrg = "LoginToAnotherOrg";
    private static final boolean isPerSessionLoggingEnabled;
    private static final boolean detailedRproxLog;
    private Socket actualClientSocket = null;
    private static final int DEFAULT_TIMEOUT = 60000;
    protected final int readTimeout = GatewayProfile.getInt("RProxyPortTimeout", 60000);
    protected int this_req = 0;
    public static final boolean processKeepAliveConnections;
    private static final int timeoutseconds;
    public static final int GRACE_PERIOD;
    public static final long maxTimeOutSetting;
    private int MAX_PER_SESS = GatewayProfile.getInt("EProxyKeepAliveMaxConnection", 10);
    public static final long THREAD_SLEEP_TIME = 50L;
    private long nullTimeout = maxTimeOutSetting;
    protected boolean thisreqKeepAlive = processKeepAliveConnections;
    protected boolean doingPDC;
    static final String defDomain;
    static final String sessionCookieName;
    static final int sessionCookieLen;
    protected static String defaultOrg;
    protected boolean pdcHeaderFound;
    protected boolean initiatePDC;
    protected boolean invalidateSSL;
    private static String gwDomain;
    private static final String PDC_COOKIE_HEADER = "DoPDC@";
    private static List serverList;
    private static final String notificationURL;
    static List expandedSessionServersList;

    public Session(Socket s) {
        this._theSocket = s;
        this.getLoggingInfo();
    }

    public Session(Socket s, String ip) {
        this._theSocket = s;
        this.getLoggingInfo();
    }

    private void getLoggingInfo() {
        Object tmp = GWLogManager.logIdMap.remove(new Integer(this._theSocket.getPort()));
        if (tmp != null) {
            LogInfoContainer info = (LogInfoContainer)tmp;
            this._logId = info.getLogID();
            this.actualClientSocket = info.getClientSocket();
        }
    }

    public boolean isStillActive() {
        return this._moreElements;
    }

    public void setStillActive(boolean v) {
        this._moreElements = v;
    }

    public abstract Request getRequest();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void processNextRequest() {
        block92: {
            block87: {
                initialtime = 0L;
                if (Session.processKeepAliveConnections) {
                    initialtime = System.currentTimeMillis();
                }
                req = this.getRequest();
                rep = null;
                loop = true;
                repeatCount = 0;
                ++Session._numRequests;
                rep_code = null;
                responseLength = 0;
                if (Session.browser_traffic.messageEnabled() && req != null) {
                    Session.browser_traffic.message("Request sent from Browser:\n" + req);
                }
                if (req != null && (gwhost = req.getGatewayHost()) != null) {
                    fqdnHost = this.getFQDN(gwhost);
                    GWDebug.debug.message("FQDN -> " + fqdnHost + " , gwhost -> " + gwhost + " , rphost -> " + Session.rphost);
                    if (fqdnHost != null && !gwhost.equalsIgnoreCase(Session.rphost)) {
                        buff = new StringBuffer();
                        buff.append(this._gwprotocol).append("://").append(fqdnHost);
                        if (this._gwprotocol.equalsIgnoreCase("http")) {
                            if (!this._gwport.equals("80")) {
                                buff.append(':').append(this._gwport);
                            }
                        } else if (!this._gwport.equals("443")) {
                            buff.append(':').append(this._gwport);
                        }
                        buff.append('/');
                        newGatewayURL = buff.toString();
                        GWDebug.debug.message("newGatewayURL -> " + newGatewayURL);
                        req.setGatewayURL(newGatewayURL);
                    }
                }
                this.processKeepAlive(initialtime, req);
                if (PerfContextObject.ENABLE_PERF) {
                    context = PerfContextObject.getPerfContext();
                    td = new TimerData("Session.java , after getting request object");
                    context.record(td);
                }
                this.initiatePDC = false;
                this.invalidateSSL = false;
                this.pdcHeaderFound = false;
                while (true) {
                    block91: {
                        if (!loop) {
                            if (!Session.isPerSessionLoggingEnabled) break block87;
                        }
                        this.initiatePDC = false;
                        this.invalidateSSL = false;
                        this.pdcHeaderFound = false;
                        sid = null;
                        if (this.doingPDC) {
                            sid = req.getSessionID();
                            if (sid != null) {
                                try {
                                    sid = URLDecoder.decode(sid);
                                }
                                catch (Exception ex) {
                                    sid = null;
                                }
                            }
                            if (sid != null && sid.startsWith("DoPDC@")) {
                                this.removePDCCookie(req);
                                this.pdcHeaderFound = true;
                            }
                        }
                        if (req != null) {
                            block90: {
                                block89: {
                                    if (GWDebug.debug.messageEnabled()) {
                                        GWDebug.debug.message("Session: processNextRequest checking for " + req.getURI() + "\nobject: " + req.getObject());
                                    }
                                    if (GWLogManager.loggingEnabled) {
                                        GWLogManager.write("RProxy", GWLocale.getPFString("session1", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), req.getURI()}));
                                    }
                                    if (req.getGatewayScheme().equals(Session.notificationURL)) {
                                        rep = this.processNotificationRequest(req);
                                        if (rep == null) {
                                            this.setStillActive(false);
                                            return;
                                        }
                                    } else if (req.getGatewayScheme().equals("statistics")) {
                                        rep = this.processStatisticsRequest(req);
                                    } else if (req.getObject().length() == 0 && req.getProtocol() != null) {
                                        rep = this.processMissingObjectRequest(req);
                                    } else {
                                        block88: {
                                            try {
                                                if (req.getProtocol() == null) {
                                                    rep = this.processMissingProtocolRequest(req);
                                                    break block88;
                                                }
                                                if (this.doingPDC && req.getObject().startsWith(Session._platformloginURL)) {
                                                    if (this.pdcHeaderFound || sid == null) {
                                                        this.initiatePDC = true;
                                                    }
                                                    if (!this.hostFound(req.getURI())) {
                                                        rep = this.processProtocolRequest(req);
                                                        break block88;
                                                    }
                                                    if (this.initiatePDC) {
                                                        rep = this.processMissingProtocolRequest(req);
                                                        break block88;
                                                    }
                                                    if (this.doingPDC && this.pdcHeaderFound) {
                                                        this.invalidateSSL = true;
                                                        rep = new RedirectResponse(this.loginURL(req, Session._platformloginURL));
                                                        break block88;
                                                    } else {
                                                        rep = this.processProtocolRequest(req);
                                                    }
                                                    break block88;
                                                }
                                                rep = this.processProtocolRequest(req);
                                            }
                                            catch (Exception ex) {
                                                if (GWDebug.debug.errorEnabled()) {
                                                    GWDebug.debug.error("Cannot process protocol request", ex);
                                                }
                                                message = ex.toString();
                                                language = req.getRequestHeader("Accept-Language");
                                                if ("ExceptionErrorMessage".length() > 0) {
                                                    userLocale = this.getUserLocale(req);
                                                    message = GWLocale.getPFString("ExceptionErrorMessage", new Object[]{message}, userLocale);
                                                }
                                                rep = new ErrorResponse(message, null, language);
                                            }
                                        }
                                        if (GWDebug.debug.messageEnabled()) {
                                            GWDebug.debug.message("Session: Request:\n" + req + "Response\n" + rep);
                                        }
                                    }
                                    if (GWLogManager.loggingEnabled) {
                                        GWLogManager.write("RProxy", GWLocale.getPFString("session2", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), new Integer(req.getSize())}));
                                    }
                                    if (Session.server_traffic.messageEnabled()) {
                                        Session.server_traffic.message("--> Session: Request:\n" + req + "Response\n" + rep);
                                    }
                                    rep.setClientCaching();
                                    cont = true;
                                    out = null;
                                    in = null;
                                    try {
                                        try {
                                            needsTranslation = false;
                                            rep_code = rep.getStatusCode();
                                            if (ServiceIdentifier.isGateway() && rep_code != null && !rep_code.startsWith("1") && !rep_code.startsWith("204") && !rep_code.startsWith("304")) {
                                                needsTranslation = true;
                                            }
                                            if (!needsTranslation) {
                                                if (GWDebug.debug.warningEnabled()) {
                                                    GWDebug.debug.warning(" ************* No Translator available");
                                                }
                                                contentLength = rep.getResponseHeader("Content-length");
                                                in = rep.getContentStream();
                                                if (contentLength == null) {
                                                    this.thisreqKeepAlive = false;
                                                }
                                            } else {
                                                if (GWDebug.debug.messageEnabled()) {
                                                    GWDebug.debug.message(" ************* Got Translator");
                                                }
                                                in = RewriterAdopter.rewrite(rep, req);
                                                if (GWDebug.debug.messageEnabled()) {
                                                    GWDebug.debug.message(" ************* Translated!!!");
                                                }
                                                if (in != null) {
                                                    rep.setContentLength(in.available());
                                                } else if (repeatCount < 3) {
                                                    ++repeatCount;
                                                    var20_30 = null;
                                                    break block89;
                                                }
                                            }
                                            if (this.thisreqKeepAlive) {
                                                rep.setConnectionAlive(" timeout=" + Session.timeoutseconds + ",max=" + (this.MAX_PER_SESS - this.this_req));
                                            } else {
                                                rep.setConnectionClose();
                                                this.setStillActive(false);
                                            }
                                            if (ServiceIdentifier.isGateway()) {
                                                this.translateHeader(rep, req);
                                            }
                                            if (Session.browser_traffic.messageEnabled()) {
                                                Session.browser_traffic.message("Response sent back to Browser:\n" + rep);
                                            }
                                            out = this._theSocket.getOutputStream();
                                            headerBytes = rep.getHeaderBytes();
                                            Session._numBytesSent += headerBytes.length;
                                            responseLength += headerBytes.length;
                                            out.write(headerBytes);
                                            out.flush();
                                            if (rep_code == null || rep_code.startsWith("1") || rep_code.startsWith("204") || rep_code.startsWith("304")) break block90;
                                            readbytes = 0;
                                            b = new byte[2048];
                                            while (true) {
                                                if ((ready = in.read(b)) <= 0) {
                                                    Session._numBytesSent += readbytes;
                                                    responseLength += readbytes;
                                                    break block90;
                                                }
                                                readbytes += userLocale;
                                                out.write(b, 0, (int)userLocale);
                                                out.flush();
                                            }
                                        }
                                        catch (IOException ex) {
                                            try {
                                                out.flush();
                                                if (in instanceof CSBufferedInputStream) {
                                                    ((CSBufferedInputStream)in).getSocket().close();
                                                }
                                            }
                                            catch (Exception ex1) {
                                                // empty catch block
                                            }
                                            if (GWDebug.debug.warningEnabled()) {
                                                GWDebug.debug.warning("Session failed to respond to client", ex);
                                            }
                                            this.setStillActive(false);
                                            var20_30 = null;
                                            try {
                                                out.flush();
                                            }
                                            catch (Exception ex1) {}
                                            break block91;
                                        }
                                        catch (NullPointerException ex) {
                                            this.setStillActive(false);
                                            if (GWDebug.debug.warningEnabled()) {
                                                GWDebug.debug.warning("Session failed to respond to client", ex);
                                            }
                                            var20_30 = null;
                                            try {}
                                            catch (Exception ex1) {}
                                            out.flush();
                                            break block91;
                                        }
                                    }
                                    catch (Throwable var19_32) {
                                        var20_30 = null;
                                        ** try [egrp 5[TRYBLOCK] [6 : 1618->1626)] { 
lbl205:
                                        // 1 sources

                                        out.flush();
                                        throw var19_32;
lbl207:
                                        // 1 sources

                                        catch (Exception ex1) {
                                            // empty catch block
                                        }
                                        throw var19_32;
                                    }
                                }
                                try {}
                                catch (Exception ex1) {}
                                out.flush();
                                continue;
                            }
                            var20_30 = null;
                            try {}
                            catch (Exception ex1) {}
                            out.flush();
                        }
                    }
                    loop = false;
                }
                type = this._theSocket instanceof SSLSocket != false ? "https" : "http";
                fromAddress = this.actualClientSocket.getInetAddress().toString();
                destHost = req.getHost();
                if (Session.detailedRproxLog && req instanceof HTTPRequest) {
                    httpreq = (HTTPRequest)req;
                    method = httpreq.getMethod();
                    requestedUrl = httpreq.getURL();
                    sessidstr = null;
                    tmpsidstr = httpreq.getSessionID();
                    if (tmpsidstr != null) {
                        try {
                            tmpsidstr = URLDecoder.decode(tmpsidstr);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        token = this.getUserSession(req, tmpsidstr);
                        if (token != null) {
                            sessidstr = token.getTokenID().toString();
                        }
                    }
                    requestContentLength = null;
                    if (method.trim().toLowerCase().equals("post")) {
                        len = httpreq.getRequestHeader("Content-length");
                        len = len.substring(len.indexOf(58) + 1);
                        try {
                            requestContentLength = new Integer(Integer.parseInt(len));
                        }
                        catch (Exception ex) {}
                    } else {
                        requestContentLength = new Integer(0);
                    }
                    GWLogManager.write("RProxy", GWLocale.getPFString("RproxyPerRequestDetailedLogFormat", new Object[]{this._logId, new String(GWLogManager.getUserId(httpreq.getSessionID())), fromAddress, type, destHost, method, requestedUrl, requestContentLength, rep_code, new Integer(responseLength)}));
                } else {
                    GWLogManager.write("RProxy", GWLocale.getPFString("RproxyPerRequestLogFormat", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), fromAddress, type, destHost}));
                }
            }
            if (this.doingPDC && this.invalidateSSL) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SESSION:  INVALIDATE SSL");
                }
                try {
                    ((SSLSocket)this._theSocket).invalidateSession();
                }
                catch (SocketException se) {
                    if (!GWDebug.debug.errorEnabled()) break block92;
                    GWDebug.debug.error("Unable to invalidate SSL Session");
                }
            }
        }
        if (rep != null) {
            rep.closeSocket();
        }
        if (this.thisreqKeepAlive != false) return;
        this.setStillActive(false);
    }

    private void processKeepAlive(long initialtime, Request req) {
        this.thisreqKeepAlive = processKeepAliveConnections;
        if (processKeepAliveConnections) {
            if (req != null) {
                ++this.this_req;
                this.nullTimeout = maxTimeOutSetting;
                if (req instanceof HTTPRequest) {
                    String keepAliveHeader;
                    HTTPRequest httpreq = (HTTPRequest)req;
                    this.thisreqKeepAlive = this.this_req >= this.MAX_PER_SESS ? false : ((keepAliveHeader = httpreq.getRequestHeader("Connection")) != null ? !(keepAliveHeader = keepAliveHeader.substring(keepAliveHeader.indexOf(58) + 1).trim().toLowerCase()).equals("close") : httpreq.getHTTPVersion().toUpperCase().compareTo("HTTP/1.1") >= 0);
                    httpreq.setRequestHeader("Connection", "Connection: close\r\n");
                    this._moreElements = true;
                    if (!this.thisreqKeepAlive) {
                        if (this.this_req < this.MAX_PER_SESS && this.this_req > 1) {
                            this.thisreqKeepAlive = true;
                            this._moreElements = true;
                        } else {
                            this._moreElements = false;
                        }
                    }
                } else if (this.this_req < this.MAX_PER_SESS && this.this_req > 1) {
                    this.thisreqKeepAlive = true;
                    this._moreElements = true;
                } else {
                    this.thisreqKeepAlive = false;
                    this._moreElements = false;
                }
            } else {
                long timediff = System.currentTimeMillis() - initialtime;
                if (timediff < this.nullTimeout && timediff >= (long)(this.readTimeout / 2)) {
                    this._moreElements = true;
                    this.nullTimeout -= timediff;
                    boolean diffed = false;
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        diffed = true;
                        this.nullTimeout -= System.currentTimeMillis() - timediff;
                    }
                    if (!diffed) {
                        this.nullTimeout -= 50L;
                    }
                } else {
                    this.thisreqKeepAlive = false;
                    this._moreElements = false;
                }
            }
        } else if (req != null) {
            HTTPRequest httpreq = (HTTPRequest)req;
            httpreq.setRequestHeader("Connection", "Connection: close\r\n");
        }
        if (this.this_req > 1 && GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Reusing the socket for : " + this.this_req);
        }
    }

    private void translateHeader(Response rep, Request req) {
        boolean isExternal = req.getGatewayScheme().equals("external");
        if (rep instanceof RedirectResponse && !((RedirectResponse)rep).needTranslation()) {
            return;
        }
        String location = rep.getResponseHeader("Location:");
        if (location != null) {
            String result = URLTranslator.translateURL(location, rep, req, location.toLowerCase().startsWith("location:"), isExternal);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Translated from [" + location + "] to [" + result + "]");
            }
            rep.setLocation(result);
        }
        if (!(rep instanceof HTTPResponse)) {
            return;
        }
        String clocation = rep.getResponseHeader("Content-Location:");
        if (clocation != null) {
            String cresult = URLTranslator.translateURL(clocation, rep, req, clocation.toLowerCase().startsWith("content-location:"), isExternal);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Translated from [" + clocation + "] to [" + cresult + "]");
            }
            ((HTTPResponse)rep).setContentLocation(cresult);
        }
    }

    private Response processMissingObjectRequest(Request req) {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Session: Redirecting-> " + req.getURL());
        }
        String gwscheme = req.getGatewayScheme();
        StringBuffer redirectURL = new StringBuffer(100);
        redirectURL.append(this._gwprotocol).append("://");
        if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
            redirectURL.append(req.getGatewayHost()).append("/");
        } else {
            redirectURL.append(req.getGatewayHost()).append(":").append(this._gwport).append("/");
        }
        if (gwscheme.length() > 0) {
            redirectURL.append(gwscheme).append("/");
        }
        redirectURL.append(req.getURL()).append("/");
        return new RedirectResponse(redirectURL.toString(), false);
    }

    private Response processNotificationRequest(Request req) {
        Object rep;
        block3: {
            rep = null;
            try {
                DataOutputStream dos = new DataOutputStream(this._theSocket.getOutputStream());
                GatewayServletResponse gsrep = new GatewayServletResponse(dos);
                PLLNotificationServlet notify = new PLLNotificationServlet();
                notify.doPost((HttpServletRequest)req, (HttpServletResponse)gsrep);
                rep = null;
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Exception in processing notification request: " + ex);
                }
                String language = req.getRequestHeader("Accept-Language");
                String msg = "Session: Unable to process notification";
                if (notificationErrorMessage == null || notificationErrorMessage.length() <= 0) break block3;
                String userLocale = this.getUserLocale(req);
                msg = GWLocale.getPFString(notificationErrorMessage, new Object[]{msg}, userLocale);
            }
        }
        return rep;
    }

    private Response processStatisticsRequest(Request req) {
        StringBuffer message = new StringBuffer(50);
        message.append("<html>");
        String uri = req.getURI();
        String params = uri.startsWith("/statistics/") && uri.length() > 12 ? uri.substring(12) : "req&read&sent";
        if (params.equals("reset")) {
            _numRequests = 0;
            _numBytesRead = 0;
            HTTPRetriever.numBytesRead = 0;
            _numBytesSent = 0;
            message.append("<p>Reset is ok.</p></html>");
            return new StatisticsResponse(message.toString());
        }
        StringTokenizer st = new StringTokenizer(params, "&");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            if (param.equals("req")) {
                message.append("<p>Number of Requests: ").append(_numRequests).append("</p>");
                continue;
            }
            if (param.equals("read")) {
                message.append("<p>Number of Bytes Read: ").append(_numBytesRead + HTTPRetriever.numBytesRead).append("</p>");
                continue;
            }
            if (!param.equals("sent")) continue;
            message.append("<p>Number of Bytes Sent: ").append(_numBytesSent).append("</p>");
        }
        message.append("</html>");
        return new StatisticsResponse(message.toString());
    }

    private Response processMissingProtocolRequest(Request req) {
        String gwhost = req.getGatewayHost();
        String fqdnhost = this.getFQDN(gwhost);
        if (fqdnhost == null) {
            String message = gwhost;
            String language = req.getRequestHeader("Accept-Language");
            if (invalidGatewayHostNameErrorMessage != null && invalidGatewayHostNameErrorMessage.length() > 0) {
                String userLocale = this.getUserLocale(req);
                message = GWLocale.getPFString(invalidGatewayHostNameErrorMessage, new Object[]{message}, userLocale);
            } else {
                message = message + " is not a valid gateway host name.";
            }
            return new ErrorResponse(message, null, language);
        }
        if (!gwhost.equalsIgnoreCase(fqdnhost)) {
            if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
                return new RedirectResponse(this._gwprotocol + "://" + fqdnhost + req.getURI(), false);
            }
            return new RedirectResponse(this._gwprotocol + "://" + fqdnhost + ":" + this._gwport + req.getURI(), false);
        }
        if (!this.doingPDC) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: not doing PDC");
            }
            return new RedirectResponse(this.loginURL(req, _platformloginURL));
        }
        boolean doingCert = false;
        String tmpurl = req.getURL();
        if (tmpurl != null && tmpurl.trim().toLowerCase().indexOf("module=cert") != -1) {
            doingCert = true;
        }
        if (this.pdcHeaderFound && !doingCert) {
            this.invalidateSSL = true;
            return new RedirectResponse(this.loginURL(req, _platformloginURL));
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Session: doing PDC");
        }
        if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
            return this.doPDC(gwhost, req);
        }
        return this.doPDC(gwhost + ":" + this._gwport, req);
    }

    private Response processProtocolRequest(Request req) {
        SSOToken token = null;
        boolean setCookieFlagExist = false;
        if (ServiceIdentifier.isGateway()) {
            if (this.isNonAuthenticatedURL(req)) {
                if (req.getURL().endsWith(_platformloginURL)) {
                    if (this.doingPDC && this.pdcHeaderFound) {
                        this.invalidateSSL = true;
                    }
                    return new RedirectResponse(this.loginURL(req, _platformloginURL));
                }
                if (this.doingPDC) {
                    setCookieFlagExist = true;
                }
            } else {
                String sidstr = req.getSessionID();
                if (sidstr == null) {
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session4", new Object[]{this._logId}));
                    }
                    return new RedirectResponse(this.loginURL(req, _platformloginURL));
                }
                try {
                    sidstr = URLDecoder.decode(sidstr).trim();
                    SSOTokenManager manager = SSOTokenManager.getInstance();
                    token = manager.createSSOToken(sidstr);
                    manager.validateToken(token);
                }
                catch (SSOException ssoEx) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("Error creating SSOToken ", ssoEx);
                    }
                    if (this.doingPDC) {
                        return this.doPDC(req.getGatewayHost(), req);
                    }
                    return new RedirectResponse(this.loginURL(req, _platformloginURL));
                }
                catch (Exception e) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("Error creating SSOToken ", e);
                    }
                    if (this.doingPDC) {
                        return this.doPDC(req.getGatewayHost(), req);
                    }
                    return new RedirectResponse(this.loginURL(req, _platformloginURL));
                }
                SSOToken sess = token;
                if (this.doingPDC) {
                    setCookieFlagExist = true;
                }
                try {
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session3", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), token.getIPAddress().toString()}));
                    }
                }
                catch (SSOException ex) {
                    // empty catch block
                }
                if (!this.isAccessControlAllowed(req, sidstr)) {
                    String message = "Access Denied";
                    String language = req.getRequestHeader("Accept-Language");
                    if (accessDeniedErrorMessage != null && accessDeniedErrorMessage.length() > 0) {
                        String userLocale = this.getUserLocale(sidstr);
                        message = GWLocale.getPFString(accessDeniedErrorMessage, new Object[]{message}, userLocale);
                    }
                    return new ErrorResponse(message, token, language);
                }
            }
        }
        String oldHost = req.getHost();
        String oldPort = req.getPort();
        String oldProtocol = req.getProtocol();
        String oldObject = req.getObject();
        try {
            String sidstr = req.getSessionID();
            if (sidstr != null) {
                sidstr = URLDecoder.decode(sidstr).trim();
                SSOTokenManager manager = SSOTokenManager.getInstance();
                token = manager.createSSOToken(sidstr);
                manager.validateToken(token);
                if (oldObject.lastIndexOf("&org=") != -1) {
                    int goIndex = oldObject.lastIndexOf("&go=true");
                    if (goIndex == -1) {
                        String userLocale = this.getUserLocale(sidstr);
                        String message = "\"" + req.getURL() + "&go=true\"";
                        message = GWLocale.getPFString(loginToAnotherOrg, new Object[]{message}, userLocale);
                        StatisticsResponse mr = new StatisticsResponse(message);
                        return mr;
                    }
                    oldObject = oldObject.substring(0, goIndex);
                }
            }
        }
        catch (SSOException ssoEx) {
            // empty catch block
        }
        Retriever retr = null;
        if (_useHTTPProxy) {
            String hphost = this.getProxyHost(req);
            req.setHost(hphost);
            req.setPort(_hpport);
            req.setProtocol(_hpprot);
            req.setObject("/" + req.getURL());
            retr = RetrievalFactory.getRetriever(_hpprot);
        } else {
            retr = RetrievalFactory.getRetriever(req.getProtocol());
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: HTTP not in HTTPS mode");
            }
        }
        Response rep = this.retrieveResponse(req, oldHost, retr, token);
        if (_useHTTPProxy) {
            req.setHost(oldHost);
            req.setPort(oldPort);
            req.setProtocol(oldProtocol);
            req.setObject(oldObject);
        }
        String rep_code = rep.getStatusCode();
        if (this.doingPDC && req.getObject().startsWith(_platformlogoutURL)) {
            this.addPDCCookie(req, rep);
            setCookieFlagExist = false;
        } else if (this.doingPDC && setCookieFlagExist && rep instanceof HTTPResponse) {
            int indx;
            String s;
            String iplanetCookie = null;
            List cookieList = ((HTTPResponse)rep).getHeaderAttributeList("Set-Cookie");
            if (cookieList != null && cookieList.size() > 0) {
                Iterator it = cookieList.iterator();
                while (it.hasNext()) {
                    SSOToken ssoToken;
                    block47: {
                        String sidstr;
                        block46: {
                            String temp;
                            iplanetCookie = (String)it.next();
                            int bindx = iplanetCookie.indexOf(sessionCookieName);
                            int eindx = iplanetCookie.indexOf(61, bindx);
                            if (bindx > 1 && !(temp = iplanetCookie.substring(bindx + sessionCookieLen, eindx)).trim().equals("")) {
                                bindx = -1;
                            }
                            if (iplanetCookie == null || bindx == -1) continue;
                            sidstr = req.getSessionID();
                            try {
                                sidstr = URLDecoder.decode(sidstr).trim();
                            }
                            catch (Exception ex) {
                                if (!GWDebug.debug.errorEnabled()) break block46;
                                GWDebug.debug.error("**** Exception while decoding ****", ex);
                            }
                        }
                        if (sidstr == null) continue;
                        ssoToken = null;
                        try {
                            SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
                            ssoToken = ssoTokenManager.createSSOToken(sidstr);
                        }
                        catch (SSOException se) {
                            if (!GWDebug.debug.errorEnabled()) break block47;
                            GWDebug.debug.error("**** ssoToken = null ****", se);
                        }
                    }
                    if (ssoToken != null) continue;
                    return this.doPDC(req.getGatewayHost(), req);
                }
            } else if (rep_code.startsWith("302") && (s = rep.getResponseHeader("Location")) != null && (indx = s.indexOf(":")) != -1) {
                if ((s = s.substring(indx + 1, s.length()).trim()).toUpperCase().startsWith(_platformloginURL.toUpperCase())) {
                    if (this.hostFound(req.getURI())) {
                        this.addPDCCookie(req, rep);
                    }
                } else {
                    String rest;
                    int end;
                    int start = s.indexOf("://");
                    if (start != -1 && (end = s.indexOf(47, start + 3)) != -1 && (rest = s.substring(0, end)).toUpperCase().startsWith(_platformloginURL.toUpperCase()) && this.hostFound(req.getURI())) {
                        this.addPDCCookie(req, rep);
                    }
                }
            }
        }
        return rep;
    }

    private boolean isNonAuthenticatedURL(Request req) {
        String host = req.getProtocol() + "://" + req.getHost() + ":" + req.getPort();
        if (host == null) {
            return false;
        }
        if (!ServersList.contains(host)) {
            return false;
        }
        String path = req.getObject();
        if (path == null) {
            path = "/";
        }
        int numElements = nonAuthPathList.size();
        int i = 0;
        while (i < numElements) {
            String elem = (String)nonAuthPathList.get(i);
            if (path.startsWith(elem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SSOToken getUserSession(Request req, String sid) {
        SSOToken s = null;
        try {
            SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
            s = ssoTokenManager.createSSOToken(sid);
            if (!ssoTokenManager.isValidToken(s)) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: state is not VALID");
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("session5", new Object[]{this._logId, sid}));
                }
                return null;
            }
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Failed to get session", e);
            }
            return null;
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private boolean wildcardMatch(String str1, String str2) {
        block10: {
            beginIndex1 = 0;
            endIndex1 = 0;
            beginIndex2 = 0;
            endIndex2 = 0;
            strlen1 = str1.length();
            strlen2 = str2.length();
            substr = null;
            if (str1 == null || str2 == null) {
                return false;
            }
            endIndex2 = str2.indexOf(42, beginIndex2);
            if (endIndex2 == -1) break block10;
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2) {
                if ((beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                    return false;
                }
                if (beginIndex1 != beginIndex2) {
                    return false;
                }
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
            if (true) ** GOTO lbl36
        }
        beginIndex1 = str1.indexOf(str2);
        if (beginIndex1 == -1) {
            return false;
        }
        return beginIndex1 == beginIndex2;
        do {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2 && (beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                return false;
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
lbl36:
            // 2 sources

        } while ((endIndex2 = str2.indexOf(42, beginIndex2)) != -1);
        substr = str2.substring(beginIndex2, strlen2);
        endIndex1 = str1.lastIndexOf(substr, strlen1 - 1);
        if (endIndex1 == -1) {
            return false;
        }
        return beginIndex1 <= endIndex1;
    }

    private boolean isAccessControlAllowed(Request req, String sessid) {
        boolean allowed = false;
        try {
            UserProfile prof = new UserProfile(sessid);
            boolean matchFound = false;
            List list = prof.getStringList("sunPortalGatewayAccessDenyList");
            Iterator iter = list.iterator();
            String requrl = req.getURL();
            while (iter.hasNext()) {
                String denyString = iter.next().toString();
                if (denyString.equals("*")) {
                    allowed = false;
                    matchFound = true;
                    break;
                }
                if (!this.wildcardMatch(requrl, denyString)) continue;
                allowed = false;
                matchFound = true;
                break;
            }
            if (!matchFound) {
                list = prof.getStringList("sunPortalGatewayAccessAllowList");
                iter = list.iterator();
                while (iter.hasNext()) {
                    String allowString = iter.next().toString();
                    if (allowString.equals("*")) {
                        allowed = true;
                        matchFound = true;
                        break;
                    }
                    if (!this.wildcardMatch(requrl, allowString)) continue;
                    allowed = true;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) {
                allowed = false;
            }
            if (!allowed) {
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("Session: request is not allowed");
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("session8", new Object[]{this._logId, req.getURL(), new String(GWLogManager.getUserId(req.getSessionID()))}));
                }
            }
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Session: failed to get URLPrivList", e);
            }
            allowed = false;
        }
        return allowed;
    }

    Response retrieveResponse(Request req, String destinationHost, Retriever retr, SSOToken token) {
        String statusText;
        Response rep;
        String acceptEncoding = req.getRequestHeader("Accept-Encoding");
        if (acceptEncoding != null) {
            req.setRequestHeader("Accept-Encoding", "");
        }
        if (req.getGatewayScheme().equals("redirect")) {
            String cliUrl = req.getURL();
            if (!DomainWebProxyConfig.containHost(req.getHost())) {
                return new RedirectResponse(cliUrl, false);
            }
        }
        if ((rep = retr.getResponse(req, destinationHost, this._logId)) == null) {
            String message;
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("Session: Unable to connect to host:  " + req.getHost());
            }
            if (req.getGatewayScheme().equals("redirect")) {
                if (req.getUseProxy()) {
                    message = req.getProxyHost() + ":" + req.getProxyPort();
                    if (webProxErrorMessage != null && webProxErrorMessage.length() > 0) {
                        String userLocale = this.getUserLocale(token);
                        message = GWLocale.getPFString(webProxErrorMessage, new Object[]{message}, userLocale);
                    } else {
                        message = "Session: Unable to connect to web prox host: " + message + ".";
                    }
                    String language = req.getRequestHeader("Accept-Language");
                    rep = new ErrorResponse(message, token, language);
                } else {
                    rep = new RedirectResponse(req.getURL(), false);
                }
            } else if (ServiceIdentifier.isGateway()) {
                message = req.getHost();
                if (hostConnectErrorMessage != null && hostConnectErrorMessage.length() > 0) {
                    String userLocale = this.getUserLocale(token);
                    message = GWLocale.getPFString(hostConnectErrorMessage, new Object[]{message}, userLocale);
                } else {
                    message = "Session: Unable to connect to host:  " + message + ".";
                }
                String language = req.getRequestHeader("Accept-Language");
                rep = new ErrorResponse(message, token, language);
            } else {
                message = "Session: Unable to connect to host:  " + req.getHost() + ".";
                if (hostConnectErrorMessage != null && hostConnectErrorMessage.length() > 0) {
                    String userLocale = this.getUserLocale(token);
                    message = GWLocale.getPFString(hostConnectErrorMessage, new Object[]{message}, userLocale);
                }
                String language = req.getRequestHeader("Accept-Language");
                rep = new ErrorResponse(message, UNKNOWN_HOST, token, language);
            }
        } else if (ServiceIdentifier.isGateway() && (statusText = rep.getStatusText()) != null && statusText.equals(UNKNOWN_HOST)) {
            if (req.getGatewayScheme().equals("redirect")) {
                BufferedInputStream in = null;
                in = rep.getContentStream();
                try {
                    if (in instanceof CSBufferedInputStream) {
                        ((CSBufferedInputStream)in).getSocket().close();
                    }
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                rep = new RedirectResponse(req.getURL(), false);
            } else {
                rep.setStatusText("Bad Gateway");
            }
        }
        return rep;
    }

    private String getProxyHost(Request req) {
        String sid = req.getSessionID();
        if (sid == null) {
            return req.getHost();
        }
        try {
            sid = URLDecoder.decode(sid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SessionID(sid).getSessionServer();
    }

    private String loginURL(Request req, String loginURLObject) {
        SessionID sessid;
        String server;
        String sid = req.getSessionID();
        if (sid == null) {
            server = ServersList.getServeraLive();
            sessid = null;
        } else {
            try {
                sid = URLDecoder.decode(sid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            sessid = new SessionID(sid);
            server = sessid.getSessionServerProtocol() + "://" + sessid.getSessionServer() + ":" + sessid.getSessionServerPort();
            server = server == null || sessid.getRandomString().equals("LOGOUT") || !ServersList.contains(server) ? ServersList.getServeraLive() : ServersList.getServeraLive(server);
        }
        String _gw = req.getGatewayHost();
        String _uri = req.getURI();
        String dm = _gw;
        String org = defaultOrg;
        String gotoParam = null;
        boolean addGotoParam = false;
        if (req.getProtocol() != null) {
            addGotoParam = true;
            gotoParam = req.getURL();
            if (gotoParam == null) {
                addGotoParam = false;
            }
        } else if (_uri.length() > 1) {
            int indx = _uri.toLowerCase().indexOf("org=");
            if (indx != -1) {
                int indx1 = _uri.indexOf(38, indx += 4);
                if (indx1 == -1) {
                    indx1 = _uri.length();
                }
                org = _uri.substring(indx, indx1);
            } else if (req.getProtocol() == null && !_uri.endsWith(_platformloginURL)) {
                dm = dm + _uri;
                org = _uri.substring(1);
            }
        }
        String _param = null;
        if (addGotoParam && gotoParam != null && gotoParam.indexOf("goto=") != -1) {
            String dummyGotoParam = gotoParam.trim().toLowerCase();
            Iterator iter = expandedSessionServersList.iterator();
            while (iter.hasNext()) {
                String tmpServer = (String)iter.next();
                if (tmpServer == null) continue;
                if (!dummyGotoParam.startsWith(tmpServer) || dummyGotoParam.indexOf(loginURLObject) != tmpServer.length()) break;
                addGotoParam = false;
                break;
            }
        }
        _param = addGotoParam ? "?gw=" + _gw + "&org=" + org + "&goto=" + gotoParam : "?gw=" + _gw + "&org=" + org;
        if (this.doingPDC) {
            _param = _param + "&module=Cert";
        }
        return server + loginURLObject + _param;
    }

    public void close() {
        try {
            this._theSocket.getOutputStream().flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this._theSocket != null) {
            try {
                this._theSocket.close();
                if (PerfContextObject.ENABLE_PERF) {
                    if (this._theSocket instanceof SSLSocket) {
                        SocketCount.decrementSSLSockets();
                    } else {
                        SocketCount.decrementPlainSockets();
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this._theSocket = null;
        }
        if (processKeepAliveConnections && this.actualClientSocket != null) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.actualClientSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.actualClientSocket = null;
        }
    }

    private static void setVirtualHostname() {
        virtualHost.add(rphost);
        String s = SystemProperties.get("gateway.virtualhost", null);
        if (s == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(s);
        while (tokens.hasMoreTokens()) {
            s = tokens.nextToken().trim().toLowerCase();
            virtualHost.add(s);
        }
    }

    private String getFQDN(String name) {
        int numHosts = virtualHost.size();
        int i = 0;
        while (i < numHosts) {
            String host = (String)virtualHost.get(i);
            if (host.regionMatches(true, 0, name, 0, name.length())) {
                return host;
            }
            ++i;
        }
        return null;
    }

    private String getUserLocale(Request req) {
        if (req == null) {
            return defaultLocale;
        }
        return this.getUserLocale(req.getSessionID());
    }

    private String getUserLocale(SSOToken token) {
        if (token == null) {
            return defaultLocale;
        }
        return this.getUserLocale(token.getTokenID().toString());
    }

    private String getUserLocale(String sessid) {
        try {
            sessid = URLDecoder.decode(sessid);
            UserProfile prof = new UserProfile(sessid);
            return prof.getString("preferredlocale", "en_US");
        }
        catch (Exception ex) {
            return defaultLocale;
        }
    }

    private Response doPDC(String _rpName, Request req) {
        Response rep;
        block30: {
            rep = null;
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: now doingPDC");
            }
            String gwLabel = "gw=";
            byte[] gwLableByte = gwLabel.getBytes();
            String gwContentEn = URLEncoder.encode(_rpName);
            byte[] gwContentByte = gwContentEn.getBytes();
            String clntLabel = "&client=";
            byte[] clntLabelByte = clntLabel.getBytes();
            String clntContentEnc = "127.0.0.1";
            byte[] clntContentByte = clntContentEnc.getBytes();
            String domainLabel = "&domain=";
            byte[] domainLabelByte = domainLabel.getBytes();
            String domainContentEnc = URLEncoder.encode(_rpName);
            byte[] domainContentByte = domainContentEnc.getBytes();
            String certLabel = "&userCert=";
            byte[] certLabelByte = certLabel.getBytes();
            String testLabel = "&testxyz=";
            byte[] testLabelByte = testLabel.getBytes();
            String testContentStr = "justatest";
            String testContentEnc = URLEncoder.encode(testContentStr);
            byte[] testContentByte = testContentEnc.getBytes();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: ABOUT TO DO CERT LOGIN");
            }
            X509Certificate clientCert = null;
            Base64 _base64 = new Base64();
            String b64Cert = null;
            byte[] certparam = null;
            SSLSocket sslsock = (SSLSocket)this._theSocket;
            try {
                byte[] byteb64Cert;
                block29: {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Session: prepare the cert to send over to the server.");
                    }
                    try {
                        clientCert = sslsock.getStatus().getPeerCertificate();
                    }
                    catch (SocketException se) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("Unable to get peer certificate");
                        }
                        return null;
                    }
                    byte[] certbyte = clientCert.getEncoded();
                    byte[] xxb64Cert = Base64.encode(certbyte);
                    String strb64Cert = new String(xxb64Cert);
                    b64Cert = URLEncoder.encode(strb64Cert);
                    byteb64Cert = b64Cert.getBytes();
                    try {
                        FileOutputStream fout = new FileOutputStream("/tmp/base64cert.certbyte");
                        DataOutputStream out = new DataOutputStream(fout);
                        int lindex = 0;
                        while (lindex < xxb64Cert.length) {
                            out.writeByte(xxb64Cert[lindex]);
                            ++lindex;
                        }
                        out.close();
                    }
                    catch (IOException ex3) {
                        if (!GWDebug.debug.errorEnabled()) break block29;
                        GWDebug.debug.error("Session: see file /tmp/base64cert");
                    }
                }
                certparam = new byte[gwLableByte.length + gwContentByte.length + clntLabelByte.length + clntContentByte.length + domainLabelByte.length + domainContentByte.length + certLabelByte.length + testLabelByte.length + testContentByte.length + byteb64Cert.length + 200];
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: certparam.length=" + certparam.length);
                    GWDebug.debug.message("Session: b64Cert.length=" + b64Cert.length());
                }
                int j = 0;
                int i = 0;
                while (i < gwLableByte.length) {
                    certparam[i] = gwLableByte[i];
                    ++i;
                }
                j = gwLableByte.length;
                int i2 = 0;
                while (i2 < gwContentByte.length) {
                    certparam[j] = gwContentByte[i2];
                    ++j;
                    ++i2;
                }
                int i3 = 0;
                while (i3 < clntLabelByte.length) {
                    certparam[j] = clntLabelByte[i3];
                    ++j;
                    ++i3;
                }
                int i4 = 0;
                while (i4 < clntContentByte.length) {
                    certparam[j] = clntContentByte[i4];
                    ++j;
                    ++i4;
                }
                int i5 = 0;
                while (i5 < domainLabelByte.length) {
                    certparam[j] = domainLabelByte[i5];
                    ++j;
                    ++i5;
                }
                int i6 = 0;
                while (i6 < domainContentByte.length) {
                    certparam[j] = domainContentByte[i6];
                    ++j;
                    ++i6;
                }
                int i7 = 0;
                while (i7 < certLabelByte.length) {
                    certparam[j] = certLabelByte[i7];
                    ++j;
                    ++i7;
                }
                int i8 = 0;
                while (i8 < byteb64Cert.length) {
                    certparam[j] = byteb64Cert[i8];
                    ++j;
                    ++i8;
                }
                int i9 = 0;
                while (i9 < testLabelByte.length) {
                    certparam[j] = testLabelByte[i9];
                    ++j;
                    ++i9;
                }
                int i10 = 0;
                while (i10 < testContentByte.length) {
                    certparam[j] = testContentByte[i10];
                    ++j;
                    ++i10;
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: certificate version: getSubjectDN " + clientCert.getSubjectDN());
                }
                Retriever retr = null;
                HTTPRequest tmpreq = new HTTPRequest(this._gwprotocol, this.port);
                if (req.getObject().startsWith(_platformloginURL)) {
                    HTTPRequest blkreq = null;
                    String _tmpurl = req.getURL().trim();
                    int indx = _tmpurl.toLowerCase().indexOf("org=");
                    if (indx != -1) {
                        int indx1 = _tmpurl.indexOf(38, indx += 4);
                        if (indx1 == -1) {
                            indx1 = _tmpurl.length();
                        }
                        if ((_tmpurl = _tmpurl.substring(indx, indx1)).startsWith("/")) {
                            _tmpurl = _tmpurl.substring(1);
                        }
                        blkreq = new HTTPRequest(_tmpurl);
                    } else {
                        blkreq = new HTTPRequest();
                    }
                    blkreq.setHost(req.getHost());
                    blkreq.setPort(req.getPort());
                    blkreq.setGatewayHost(req.getGatewayHost());
                    tmpreq.addHeaderLine("POST  /" + this.loginURL(blkreq, _platformloginURL) + " " + ((HTTPRequest)req).getHTTPVersion() + "\r\n");
                } else {
                    tmpreq.addHeaderLine("POST  /" + this.loginURL(req, _platformloginURL) + " " + ((HTTPRequest)req).getHTTPVersion() + "\r\n");
                }
                tmpreq.addHeaderLine("Content-Length: " + certparam.length + "\r\n");
                retr = RetrievalFactory.getRetriever(tmpreq.getProtocol());
                rep = retr.getResponse2(tmpreq, tmpreq.getHost(), this._logId, certparam);
                req.setHost(tmpreq.getHost());
                req.setPort(tmpreq.getPort());
                req.setProtocol(tmpreq.getProtocol());
                req.setObject(tmpreq.getObject());
            }
            catch (CertificateEncodingException ex2) {
                if (!GWDebug.debug.errorEnabled()) break block30;
                GWDebug.debug.error("Session: CertificateEncodingException");
            }
        }
        return rep;
    }

    private void removePDCCookie(Request req) {
        String cookie = req.getRequestHeader("Cookie");
        StringBuffer sb = new StringBuffer();
        int index = cookie.indexOf(sessionCookieName);
        index = cookie.indexOf(61, index) + 1;
        String rest = cookie.substring(index).trim();
        sb.append(cookie.substring(0, index));
        sb.append(rest.substring(6));
        req.setRequestHeader("Cookie", sb.toString());
    }

    private void addPDCCookie(Request req, Response res) {
        if (!(res instanceof HTTPResponse)) {
            return;
        }
        String cookie = null;
        List cookieList = ((HTTPResponse)res).getHeaderAttributeList("Set-Cookie");
        if (cookieList != null && cookieList.size() > 0) {
            ((HTTPResponse)res).removeResponseHeader("Set-Cookie");
            Iterator it = cookieList.iterator();
            while (it.hasNext()) {
                cookie = (String)it.next();
                StringBuffer sb = new StringBuffer();
                int index = cookie.indexOf(sessionCookieName);
                String rest = cookie.substring(cookie.indexOf(61, index) + 1).trim();
                sb.append(cookie.substring(0, index));
                sb.append(sessionCookieName);
                sb.append("=");
                sb.append(PDC_COOKIE_HEADER);
                sb.append(rest);
                ((HTTPResponse)res).appendResponseHeader("Set-Cookie", sb.toString());
            }
        } else {
            cookie = req.getRequestHeader("Cookie");
            if (cookie != null) {
                StringBuffer sb = new StringBuffer();
                int index = cookie.indexOf(sessionCookieName);
                if (index != -1) {
                    int end = cookie.indexOf(59, index);
                    end = end == -1 ? cookie.length() : end;
                    String rest = cookie.substring(cookie.indexOf(61, index) + 1, end).trim();
                    sb.append("Set-Cookie: ");
                    sb.append(sessionCookieName);
                    sb.append("=");
                    sb.append(PDC_COOKIE_HEADER);
                    sb.append(rest);
                    sb.append(";path = /;");
                    if (gwDomain != null) {
                        sb.append(" domain =");
                        sb.append(gwDomain);
                        sb.append(";");
                    }
                    res.setResponseHeader("Set-Cookie", sb.toString());
                } else {
                    sb.append("Set-Cookie: ");
                    sb.append(sessionCookieName);
                    sb.append("=");
                    sb.append(PDC_COOKIE_HEADER);
                    sb.append(";path = /;");
                    if (gwDomain != null) {
                        sb.append(" domain =");
                        sb.append(gwDomain);
                        sb.append(";");
                    }
                    res.setResponseHeader("Set-Cookie", sb.toString());
                }
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("Set-Cookie: ");
                sb.append(sessionCookieName);
                sb.append("=");
                sb.append(PDC_COOKIE_HEADER);
                sb.append(";path = /;");
                if (gwDomain != null) {
                    sb.append(" domain =");
                    sb.append(gwDomain);
                    sb.append(";");
                }
                res.setResponseHeader("Set-Cookie", sb.toString());
            }
        }
    }

    private boolean hostFound(String reqUri) {
        Iterator it = serverList.iterator();
        while (it.hasNext()) {
            String fullhost = it.next().toString().toLowerCase();
            String hostname = null;
            int lastColonIndex = -1;
            if (fullhost.startsWith("http:")) {
                lastColonIndex = fullhost.lastIndexOf(58);
                hostname = 4 == lastColonIndex ? fullhost.substring(7) : fullhost.substring(7, lastColonIndex);
            } else if (fullhost.startsWith("https:")) {
                lastColonIndex = fullhost.lastIndexOf(58);
                hostname = 5 == lastColonIndex ? fullhost.substring(8) : fullhost.substring(8, lastColonIndex);
            } else if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Server list entry is not in the right format: " + fullhost);
            }
            String reqUriSub = reqUri.substring(reqUri.indexOf(58) + 3).toLowerCase();
            if (hostname == null) {
                return false;
            }
            if (!reqUriSub.startsWith(hostname)) continue;
            return true;
        }
        return false;
    }

    static {
        _hpprot = "https";
        srapGateway_certificateEnabledList_lc = new ArrayList();
        virtualHost = new ArrayList();
        _numRequests = 0;
        _numBytesRead = 0;
        _numBytesSent = 0;
        processKeepAliveConnections = GatewayProfile.getBoolean("EProxyDoKeepAlive", true) && ServiceIdentifier.isGateway();
        timeoutseconds = GatewayProfile.getInt("EProxyKeepAliveConnectionTimeout", 50);
        GRACE_PERIOD = GatewayProfile.getInt("EProxyKeepAliveConnectionGraceTimeout", 20);
        maxTimeOutSetting = (long)(timeoutseconds + GRACE_PERIOD) * 1000L;
        defDomain = GatewayProfile.getString("DefaultDomainAndSubdomains", "");
        sessionCookieName = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        sessionCookieLen = sessionCookieName.length();
        defaultOrg = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.defaultOrg", (String)defDomain);
        gwDomain = null;
        serverList = GatewayProfile.getStringList("PortalServerList");
        notificationURL = System.getProperty("gateway.notification.url", "notification");
        isPerSessionLoggingEnabled = GatewayProfile.getBoolean("EProxyPerSessionLogging", false) && ServiceIdentifier.isGateway();
        detailedRproxLog = GatewayProfile.getBoolean("EProxyDetailedPerSessionLogging", false);
        defaultLocale = GatewayProfile.getString("locale", "en_US");
        server_traffic = GWDebug.createDebugLog("Gateway_to_from_server");
        server_traffic.setDebug();
        browser_traffic = GWDebug.createDebugLog("Gateway_to_from_browser");
        browser_traffic.setDebug();
        rphost = SystemProperties.get("gateway.host", null);
        Session.setVirtualHostname();
        Iterator it = GatewayProfile.getStringList("CertificateEnabledList").iterator();
        while (it.hasNext()) {
            srapGateway_certificateEnabledList_lc.add(it.next().toString().toLowerCase());
        }
        _useHTTPProxy = GatewayProfile.getBoolean("UseHTTPProxy", false) && ServiceIdentifier.isGateway();
        _hpport = GatewayProfile.getString("HTTPProxyPort", "10443");
        _platformloginURL = PlatformProfile.getString("login-url", "");
        _platformlogoutURL = PlatformProfile.getString("logout-url", "");
        nonAuthPathList = GatewayProfile.getStringList("NonAuthenticatedURLPath");
        if (nonAuthPathList == null) {
            nonAuthPathList = new ArrayList();
        }
        nonAuthPathList.add(_platformloginURL);
        nonAuthPathList.add(_platformlogoutURL);
        int index = rphost.indexOf(46);
        gwDomain = index != -1 ? rphost.substring(index) : null;
        defaultOrg = defaultOrg.trim().substring(defaultOrg.lastIndexOf("=") + 1);
        expandedSessionServersList = null;
        expandedSessionServersList = new LinkedList();
        Set sessionServers = ServersList.getAllSessionServersSet();
        URL tmpUrl = null;
        String tmpStr = null;
        Iterator iter = sessionServers.iterator();
        while (iter.hasNext()) {
            try {
                tmpStr = iter.next().toString();
                tmpUrl = new URL(tmpStr);
                expandedSessionServersList.add(tmpUrl.getProtocol() + "://" + tmpUrl.getHost() + ":" + tmpUrl.getPort());
                if ((!tmpUrl.getProtocol().equalsIgnoreCase("http") || tmpUrl.getPort() != 80) && (!tmpUrl.getProtocol().equalsIgnoreCase("https") || tmpUrl.getPort() != 443)) continue;
                expandedSessionServersList.add(tmpUrl.getProtocol() + "://" + tmpUrl.getHost());
            }
            catch (Exception ex) {
                if (!GWDebug.debug.messageEnabled()) continue;
                GWDebug.debug.message("Exception while parsing entry " + tmpStr, ex);
            }
        }
    }
}

