/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rewriter.DataServiceException;
import com.sun.portal.rewriter.InvalidXMLException;
import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterFactory;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.URISpec;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Document;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.ErrorResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.rewriter.SRAPRewriterModule;
import com.sun.portal.rproxy.rewriter.SRAPTranslator;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class RewriterAdopter {
    private static final String UN_SUPPORTED_ENCODING_EXCEPTION_LOCALE_KEY = "UnSupportedEncodingWarningMessage";
    private static final String INVALID_XML_EXCEPTION_LOCALE_KEY = "InvalidRuleSetWarningMessage";
    private static final String DATASERVICE_EXCEPTION_LOCALE_KEY = "DataServiceErrorMessage";
    private static final String IO_EXCEPTION_LOCALE_KEY = "IOErrorMessage";
    private static final String SYSTEM_ENCODING = System.getProperty("file.encoding");
    private static boolean ignoreContentLength = SystemProperties.get("gateway.rewriter.ignorecl", "false").equalsIgnoreCase("true");

    public static InputStream rewrite(Response aResp, Request aReq) {
        String lEncoding = "";
        String lRuleSet2Apply = "";
        try {
            byte[] lByteContent = RewriterAdopter.readFullContent(aResp);
            String lMIME = RewriterAdopter.getMIME(aResp);
            lMIME = SRAPConfigManager.getMappedMIME((String)lMIME);
            if (lMIME == null || lMIME.trim().length() == 0) {
                return new ByteArrayInputStream(lByteContent);
            }
            String sudoPageContent = new String(lByteContent);
            lEncoding = RewriterAdopter.getCharacterEncoding(aResp, sudoPageContent);
            if (lEncoding == null) {
                lEncoding = lMIME.indexOf("text/xml") != -1 ? Document.parseEncoding((String)sudoPageContent) : SYSTEM_ENCODING;
            }
            String pageContent = lEncoding.equalsIgnoreCase(SYSTEM_ENCODING) ? sudoPageContent : new String(lByteContent, lEncoding);
            SRAPTranslator bSRAPTranslator = new SRAPTranslator(aReq, lMIME);
            URISpec bURISpec = bSRAPTranslator.getBaseSpec();
            lRuleSet2Apply = SRAPConfigManager.findRuleSet2Apply((URISpec)bURISpec);
            Rewriter lRewriter = RewriterFactory.getInstance((String)lRuleSet2Apply, (URISpec)bURISpec);
            String lResult = lRewriter.rewrite(pageContent, (Translator)bSRAPTranslator);
            return new ByteArrayInputStream(lResult.getBytes(lEncoding));
        }
        catch (UnsupportedEncodingException usException) {
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("RewriterAdopter:UnsupportedEncodingException:", usException);
            }
            return RewriterAdopter.handleException(aResp, aReq, UN_SUPPORTED_ENCODING_EXCEPTION_LOCALE_KEY, new Object[]{lEncoding});
        }
        catch (InvalidXMLException ixException) {
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("RewriterAdopter:InvalidXMLException: ", ixException);
            }
            return RewriterAdopter.handleException(aResp, aReq, INVALID_XML_EXCEPTION_LOCALE_KEY, new Object[]{lRuleSet2Apply});
        }
        catch (DataServiceException dsException) {
            GWDebug.debug.error("RewriterAdopter:DataServiceException:", dsException);
            return RewriterAdopter.handleException(aResp, aReq, DATASERVICE_EXCEPTION_LOCALE_KEY, new Object[]{""});
        }
        catch (IOException ioException) {
            GWDebug.debug.error("RewriterAdopter:IOException:", ioException);
            return RewriterAdopter.handleException(aResp, aReq, IO_EXCEPTION_LOCALE_KEY, new Object[]{""});
        }
    }

    private static byte[] readFullContent(Response resp) throws IOException {
        int numbytes;
        String contentLength = resp.getResponseHeader("Content-length");
        BufferedInputStream reqIn = resp.getContentStream();
        if (!ignoreContentLength && contentLength != null) {
            int length = Integer.parseInt(contentLength.substring(contentLength.indexOf(58) + 1).trim());
            byte[] content = new byte[length];
            int read = 0;
            int totalRead = 0;
            while (totalRead < length) {
                read = reqIn.read(content, totalRead, length - totalRead);
                if (read == -1) {
                    if (totalRead >= length) break;
                    continue;
                }
                totalRead += read;
            }
            return content;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] content = new byte[2048];
        while ((numbytes = reqIn.read(content)) != -1) {
            baos.write(content, 0, numbytes);
        }
        return baos.toByteArray();
    }

    private static String getCharacterEncoding(Response aResp, String aContent) {
        int idxCloseArrowBracket;
        int idxCharset;
        int idxMetaTag;
        String contentType_lc;
        int start;
        String contentType = aResp.getContentType();
        String charEncoding = null;
        if (contentType != null && (start = (contentType_lc = contentType.toLowerCase()).indexOf("charset=")) != -1) {
            String[] splitted;
            int end = contentType.indexOf(59, start);
            if (end == -1) {
                end = contentType.length();
            }
            if ((splitted = StringHelper.regExpSplit((String)(charEncoding = contentType.substring(start + 8, end)), (String)"")).length == 3) {
                charEncoding = splitted[1];
            }
            if (charEncoding.equals("")) {
                charEncoding = null;
            }
            return charEncoding;
        }
        String content_lc = aContent.toLowerCase();
        int startIdx = 0;
        while ((idxMetaTag = content_lc.indexOf("<meta", startIdx)) != -1 && (idxCharset = content_lc.indexOf("charset=", idxMetaTag)) != -1 && (idxCloseArrowBracket = content_lc.indexOf(">", idxMetaTag)) != -1) {
            int startCE;
            if (idxCloseArrowBracket < idxCharset) {
                startIdx = idxCloseArrowBracket;
                continue;
            }
            int endCE = startCE = idxCharset + 8;
            char ch = content_lc.charAt(endCE);
            while (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                ch = content_lc.charAt(++endCE);
            }
            if (endCE <= startCE) break;
            charEncoding = aContent.substring(startCE, endCE);
            break;
        }
        return charEncoding;
    }

    private static InputStream handleException(Response aResp, Request aReq, String aLocaleKey, Object[] aLocaleParams) {
        String lSessionID = aReq.getSessionID();
        String lUserLocale = RewriterAdopter.getUserLocale(lSessionID);
        String lMessage = GWLocale.getPFString(aLocaleKey, aLocaleParams, lUserLocale);
        return new ErrorResponse(lMessage, null, aReq.getRequestHeader("Accept-Language")).getContentStream();
    }

    private static String getUserLocale(String sessid) {
        try {
            sessid = URLDecoder.decode(sessid);
            UserProfile prof = new UserProfile(sessid);
            return prof.getString("preferredlocale", "en_US");
        }
        catch (Exception ex) {
            return GatewayProfile.getString("locale", "en_US");
        }
    }

    public static String getMIME(Response aResp) {
        String lContentType = aResp.getContentType();
        if (lContentType != null) {
            int i = lContentType.indexOf(59);
            if (i == -1) {
                return lContentType;
            }
            return lContentType.substring(0, i);
        }
        return lContentType;
    }

    public static void main(String[] args) {
    }

    static {
        SRAPRewriterModule.init(null);
    }
}

