/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.perf.netlet.client;

import com.sun.portal.netlet.crypt.ciph.CipherGroup;
import com.sun.portal.netlet.econnection.DataCipherMsg;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ProxyCipherMsg;
import com.sun.portal.netlet.econnection.SessionCipherMsg;
import com.sun.portal.netlet.econnection.SessionKey;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.StringTokenizer;

public class NetletClientApp {
    public static final int EPROX_ID_SIZE = 5;
    public static long[] statistics;
    public static byte[] data;
    public static int MAXBUFFERSIZE;
    public static int REP_COUNT;
    protected static final int MAX_DATA_LEN = 8192;

    public NetletClientApp(String[] args) {
        if (args.length != 12) {
            System.out.println("Usage: java com.sun.portal.perf.netlet.client.NetletClient <gateway-host> <gateway-port> <target-host> <target-port> <profile-host> <profile-port> <cipher-name> <key-len> <userinfo-filename> <data-file> <num-of-bytes> <rep-count>");
            System.exit(1);
        }
        MAXBUFFERSIZE = Integer.parseInt(args[10]);
        REP_COUNT = Integer.parseInt(args[11]);
        NetletClient[] nc = new NetletClient[1000];
        data = new byte[MAXBUFFERSIZE];
        statistics = new long[1000];
        Object s = null;
        try {
            FileInputStream fis = new FileInputStream(args[9]);
            fis.read(data);
        }
        catch (IOException ioe) {
            System.out.println("Error reading input file...." + ioe);
            System.exit(1);
        }
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new InputStreamReader(new FileInputStream(args[8])));
        }
        catch (Exception e) {
            System.out.println("Invalid userinfo filename - " + e);
            System.exit(1);
        }
        int i = 0;
        int flag = 0;
        while (flag == 0) {
            try {
                String entry = fileReader.readLine();
                if (entry == null || entry.trim().length() == 0) {
                    flag = -1;
                }
                if (flag != -1) {
                    StringTokenizer st = new StringTokenizer(entry);
                    nc[i] = new NetletClient(i, st.nextToken(), st.nextToken(), args[0], args[1], args[2], args[3], args[4], args[5], args[6], Integer.parseInt(args[7]));
                }
            }
            catch (Exception ioe) {
                flag = -1;
                System.out.println("Exception in main..." + ioe);
                ioe.printStackTrace();
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        new NetletClientApp(args);
    }

    class NetletClient
    implements Runnable {
        int id;
        int keylen;
        int connsPerUser;
        int kiloBytes;
        String username;
        String password;
        String rh;
        String rp;
        String sh;
        String sp;
        String profileHost;
        String profilePort;
        String ciphername;
        Thread t = null;
        ReadWrite[] rw;

        public NetletClient(int id, String username, String password, String rh, String rp, String sh, String sp, String ph, String pp, String ciphername, int keylen) {
            this.id = id;
            this.keylen = keylen;
            this.connsPerUser = 1;
            this.username = username;
            this.password = password;
            this.rh = rh;
            this.rp = rp;
            this.sh = sh;
            this.sp = sp;
            this.profileHost = ph;
            this.profilePort = pp;
            this.ciphername = ciphername;
            this.kiloBytes = 1000000;
            this.rw = new ReadWrite[this.connsPerUser];
            this.t = new Thread((Runnable)this, "" + id);
            this.t.start();
        }

        public void run() {
            String sessionID = this.login();
            int i = 0;
            while (i < this.connsPerUser) {
                this.rw[i] = new ReadWrite(this.id * this.connsPerUser + i, sessionID, this.rh, this.rp, this.sh, this.sp, this.ciphername, this.keylen, this.kiloBytes);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.connsPerUser) {
                try {
                    this.rw[i2].t.join();
                }
                catch (Exception e) {
                    System.out.println("Exception in waiting for reader writer threads: " + e);
                }
                ++i2;
            }
        }

        private String login() {
            String sessID = null;
            try {
                StringBuffer urlSb = new StringBuffer();
                urlSb.append("GET /amserver/login?module=LDAP&authType=command&TOKEN0=").append(this.username).append("&TOKEN1=").append(this.password).append("&page=1 HTTP/1.0\r\n").append("Cookie: a=b\r\n").append("\r\n");
                Socket s = new Socket(InetAddress.getByName(this.profileHost), Integer.parseInt(this.profilePort));
                OutputStream out = s.getOutputStream();
                out.write(urlSb.toString().getBytes());
                out.flush();
                DataInputStream in = new DataInputStream(s.getInputStream());
                byte[] b = new byte[8192];
                int flag = 0;
                String output = new String();
                while (flag != -1) {
                    try {
                        flag = in.read(b);
                        output = output + new String(b);
                    }
                    catch (IOException ioe) {
                        flag = -1;
                    }
                }
                sessID = output.substring(output.indexOf("iPlanetDirectoryPro") + "iPlanetDirectoryPro".length() + 1);
                StringTokenizer st = new StringTokenizer(sessID);
                sessID = st.nextToken();
                st = new StringTokenizer(sessID, ";");
                sessID = st.nextToken();
                sessID = URLDecoder.decode(sessID);
            }
            catch (Exception e) {
                System.out.println("Exception in user login. " + e);
            }
            return sessID;
        }
    }

    class ReadWrite
    implements Runnable,
    KeyConstants {
        String sessID;
        String rh;
        String rp;
        String sh;
        String sp;
        String ciphername;
        int id;
        int keylen;
        int kiloBytes;
        public Thread t = null;

        public ReadWrite(int id, String sessID, String rh, String rp, String sh, String sp, String ciphername, int keylen, int kbs) {
            this.id = id;
            this.sessID = sessID;
            this.rh = rh;
            this.rp = rp;
            this.sh = sh;
            this.sp = sp;
            this.ciphername = ciphername;
            this.keylen = keylen;
            this.kiloBytes = kbs;
            this.t = new Thread((Runnable)this, "" + id);
            this.t.start();
        }

        public void run() {
            SessionKey initKey = new SessionKey("SN1.0SN1.0SN1.0S.SN9.0SN3.0SN.05".getBytes());
            CipherGroup initCipherGroup = new CipherGroup("RC4", initKey, 128);
            this.sessID = this.sessID + "|" + this.ciphername;
            String sessionKey = "O3BBzFEmQY5NHWxN1tD4calPQlHjSFROaYavWu1Nb8IscavBQlHESLJOlFHhUUFNxmUFcUh2QlFKSOJOVEFRQUFNcUJRSFROZVQydGIwZDZySFI5R0p2TSsvUUcrdjAvdysvWjZsVVZ2VUZpTUtiMjRiT1ZiZk83NHd6Z3dDdHhnWWYzYkRNSHdnemVkaFlrMDUwTTlDdFJmd3JXZFlrVi9NSEI0SkQ4TTdYZz1AZXhjZWwuSW5kaWEuU3VuLkNPTS0x";
            SessionKey sKey = new SessionKey(sessionKey);
            CipherGroup cipher = new CipherGroup(this.ciphername, sKey, this.keylen);
            try {
                Socket s = new Socket(InetAddress.getByName(this.rh), Integer.parseInt(this.rp));
                DataOutputStream out = new DataOutputStream(s.getOutputStream());
                byte[] esessMsg = "RP1.0".getBytes();
                out.write(esessMsg, 0, 5);
                out.flush();
                SessionCipherMsg sMsg = new SessionCipherMsg(this.sessID.getBytes(), this.sessID.getBytes().length, initCipherGroup);
                if (sMsg.writeMsg(out) != 0) {
                    System.out.println("NetletClientApp unable to process session id");
                }
                ProxyCipherMsg pMsg = new ProxyCipherMsg(30000, this.sp.getBytes(), this.sp.getBytes().length, this.sh.getBytes(), this.sh.getBytes().length, cipher);
                pMsg.writeMsg(out);
                DataInputStream d_in = new DataInputStream(s.getInputStream());
                DataOutputStream d_out = new DataOutputStream(s.getOutputStream());
                DataCipherMsg wdMsg = new DataCipherMsg(cipher);
                byte[] wb = new byte[8192];
                DataCipherMsg rdMsg = new DataCipherMsg(cipher);
                byte[] rb = new byte[8192];
                rdMsg.setDataByRef(rb, 0);
                while (true) {
                    long startTime = System.currentTimeMillis();
                    int k = 0;
                    k = 0;
                    while (k < REP_COUNT) {
                        System.arraycopy(data, 0, wb, 0, MAXBUFFERSIZE);
                        wdMsg.setDataByRef(wb, MAXBUFFERSIZE);
                        if (wdMsg.writeMsg(d_out) == 0) {
                            for (int bytesRead = 0; bytesRead < MAXBUFFERSIZE; bytesRead += rdMsg.getMsgLen()) {
                                if (rdMsg.readMsg(d_in) == 0) {
                                    continue;
                                }
                                System.out.println("Error reading data");
                                break;
                            }
                        } else {
                            System.out.println("Error writing data");
                        }
                        ++k;
                    }
                    double dataCount = (double)MAXBUFFERSIZE / 128.0;
                    double timeTaken = System.currentTimeMillis() - startTime;
                    double bandWidth = dataCount * (double)REP_COUNT / (timeTaken /= 1000.0);
                    System.out.println("Current time -> " + System.currentTimeMillis() + " Throughput = " + bandWidth + " kbps");
                }
            }
            catch (Exception ioe) {
                System.out.println("Exception in reader writer: " + ioe);
                return;
            }
        }
    }
}

